/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import com.google.common.base.Strings;
import com.huawei.smartkit.drop.protocol.ssh.entity.ISshJudge;
import com.huawei.smartkit.drop.protocol.ssh.entity.LocalServerKeyVerifier;
import com.huawei.smartkit.drop.protocol.ssh.entity.SessionMonitor;
import com.huawei.smartkit.drop.protocol.ssh.entity.SshErrMatcher;
import com.huawei.smartkit.drop.protocol.ssh.entity.SshException;
import com.huawei.smartkit.drop.protocol.ssh.entity.SshPublicKey;
import com.huawei.smartkit.drop.protocol.ssh.entity.enums.SshCliOutputErrorType;
import com.huawei.smartkit.drop.util.EncryptUtils;
import com.huawei.smartkit.drop.util.LogInfoCheckUtils;
import com.huawei.smartkit.drop.util.ThreadUtils;
import com.huawei.smartkit.drop.util.sensitive.SensitiveUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnection
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshConnection.class);
    private static final String MINISYSTEM_MARK = "Storage: minisystem>";
    private static final String UPGRADE_MARK = "upgrade:/>";
    private static final String PD_WILL_EXPIRE_CLI_RETURN = "The password is about to expire. Change the password immediately?(y/n)";
    private static final String INITPD_NOT_CHANGE_CLI_RETURN = "For security purposes, please change the initial password and log in to the system using the new password.";
    private static final int LINUX_PROCESS_KILL_CMD = 3;
    private static final String ENTER = System.lineSeparator();
    private static final String GO_BACK = "\b";
    private static final int CMD_DEFAULT_TIMEOUTE = 1200;
    private static final String TIMEOUT_KEY = "ssh.common.timeout";
    private static final int CONNECT_TIMEOUT_MS = 10000;
    private static final String BUILD_CON_FAILED_KEY = "build.connection.failed";
    private static final String BUILD_CON_CLI_NUM_OVER_KEY = "build.connection.cli.num.over";
    private static final String BUILD_CON_PWD_UNSAFE_KEY = "build.connection.pwd.unsafe";
    private static final String PD_EXPIRED_CLI_OUTPUT = "The password has expired. Please change the password and log in to the system using the new password.";
    private static final String PD_EXPIRED_CLI_OUTPUT_9000 = "WARNING: Your password has expired." + System.lineSeparator() + "You must change your password now and login again!" + System.lineSeparator() + "Changing password for omuser." + System.lineSeparator() + "Old Password: ";
    private boolean pwdWillExpired = false;
    private SshClient client;
    private ClientSession session;
    private String username;
    private String password;
    private SshPublicKey publicKey = null;
    private String hostName = "";
    private int hostPort = 0;
    private volatile boolean connected;
    private ISshJudge sshEndJudgeIntf = null;
    private SessionMonitor monitor = null;
    private String logInMessage = "";

    public SshConnection(String sshHostname, String username, String password, int sshHostPort, ISshJudge sshEndJudgeIntf) {
        log.info("Connect to host: {} HostPort: {} :username: {}", new Object[]{sshHostname, sshHostPort, username});
        this.username = username;
        this.password = password;
        this.hostName = sshHostname;
        this.hostPort = sshHostPort;
        this.sshEndJudgeIntf = sshEndJudgeIntf;
    }

    public SshConnection(String sshHostname, String username, SshPublicKey publicKey, int sshHostPort, ISshJudge sshEndJudgeIntf) {
        log.info("Connect by public key to host:  {} HostPort: {} :username: {}", new Object[]{sshHostname, sshHostPort, username});
        this.hostName = sshHostname;
        this.username = username;
        this.publicKey = publicKey;
        this.hostPort = sshHostPort;
        this.sshEndJudgeIntf = sshEndJudgeIntf;
    }

    @Override
    public synchronized void close() {
        try {
            if (!this.connected) {
                return;
            }
        }
        finally {
            this.closeSession();
            this.connected = false;
        }
    }

    private void closeStraightly() {
        if (!this.connected) {
            return;
        }
        this.closeSession();
        this.connected = false;
    }

    public synchronized boolean isConnected() {
        if (!this.isConnectionActive()) {
            return false;
        }
        if (!this.isSessionActive()) {
            log.debug("the connection session is closed, close whole connection and isConnected return false.");
            this.closeStraightly();
            return false;
        }
        return true;
    }

    public boolean isMinisystem() {
        Matcher matcher = Pattern.compile(MINISYSTEM_MARK).matcher(this.logInMessage);
        if (matcher.find()) {
            log.info("The device is in minisystem mode.");
            return true;
        }
        return false;
    }

    public boolean isUpgrade() {
        Matcher matcher = Pattern.compile(UPGRADE_MARK).matcher(this.logInMessage);
        if (matcher.find()) {
            log.info("The device is in upgrade mode.");
            return true;
        }
        return false;
    }

    public synchronized boolean isConnectionActive() {
        if (!this.connected) {
            log.debug("the connection is closed, isConected return false.");
            return false;
        }
        return true;
    }

    private boolean isInitPwdNotChanged(String temp) {
        return temp.contains(INITPD_NOT_CHANGE_CLI_RETURN);
    }

    private boolean isPwdWillExpire(String temp) {
        return temp.contains(PD_WILL_EXPIRE_CLI_RETURN);
    }

    private boolean isPwdExpired(String temp) {
        return com.huawei.smartkit.drop.util.StringUtils.replaceNotEnChar((String)temp).contains(com.huawei.smartkit.drop.util.StringUtils.replaceNotEnChar((String)PD_EXPIRED_CLI_OUTPUT)) || com.huawei.smartkit.drop.util.StringUtils.replaceNotEnChar((String)temp).contains(com.huawei.smartkit.drop.util.StringUtils.replaceNotEnChar((String)PD_EXPIRED_CLI_OUTPUT_9000));
    }

    private boolean isCommandFinished(String temp) {
        return this.sshEndJudgeIntf.isSshFinish(temp, this.username);
    }

    private void preInputStreamReceiver() {
        if (Objects.isNull(this.monitor)) {
            return;
        }
        String lastOut = this.monitor.getCurrentStdOut(true);
        String lastError = this.monitor.getCurrentStdErr(true);
        if (!Strings.isNullOrEmpty((String)lastOut)) {
            log.debug("PreInputStreamReceiver. Read : {}", (Object)LogInfoCheckUtils.getVerifyMsg((String)lastOut));
        }
        if (!com.huawei.smartkit.drop.util.StringUtils.isEmpty((CharSequence)lastError)) {
            log.debug("PreInputStreamReceiver. Read :{}", (Object)LogInfoCheckUtils.getVerifyMsg((String)lastError));
        }
    }

    protected void checkConnected() throws SshException {
        if (!this.connected) {
            throw new SshException(BUILD_CON_FAILED_KEY, new String[]{this.hostName});
        }
        if (!this.isSessionActive()) {
            log.error("session is note active.");
            this.close();
            throw new SshException(BUILD_CON_FAILED_KEY, new String[]{this.hostName});
        }
    }

    public synchronized boolean isSessionActive() {
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.isActive();
    }

    private void closeSession() {
        if (this.monitor != null) {
            this.monitor.close();
            this.monitor = null;
        }
        this.client.stop();
    }

    public synchronized String getCurrentSessionOut(boolean isFlush) {
        return this.monitor.getCurrentStdOut(isFlush);
    }

    protected void sendCmd(String cmd) throws SshException {
        this.sendCmd(cmd, true);
    }

    protected void sendCmd(String cmd, boolean isEnter) throws SshException {
        boolean isFailed = false;
        try {
            this.preInputStreamReceiver();
            String remoteCommandLine = cmd;
            if (isEnter) {
                remoteCommandLine = remoteCommandLine + ENTER;
            }
            if (Objects.nonNull(this.monitor) && Objects.nonNull(remoteCommandLine)) {
                this.monitor.sendCmd(remoteCommandLine);
            }
        }
        catch (IOException th) {
            log.error("Execute cmd error,", (Throwable)th);
            isFailed = true;
        }
        if (isFailed) {
            throw new SshException("cmd.execute.error,Execute cmd error");
        }
    }

    protected String waitForResult(int timeout, boolean isLog, String cmd) throws SshException {
        try {
            return this.waitForResult(timeout, isLog, cmd, false, true);
        }
        catch (SshException e) {
            log.error("pwd exception error.");
            return "";
        }
    }

    protected String waitForResult(int timeout, boolean isLog, String cmd, boolean isLogin, boolean checkPassword) throws SshException {
        String result = "";
        boolean isFailed = false;
        try {
            ThreadUtils.threadSafeSleep((int)200, (TimeUnit)TimeUnit.MILLISECONDS);
            for (int i = 0; i < timeout; ++i) {
                if (!this.isConnected()) {
                    log.error("connection is over.");
                }
                if (!isLogin && !this.isSessionActive()) {
                    log.error("connection session is over.");
                    throw new SshException(BUILD_CON_FAILED_KEY);
                }
                if (null == this.monitor) {
                    return result;
                }
                result = this.monitor.getCurrentStdOut(false);
                if (isLogin && checkPassword) {
                    result = this.pwdCheckHandle(result);
                }
                if (this.isCommandFinished(result)) {
                    log.debug("command finished!!! isCommandFinished");
                    this.monitor.getCurrentStdOut(true);
                    break;
                }
                if (this.isEndWithByNewCli(result, cmd)) {
                    log.debug("command finished!!! isEndWithByNewCli");
                    break;
                }
                ThreadUtils.threadSafeSleep((int)1, (TimeUnit)TimeUnit.SECONDS);
                this.checkTimeout(i, timeout, isLogin);
            }
        }
        catch (SshException e) {
            log.error("pwd check failed. ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("connection exec failed", (Throwable)e);
            isFailed = true;
        }
        if (isFailed) {
            throw new SshException(BUILD_CON_FAILED_KEY, new String[]{this.hostName});
        }
        if (isLog) {
            log.debug("Receive ssh str : {}", (Object)LogInfoCheckUtils.getVerifyMsg((String)com.huawei.smartkit.drop.util.StringUtils.replacePwd((String)result)));
        }
        return result;
    }

    private String pwdCheckHandle(String result) throws SshException {
        SshCliOutputErrorType sshCliOutputErrorType = SshErrMatcher.getCliOutputErrorType(result);
        switch (sshCliOutputErrorType) {
            case INIT_PWD_NOT_CHANGE: {
                throw new SshException(SshCliOutputErrorType.INIT_PWD_NOT_CHANGE.getErrorId());
            }
            case PWD_WILL_EXPIRE: {
                this.pwdWillExpired = true;
                return this.execCmd("n", 100, false);
            }
            case PWD_EXPIRED: {
                throw new SshException("tool.connet.pwd.expired.info");
            }
        }
        return result;
    }

    public synchronized String execCmd(String command, int timout, boolean isLog) throws SshException {
        log.debug("execute not log command:*******");
        this.checkConnected();
        this.sendCmd(command);
        try {
            return this.waitForResult(timout, isLog, command, false, true);
        }
        catch (SshException e) {
            log.error("pwd exception error.", (Throwable)e);
            return "";
        }
    }

    private boolean isEndWithByNewCli(String result, String commd) throws IOException {
        int charIndex;
        boolean isNotErr;
        if (null == commd) {
            return false;
        }
        String sign = "^";
        int commdIndex = result.indexOf(commd);
        boolean bl = isNotErr = commdIndex + 1 == (charIndex = result.indexOf(sign));
        if (isNotErr || !result.contains(sign)) {
            return false;
        }
        String[] arr = result.split("\n");
        String lastLine = com.huawei.smartkit.drop.util.StringUtils.safetyGetStr((String[])arr, (int)(arr.length - 1));
        StringBuilder backSbr = new StringBuilder();
        if (lastLine.endsWith(commd)) {
            for (int chars = 0; chars < commd.length(); ++chars) {
                backSbr.append(GO_BACK);
            }
            this.monitor.sendCmd(backSbr.toString());
            return true;
        }
        if (lastLine.contains("/>")) {
            String backStr = lastLine.substring(lastLine.lastIndexOf("/>"));
            for (int chars = 0; chars < backStr.length(); ++chars) {
                backSbr.append(GO_BACK);
            }
            this.monitor.sendCmd(backSbr.toString());
            return true;
        }
        return false;
    }

    private void checkTimeout(int times, int timeout, boolean isLogin) throws SshException, IOException {
        if (times == timeout - 1) {
            log.debug("No message recived after time out, sending 'Ctrl C' command");
            this.monitor.sendCmd(3);
            for (int j = 0; j < 100; ++j) {
                if (this.isCommandFinished(this.monitor.getCurrentStdOut(false))) {
                    this.monitor.getCurrentStdOut(true);
                    break;
                }
                ThreadUtils.threadSafeSleep((int)100, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (isLogin) {
                log.error("connect time out!");
                throw new SshException("connect time out!");
            }
        }
    }

    public synchronized void connect(String sshPublicKey, boolean isCheckHostKey, boolean isUseSshSecureConn) throws SshException {
        log.debug("Begin connect SSH host: {} with port: {}", (Object)this.hostName, (Object)this.hostPort);
        try {
            this.openSession(sshPublicKey, isCheckHostKey, isUseSshSecureConn);
        }
        catch (SshException defException) {
            this.close();
            throw defException;
        }
        catch (Exception e) {
            this.close();
            log.error("connect failed", (Throwable)e);
            throw new SshException(BUILD_CON_FAILED_KEY, new String[]{this.hostName});
        }
        log.debug("SSH Connecting successfull!");
    }

    private void openSession(String sshPublicKey, boolean isCheckHostKey, boolean isUseSshSecureConn) throws IOException, SshException {
        try {
            this.initSession(sshPublicKey, isCheckHostKey, isUseSshSecureConn);
            this.monitor = new SessionMonitor(this.session);
            this.monitor.startShell();
        }
        catch (IOException e) {
            this.closeSession();
            throw new IOException(e);
        }
        this.logInMessage = this.waitForResult(180, true, null, true, true);
        this.checkIsLogining(this.logInMessage);
    }

    private void initSession(String sshPublicKey, boolean isCheckHostKey, boolean isUseSshSecureConn) throws IOException, SshException {
        try {
            if (this.hostName.contains(";")) {
                this.hostName = this.hostName.replace(";", "");
            }
            this.client = SshClient.setUpDefaultClient();
            this.setClientFactories(isUseSshSecureConn);
            this.client.start();
            if (!com.huawei.smartkit.drop.util.StringUtils.isEmpty((CharSequence)sshPublicKey) || isCheckHostKey) {
                this.client.setServerKeyVerifier((ServerKeyVerifier)new LocalServerKeyVerifier(EncryptUtils.decryptByAes((String)sshPublicKey)));
            } else {
                this.client.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
            }
            this.session = (ClientSession)((ConnectFuture)this.client.connect(this.username, this.hostName, this.hostPort).verify(10000L, new CancelOption[0])).getSession();
            String pwd = null;
            if (Objects.isNull(this.publicKey)) {
                pwd = this.getPassword();
                this.session.addPasswordIdentity(pwd);
            } else {
                Collection keyPairs = SecurityUtils.getKeyPairResourceParser().loadKeyPairs(null, Paths.get(this.publicKey.getKeyFile(), new String[0]), FilePasswordProvider.of((String)this.publicKey.getKeyPwd()), new OpenOption[0]);
                for (KeyPair keyPair : keyPairs) {
                    this.session.addPublicKeyIdentity(keyPair);
                }
            }
            this.session.auth().verify(10000L, new CancelOption[0]);
            SensitiveUtils.cleanStr((String)pwd);
            this.connected = true;
        }
        catch (Exception e) {
            String reason = e.getMessage();
            if (!com.huawei.smartkit.drop.util.StringUtils.isEmpty((CharSequence)reason) && (reason.contains("timed out") || reason.contains("timeout"))) {
                log.error("Time out, connect fail...");
                throw new SshException("timeout", e);
            }
            log.error("Connect fail, the reason is :{}", (Object)reason);
            throw new IOException("Init session error.", e);
        }
    }

    private void setClientFactories(boolean isUseSshSecureConn) {
        if (!isUseSshSecureConn) {
            this.client.setCipherFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)BuiltinCiphers.VALUES));
            this.client.setMacFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)BuiltinMacs.VALUES));
            this.client.setSignatureFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)BuiltinSignatures.VALUES));
            this.client.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)true, (Collection)BuiltinDHFactories.VALUES, (Function)ClientBuilder.DH2KEX));
        }
        if (Objects.isNull(this.publicKey)) {
            this.client.setUserAuthFactories(Collections.singletonList(UserAuthPasswordFactory.INSTANCE));
        }
    }

    private void checkIsLogining(String retInput) throws SshException {
        String ret = retInput.toLowerCase(Locale.ENGLISH).trim();
        if (this.isLogining(ret)) {
            throw new SshException("inspect.ssh.user.already.login");
        }
    }

    private boolean isLogining(String ret) {
        return StringUtils.containsAny((CharSequence)ret, (CharSequence[])new CharSequence[]{"already logged in", "Already Online", "logining in", "logged in"}) || ret.endsWith("is logining in!");
    }

    public String toString() {
        return "ssh connection connet :" + this.hostName + ":" + this.hostPort;
    }

    public String getLoginMessage() {
        return this.logInMessage;
    }

    public ClientSession getSession() {
        return this.session;
    }

    private String getPassword() {
        return EncryptUtils.decryptByAes((String)this.password);
    }

    public boolean isPwdWillExpired() {
        return this.pwdWillExpired;
    }

    @Generated
    public SshClient getClient() {
        return this.client;
    }

    @Generated
    public SshPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public int getHostPort() {
        return this.hostPort;
    }

    @Generated
    public ISshJudge getSshEndJudgeIntf() {
        return this.sshEndJudgeIntf;
    }

    @Generated
    public SessionMonitor getMonitor() {
        return this.monitor;
    }

    @Generated
    public void setPwdWillExpired(boolean pwdWillExpired) {
        this.pwdWillExpired = pwdWillExpired;
    }

    @Generated
    public void setClient(SshClient client) {
        this.client = client;
    }

    @Generated
    public void setSession(ClientSession session) {
        this.session = session;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setPublicKey(SshPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Generated
    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }

    @Generated
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Generated
    public void setSshEndJudgeIntf(ISshJudge sshEndJudgeIntf) {
        this.sshEndJudgeIntf = sshEndJudgeIntf;
    }

    @Generated
    public void setMonitor(SessionMonitor monitor) {
        this.monitor = monitor;
    }

    @Generated
    public void setLogInMessage(String logInMessage) {
        this.logInMessage = logInMessage;
    }

    @Generated
    public SshConnection() {
    }

    @Generated
    public String getUsername() {
        return this.username;
    }
}

