/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import com.huawei.smartkit.drop.protocol.ssh.entity.enums.SshCliOutputErrorType;
import com.huawei.smartkit.drop.protocol.ssh.entity.enums.SshConnectExceptionType;
import com.huawei.smartkit.drop.util.StringUtils;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class SshErrMatcher {
    private static final String USER_REACHE_UPLIMIT = "The number of users has reached the upper limit.";
    private static final String USER_REACHE_IPLIMIT_KUNPENG = "The number of users that log in through the CLI has reached the upper limit";
    private static final String USER_REACHE_UPLIMIT_MEMEROY = "the number of users that log in through the CLI reaches";
    private static final String PWD_EXPIRED_CLI_OUTPUT = "The password has expired. Please change the password and log in to the system using the new password.";
    private static final String PWD_UNSAFE_CLI_OUTPUT = "For account security, change the password and relog in to the system.";
    private static final String PWD_WILL_EXPIRE_CLI_OUTPUT = "The password is about to expire. Change the password immediately?(y/n)";
    private static final String INITPWD_NOT_CHANGE_CLI_OUTPUT = "For security purposes, please change the initial password and log in to the system using the new password.";
    private static final String LOGINCLIS_OVERRUN_LOWER_CLI_OUTPUT = "Quit one or more logged-in CLIs, or release some memory space and try again later.";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_OUTPUT_PRE = "There are more than ";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_OUTPUT_POST = "processes of ismcli in system, do not run CLI. Please try again later.";
    private static final String ROOT_INITPWD_NOT_CHANGE_CLI_OUTPUT = "you are required to change your password immediately (root enforced)";
    private static final String SECURITY_ALGORITHM_ERR_OUTPUT = "Algorithm negotiation fail";

    private static boolean isInitPwdNotChanged(String cliOutput) {
        return cliOutput.contains(INITPWD_NOT_CHANGE_CLI_OUTPUT);
    }

    private static boolean isPwdWillExpire(String cliOutput) {
        return cliOutput.contains(PWD_WILL_EXPIRE_CLI_OUTPUT);
    }

    private static boolean isPwdExpired(String cliOutput) {
        return cliOutput.contains(PWD_EXPIRED_CLI_OUTPUT);
    }

    private static boolean isSecurityAlgorithmExpired(String errorMsg) {
        return errorMsg.contains(SECURITY_ALGORITHM_ERR_OUTPUT);
    }

    public static SshCliOutputErrorType getCliOutputErrorType(@NotNull String cliOutput) {
        if (SshErrMatcher.isInitPwdNotChanged(cliOutput)) {
            return SshCliOutputErrorType.INIT_PWD_NOT_CHANGE;
        }
        if (SshErrMatcher.isPwdExpired(cliOutput)) {
            return SshCliOutputErrorType.PWD_EXPIRED;
        }
        if (SshErrMatcher.isPwdWillExpire(cliOutput)) {
            return SshCliOutputErrorType.PWD_WILL_EXPIRE;
        }
        if (SshErrMatcher.isLoginCLIsOverrun(cliOutput)) {
            return SshCliOutputErrorType.CLI_NUM_OVER;
        }
        if (SshErrMatcher.isPwdUnSafe(cliOutput)) {
            return SshCliOutputErrorType.PWD_UNSAFE;
        }
        return SshCliOutputErrorType.COMMON_ERROR;
    }

    public static SshConnectExceptionType getConnectExceptionTypeByException(@NotNull Exception exception) {
        String message = exception.getMessage();
        return SshConnectExceptionType.getConnectExceptionTypeByCliOutput(message);
    }

    private static boolean isPwdUnSafe(String result) {
        return !StringUtils.isEmpty((CharSequence)result) && result.contains(PWD_UNSAFE_CLI_OUTPUT);
    }

    private static boolean isLoginCLIsOverrun(String result) {
        if (result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_OUTPUT_PRE) && result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_OUTPUT_POST)) {
            return true;
        }
        return result.contains(LOGINCLIS_OVERRUN_LOWER_CLI_OUTPUT) || result.contains(USER_REACHE_UPLIMIT) || result.contains(USER_REACHE_UPLIMIT_MEMEROY) || result.contains(USER_REACHE_IPLIMIT_KUNPENG);
    }

    private static boolean isRootInitPwdNotChanged(String result) {
        if (StringUtils.isEmpty((CharSequence)result)) {
            return false;
        }
        return result.contains(ROOT_INITPWD_NOT_CHANGE_CLI_OUTPUT);
    }

    @Generated
    private SshErrMatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

