/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.Splitter;
import com.huawei.smartkit.drop.util.EncryptUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SshParam
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8431859298570044396L;
    private String userName = "";
    private transient String password = "";
    private String sshPort = "";
    private boolean isDebugPassword;
    private transient String debugPassword = "";
    private String ipAddresses;
    private boolean configSsh;
    private String isUpdateSshPwd;
    private int sshStatus;
    private transient String sshUserPwdNew;
    private int configWay = 0;
    private String userKeyFile;
    private transient String userKeyPwd;
    private String fingerprint = "";
    private String sshPublicKey = "";
    private String isVerifySshHostKey;
    private String isUseSshSecureConn;

    public String getEncryptPassword() {
        return this.password;
    }

    @JSONField(serialize=false)
    public String getDecryptPassword() {
        return EncryptUtils.decryptByAes((String)this.password);
    }

    public void setEncryptPassword(String pwd) {
        this.password = pwd;
    }

    public boolean isDebug() {
        return this.isDebugPassword;
    }

    public void setDebug(boolean isDebug) {
        this.isDebugPassword = isDebug;
    }

    public String getEncryptDebugPassword() {
        return this.debugPassword;
    }

    @JSONField(serialize=false)
    public String getDecryptDebugPassword() {
        return EncryptUtils.decryptByAes((String)this.debugPassword);
    }

    public void setEncryptDebugPassword(String debugPwd) {
        this.debugPassword = debugPwd;
    }

    public List<String> getIpList() {
        if (StringUtils.isBlank((CharSequence)this.ipAddresses)) {
            return Collections.emptyList();
        }
        return Splitter.on((String)";").omitEmptyStrings().trimResults().splitToList((CharSequence)this.ipAddresses);
    }

    public SshParam clone() throws CloneNotSupportedException {
        return (SshParam)super.clone();
    }

    public boolean contentEquals(SshParam sshParam) {
        if (this.configWay != sshParam.getConfigWay()) {
            return false;
        }
        if (!this.userName.equals(sshParam.getUserName())) {
            return false;
        }
        if (!this.password.equals(sshParam.getEncryptPassword())) {
            return false;
        }
        if (!this.userKeyFile.equals(sshParam.getUserKeyFile())) {
            return false;
        }
        if (!this.userKeyPwd.equals(sshParam.getUserKeyPwd())) {
            return false;
        }
        if (!this.sshPort.equals(sshParam.getSshPort())) {
            return false;
        }
        if (this.isDebugPassword ? !sshParam.isDebug() : sshParam.isDebug()) {
            return false;
        }
        return this.debugPassword.equals(sshParam.getEncryptDebugPassword());
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.userName) && StringUtils.isBlank((CharSequence)this.password);
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public void setUserKeyFile(String userKeyFile) {
        this.userKeyFile = EncryptUtils.encryptByAes((String)userKeyFile);
    }

    public void setEncryptUserKeyFile(String userKeyFileInput) {
        this.userKeyFile = userKeyFileInput;
    }

    @JSONField(serialize=false)
    public String getDecryptUserKeyFile() {
        return EncryptUtils.decryptByAes((String)this.userKeyFile);
    }

    public String getUserKeyPwd() {
        return this.userKeyPwd;
    }

    public void setUserKeyPwd(String userKeyPwd) {
        this.userKeyPwd = EncryptUtils.encryptByAes((String)userKeyPwd);
    }

    public void setEncryptUserKeyPwd(String userKeyPwdInput) {
        this.userKeyPwd = userKeyPwdInput;
    }

    @JSONField(serialize=false)
    public String getDecryptUserKeyPwd() {
        return EncryptUtils.decryptByAes((String)this.userKeyPwd);
    }

    public String getSshUserPwdNew() {
        return this.sshUserPwdNew;
    }

    @JSONField(serialize=false)
    public String getDecryptSshUserPwdNew() {
        return EncryptUtils.decryptByAes((String)this.sshUserPwdNew);
    }

    public void setSshUserPwdNew(String sshUserPwdNew) {
        this.sshUserPwdNew = EncryptUtils.encryptByAes((String)sshUserPwdNew);
    }

    public void setEncryptSshUserPwdNew(String userPwdNew) {
        this.sshUserPwdNew = userPwdNew;
    }

    public String getUpdateSshPwd() {
        return this.isUpdateSshPwd;
    }

    @JSONField(serialize=false)
    public String getDecryptUpdateSshPwd() {
        return EncryptUtils.decryptByAes((String)this.isUpdateSshPwd);
    }

    public void setUpdateSshPwd(String isUpdatePwd) {
        this.isUpdateSshPwd = EncryptUtils.encryptByAes((String)isUpdatePwd);
    }

    public void setEncryptUpdateSshPwd(String isUpdatePwd) {
        this.isUpdateSshPwd = isUpdatePwd;
    }

    public String toString() {
        return "SnmpParam [userName=" + this.userName + ", sshPort=" + this.sshPort + ", ipAddresses=" + this.ipAddresses + ", configSsh=" + this.configSsh + ", sshStatus=" + this.sshStatus + ", configWay=" + this.configWay + "]";
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getSshPort() {
        return this.sshPort;
    }

    @Generated
    public boolean isDebugPassword() {
        return this.isDebugPassword;
    }

    @Generated
    public String getDebugPassword() {
        return this.debugPassword;
    }

    @Generated
    public String getIpAddresses() {
        return this.ipAddresses;
    }

    @Generated
    public boolean isConfigSsh() {
        return this.configSsh;
    }

    @Generated
    public String getIsUpdateSshPwd() {
        return this.isUpdateSshPwd;
    }

    @Generated
    public int getSshStatus() {
        return this.sshStatus;
    }

    @Generated
    public int getConfigWay() {
        return this.configWay;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    @Generated
    public String getIsVerifySshHostKey() {
        return this.isVerifySshHostKey;
    }

    @Generated
    public String getIsUseSshSecureConn() {
        return this.isUseSshSecureConn;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setSshPort(String sshPort) {
        this.sshPort = sshPort;
    }

    @Generated
    public void setDebugPassword(boolean isDebugPassword) {
        this.isDebugPassword = isDebugPassword;
    }

    @Generated
    public void setIpAddresses(String ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    @Generated
    public void setConfigSsh(boolean configSsh) {
        this.configSsh = configSsh;
    }

    @Generated
    public void setIsUpdateSshPwd(String isUpdateSshPwd) {
        this.isUpdateSshPwd = isUpdateSshPwd;
    }

    @Generated
    public void setSshStatus(int sshStatus) {
        this.sshStatus = sshStatus;
    }

    @Generated
    public void setConfigWay(int configWay) {
        this.configWay = configWay;
    }

    @Generated
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Generated
    public void setSshPublicKey(String sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
    }

    @Generated
    public void setIsVerifySshHostKey(String isVerifySshHostKey) {
        this.isVerifySshHostKey = isVerifySshHostKey;
    }

    @Generated
    public void setIsUseSshSecureConn(String isUseSshSecureConn) {
        this.isUseSshSecureConn = isUseSshSecureConn;
    }
}

