/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum SshUserType {
    SUPER_ADMIN("SUPER_ADMIN"),
    ADMIN("ADMIN"),
    GUEST("GUEST"),
    ONE("1"),
    TWO("2"),
    THIRTEEN("13"),
    OTHER("OTHER");

    private String value;

    private SshUserType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static SshUserType getSshUserType(String level) {
        for (SshUserType userType : SshUserType.values()) {
            if (!userType.getValue().equalsIgnoreCase(level)) continue;
            return userType;
        }
        return OTHER;
    }

    public static boolean isGuestAccount(String level) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return true;
        }
        return StringUtils.containsAny((CharSequence)level.toLowerCase(Locale.ENGLISH), (CharSequence[])new CharSequence[]{OTHER.getValue().toLowerCase(Locale.ENGLISH), GUEST.getValue().toLowerCase(Locale.ENGLISH)});
    }

    public static boolean isSpuerAdminAccount(String level) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return false;
        }
        for (SshUserType userType : SshUserType.values()) {
            if (!userType.getValue().equalsIgnoreCase(level.trim()) || userType != ONE && SUPER_ADMIN != userType) continue;
            return true;
        }
        return false;
    }
}

