/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity.enums;

import com.huawei.baize.base.string.StringFormatUtils;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum SshConnectExceptionType {
    CONNECT_TIME_OUT("ssh.connect.timed.out", "connection timed out"),
    CONNECT_AUTH_FAIL("ssh.connect.auth.fail", "auth fail"),
    KEY_FILE_NOT_FOUND("ssh.connect.key.not.found", "filenotfoundexception"),
    KEY_AUTH_NOT_SUPPORT("ssh.connect.auth.not.support.key", "shouldn't use publickey"),
    PWD_AUTH_NOT_SUPPORT("ssh.connect.auth.not.support.pwd", "shouldn't use password"),
    CONNECT_UNKNOWN_ERR("ssh.connect.unknown.error", "--.ssh.connect.unknown.error.info.!!!!");

    private final String errorId;
    private final String matchKey;

    @NotNull
    public static SshConnectExceptionType get(@NotNull String errorId) throws IllegalArgumentException {
        return Arrays.stream(SshConnectExceptionType.values()).filter(exceptionType -> exceptionType.getErrorId().equalsIgnoreCase(errorId)).findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatUtils.format((String)"Could not find error type for name {}.", (Object[])new Object[]{errorId})));
    }

    @NotNull
    public static SshConnectExceptionType getConnectExceptionTypeByCliOutput(@NotNull String errorMsg) {
        return Arrays.stream(SshConnectExceptionType.values()).filter(exceptionType -> errorMsg.toLowerCase(Locale.ROOT).contains(exceptionType.getMatchKey())).findFirst().orElse(CONNECT_UNKNOWN_ERR);
    }

    @Generated
    private SshConnectExceptionType(String errorId, String matchKey) {
        this.errorId = errorId;
        this.matchKey = matchKey;
    }

    @Generated
    public String getErrorId() {
        return this.errorId;
    }

    @Generated
    public String getMatchKey() {
        return this.matchKey;
    }
}

