/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.service;

import com.huawei.smartkit.drop.protocol.ssh.entity.DeviceBaseVo;
import com.huawei.smartkit.drop.protocol.ssh.entity.ISshJudge;
import com.huawei.smartkit.drop.protocol.ssh.entity.SshConnection;
import com.huawei.smartkit.drop.protocol.ssh.entity.SshException;
import com.huawei.smartkit.drop.protocol.ssh.service.ISshConnection;
import com.huawei.smartkit.drop.util.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionAdapter
extends SshConnection
implements ISshConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshConnectionAdapter.class);
    private static final int CMD_DEFAULT_TIMEOUT = 1200;

    public SshConnectionAdapter(DeviceBaseVo deviceBaseVo, ISshJudge sshEndJudgeIntf) {
        super(deviceBaseVo.getIp(), deviceBaseVo.getLoginUser().getName(), deviceBaseVo.getLoginUser().getPassword(), deviceBaseVo.getPort(), sshEndJudgeIntf);
        log.info("Connect to host: {} HostPort: {} :username: {}", new Object[]{deviceBaseVo.getIp(), deviceBaseVo.getPort(), deviceBaseVo.getLoginUser().getName()});
    }

    public synchronized void execCmdWithOutReturn(String commandLine) throws SshException {
        this.execCmdWithOutReturn(commandLine, true);
    }

    public synchronized void execCmdWithOutReturn(String command, boolean isAutoEnter) throws SshException {
        log.debug("Excuted command line : {}", (Object)StringUtils.replacePwd((String)command));
        this.checkConnected();
        this.sendCmd(command, false);
    }

    @Override
    public String execCmd(String commandLine) throws SshException {
        return this.execCmdWithTimout(commandLine, 1200);
    }

    @Override
    public synchronized String execCmdNoLog(String command) throws SshException {
        log.debug("execute not log command:{}", (Object)StringUtils.replacePwd((String)command));
        this.checkConnected();
        this.sendCmd(command);
        return this.waitForResult(1200, false, command);
    }

    @Override
    public synchronized String execCmdNoLogTimout(String command, int timout) throws SshException {
        log.debug("execute not log command:*******");
        this.checkConnected();
        this.sendCmd(command);
        try {
            return this.waitForResult(timout, false, command, false, true);
        }
        catch (SshException e) {
            log.error("pwd exception error.", (Throwable)e);
            return "";
        }
    }

    @Override
    public synchronized String execCmdWithTimout(String commandLine, int timeout) throws SshException {
        log.debug("Excuted command line : {}", (Object)StringUtils.replacePwd((String)commandLine));
        this.checkConnected();
        this.sendCmd(commandLine);
        return this.waitForResult(timeout, true, commandLine);
    }

    @Override
    public synchronized String execCmdWithTryCount(String command, int tryCount) throws SshException {
        log.debug("Executed command line : {}", (Object)StringUtils.replacePwd((String)command));
        this.checkConnected();
        this.sendCmd("screen-length 0 temporary\n" + command);
        return this.waitForResult(tryCount, true, command, false, false);
    }

    @Generated
    public SshConnectionAdapter() {
    }
}

