/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.service;

import com.huawei.smartkit.drop.protocol.ssh.dto.SshConnectionCreateCmd;
import com.huawei.smartkit.drop.protocol.ssh.entity.DefaultSshJudge;
import com.huawei.smartkit.drop.protocol.ssh.entity.DeviceBaseVo;
import com.huawei.smartkit.drop.protocol.ssh.entity.ISshJudge;
import com.huawei.smartkit.drop.protocol.ssh.service.ISshConnection;
import com.huawei.smartkit.drop.protocol.ssh.service.SshConnectionAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SshConnectionMgmtService {
    private Map<String, ISshConnection> sshConnectionMap = new HashMap<String, ISshConnection>();

    public ISshConnection createConnection(SshConnectionCreateCmd createCmd) {
        DeviceBaseVo deviceBaseVo = createCmd.getDeviceBaseVo();
        ISshJudge sshJudge = createCmd.getSshJudge() == null ? new DefaultSshJudge() : createCmd.getSshJudge();
        SshConnectionAdapter sshConnection = new SshConnectionAdapter(deviceBaseVo, sshJudge);
        sshConnection.connect("", false, false);
        return sshConnection;
    }

    public ISshConnection getConnection(SshConnectionCreateCmd createCmd) {
        String connectionKey = createCmd.getConnectionKey();
        if (this.sshConnectionMap.containsKey(connectionKey)) {
            return this.sshConnectionMap.get(connectionKey);
        }
        return this.createConnection(createCmd);
    }

    public void releaseConnection(DeviceBaseVo deviceBaseVo) throws IOException {
        ISshConnection connection = this.sshConnectionMap.get(deviceBaseVo.getIp() + deviceBaseVo.getPort());
        connection.close();
    }
}

