/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.RecordDataParser;
import com.huawei.ftdsanalysis.analysis.iorecord.RecordDateMerge;
import com.huawei.ftdsanalysis.analysis.iorecord.exception.IORecordAnalyseException;
import com.huawei.ftdsanalysis.analysis.iorecord.io.BinaryFileReader;
import com.huawei.ftdsanalysis.analysis.iorecord.io.SmallHeadInputStream;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.util.CSVFileUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class IORecordFileAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(IORecordFileAnalyzer.class);
    private BinaryFileReader fileReader;
    private static final int BUFFERED_SIZE = 0x500000;
    private StringBuilder dataTypeErrorBuilder = new StringBuilder();
    private String outPutPath;
    private int paseRules;
    private Map<Object, LocationTableInfo> tableInfoMap = new ConcurrentHashMap<Object, LocationTableInfo>();

    public IORecordFileAnalyzer(InputStream in, String outPutPath, int paseRules) throws IOException {
        this.fileReader = new BinaryFileReader(new SmallHeadInputStream(new BufferedInputStream(in, 0x500000)));
        this.outPutPath = outPutPath;
        this.paseRules = paseRules;
    }

    public void analyse() throws IOException {
        LOGGER.info((Object)"record file parse started");
        try {
            this.fileReader.skip(128);
            while (this.fileReader.available() >= 16) {
                RecordDataParser.parseRecordData(this.fileReader, this.tableInfoMap, this.dataTypeErrorBuilder);
            }
            if (this.paseRules == 2) {
                RecordDateMerge.takeOutDate(this);
            }
            LOGGER.info((Object)"record file parse filished");
            this.writeToFile();
            LOGGER.info((Object)"parse result write to CSV filished");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Date have error.", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (this.dataTypeErrorBuilder.length() > 0) {
                LOGGER.error((Object)this.dataTypeErrorBuilder.toString());
            }
            this.close();
        }
    }

    public void writeToFile() throws IOException {
        ArrayList<Map.Entry<Object, LocationTableInfo>> list = new ArrayList<Map.Entry<Object, LocationTableInfo>>(this.tableInfoMap.entrySet());
        if (list.isEmpty()) {
            throw new IORecordAnalyseException("not have date.");
        }
        for (Map.Entry entry : list) {
            LocationTableInfo locationTableInfo = (LocationTableInfo)entry.getValue();
            if (locationTableInfo.getDataList().isEmpty()) continue;
            CSVFileUtil.createCSVFile(locationTableInfo, this.outPutPath, this.paseRules);
            locationTableInfo.getDataList().clear();
        }
        CSVFileUtil.initializationA();
    }

    private void close() {
        try {
            this.fileReader.close();
            this.fileReader = null;
        }
        catch (IOException e) {
            LOGGER.error((Object)"close IORecordFileAnalyzer IOException\uff1a", (Throwable)e);
        }
    }

    public Map<Object, LocationTableInfo> getTableInfoMap() {
        return this.tableInfoMap;
    }

    public void setTableInfoMap(Map<Object, LocationTableInfo> tableInfoMap) {
        this.tableInfoMap = tableInfoMap;
    }
}

