/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.RecordDataParserNew;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LongField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.StringField;
import com.huawei.ftdsanalysis.analysis.iorecord.io.BinaryFileReader;
import com.huawei.ftdsanalysis.analysis.iorecord.io.SmallHeadInputStream;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FieldType;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FsidTableInfoTemp;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfoMap;
import com.huawei.ftdsanalysis.analysis.iorecord.model.RecordHeadInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.util.SANCSVFile;
import com.huawei.ftdsanalysis.analysis.iorecord.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class IORecordFileAnalyzerNAS {
    private static final Logger LOGGER = Logger.getLogger(IORecordFileAnalyzerNAS.class);
    private BinaryFileReader fileReader;
    private static final int BUFFERED_SIZE = 0x500000;
    private String outPutPath = null;
    private static final String OPCODE = "opcode";
    private StringBuilder dataTypeErrorBuilder = new StringBuilder();
    private Map<String, SANCSVFile> csvFileMap = new ConcurrentHashMap<String, SANCSVFile>();

    public IORecordFileAnalyzerNAS(InputStream in, String outPutPath) throws IOException {
        this.fileReader = new BinaryFileReader(new SmallHeadInputStream(new BufferedInputStream(in, 0x500000)));
        this.outPutPath = outPutPath;
    }

    public void analyse() throws IOException {
        try {
            this.fileReader.skip(128);
            while (this.fileReader.available() >= 16) {
                this.parseRecordData();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Date have error.", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (this.dataTypeErrorBuilder.length() > 0) {
                LOGGER.error((Object)this.dataTypeErrorBuilder.toString());
            }
            for (SANCSVFile csvFile : this.csvFileMap.values()) {
                csvFile.closeAll();
            }
            this.close();
        }
    }

    public void parseRecordData() throws IOException {
        RecordHeadInfo recordHeadInfo = RecordDataParserNew.parseRecordHead(this.fileReader);
        int locationId = recordHeadInfo.getLocationId();
        if (LocationTableInfoMap.getInstance().get(locationId) != null) {
            boolean handlerIsOne;
            LocationTableInfo locationTableInfo = new LocationTableInfo();
            locationTableInfo.setTableFieldList(LocationTableInfoMap.getInstance().get(locationId).getTableFieldListClon());
            if (this.fileReader.available() >= recordHeadInfo.getLength() && (handlerIsOne = this.parseRecordBody(locationTableInfo, recordHeadInfo, locationId))) {
                return;
            }
            LocationField locationIdtabele = new LocationField("locationId", FieldType.STRING, 100);
            locationTableInfo.addField(locationIdtabele);
            String fsid = locationTableInfo.getTableName();
            SANCSVFile csvFile = this.csvFileMap.get(fsid);
            if (csvFile == null) {
                String fileName = this.outPutPath + "-FSID-" + fsid;
                csvFile = new SANCSVFile(fileName);
                this.csvFileMap.put(fsid, csvFile);
            }
            csvFile.writerCSVFile(locationTableInfo);
        } else {
            this.dataTypeErrorBuilder.append("Can't find the locationID:").append(locationId);
            this.fileReader.skip(recordHeadInfo.getLength());
        }
    }

    private boolean parseRecordBody(LocationTableInfo locationTableInfo, RecordHeadInfo recordHeadInfo, int locationId) throws IOException {
        HashMap<String, LocationField> dataMap = new HashMap<String, LocationField>();
        int length = recordHeadInfo.getLength();
        int len = 0;
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            LocationField locationField = null;
            if (field.getName().equals("time")) {
                locationField = new LongField(field.getName(), BigInteger.valueOf(recordHeadInfo.getRecordDate()), FieldType.LONG, 8);
            } else {
                len += field.getLength();
                locationField = field.getType().newInstance().parse(field, this.fileReader);
            }
            dataMap.put(field.getName(), locationField);
        }
        this.checkLength(locationTableInfo, length, len);
        String locationID1 = String.valueOf(Integer.toHexString(locationId)).substring(0, 1);
        locationId = this.getLocationId(locationId, dataMap, locationID1);
        String fsid = ((LocationField)dataMap.get("fsid")).stringValue();
        locationTableInfo.setTableName(fsid);
        locationTableInfo.setTableId(fsid);
        String handler = ((LocationField)dataMap.get("handler")).stringValue();
        String name = LocationTableInfoMap.getInstance().get(locationId).getTableName();
        if ("0".equals(handler)) {
            name = name + "_START";
        } else {
            if ("1".equals(handler)) {
                String xid = ((LocationField)dataMap.get("xid")).stringValue();
                FsidTableInfoTemp.getInstance().put(xid, dataMap);
                return true;
            }
            name = name + "_DONE";
        }
        StringField locationField = new StringField("locationId", name, FieldType.STRING, 100);
        dataMap.put("locationId", locationField);
        locationTableInfo.addData(dataMap);
        return false;
    }

    private int getLocationId(int locationId, Map<String, LocationField> dataMap, String locationID1) {
        if (dataMap.containsKey(OPCODE) && "20".equals(locationID1) && "9".equals(dataMap.get(OPCODE).stringValue())) {
            int id2;
            locationId = id2 = StringUtil.hexIntValue("0x200033");
        }
        return locationId;
    }

    private void checkLength(LocationTableInfo locationTableInfo, int length, int len) throws IOException {
        if (length > len) {
            this.fileReader.skip(length - len);
        } else if (length < len) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Date Record failed,locationid=" + locationTableInfo.getTableId()));
            }
            throw new IOException("Io Record parsed an error, recordLength:" + length + ", realLength:" + len);
        }
    }

    private void close() {
        try {
            this.fileReader.close();
            this.fileReader = null;
        }
        catch (IOException e) {
            LOGGER.error((Object)"close fileReader IOException\uff1a", (Throwable)e);
        }
    }
}

