/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.RecordDataParserNew;
import com.huawei.ftdsanalysis.analysis.iorecord.io.BinaryFileReader;
import com.huawei.ftdsanalysis.analysis.iorecord.io.SmallHeadInputStream;
import com.huawei.ftdsanalysis.analysis.iorecord.util.SANCSVFile;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class IORecordFileAnalyzerNew {
    private static final Logger LOGGER = Logger.getLogger(IORecordFileAnalyzerNew.class);
    private BinaryFileReader fileReader;
    private static final int BUFFERED_SIZE = 0x500000;
    private StringBuilder dataTypeErrorBuilder = new StringBuilder();
    private SANCSVFile csvFile = null;

    public IORecordFileAnalyzerNew(InputStream in, String outPutPath) throws IOException {
        this.fileReader = new BinaryFileReader(new SmallHeadInputStream(new BufferedInputStream(in, 0x500000)));
        this.csvFile = new SANCSVFile(outPutPath);
    }

    public void analyse() throws IOException {
        try {
            this.fileReader.skip(128);
            while (this.fileReader.available() >= 16) {
                RecordDataParserNew.parseRecordData(this.fileReader, this.dataTypeErrorBuilder, this.csvFile);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Date have error.", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            if (this.dataTypeErrorBuilder.length() > 0) {
                LOGGER.error((Object)this.dataTypeErrorBuilder.toString());
            }
            this.csvFile.closeAll();
            this.close();
        }
    }

    private void close() {
        try {
            this.fileReader.close();
            this.fileReader = null;
        }
        catch (IOException e) {
            LOGGER.error((Object)"close IOException\uff1a", (Throwable)e);
        }
    }
}

