/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.exception.VersionNMapParserException;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FieldType;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfoMap;
import com.huawei.ftdsanalysis.analysis.iorecord.util.CSVFileUtil;
import com.huawei.ftdsanalysis.analysis.iorecord.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LocationTableInfoMapParser {
    private static final Logger LOGGER = Logger.getLogger(LocationTableInfoMapParser.class);
    private static final byte VALUE_LENGTH = 4;
    private static final String CHARSET_NAME = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputStream in, int paseRules) throws IOException {
        LOGGER.info((Object)"version.nmap parse started");
        LocationTableInfoMap.getInstance().clear();
        BufferedReader b = null;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in, CHARSET_NAME);
            b = new BufferedReader(isr);
            LocationTableInfoMapParser.addMapEntry(b, paseRules);
            if (LocationTableInfoMap.getInstance().getEntryLocationTableInfoList().size() == 0) {
                throw new VersionNMapParserException("version.nmap parse no date.");
            }
        }
        catch (Throwable throwable) {
            CSVFileUtil.close(b);
            CSVFileUtil.close(isr);
            CSVFileUtil.close(in);
            throw throwable;
        }
        CSVFileUtil.close(b);
        CSVFileUtil.close(isr);
        CSVFileUtil.close(in);
        LOGGER.info((Object)"version.nmap parse filished");
    }

    private static void addMapEntry(BufferedReader b, int paseRules) throws IOException {
        String content = "";
        HashMap<Integer, String> locationInfoMap = new HashMap<Integer, String>();
        while ((content = b.readLine()) != null) {
            String str = content.trim();
            String[] strs = str.split("=");
            if (strs.length >= 2) {
                String key = strs[0].trim();
                if ("".equals(key)) {
                    LOGGER.error((Object)"parse locationId file error,locationID is null.");
                    continue;
                }
                String[] values = strs[1].trim().split(",");
                if (values.length < 4) {
                    LOGGER.error((Object)"parse locationId file error,values length less 4.");
                    continue;
                }
                locationInfoMap.put(StringUtil.hexIntValue(key), values[3]);
                continue;
            }
            if (!str.equals("[FORMAT]")) continue;
            LocationTableInfoMapParser.intermediary(b, locationInfoMap, paseRules);
        }
    }

    private static void intermediary(BufferedReader b, Map<Integer, String> locationMap, int paseRules) throws IOException {
        String content = "";
        if (paseRules == 1) {
            LocationTableInfoMapParser.addLocationTableInfoMapEntry(b, locationMap);
        } else if (paseRules == 2) {
            while ((content = b.readLine()) != null) {
                String str = content.trim();
                if (!str.equals("[PROTOCOL-FORMAT]")) continue;
                LocationTableInfoMapParser.addLocationTableInfoMapEntry(b, locationMap);
            }
        }
    }

    private static void addLocationTableInfoMapEntry(BufferedReader b, Map<Integer, String> locationMap) throws IOException {
        String content = "";
        LocationTableInfoMap locationTableInfoMap = LocationTableInfoMap.getInstance();
        while ((content = b.readLine()) != null) {
            String str = content.trim();
            String[] strs = str.split("=");
            if (strs.length < 2) continue;
            String key = strs[0].trim();
            if ("".equals(key)) {
                LOGGER.error((Object)"parse locationId file error,locationID is null.");
                continue;
            }
            LocationTableInfo locationTableInfo = LocationTableInfoMapParser.parseLocationTableInfo(key, strs[1].trim(), locationMap);
            if (locationTableInfo != null) {
                locationTableInfoMap.put(locationTableInfo);
                continue;
            }
            LOGGER.error((Object)("parse locationId file error\uff0clocationID\uff1a" + key + "format error."));
        }
    }

    private static LocationTableInfo parseLocationTableInfo(String key, String value, Map<Integer, String> locationMap) {
        LocationTableInfo locationTableInfo = new LocationTableInfo();
        int locationId = StringUtil.hexIntValue(key);
        locationTableInfo.setTableId(locationId);
        locationTableInfo.setTableName(locationMap.get(locationId));
        String[] fieldvalues = value.trim().split("\\|");
        LocationTableInfoMapParser.addTimeField(locationTableInfo);
        for (String val : fieldvalues) {
            if (StringUtil.isEmpty(val)) continue;
            LocationField field = LocationTableInfoMapParser.parseField(val);
            if (field != null) {
                locationTableInfo.addField(field);
                continue;
            }
            return null;
        }
        return locationTableInfo;
    }

    private static void addTimeField(LocationTableInfo locationTableInfo) {
        LocationField field = new LocationField();
        field.setName("time");
        field.setLength(8);
        field.setType(FieldType.LONG);
        locationTableInfo.addField(field);
    }

    private static LocationField parseField(String value) {
        String[] tempStrs;
        String[] strs;
        LocationField field = null;
        if (!StringUtil.isEmpty(value) && (strs = value.split(":")).length == 2 && (tempStrs = strs[1].split("\\%")).length == 2) {
            field = new LocationField();
            field.setName(strs[0]);
            field.setLength(Integer.parseInt(tempStrs[0]));
            field.setType(FieldType.transfer(LocationTableInfoMapParser.getFieldTypeValue(tempStrs)));
        }
        return field;
    }

    private static String getFieldTypeValue(String[] tempStrs) {
        String fieldTypeValue = "";
        fieldTypeValue = tempStrs[1].contains("d") ? tempStrs[0] + "%" + tempStrs[1] : "%" + tempStrs[1];
        return fieldTypeValue;
    }
}

