/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.exception.FileException;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FsidTableInfoTemp;
import com.huawei.ftdsanalysis.analysis.iorecord.model.TableHead;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class NASDateMergeTask
implements Callable<String> {
    private static final Logger LOGGER = Logger.getLogger(NASDateMergeTask.class);
    private static final String CHARSET_NAME = "utf-8";
    private static final int BUFFER_SIZE = 5120;
    private File mergeFile = null;
    private static final String IO_SIZE = "io_size(4%d)";
    private static final String IO_OFFSET = "io_offset(8%d)";
    private static final String FSID = "fsid(8%d)";
    private static final String FID = "fid(8%d)";
    private static final String HANDLER = "handler(1%d)";
    private static final String XID = "xid(4%d)";
    private static final String ZERO = "0";

    public NASDateMergeTask(File mergeFile) {
        this.mergeFile = mergeFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String call() throws Exception {
        File csvFile;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "File merge started,File name is %s", this.mergeFile.getName()));
        String line = null;
        try {
            csvFile = this.getCsvFile(this.mergeFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to get canonical path of mergeFile", (Throwable)e);
            if (!this.mergeFile.delete()) return null;
            LOGGER.error((Object)("Delete temp file is false,file name is : " + this.mergeFile.getName()));
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.mergeFile), 5120);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), CHARSET_NAME);
             BufferedWriter csvWriter = new BufferedWriter(osw, 5120);){
            String head = br.readLine();
            if (head == null) {
                String string = null;
                return string;
            }
            String[] tabele = head.split("\\|");
            int index = 0;
            ConcurrentHashMap<String, TableHead> tabelHeadMap = new ConcurrentHashMap<String, TableHead>();
            this.putTabelHeadMap(tabele, index, tabelHeadMap);
            csvWriter.write(head);
            csvWriter.newLine();
            while ((line = br.readLine()) != null) {
                String handler = line.substring(((TableHead)tabelHeadMap.get(HANDLER)).getIndexStart(), ((TableHead)tabelHeadMap.get(HANDLER)).getIndexEnd()).trim();
                line = this.getline(line, tabelHeadMap, handler);
                csvWriter.write(line);
                csvWriter.newLine();
            }
            csvWriter.flush();
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        if (this.mergeFile.delete()) {
            LOGGER.error((Object)("Delete temp file is false,file name is : " + this.mergeFile.getName()));
        }
        LOGGER.info((Object)"File merge is filished.");
        return null;
    }

    private File getCsvFile(String name) throws IOException {
        File csvFile = FileUtils.getFile(this.mergeFile.getCanonicalPath().substring(0, name.length() - 5) + ".csv");
        if (csvFile == null) {
            LOGGER.error((Object)"csvFile is null");
            return csvFile;
        }
        if (!csvFile.createNewFile()) {
            LOGGER.error((Object)(csvFile.getName() + " create failed!"));
        }
        return csvFile;
    }

    private void putTabelHeadMap(String[] tabele, int index, Map<String, TableHead> tabelHeadMap) {
        for (String string : tabele) {
            TableHead th = new TableHead();
            th.setName(string);
            th.setIndexStart(index);
            th.setIndexEnd(index += string.length());
            tabelHeadMap.put(string.trim(), th);
            ++index;
        }
    }

    private String getline(String line, Map<String, TableHead> tabelHeadMap, String handler) {
        if (handler.equals("2")) {
            String xid = line.substring(tabelHeadMap.get(XID).getIndexStart(), tabelHeadMap.get(XID).getIndexEnd()).trim();
            if (FsidTableInfoTemp.getInstance().isContainXid(xid)) {
                Map<String, LocationField> data = FsidTableInfoTemp.getInstance().get(xid);
                line = this.mergeData(IO_SIZE, line, tabelHeadMap, data);
                line = this.mergeData(IO_OFFSET, line, tabelHeadMap, data);
                line = this.mergeData(FSID, line, tabelHeadMap, data);
                line = this.mergeData(FID, line, tabelHeadMap, data);
            }
        }
        return line;
    }

    private String stuff(String date) {
        StringBuilder strB = new StringBuilder();
        strB.append(date);
        while (strB.length() < 20) {
            strB.append(" ");
        }
        return strB.toString();
    }

    private String mergeData(String type, String line, Map<String, TableHead> tabelHeadMap, Map<String, LocationField> data) {
        String[] list;
        String type2;
        String typerValue;
        String result = line;
        if (tabelHeadMap.containsKey(type) && !ZERO.equals(typerValue = data.get(type2 = (list = type.split("\\("))[0]).stringValue())) {
            result = line.substring(0, tabelHeadMap.get(type).getIndexStart()) + this.stuff(typerValue) + line.substring(tabelHeadMap.get(type).getIndexEnd());
        }
        return result;
    }

    private static void close(Closeable os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }
    }
}

