/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LongField;
import com.huawei.ftdsanalysis.analysis.iorecord.io.BinaryFileReader;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FieldType;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfoMap;
import com.huawei.ftdsanalysis.analysis.iorecord.model.RecordHeadInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordDataParser {
    private static final Logger LOGGER = Logger.getLogger(RecordDataParser.class);

    public static void parseRecordData(BinaryFileReader fileReader, Map<Object, LocationTableInfo> tableInfoMap, StringBuilder dataTypeErrorBuilder) throws IOException {
        RecordHeadInfo recordHeadInfo = RecordDataParser.parseRecordHead(fileReader);
        int locationId = recordHeadInfo.getLocationId();
        LocationTableInfo locationTableInfo = tableInfoMap.get(locationId);
        if (LocationTableInfoMap.getInstance().get(locationId) != null) {
            if (locationTableInfo == null) {
                locationTableInfo = new LocationTableInfo();
                locationTableInfo.setTableId(locationId);
                locationTableInfo.setTableName(LocationTableInfoMap.getInstance().get(locationId).getTableName());
                locationTableInfo.setTableFieldList(LocationTableInfoMap.getInstance().get(locationId).getTableFieldListClon());
                tableInfoMap.put(locationId, locationTableInfo);
            }
            if (fileReader.available() >= recordHeadInfo.getLength()) {
                RecordDataParser.parseRecordBody(fileReader, locationTableInfo, recordHeadInfo);
            }
        } else {
            dataTypeErrorBuilder.append("Can't find the locationID:").append(locationId);
            fileReader.skip(recordHeadInfo.getLength());
        }
    }

    public static RecordHeadInfo parseRecordHead(BinaryFileReader fileReader) throws IOException {
        RecordHeadInfo recordHeadInfo = new RecordHeadInfo();
        recordHeadInfo.setRecordDate(fileReader.readLong());
        recordHeadInfo.setLocationId(fileReader.readInt());
        recordHeadInfo.setLength(fileReader.readShortUnsigned());
        recordHeadInfo.setNum(fileReader.readShort());
        return recordHeadInfo;
    }

    public static void parseRecordBody(BinaryFileReader fileReader, LocationTableInfo locationTableInfo, RecordHeadInfo recordHeadInfo) throws IOException {
        HashMap<String, LocationField> dataMap = new HashMap<String, LocationField>();
        int length = recordHeadInfo.getLength();
        int len = 0;
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            LocationField locationField;
            if (field.getName().equals("time")) {
                locationField = new LongField(field.getName(), BigInteger.valueOf(recordHeadInfo.getRecordDate()), FieldType.LONG, 8);
                dataMap.put(field.getName(), locationField);
                continue;
            }
            len += field.getLength();
            locationField = field.getType().newInstance().parse(field, fileReader);
            dataMap.put(field.getName(), locationField);
        }
        if (length > len) {
            fileReader.skip(length - len);
        } else if (length < len) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Date Record failed,locationid=" + locationTableInfo.getTableId()));
            }
            throw new IOException("Io Record parsed an error, recordLength:" + length + ", realLength:" + len);
        }
        locationTableInfo.addData(dataMap);
    }
}

