/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LongField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.StringField;
import com.huawei.ftdsanalysis.analysis.iorecord.io.BinaryFileReader;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FieldType;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfoMap;
import com.huawei.ftdsanalysis.analysis.iorecord.model.RecordHeadInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.util.SANCSVFile;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RecordDataParserNew {
    private static final Logger LOGGER = Logger.getLogger(RecordDataParserNew.class);

    public static void parseRecordData(BinaryFileReader fileReader, StringBuilder dataTypeErrorBuilder, SANCSVFile csvFile) throws IOException {
        RecordHeadInfo recordHeadInfo = RecordDataParserNew.parseRecordHead(fileReader);
        int locationId = recordHeadInfo.getLocationId();
        if (LocationTableInfoMap.getInstance().get(locationId) != null) {
            LocationTableInfo locationTableInfo = new LocationTableInfo();
            locationTableInfo.setTableId(locationId);
            locationTableInfo.setTableName(LocationTableInfoMap.getInstance().get(locationId).getTableName());
            locationTableInfo.setTableFieldList(LocationTableInfoMap.getInstance().get(locationId).getTableFieldListClon());
            LocationField locationIdtabele = new LocationField("locationId", FieldType.STRING, 100);
            locationTableInfo.addField(locationIdtabele);
            if (fileReader.available() >= recordHeadInfo.getLength()) {
                RecordDataParserNew.parseRecordBody(fileReader, locationTableInfo, recordHeadInfo);
            }
            csvFile.writerCSVFile(locationTableInfo);
            locationTableInfo.clear();
        } else {
            dataTypeErrorBuilder.append("Can't find the locationID:").append(locationId);
            fileReader.skip(recordHeadInfo.getLength());
        }
    }

    public static RecordHeadInfo parseRecordHead(BinaryFileReader fileReader) throws IOException {
        RecordHeadInfo recordHeadInfo = new RecordHeadInfo();
        recordHeadInfo.setRecordDate(fileReader.readLong());
        recordHeadInfo.setLocationId(fileReader.readInt());
        recordHeadInfo.setLength(fileReader.readShortUnsigned());
        recordHeadInfo.setNum(fileReader.readShort());
        return recordHeadInfo;
    }

    public static void parseRecordBody(BinaryFileReader fileReader, LocationTableInfo locationTableInfo, RecordHeadInfo recordHeadInfo) throws IOException {
        HashMap<String, LocationField> dataMap = new HashMap<String, LocationField>();
        int length = recordHeadInfo.getLength();
        int len = 0;
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            LocationField locationField = null;
            if (field.getName().equals("time")) {
                locationField = new LongField(field.getName(), BigInteger.valueOf(recordHeadInfo.getRecordDate()), FieldType.LONG, 8);
            } else if (field.getName().equals("locationId")) {
                String newName = locationTableInfo.getTableName();
                locationField = new StringField("locationId", newName, FieldType.STRING, 100);
            } else {
                len += field.getLength();
                locationField = field.getType().newInstance().parse(field, fileReader);
            }
            dataMap.put(field.getName(), locationField);
        }
        if (length > len) {
            fileReader.skip(length - len);
        } else if (length < len) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Date Record failed,locationid=" + locationTableInfo.getTableId()));
            }
            throw new IOException("Io Record parsed an error, recordLength:" + length + ", realLength:" + len);
        }
        locationTableInfo.addData(dataMap);
    }
}

