/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.IORecordFileAnalyzer;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.field.StringField;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FieldType;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ftdsanalysis.analysis.iorecord.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RecordDateMerge {
    private static final Logger LOGGER = Logger.getLogger(RecordDateMerge.class);
    private static final String HANDLER = "handler";
    private static final String START = "_START";
    private static final String DONE = "_DONE";
    private static final String OPCODE = "opcode";
    private static final String XID = "xid";
    private static final String IO_SIZE = "io_size";
    private static final String IO_OFFSET = "io_offset";
    private static final String FSID = "fsid";
    private static final String FID = "fid";
    private static final String ID1 = "20";
    private static final String ID2 = "0x200033";
    private static final String HANDLERID0 = "0";
    private static final String HANDLERID1 = "1";
    private static final String HANDLERID2 = "2";
    private static final String OPCODEID9 = "9";
    private static final String ZERO = "0";

    public static void takeOutDate(IORecordFileAnalyzer ioRecord) throws IOException {
        ConcurrentHashMap<Object, LocationTableInfo> tableInfoMapNAS = new ConcurrentHashMap<Object, LocationTableInfo>();
        ArrayList<Map<String, LocationField>> temporaryList = new ArrayList<Map<String, LocationField>>();
        ArrayList<Map.Entry<Object, LocationTableInfo>> list = new ArrayList<Map.Entry<Object, LocationTableInfo>>(ioRecord.getTableInfoMap().entrySet());
        try {
            RecordDateMerge.takeOuthandl1(temporaryList, list);
            if (!temporaryList.isEmpty()) {
                RecordDateMerge.merger(temporaryList, list);
            }
            RecordDateMerge.restructuring(tableInfoMapNAS, list);
            ioRecord.setTableInfoMap(tableInfoMapNAS);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Merge Date error.", (Throwable)e);
        }
    }

    public static void replace(Map<Object, LocationTableInfo> tableInfoMap, Map<Object, LocationTableInfo> tableInfoMapNAS) {
        tableInfoMap.clear();
        ArrayList<Map.Entry<Object, LocationTableInfo>> listNAS = new ArrayList<Map.Entry<Object, LocationTableInfo>>(tableInfoMapNAS.entrySet());
        for (Map.Entry entry : listNAS) {
            tableInfoMap.put(entry.getKey(), (LocationTableInfo)entry.getValue());
        }
    }

    public static void restructuring(Map<Object, LocationTableInfo> tableInfoMapNAS, List<Map.Entry<Object, LocationTableInfo>> list) {
        for (Map.Entry<Object, LocationTableInfo> e : list) {
            LocationTableInfo locationTableInfo = e.getValue();
            List<LocationField> fisdFieldList = locationTableInfo.getTableFieldList();
            LocationField locationId = new LocationField("locationId", FieldType.STRING, 100);
            fisdFieldList.add(locationId);
            String newName = locationTableInfo.getTableName();
            String nameStart = newName + START;
            String nameDone = newName + DONE;
            for (Map<String, LocationField> fieldMap : locationTableInfo.getDataList()) {
                StringField locationIddate;
                LocationField fsidField = fieldMap.get(FSID);
                if (null == fsidField) continue;
                String fsidname = fsidField.stringValue();
                LocationTableInfo locationTableInfoNAS = tableInfoMapNAS.get(fsidname);
                if (locationTableInfoNAS == null) {
                    locationTableInfoNAS = new LocationTableInfo();
                    locationTableInfoNAS.setTableId(fsidname);
                    locationTableInfoNAS.setTableName(fsidname);
                    locationTableInfoNAS.setTableFieldList(fisdFieldList);
                    tableInfoMapNAS.put(fsidname, locationTableInfoNAS);
                }
                if (fieldMap.get(HANDLER).stringValue().equals("0")) {
                    locationIddate = new StringField("locationId", nameStart, FieldType.STRING, 100);
                    fieldMap.put("locationId", locationIddate);
                }
                if (fieldMap.get(HANDLER).stringValue().equals(HANDLERID2)) {
                    locationIddate = new StringField("locationId", nameDone, FieldType.STRING, 100);
                    fieldMap.put("locationId", locationIddate);
                }
                fieldMap.remove(HANDLER);
                locationTableInfoNAS.deletetableField(HANDLER);
                locationTableInfoNAS.addData(fieldMap);
            }
        }
    }

    public static void takeOuthandl1(List<Map<String, LocationField>> temporaryList, List<Map.Entry<Object, LocationTableInfo>> list) {
        int id2 = StringUtil.hexIntValue(ID2);
        for (Map.Entry<Object, LocationTableInfo> e : list) {
            LocationTableInfo locationTableInfo = e.getValue();
            String locationID1 = String.valueOf(Integer.toHexString((Integer)locationTableInfo.getTableId())).substring(0, 1);
            Iterator<Map<String, LocationField>> dataList = locationTableInfo.getDataList().iterator();
            while (dataList.hasNext()) {
                Map<String, LocationField> fieldMap = dataList.next();
                if (ID1.equals(locationID1) && OPCODEID9.equals(fieldMap.get(OPCODE).stringValue())) {
                    locationTableInfo.setTableId(id2);
                }
                if (!HANDLERID1.equals(fieldMap.get(HANDLER).stringValue())) continue;
                temporaryList.add(fieldMap);
                dataList.remove();
            }
        }
    }

    public static void merger(List<Map<String, LocationField>> temporaryList, List<Map.Entry<Object, LocationTableInfo>> list) {
        for (Map<String, LocationField> date1 : temporaryList) {
            String date1Xid = date1.get(XID).stringValue();
            for (Map.Entry<Object, LocationTableInfo> e : list) {
                LocationTableInfo locationTableInfo = e.getValue();
                for (Map<String, LocationField> fieldMap : locationTableInfo.getDataList()) {
                    RecordDateMerge.mergeDate(date1Xid, fieldMap, date1);
                }
            }
        }
    }

    public static void mergeDate(String date1Xid, Map<String, LocationField> fieldMap, Map<String, LocationField> date1) {
        if (date1Xid.equals(fieldMap.get(XID).stringValue()) && fieldMap.get(HANDLER).stringValue().equals(HANDLERID2)) {
            if ("0".equals(date1.get(IO_SIZE).stringValue())) {
                fieldMap.get(IO_SIZE).setFieldsData(date1.get(IO_SIZE).stringValue());
            }
            if ("0".equals(date1.get(IO_OFFSET).stringValue())) {
                fieldMap.get(IO_OFFSET).setFieldsData(date1.get(IO_OFFSET).stringValue());
            }
            if ("0".equals(date1.get(FSID).stringValue())) {
                fieldMap.get(FSID).setFieldsData(date1.get(FSID).stringValue());
            }
            if ("0".equals(date1.get(FID).stringValue())) {
                fieldMap.get(FID).setFieldsData(date1.get(FID).stringValue());
            }
        }
    }
}

