/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.IORecordFileAnalyzerNAS;
import com.huawei.ftdsanalysis.analysis.iorecord.IORecordFileAnalyzerNew;
import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class SANParseTask
implements Callable<String> {
    private static final Logger LOGGER = Logger.getLogger(SANParseTask.class);
    private File sourceFile = null;
    private String outPath = null;
    private int paseRules;

    public SANParseTask(File sourceFile, String outPath, int paseRules) {
        this.sourceFile = sourceFile;
        this.outPath = outPath;
        this.paseRules = paseRules;
    }

    @Override
    public String call() throws Exception {
        String fileName = this.sourceFile.getName();
        this.outPath = this.outPath + File.separator + fileName.substring(0, fileName.indexOf(".record"));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("record file parse started,File name is " + this.sourceFile.getName()));
        }
        if (this.paseRules == 1) {
            IORecordFileAnalyzerNew analyzer = new IORecordFileAnalyzerNew(new FileInputStream(this.sourceFile), this.outPath);
            analyzer.analyse();
        } else {
            IORecordFileAnalyzerNAS analyzer = new IORecordFileAnalyzerNAS(new FileInputStream(this.sourceFile), this.outPath);
            analyzer.analyse();
        }
        LOGGER.info((Object)"file parse is filished.");
        return fileName;
    }
}

