/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord;

import com.huawei.ftdsanalysis.analysis.iorecord.LocationTableInfoMapParser;
import com.huawei.ftdsanalysis.analysis.iorecord.NASDateMergeTask;
import com.huawei.ftdsanalysis.analysis.iorecord.SANParseTask;
import com.huawei.ftdsanalysis.analysis.iorecord.exception.IORecordAnalyseException;
import com.huawei.ftdsanalysis.analysis.iorecord.exception.VersionNMapParserException;
import com.huawei.ftdsanalysis.analysis.iorecord.model.FsidTableInfoTemp;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import utils.FilesUtil;

public class WorkloadParser {
    private static final Logger LOGGER = Logger.getLogger(WorkloadParser.class);
    private static int paseRules = 1;
    private static final String SYSTEM_FILE = "system.map";
    private static final String VERSION_FILE = "version.nmap";
    private static final String CACHE = "cache";
    private static final String PROTOCOL = "protocol";
    private static List<List<Object>> errMsgs = new ArrayList<List<Object>>(0);
    private static List<Object> msg = null;
    private static boolean isParseExcption = false;
    private static int threadsize = 4;
    private static int mergeThreadsize = 4;
    private static final String ERROR_TYPE_MAP = HisResourceManager.getString("ERROR_TYPE_MAP");
    private static final String ERROR_TYPE_PARSE = HisResourceManager.getString("ERROR_TYPE_PARSE");
    private static final String ERROR_TYPE_OTHERS = HisResourceManager.getString("ERROR_TYPE_OTHERS");
    private static final String ERROR_TYPE_MERGE = HisResourceManager.getString("ERROR_TYPE_MERGE");

    public static void parse(File destFile, String csvDest, String processTag) throws Exception {
        File[] listFiles;
        File csvFolder = new File(csvDest);
        if (!csvFolder.mkdirs()) {
            LOGGER.info((Object)"Result directory creation failed");
        }
        if ((listFiles = destFile.listFiles()) == null) {
            LOGGER.error((Object)"listFiles is null.");
            return;
        }
        File mapFile = new File(destFile + File.separator + VERSION_FILE);
        WorkloadParser.checkPaseRules(listFiles);
        try {
            LocationTableInfoMapParser.parse(new FileInputStream(mapFile), paseRules);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        SANParseTask task = null;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsize);
        ArrayList<Future<String>> resultList = new ArrayList<Future<String>>();
        HashMap<Future<String>, String> pathMapFuture = new HashMap<Future<String>, String>();
        for (File f : listFiles) {
            if (f.getName().equals(VERSION_FILE) || f.getName().contains(SYSTEM_FILE) || f.isDirectory()) continue;
            task = new SANParseTask(f, csvDest, paseRules);
            Future<String> result = executorService.submit(task);
            resultList.add(result);
            pathMapFuture.put(result, f.getCanonicalPath());
        }
        for (Future future : resultList) {
            WorkloadParser.getFuture(pathMapFuture, future);
        }
        executorService.shutdown();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Parsing whether the thread pool is closed :" + executorService.isTerminated()));
        }
        if (FsidTableInfoTemp.getInstance().getDateNum() > 0) {
            WorkloadParser.merge(csvDest);
            FsidTableInfoTemp.getInstance().cleanTeam();
        }
    }

    private static void getFuture(Map<Future<String>, String> pathMapFuture, Future<String> future) {
        try {
            future.get();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Parsing thread:" + future));
            }
        }
        catch (VersionNMapParserException e) {
            msg = new ArrayList<Object>();
            isParseExcption = true;
            msg.add(ERROR_TYPE_MAP);
            msg.add(pathMapFuture.get(future));
            errMsgs.add(msg);
            LOGGER.error(msg, (Throwable)e);
        }
        catch (IORecordAnalyseException e) {
            msg = new ArrayList<Object>();
            isParseExcption = true;
            msg.add(ERROR_TYPE_PARSE);
            msg.add(pathMapFuture.get(future));
            errMsgs.add(msg);
            LOGGER.error(msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = new ArrayList<Object>();
            isParseExcption = true;
            msg.add(ERROR_TYPE_OTHERS);
            msg.add(pathMapFuture.get(future));
            errMsgs.add(msg);
            LOGGER.error(msg, (Throwable)e);
        }
    }

    private static void checkPaseRules(File[] listFiles) {
        for (File file : listFiles) {
            if (file.getName().indexOf(CACHE) != -1) {
                paseRules = 1;
                break;
            }
            if (file.getName().indexOf(PROTOCOL) == -1) continue;
            paseRules = 2;
            break;
        }
    }

    public static void merge(String csvDest) {
        LOGGER.info((Object)"There is a need to merge data,Start data merge.");
        File mergeDirectory = new File(csvDest);
        File[] mergeFileList = mergeDirectory.listFiles();
        NASDateMergeTask mergeTask = null;
        ExecutorService mergeExecutorService = Executors.newFixedThreadPool(mergeThreadsize);
        ArrayList<Future<String>> mergeResultList = new ArrayList<Future<String>>();
        HashMap<Future<String>, String> mergePathMapFuture = new HashMap<Future<String>, String>();
        if (mergeFileList == null || mergeFileList.length == 0) {
            return;
        }
        for (File file : mergeFileList) {
            mergeTask = new NASDateMergeTask(file);
            Future<String> mergeResult = mergeExecutorService.submit(mergeTask);
            mergeResultList.add(mergeResult);
            mergePathMapFuture.put(mergeResult, FilesUtil.getCanonicalPath((File)file));
        }
        for (Future future : mergeResultList) {
            try {
                future.get();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Merge thread:" + future));
            }
            catch (Exception e) {
                msg = new ArrayList<Object>();
                isParseExcption = true;
                msg.add(ERROR_TYPE_MERGE);
                msg.add(mergePathMapFuture.get(future));
                errMsgs.add(msg);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        mergeExecutorService.shutdown();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Merge whether the thread pool is closed :" + mergeExecutorService.isTerminated()));
        }
    }

    public static List<List<Object>> getErrMsgs() {
        return errMsgs;
    }

    public static void setErrMsgs(List<List<Object>> errMsgs) {
        WorkloadParser.errMsgs = errMsgs;
    }

    public static boolean isParseExcption() {
        return isParseExcption;
    }
}

