/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.io;

import com.huawei.ftdsanalysis.analysis.iorecord.exception.TraceAnalyseException;
import com.huawei.ftdsanalysis.analysis.iorecord.interfaces.IBinaryDataInputStream;
import com.huawei.ftdsanalysis.analysis.iorecord.util.StringUtil;
import java.io.IOException;
import java.math.BigInteger;

public final class BinaryFileReader {
    private IBinaryDataInputStream dis;

    public BinaryFileReader(IBinaryDataInputStream dis) {
        this.dis = dis;
    }

    public void seek(long offset) throws IOException {
        this.dis.seek(offset);
    }

    public void skip(int skipLen) throws IOException {
        try {
            this.dis.skipBytes(skipLen);
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error skipping the specified byte.The" + this.getFilePointer() + "byte begins to skip,length:" + skipLen + ",File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public short readShort() throws IOException {
        try {
            return this.dis.readShort();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading two bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.dis.readLong();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading eight bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public BigInteger readBig() throws IOException {
        try {
            return this.dis.readBig();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading eight bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.dis.readByte();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading one bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public short readUnsignedByte() throws IOException {
        try {
            return this.dis.readUnsignedByte();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading one bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            return this.dis.readUnsignedShort();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading two bytes,File corresponds to the starting position::" + this.getCurrentLocation());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.dis.readInt();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading four bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public long readIntUnsigned() throws IOException {
        try {
            return this.dis.readIntUnsigned();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading four bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public char readChar() throws IOException {
        try {
            return this.dis.readChar();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading one bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.dis.read(b);
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading " + b.length + "bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public int available() {
        try {
            return this.dis.available();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public int getFilePointer() throws IOException {
        return (int)this.dis.getFilePointer();
    }

    public void close() throws IOException {
        this.dis.close();
        this.dis = null;
    }

    public void mark(int readlimit) throws IOException {
    }

    public void reset() throws IOException {
        this.dis.reset();
    }

    public String getCurrentLocation() throws IOException {
        return "rowNum:".concat(Long.toHexString(this.getFilePointer() / 16)).concat(", colNum:") + this.getFilePointer() % 16;
    }

    public String getLocation() throws IOException {
        return "".concat(Long.toHexString(this.getFilePointer() / 16)).concat(Long.toHexString(this.getFilePointer() % 16)).concat("h");
    }

    public String readHexString(int byteLength) throws IOException {
        byte[] bytes = new byte[byteLength];
        this.read(bytes);
        return StringUtil.bytesToBigHexString(bytes);
    }

    public String readHexStringList(int byteLength) throws IOException {
        byte[] bytes = new byte[byteLength];
        this.read(bytes);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ',') {
                sb.append(",");
            }
            sb.append(StringUtil.bytesToBigHexString(b));
        }
        return sb.toString();
    }

    public String readStr(int udNum) throws IOException {
        String str = null;
        try {
            byte[] bytes = new byte[udNum];
            this.read(bytes);
            byte[] strByte = new byte[udNum];
            int realLength = udNum;
            for (int i = 0; i < udNum; ++i) {
                byte b;
                strByte[i] = b = bytes[udNum - 1 - i];
                if (b != 0) continue;
                realLength = i;
                break;
            }
            byte[] realByts = new byte[realLength];
            System.arraycopy(strByte, 0, realByts, 0, realLength);
            str = new String(realByts, "UTF-8");
        }
        catch (Throwable e) {
            throw new IOException("error when analyseUserDataStr", e);
        }
        return str;
    }

    public short readByteUnsigned() throws IOException {
        try {
            return this.dis.readByteUnsigned();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading one bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }

    public int readShortUnsigned() throws IOException {
        try {
            return this.dis.readShortUnsigned();
        }
        catch (IOException e) {
            throw new TraceAnalyseException("Error reading file contents.Error byte start position:" + this.getFilePointer() + ",Error reading two bytes,File corresponds to the starting position:" + this.getCurrentLocation());
        }
    }
}

