/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.io;

import com.huawei.ftdsanalysis.analysis.iorecord.interfaces.IBinaryDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class SmallHeadInputStream
implements IBinaryDataInputStream {
    private InputStream in;
    private int index;
    private byte[] readBuffer = new byte[8];

    public SmallHeadInputStream(InputStream in) throws IOException {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void seek(long offset) throws IOException {
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.index;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.index;
        return (byte)ch;
    }

    @Override
    public short readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.index;
        return (short)ch;
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.index += 4;
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public long readLong() throws IOException {
        this.read(this.readBuffer);
        long aLong = ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
        this.index += 8;
        return aLong;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.index += 2;
        return (short)((ch1 << 0) + (ch2 << 8));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.index += 2;
        return (ch1 << 0) + (ch2 << 8);
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        ++this.index;
        return (char)(ch1 << 0);
    }

    @Override
    public int skipBytes(int num) throws IOException {
        return (int)this.in.skip(num);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        int i = this.readToByte(b, len, c);
        this.index += i;
        return i;
    }

    private int readToByte(byte[] b, int len, int c) throws IOException {
        b[len - 1] = (byte)c;
        int i = 2;
        while (0 <= len - i && (c = this.in.read()) != -1) {
            b[len - i] = (byte)c;
            ++i;
        }
        return i;
    }

    @Override
    public void mark(int readlimit) throws IOException {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public long readIntUnsigned() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.index += 4;
        return ((long)ch4 << 24) + (long)(ch3 << 16) + (long)(ch2 << 8) + (long)(ch1 << 0);
    }

    @Override
    public BigInteger readBig() throws IOException {
        int ch8 = this.in.read();
        int ch7 = this.in.read();
        int ch6 = this.in.read();
        long ch5 = this.in.read();
        long ch4 = this.in.read();
        long ch3 = this.in.read();
        long ch2 = this.in.read();
        BigInteger ch1 = BigInteger.valueOf(this.in.read());
        long aLong = (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (long)(ch6 << 16) + (long)(ch7 << 8) + (long)(ch8 << 0);
        BigInteger big1 = BigInteger.valueOf(aLong);
        BigInteger big2 = ch1.shiftLeft(56).add(big1);
        return big2;
    }

    @Override
    public short readByteUnsigned() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.index;
        return (short)ch;
    }

    @Override
    public int readShortUnsigned() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.index += 2;
        return (ch1 << 0) + (ch2 << 8);
    }
}

