/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.model;

import com.huawei.ftdsanalysis.analysis.iorecord.DataTypeParser;
import com.huawei.ftdsanalysis.analysis.iorecord.exception.FTDSException;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.ByteParser;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.HexStringParser;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.IntParser;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.LongParser;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.ShortParser;
import com.huawei.ftdsanalysis.analysis.iorecord.fieldparser.StringParser;
import java.lang.reflect.Constructor;

public enum FieldType {
    BYTE(1, "1%d", ByteParser.class),
    SHORT(2, "2%d", ShortParser.class),
    INT(3, "4%d", IntParser.class),
    LONG(4, "8%d", LongParser.class),
    STRING(5, "%s", StringParser.class),
    HEXSTRING(6, "%x", HexStringParser.class);

    private int value;
    private String name;
    private transient Constructor<? extends DataTypeParser> parserConstructor;

    private FieldType(int value, String name, Class<? extends DataTypeParser> clazz) {
        try {
            this.value = value;
            this.name = name;
            this.parserConstructor = clazz.getDeclaredConstructor(new Class[0]);
            this.parserConstructor.setAccessible(true);
        }
        catch (Throwable e) {
            throw new FTDSException("\u521d\u59cb\u5316 (" + name + ") \u51fa\u9519", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static FieldType transfer(String name) {
        for (FieldType t : FieldType.values()) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return STRING;
    }

    public DataTypeParser newInstance() {
        try {
            DataTypeParser dataTypeParser = this.parserConstructor.newInstance(new Object[0]);
            return dataTypeParser;
        }
        catch (Throwable e) {
            throw new FTDSException(e);
        }
    }
}

