/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.util;

import com.huawei.ftdsanalysis.analysis.iorecord.exception.FileException;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import com.huawei.ism.tool.base.utils.excel.CsvUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSVFileUtil {
    private static final Logger LOGGER = Logger.getLogger(CSVFileUtil.class);
    private static final String CHARSET_NAME = "utf-8";
    private static final int BUFFER_SIZE = 5120;
    private static int num = 0;

    public static File createCSVFile(LocationTableInfo locationTableInfo, String outPutPath, int paseRules) throws IOException {
        ++num;
        File csvFile = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter csvWriter = null;
        try {
            File parent = new File(outPutPath);
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                LOGGER.error((Object)"outPutPath create failed!");
            }
            String dateStr = parent.getName();
            csvFile = paseRules == 2 ? new File(outPutPath + File.separator + "NAS_FSID_" + locationTableInfo.getTableName() + "_" + dateStr + ".csv") : new File(outPutPath + File.separator + dateStr + "-" + num + "-.csv");
            if (!csvFile.createNewFile()) {
                LOGGER.error((Object)(csvFile.getName() + " create failed!"));
            }
            fos = new FileOutputStream(csvFile);
            osw = new OutputStreamWriter((OutputStream)fos, CHARSET_NAME);
            csvWriter = new BufferedWriter(osw, 5120);
            CSVFileUtil.writeHeader(locationTableInfo, csvWriter);
            FileChannel fc = null;
            fc = fos.getChannel();
            Iterator<Map<String, LocationField>> dataList = locationTableInfo.getDataList().iterator();
            while (dataList.hasNext()) {
                Map<String, LocationField> row = dataList.next();
                CSVFileUtil.writeRow(locationTableInfo, row, csvWriter);
                CSVFileUtil.createCSVFile(locationTableInfo, outPutPath, paseRules, fc, dataList);
            }
            csvWriter.flush();
        }
        catch (IOException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                CSVFileUtil.close(csvWriter);
                CSVFileUtil.close(osw);
                CSVFileUtil.close(fos);
                throw throwable;
            }
        }
        CSVFileUtil.close(csvWriter);
        CSVFileUtil.close(osw);
        CSVFileUtil.close(fos);
        return csvFile;
    }

    private static void createCSVFile(LocationTableInfo locationTableInfo, String outPutPath, int paseRules, FileChannel fc, Iterator<Map<String, LocationField>> dataList) throws IOException {
        if (paseRules == 1) {
            dataList.remove();
            if (fc.size() >= 0x1400000L) {
                CSVFileUtil.createCSVFile(locationTableInfo, outPutPath, paseRules);
            }
        }
    }

    private static void writeRow(LocationTableInfo locationTableInfo, Map<String, LocationField> row, BufferedWriter csvWriter) throws IOException {
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            csvWriter.write(CSVFileUtil.formatCellValue(row.get(field.getName()).stringValue()));
        }
        csvWriter.newLine();
    }

    private static void writeHeader(LocationTableInfo locationTableInfo, BufferedWriter csvWriter) throws IOException {
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            csvWriter.write(CSVFileUtil.formatCellValue(CSVFileUtil.getHeaderStr(field)));
        }
        csvWriter.newLine();
    }

    private static String formatCellValue(String value) {
        if (CsvUtils.isStartswithInvalidChar((String)value)) {
            return "\"\t" + value + "\",";
        }
        return '\"' + value + "\",";
    }

    private static String getHeaderStr(LocationField field) {
        StringBuilder headerStr = new StringBuilder();
        headerStr.append(field.getName());
        String typeString = field.getType().getName();
        if (typeString.contains("d")) {
            headerStr.append("(").append(typeString).append(")");
        } else {
            headerStr.append("(").append(field.getLength()).append(typeString).append(")");
        }
        return headerStr.toString();
    }

    public static void close(Closeable os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }
    }

    public static void initializationA() {
        num = 0;
    }
}

