/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.util;

import com.huawei.ftdsanalysis.analysis.iorecord.exception.FileException;
import com.huawei.ftdsanalysis.analysis.iorecord.field.LocationField;
import com.huawei.ftdsanalysis.analysis.iorecord.model.LocationTableInfo;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class SANCSVFile {
    private static final Logger LOGGER = Logger.getLogger(SANCSVFile.class);
    private static final String CHARSET_NAME = "utf-8";
    private static final int BUFFER_SIZE = 5120;
    private File csvFile = null;
    private FileOutputStream fos = null;
    private OutputStreamWriter osw = null;
    private BufferedWriter csvWriter = null;
    private String outPutPath = null;
    private int num = 1;
    private boolean mark = true;

    public SANCSVFile(String outPutPath) {
        this.outPutPath = outPutPath;
        this.createCSVFile();
    }

    public File writerCSVFile(LocationTableInfo locationTableInfo) {
        try {
            if (this.mark) {
                this.writeHeader(locationTableInfo);
                this.mark = false;
                this.csvWriter.flush();
            }
            FileChannel fc = null;
            fc = this.fos.getChannel();
            for (Map<String, LocationField> row : locationTableInfo.getDataList()) {
                this.writeRow(locationTableInfo, row);
            }
            this.csvWriter.flush();
            if (fc.size() >= 0x1400000L) {
                ++this.num;
                this.closeAll();
                this.createCSVFile();
                this.mark = true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(this.csvFile.getName() + " writer error!"));
        }
        return this.csvFile;
    }

    public void createCSVFile() {
        this.csvFile = new File(this.outPutPath + "-" + this.num + "-.csv");
        try {
            if (!this.csvFile.createNewFile()) {
                LOGGER.error((Object)(this.csvFile.getName() + " create failed!"));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)(this.csvFile.getName() + " create error!"));
        }
        try {
            this.fos = new FileOutputStream(this.csvFile);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, CHARSET_NAME);
            this.csvWriter = new BufferedWriter(this.osw, 5120);
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    private void writeHeader(LocationTableInfo locationTableInfo) throws IOException {
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            String header = this.getHeaderStr(field);
            StringBuilder strB = new StringBuilder();
            strB.append(header);
            int lengh = 20;
            if ("time".equals(field.getName()) || "locationId".equals(field.getName())) {
                lengh = 35;
            }
            while (strB.length() < lengh) {
                strB.append(" ");
            }
            String rowStr = strB.append("|").toString();
            this.csvWriter.write(rowStr);
        }
        this.csvWriter.newLine();
    }

    private String getHeaderStr(LocationField field) {
        StringBuilder headerStr = new StringBuilder();
        headerStr.append(field.getName());
        String typeString = field.getType().getName();
        if (typeString.contains("d")) {
            headerStr.append("(").append(typeString).append(")");
        } else {
            headerStr.append("(").append(field.getLength()).append(typeString).append(")");
        }
        return headerStr.toString();
    }

    private void writeRow(LocationTableInfo locationTableInfo, Map<String, LocationField> row) throws IOException {
        for (LocationField field : locationTableInfo.getTableFieldList()) {
            String str = row.get(field.getName()).stringValue();
            StringBuilder strB = new StringBuilder();
            int lengh = 20;
            if ("time".equals(field.getName())) {
                lengh = 35;
                long l = Long.parseLong(str) / 1000000L;
                String microSecond = str.substring(str.length() - 3);
                String nanoSecond = str.substring(str.length() - 6, str.length() - 3);
                Date date = new Date(l);
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                StringBuilder time = new StringBuilder();
                time.append(sdf2.format(date)).append(".").append(microSecond).append(".").append(nanoSecond);
                str = time.toString();
            }
            if ("locationId".equals(field.getName())) {
                lengh = 35;
            }
            strB.append(str);
            while (strB.length() < lengh) {
                strB.append(" ");
            }
            String rowStr = strB.append("|").toString();
            this.csvWriter.write(rowStr);
        }
        this.csvWriter.newLine();
    }

    public void closeAll() {
        SANCSVFile.close(this.csvWriter);
        SANCSVFile.close(this.osw);
        SANCSVFile.close(this.fos);
    }

    public static void close(Closeable os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }
    }
}

