/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ftdsanalysis.analysis.iorecord.util;

import javax.xml.bind.DatatypeConverter;

public class StringUtil {
    public static final byte HEX = 16;
    private static final char[] HEX_CODE = "0123456789abcdef".toCharArray();
    private static final char[] HEX_BIG_CODE = "0123456789ABCDEF".toCharArray();
    public static final int BIG_HEAD = 1;
    public static final int SMALL_HEAD = 0;

    public static int hexIntValue(String str) {
        return Integer.valueOf(StringUtil.getVK(str), 16);
    }

    private static String getVK(String vk) {
        if ((vk = vk.trim()).startsWith("0x")) {
            vk = vk.substring(2);
        }
        return vk;
    }

    public static boolean isEmpty(String content) {
        return content == null || "".equals(content.trim());
    }

    public static byte[] parseHexBinary(String str) {
        return DatatypeConverter.parseHexBinary((String)str);
    }

    public static byte[] byteReverse(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte temp = bytes[i];
            bytes[i] = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = temp;
        }
        return bytes;
    }

    public static String bytesToHexString(byte ... bytes) {
        StringBuilder localStringBuilder = new StringBuilder(bytes.length * 2);
        for (byte k : bytes) {
            localStringBuilder.append(HEX_CODE[k >> 4 & 0xF]);
            localStringBuilder.append(HEX_CODE[k & 0xF]);
        }
        return localStringBuilder.toString();
    }

    public static String bytesToBigHexString(byte ... bytes) {
        StringBuilder localStringBuilder = new StringBuilder(bytes.length * 2);
        for (byte k : bytes) {
            localStringBuilder.append(HEX_BIG_CODE[k >> 4 & 0xF]);
            localStringBuilder.append(HEX_BIG_CODE[k & 0xF]);
        }
        return localStringBuilder.toString();
    }

    public static String bytesToBigHexString(byte[] bs, int start, int end) {
        if (bs == null || end <= start || start >= bs.length) {
            return null;
        }
        int length = end - start;
        byte[] dest = new byte[length];
        int index = 0;
        for (int i = start; i < end; ++i) {
            dest[index++] = bs[i];
        }
        return StringUtil.bytesToBigHexString(dest);
    }

    public static String bytesToBigHexStringList(byte ... bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ',') {
                sb.append(",");
            }
            sb.append(StringUtil.bytesToBigHexString(b));
        }
        return sb.toString();
    }

    public static String getAllBinaryBits(byte b) {
        StringBuffer sb = new StringBuffer();
        sb.append((b & 0x80) == 0 ? 0 : (b & 0x80) >> 7);
        sb.append((b & 0x40) == 0 ? 0 : (b & 0x40) >> 6);
        sb.append((b & 0x20) == 0 ? 0 : (b & 0x20) >> 5);
        sb.append((b & 0x10) == 0 ? 0 : (b & 0x10) >> 4);
        sb.append((b & 8) == 0 ? 0 : (b & 8) >> 3);
        sb.append((b & 4) == 0 ? 0 : (b & 4) >> 2);
        sb.append((b & 2) == 0 ? 0 : (b & 2) >> 1);
        sb.append(b & 1);
        return sb.toString();
    }

    public static String toDataFieldStr(String strs, int headType) {
        String[] sa = strs.split(",");
        StringBuilder sb = new StringBuilder(sa.length * 2);
        if (headType == 0) {
            for (String str : sa) {
                sb.append(str);
            }
        } else {
            for (int i = sa.length - 1; i >= 0; --i) {
                sb.append(sa[i]);
            }
        }
        return sb.toString();
    }
}

