/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import java.io.ObjectStreamException;

public enum DeviceTypeIsm {
    N8000("N8000"),
    S2300("S2300"),
    S2600("S2600"),
    T3000("T3000"),
    S5000("S5000"),
    S5300("S5300"),
    AKI("AKI"),
    NEX("NEX"),
    OCEAN_STOR("OceanStor"),
    VIS("VIS"),
    S8000("S8000"),
    S5500("S5500"),
    S5600("S5600"),
    S6800E("S6800e"),
    C3("C3"),
    VTL3500("VTL3500"),
    VTL6000("VTL6000"),
    SIR6000("SIR6000"),
    HDP3500("HDP3500"),
    ALL_IN_ONE("AllInOne"),
    DORADO_2100("Dorado2100"),
    DORADO("Dorado"),
    N5000("N5000"),
    HVS88T("HVS88T"),
    SWITCHFC("SWITCHFC"),
    SWITCHFIBER("SWITCHFIBER"),
    V_2200V3("2200 V3"),
    V_2600V3("2600 V3"),
    ALL("ALL");

    private static final long serialVersionUID = 5126097720840441893L;
    private String subType;
    private String description = null;

    private DeviceTypeIsm(String description) {
        this.description = description;
    }

    public static DeviceTypeIsm getDeviceType(String type) {
        for (DeviceTypeIsm deviceType : DeviceTypeIsm.values()) {
            if (!deviceType.getDescription().equals(type)) continue;
            return deviceType;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    private Object readResolve() throws ObjectStreamException {
        String desc = this.getDescription();
        DeviceTypeIsm type = DeviceTypeIsm.valueOf(desc);
        if (null != type) {
            type.subType = this.getSubType();
        }
        throw new ObjectStreamException("Can't find the device type which description is \"" + desc + "\""){};
    }

    public static boolean isNASStorSerias(String type) {
        DeviceTypeIsm deviceType = DeviceTypeIsm.valueOf(type);
        if (null == deviceType) {
            return false;
        }
        return N8000.getDescription().equalsIgnoreCase(type) || T3000.getDescription().equalsIgnoreCase(type);
    }

    public static boolean isNASStorSerias(DeviceTypeIsm deviceType) {
        if (null == deviceType) {
            return false;
        }
        return N8000.equals((Object)deviceType) || T3000.equals((Object)deviceType);
    }

    public static boolean isVTLSerias(String type) {
        DeviceTypeIsm deviceType = DeviceTypeIsm.valueOf(type);
        if (null == deviceType) {
            return false;
        }
        return VTL3500.getDescription().equalsIgnoreCase(type) || VTL6000.getDescription().equalsIgnoreCase(type) || ALL_IN_ONE.getDescription().equalsIgnoreCase(type);
    }

    public static boolean isVISSerias(DeviceTypeIsm type) {
        if (null == type) {
            return false;
        }
        return S8000 == type || VIS == type;
    }

    public static boolean isVISSerias(String type) {
        if (null == type) {
            return false;
        }
        DeviceTypeIsm deviceType = DeviceTypeIsm.valueOf(type);
        if (null == deviceType) {
            return false;
        }
        return S8000 == deviceType || VIS == deviceType;
    }

    public static boolean isStorageCellSerias(String type) {
        DeviceTypeIsm deviceType = DeviceTypeIsm.valueOf(type);
        if (null == deviceType) {
            return false;
        }
        return !DeviceTypeIsm.isNASStorSerias(type) && !DeviceTypeIsm.isVISSerias(deviceType);
    }

    public String getSubType() {
        return this.subType;
    }
}

