/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.ITimeSpanEnum;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class HisPerfStatObjectType {
    private static final Logger LOGGER = Logger.getLogger(HisPerfStatObjectType.class);
    private HisObjectTypeEnum objectType;
    private List<HisDataTypeEnum> dataTypeList = new ArrayList<HisDataTypeEnum>(0);
    private List<HisTimeSpanEnum> timeSpanList = new ArrayList<HisTimeSpanEnum>(0);
    private int sampleInterval;

    public HisObjectTypeEnum getType() {
        return this.objectType;
    }

    public void setType(HisObjectTypeEnum objectTypeIn) {
        this.objectType = objectTypeIn;
    }

    public List<HisDataTypeEnum> getDataTypeList() {
        return this.getDataTypeSortList(this.dataTypeList);
    }

    public List<HisDataTypeEnum> getDataTypeSortList(List<HisDataTypeEnum> inList) {
        ArrayList<HisDataTypeEnum> list = new ArrayList<HisDataTypeEnum>(0);
        if (null == inList) {
            return list;
        }
        Collections.sort(inList, new Comparator<HisDataTypeEnum>(){

            @Override
            public int compare(HisDataTypeEnum arg0, HisDataTypeEnum arg1) {
                if (arg0.getValue() > arg1.getValue()) {
                    return 1;
                }
                return 0;
            }
        });
        list.addAll(inList);
        return list;
    }

    public HisDataTypeEnum getDataType(int index) {
        if (index >= 0 && index < this.dataTypeList.size()) {
            return this.dataTypeList.get(index);
        }
        return null;
    }

    public void addDataTypeList(List<HisDataTypeEnum> dataTypesList) {
        if (null != dataTypesList) {
            this.dataTypeList.addAll(dataTypesList);
        }
    }

    public void addDataType(HisDataTypeEnum dataType) {
        this.dataTypeList.add(dataType);
    }

    public List<HisTimeSpanEnum> getTimeSpanList() {
        return new ArrayList<HisTimeSpanEnum>(this.timeSpanList);
    }

    public HisTimeSpanEnum getTimeSpan(int indexIn) {
        if (indexIn >= 0 && indexIn < this.timeSpanList.size()) {
            return this.timeSpanList.get(indexIn);
        }
        return null;
    }

    public void addTimeSpan(List<HisTimeSpanEnum> periodList) {
        if (null != periodList) {
            this.timeSpanList.addAll(periodList);
        }
    }

    public void addTimeSpan(HisTimeSpanEnum period) {
        this.timeSpanList.add(period);
    }

    public void setTimeSpan(List<HisTimeSpanEnum> timeSpans) {
        this.timeSpanList.clear();
        this.timeSpanList.addAll(timeSpans);
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(int sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HisPerfStatObjectType)) {
            return false;
        }
        HisPerfStatObjectType other = (HisPerfStatObjectType)object;
        return this.getType().equals((Object)other.getType());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("ObjectType", (Object)(this.objectType == null ? "null" : this.objectType.getName())).append("DataType", this.dataTypeList).append("Period", this.timeSpanList).append("SamplingInterval", this.objectType == null ? "null" : Integer.valueOf(this.sampleInterval)).toString();
    }

    public int hashCode() {
        if (null == this.objectType) {
            return "null".hashCode();
        }
        return this.objectType.hashCode();
    }

    public static enum HisTimeSpanEnum implements ITimeSpanEnum
    {
        NONE("None", 0),
        MONTH("Month", 1),
        DAY("Day", 2),
        HALF_HOUR("HalfHour", 3),
        MINUTE("Minute", 4),
        YEAR("Year", 5);

        private int timeValue;
        private String timeSpan;

        private HisTimeSpanEnum(String timeSpan, int value) {
            this.timeValue = value;
            this.timeSpan = timeSpan;
        }

        public String getTimeSpan() {
            return this.timeSpan;
        }

        public int getValue() {
            return this.timeValue;
        }

        public long getMilliSecond() {
            int second = 1;
            switch (this) {
                case MINUTE: {
                    second = 60;
                    break;
                }
                case HALF_HOUR: {
                    second = 1800;
                    break;
                }
                case DAY: {
                    second = 86400;
                    break;
                }
                case MONTH: {
                    second = 2592000;
                    break;
                }
                case YEAR: {
                    second = 31536000;
                    break;
                }
            }
            return (long)second * 1000L;
        }

        @Override
        public String getDescription() {
            return HisResourceManager.getString(this.getTimeSpan());
        }

        public static HisTimeSpanEnum valueOf(int intValue) throws IsmException {
            HisTimeSpanEnum[] values;
            for (HisTimeSpanEnum value : values = HisTimeSpanEnum.values()) {
                if (value.timeValue != intValue) continue;
                return value;
            }
            throw new IsmException(-1L, (Object)("wrong StatisticPeriod value ! type:" + intValue));
        }

        public long getSamplingInterval() {
            int second = 1;
            switch (this) {
                case MINUTE: {
                    second = 2;
                    break;
                }
                case HALF_HOUR: {
                    second = 60;
                    break;
                }
                case DAY: {
                    second = 1800;
                    break;
                }
                case MONTH: {
                    second = 86400;
                    break;
                }
                case YEAR: {
                    second = 2592000;
                    break;
                }
            }
            return (long)second * 1000L;
        }
    }

    public static enum HisDataTypeEnum implements IDataTypeEnum
    {
        UNKNOWN_DATA_TYPE("UNKNOWN_DATA_TYPE", 99999),
        TOTAL_IO_COUNT("TotalIOCount", 1),
        READ_IO_RATIO("ReadIORatio", 2),
        WRITE_IO_RATIO("WriteIORatio", 3),
        CURRENT_BAND_WIDTH("CurrentBandWidth", 4),
        MAX_BAND_WIDTH("MaxBandWidth", 5),
        CURRENT_IOPS("CurrentIOPS", 6),
        MAX_IOPS("MaxIOPS", 7),
        MAX_LATENCY("MaxLatency", 8),
        AVERAGE_LATENCY("AverageLatency", 9),
        CACHE_HIT("CacheHit", 10),
        LOCAL_WRITE_CACHE_RATIO("LocalWriteCacheRatio", 11),
        MIRROR_WRITE_CACHE_RATIO("MirrorWriteCacheRatio", 12),
        READ_IO_TRAFFIC("ReadIOTraffic", 13),
        WRITE_IO_TRAFFIC("WriteIOTraffic", 14),
        MAX_POWER_CONSUME("MaxPowerConsume", 15),
        AVG_POWER_CONSUME("AvgPowerConsume", 16),
        MIN_POWER_CONSUME("MinPowerConsume", 17),
        USAGE("Usage", 18),
        QUEUE_SIZE("QueueSize", 19),
        RESPONSE_TIME("ResponseTime", 20),
        BAND_WIDTH("BandWidth", 21),
        THROUGHPUT("Throughput", 22),
        READ_BAND_WIDTH("ReadBandWidth", 23),
        AVERAGE_READ_IO("AverageReadIO", 24),
        READ_THROUGHPUT("ReadThroughput", 25),
        WRITE_BAND_WIDTH("WriteBandWidth", 26),
        AVERAGE_WRITE_IO("AverageWriteIO", 27),
        WIRTE_THROUGHPUT("WirteThroughput", 28),
        SERVICE_TIME("ServiceTime", 29),
        READ_IO_STATISTICS_512_B("ReadIOStatistics512B", 30),
        READ_IO_STATISTICS_1_KB("ReadIOStatistics1KB", 31),
        READ_IO_STATISTICS_2_KB("ReadIOStatistics2KB", 32),
        READ_IO_STATISTICS_4_KB("ReadIOStatistics4KB", 33),
        READ_IO_STATISTICS_8_KB("ReadIOStatistics8KB", 34),
        READ_IO_STATISTICS_16_KB("ReadIOStatistics16KB", 35),
        READ_IO_STATISTICS_32_KB("ReadIOStatistics32KB", 36),
        READ_IO_STATISTICS_64_KB("ReadIOStatistics64KB", 37),
        READ_IO_STATISTICS_128_KB("ReadIOStatistics128KB", 38),
        READ_IO_STATISTICS_256_KB("ReadIOStatistics256KB", 39),
        READ_IO_STATISTICS_512_KB("ReadIOStatistics512KB", 40),
        WRITE_IO_STATISTICS_512_B("WriteIOStatistics512B", 41),
        WRITE_IO_STATISTICS_1_KB("WriteIOStatistics1KB", 42),
        WRITE_IO_STATISTICS_2_KB("WriteIOStatistics2KB", 43),
        WRITE_IO_STATISTICS_4_KB("WriteIOStatistics4KB", 44),
        WRITE_IO_STATISTICS_8_KB("WriteIOStatistics8KB", 45),
        WRITE_IO_STATISTICS_16_KB("WriteIOStatistics16KB", 46),
        WRITE_IO_STATISTICS_32_KB("WriteIOStatistics32KB", 47),
        WRITE_IO_STATISTICS_64_KB("WriteIOStatistics64KB", 48),
        WRITE_IO_STATISTICS_128_KB("WriteIOStatistics128KB", 49),
        WRITE_IO_STATISTICS_256_KB("WriteIOStatistics256KB", 50),
        WRITE_IO_STATISTICS_512_KB("WriteIOStatistics512KB", 51),
        READ_WRITE_IO_STATISTICS_512_B("ReadWriteIOStatistics512B", 52),
        READ_WRITE_IO_STATISTICS_1_KB("ReadWriteIOStatistics1KB", 53),
        READ_WRITE_IO_STATISTICS_2_KB("ReadWriteIOStatistics2KB", 54),
        READ_WRITE_IO_STATISTICS_4_KB("ReadWriteIOStatistics4KB", 55),
        READ_WRITE_IO_STATISTICS_8_KB("ReadWriteIOStatistics8KB", 56),
        READ_WRITE_IO_STATISTICS_16_KB("ReadWriteIOStatistics16KB", 57),
        READ_WRITE_IO_STATISTICS_32_KB("ReadWriteIOStatistics32KB", 58),
        READ_WRITE_IO_STATISTICS_64_KB("ReadWriteIOStatistics64KB", 59),
        READ_WRITE_IO_STATISTICS_128_KB("ReadWriteIOStatistics128KB", 60),
        READ_WRITE_IO_STATISTICS_256_KB("ReadWriteIOStatistics256KB", 61),
        READ_WRITE_IO_STATISTICS_512_KB("ReadWriteIOStatistics512KB", 62),
        WRITE_IO_IN_PERIOD("WriteIOInPeriod", 63),
        READ_IO_IN_PERIOD("ReadIOInPeriod", 64),
        RANDOM_SEQUENCE_RATIO("RandomSequenceRatio", 65),
        USAGE_2("Usage2", 66),
        READ_BAND_WIDTH_USAGE("ReadBandWidthUsage", 67),
        CPU_USAGE("CPUUsage", 68),
        MEMORY_USAGE("MemoryUsage", 69),
        SWAP_USAGE("SwapUsage", 70),
        NET_READ_TRAFFIC("NetReadTraffic", 71),
        NET_WRITE_TRAFFIC("NetWriteTraffic", 72),
        NET_IN_PACKAGE("NetInPackage", 73),
        NET_OUT_PACKAGE("NetOutPackage", 74),
        WORK_TEMPERTURE("WorkTemperture", 75),
        POWER_CONSUME("PowerConsume", 76),
        VOLTAGE("Voltage", 77),
        AVERAGE_IO_RESPONSE_TIME("AverageIOResponseTime", 78),
        MAX_IO_RESPONSE_TIME("MaxIOResponseTime", 79),
        DIRTY_PAGE_RATIO("DirtyPageRatio", 80),
        REFRESH_CACHE_DIVIDE_WRITE_REQUEST("RefreshCacheDivideWriteRequest", 81),
        REFRESH_CACHE_BAND_WIDTH("RefreshCacheBandWidth", 82),
        REFRESH_CACHE_BECAUSE_HIGHT_WATER("RefreshCacheBecauseHightWater", 83),
        REFRESH_CACHE_BECAUSE_SCHEDULE_TIMER("RefreshCacheBecauseScheduleTimer", 84),
        CACHE_LOW_WATER("CacheLowWater", 85),
        MAX_BAND_WIDTH_WRITE("MaxBandWidthWrite", 86),
        FETCH_FLUX("FetchFlux", 87),
        FETCH_RATIO("FetchRatio", 88),
        READ_CACHE_HIT("ReadCacheHit", 89),
        READ_CACHE_NOT_HIT("ReadCacheNotHit", 90),
        READ_CACHE_HIT_WHEN_WRITE("ReadCacheHitWhenWrite", 91),
        READ_CACHE_HIT_WHEN_READ("ReadCacheHitWhenRead", 92),
        READ_CACHE_RATIO("ReadCacheRatio", 93),
        READ_CACHE_RE_HIT_RATIO("ReadCacheReHitRatio", 94),
        WRITE_CACHE_HIT_RATIO("WriteCacheHitRatio", 95),
        WRITE_CACHE_RE_HIT_RATIO("WriteCacheReHitRatio", 96),
        WRITE_CACHE_HIT("WriteCacheHit", 97),
        WRITE_CACHE_NOT_HIT("WriteCacheNotHit", 98),
        ASYNC_TIME("AsyncTime", 99),
        ASYNC_DATA("AsyncData", 100),
        READE_REQUEST_CNT_FROM_SNAPSHOT("ReadeRequestCntFromSnapshot", 101),
        READE_REQUEST_CNT_FROM_SOURCE_LUN("ReadeRequestCntFromSourceLUN", 102),
        WRITE_REQUEST_CNT_FROM_SOURCE_LUN("WriteRequestCntFromSourceLUN", 103),
        READ_REQUEST_CNT_SNAPSHOT_POOL("ReadRequestCntSnapshotPool", 104),
        WRITE_REQUEST_CNT_SNAPSHOT_POOL("WriteRequestCntSnapshotPool", 105),
        WRITE_REQUEST_CNT_MORETHAN_CHUNK("WriteRequestCntMorethanChunk", 106),
        CHUNK_CNT_USED_BY_SNAPSHOT_COPY("ChunkCntUsedBySnapshotCopy", 107),
        LOCAL_CACHE_USAGE("LocalCacheUsage", 108),
        MIRROR_CACHE_USAGE("MirrorCacheUsage", 109),
        LOCAL_READ_CACHE_RATIO("LocalReadCacheRatio", 110),
        TIME_FOR_HOST_TO_SEND_DATA("TimeForHostToSendData", 111),
        TIME_FOR_SAVING_WRITE_DATA("TimeForSavingWriteData", 112),
        TIME_FOR_RELEASING_WRITE_REQUEST_RESOURCES("TimeForReleasingWriteRequestResources", 113),
        TIME_FOR_EXECUTING_A_WRITE_REQUEST("TimeForExecutingAWriteRequest", 114),
        TIME_FOR_RELEASING_READ_REQUEST_RESOURCES("TimeForReleasingReadRequestResources", 115),
        CACHE_READ_IO_LATENCY("CacheReadIOLatency", 116),
        CACHE_WRITE_IO_LATENCY("CacheWriteIOLatency", 117),
        CACHE_MIRROR_IO_LATENCY("CacheMirrorIOLatency", 118),
        TIME_FOR_ALLOCATING_MEMORY_TO_A_WRITE_REQUEST("TimeForAllocatingMemoryToAWriteRequest", 119),
        CACHE_WRITE_USAGE("CacheWriteUsage", 120),
        NUMBER_OF_CACHE_DATA_FLUSH_IO("NumberOfCacheDataFlushIO", 121),
        NUMBER_OF_CACHE_DATA_FLUSH_PAGES("NumberOfCacheDataFlushPages", 122),
        READ_BANDWIDTH_KB("ReadBandwidthKB", 123),
        WRITE_BANDWIDTH_KB("WriteBandwidthKB", 124),
        AVERAGE_READ_IO_CONTROLLER_A("AverageReadIOControllerA", 125),
        AVERAGE_WRITE_IO_CONTROLLER_A("AverageWriteIOControllerA", 126),
        MAX_IO_LATENCY_CONTROLLER_A("MaxIOLatencyControllerA", 127),
        AVERAGE_IO_LATENCY_CONTROLLER_A("AverageIOLatencyControllerA", 128),
        USAGE_RATIO_CONTROLLER_A("UsageRatioControllerA", 129),
        QUEUE_LENGTH_CONTROLLER_A("QueueLengthControllerA", 130),
        SERVICE_TIME_CONTROLLER_A("ServiceTimeControllerA", 131),
        NUMBER_OF_COMBINED_READ_I_OS_PER_SECOND_CONTROLLER_A("NumberOfCombinedReadIOsPerSecondControllerA", 132),
        NUMBER_OF_COMBINED_WRITE_I_OS_PER_SECOND_CONTROLLER_A("NumberOfCombinedWriteIOsPerSecondControllerA", 133),
        READ_WAITING_TIME_CONTROLLER_A("ReadWaitingTimeControllerA", 134),
        WRITE_WAITING_TIME_CONTROLLER_A("WriteWaitingTimeControllerA", 135),
        AVERAGE_IO_SIZE_CONTROLLER_A("AverageIOSizeControllerA", 136),
        AVERAGE_READ_IO_CONTROLLER_B("AverageReadIOControllerB", 137),
        AVERAGE_WRITE_IO_CONTROLLER_B("AverageWriteIOControllerB", 138),
        MAX_IO_LATENCY_CONTROLLER_B("MaxIOLatencyControllerB", 139),
        AVERAGE_IO_LATENCY_CONTROLLER_B("AverageIOLatencyControllerB", 140),
        USAGE_RATIO_CONTROLLER_B("UsageRatioControllerB", 141),
        QUEUE_LENGTH_CONTROLLER_B("QueueLengthControllerB", 142),
        SERVICE_TIME_CONTROLLER_B("ServiceTimeControllerB", 143),
        NUMBER_OF_COMBINED_READ_I_OS_PER_SECOND_CONTROLLER_B("NumberOfCombinedReadIOsPerSecondControllerB", 144),
        NUMBER_OF_COMBINED_WRITE_I_OS_PER_SECOND_CONTROLLER_B("NumberOfCombinedWriteIOsPerSecondControllerB", 145),
        READ_WAITING_TIME_CONTROLLER_B("ReadWaitingTimeControllerB", 146),
        WRITE_WAITING_TIME_CONTROLLER_B("WriteWaitingTimeControllerB", 147),
        AVERAGE_IO_SIZE_CONTROLLER_B("AverageIOSizeControllerB", 148),
        READ_IO_GRANULARITY_DISTRIBUTION_4_KB("ReadIOGranularityDistribution4KB", 149),
        READ_IO_GRANULARITY_DISTRIBUTION_8_KB("ReadIOGranularityDistribution8KB", 150),
        READ_IO_GRANULARITY_DISTRIBUTION_16_KB("ReadIOGranularityDistribution16KB", 151),
        READ_IO_GRANULARITY_DISTRIBUTION_32_KB("ReadIOGranularityDistribution32KB", 152),
        READ_IO_GRANULARITY_DISTRIBUTION_64_KB("ReadIOGranularityDistribution64KB", 153),
        READ_IO_GRANULARITY_DISTRIBUTION_128_KB("ReadIOGranularityDistribution128KB", 154),
        READ_IO_GRANULARITY_DISTRIBUTION_256_KB("ReadIOGranularityDistribution256KB", 155),
        READ_IO_GRANULARITY_DISTRIBUTION_512_KB("ReadIOGranularityDistribution512KB", 156),
        READ_IO_GRANULARITY_DISTRIBUTION_1_MB("ReadIOGranularityDistribution1MB", 157),
        READ_IO_GRANULARITY_DISTRIBUTION_2_MB("ReadIOGranularityDistribution2MB", 158),
        READ_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB("ReadIOGranularityDistributionMoreThan2MB", 159),
        WRITE_IO_GRANULARITY_DISTRIBUTION_4_KB("WriteIOGranularityDistribution4KB", 160),
        WRITE_IO_GRANULARITY_DISTRIBUTION_8_KB("WriteIOGranularityDistribution8KB", 161),
        WRITE_IO_GRANULARITY_DISTRIBUTION_16_KB("WriteIOGranularityDistribution16KB", 162),
        WRITE_IO_GRANULARITY_DISTRIBUTION_32_KB("WriteIOGranularityDistribution32KB", 163),
        WRITE_IO_GRANULARITY_DISTRIBUTION_64_KB("WriteIOGranularityDistribution64KB", 164),
        WRITE_IO_GRANULARITY_DISTRIBUTION_128_KB("WriteIOGranularityDistribution128KB", 165),
        WRITE_IO_GRANULARITY_DISTRIBUTION_256_KB("WriteIOGranularityDistribution256KB", 166),
        WRITE_IO_GRANULARITY_DISTRIBUTION_512_KB("WriteIOGranularityDistribution512KB", 167),
        WRITE_IO_GRANULARITY_DISTRIBUTION_1_MB("WriteIOGranularityDistribution1MB", 168),
        WRITE_IO_GRANULARITY_DISTRIBUTION_2_MB("WriteIOGranularityDistribution2MB", 169),
        WRITE_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB("WriteIOGranularityDistributionMoreThan2MB", 170),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_4_KB("ReadAndWriteIOGranularityDistribution4KB", 171),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_8_KB("ReadAndWriteIOGranularityDistribution8KB", 172),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_16_KB("ReadAndWriteIOGranularityDistribution16KB", 173),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_32_KB("ReadAndWriteIOGranularityDistribution32KB", 174),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_64_KB("ReadAndWriteIOGranularityDistribution64KB", 175),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_128_KB("ReadAndWriteIOGranularityDistribution128KB", 176),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_256_KB("ReadAndWriteIOGranularityDistribution256KB", 177),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_512_KB("ReadAndWriteIOGranularityDistribution512KB", 178),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_1_MB("ReadAndWriteIOGranularityDistribution1MB", 179),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_2_MB("ReadAndWriteIOGranularityDistribution2MB", 180),
        READ_AND_WRITE_IO_GRANULARITY_DISTRIBUTION_MORE_THAN_2_MB("ReadAndWriteIOGranularityDistributionMoreThan2MB", 181),
        OPS("OPS", 182),
        NUMBEROF_ONLINE_USER("NumberofOnlineUser", 183),
        FILE_SPACE_HARD_QUOTA("FileSpaceHardQuota", 184),
        USED_CAPACITY("UsedCapacity", 185),
        TOTAL_CAPACITY("TotalCapacity", 186),
        DEDUPE_RATE("DedupeRate", 187),
        DISK_BUSY_RATIO("DiskBusyRatio", 192),
        PACKAGES_RATE("PackagesRate", 193),
        RVG_BAND_WIDTH("RvgBandWidth", 194),
        ERROR_PACKAGE("ErrorPackage", 190),
        DROPPED_PACKAGE("DroppedPackage", 189),
        OVERRUN_PACKAGE("OverrunPackage", 191),
        X_FER_PACKAGE("XFerPackage", 188),
        MAX_READ_IO_LATENCY("MaxReadIOLatency", 195),
        MAX_WRITE_IO_LATENCY("MaxWriteIOLatency", 196),
        AVERAGE_READ_IO_LATENCY("AverageReadIOLatency", 197),
        AVERAGE_WRITE_IO_LATENCY("AverageWriteIOLatency", 198),
        READ_IO_LATENCY_DISTRIBUTION_10_MS("ReadIOLatencyDistribution10ms", 199),
        READ_IO_LATENCY_DISTRIBUTION_20_MS("ReadIOLatencyDistribution20ms", 200),
        READ_IO_LATENCY_DISTRIBUTION_50_MS("ReadIOLatencyDistribution50ms", 201),
        READ_IO_LATENCY_DISTRIBUTION_100_MS("ReadIOLatencyDistribution100ms", 202),
        READ_IO_LATENCY_DISTRIBUTION_200_MS("ReadIOLatencyDistribution200ms", 203),
        READ_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS("ReadIOLatencyDistributionMoreThan200ms", 204),
        WRITE_IO_LATENCY_DISTRIBUTION_10_MS("WriteIOLatencyDistribution10ms", 205),
        WRITE_IO_LATENCY_DISTRIBUTION_20_MS("WriteIOLatencyDistribution20ms", 206),
        WRITE_IO_LATENCY_DISTRIBUTION_50_MS("WriteIOLatencyDistribution50ms", 207),
        WRITE_IO_LATENCY_DISTRIBUTION_100_MS("WriteIOLatencyDistribution100ms", 208),
        WRITE_IO_LATENCY_DISTRIBUTION_200_MS("WriteIOLatencyDistribution200ms", 209),
        WRITE_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS("WriteIOLatencyDistributionMoreThan200ms", 210),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_10_MS("ReadandWriteIOLatencyDistribution10ms", 211),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_20_MS("ReadandWriteIOLatencyDistribution20ms", 212),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_50_MS("ReadandWriteIOLatencyDistribution50ms", 213),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_100_MS("ReadandWriteIOLatencyDistribution100ms", 214),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_200_MS("ReadandWriteIOLatencyDistribution200ms", 215),
        READAND_WRITE_IO_LATENCY_DISTRIBUTION_MORE_THAN_200_MS("ReadandWriteIOLatencyDistributionMoreThan200ms", 216),
        MAX_CPU_USAGE("MaxCPUUsage", 217),
        MAX_MEMORY_USAGE("MaxMemoryUsage", 218),
        NFS_BANDWIDTH("NFSBandwidth", 219),
        NFS_IN_BANDWIDTH("NFSInBandwidth", 220),
        NFS_OUT_BANDWIDTH("NFSOutBandwidth", 221),
        CIFS_BANDWIDTH("CIFSBandwidth", 222),
        CIFS_IN_BANDWIDTH("CIFSInBandwidth", 223),
        CIFS_OUT_BANDWIDTH("CIFSOutBandwidth", 224),
        CONNECTED_CLIENT_COUNT("ConnectedClientCount", 225),
        CONNECTED_NFS_CLIENT_COUNT("ConnectedNFSClientCount", 226),
        CONNECTED_CIFS_CLIENT_COUNT("ConnectedCIFSClientCount", 227),
        AVERAGE_IO_SIZE("AverageIOSize", 228),
        NETWORK_PACKET_RATE("NetworkPacketRate", 229),
        NETWORK_INBOUND_PACKET_RATE("NetworkInboundPacketRate", 230),
        NETWORK_OUTBOUND_PACKET_RATE("NetworkOutboundPacketRate", 231),
        READ_OPS("ReadOPS", 232),
        WRITE_OPS("WriteOPS", 233),
        CLOUD_COPY_BAND_WIDTH("CloudCopyBandWidth", 236),
        READ_L_2_CACHE_HIT("ReadL2CacheHit", 237),
        READ_L_2_CACHE_NOT_HIT("ReadL2CacheNotHit", 238),
        READ_L_2_CACHE_HIT_RATIO("ReadL2CacheHitRatio", 239),
        AVERAGE_QUEUE_SIZE("AverageQueueSize", 240),
        COMPLETE_SCSI_COMMANDS_PER_SECOND("CompleteSCSICommandsPerSecond", 241),
        VERIFY_COMMANDS_PER_SECOND("VerifyCommandsPerSecond", 242),
        DISK_TOTAL_CAPACITY("DiskTotalCapacity", 243),
        DISK_ALLOCED_CAPACITY("DiskAllocedCapacity", 244),
        DISK_ALLOCED_USAGE("DiskAllocedUsage", 245),
        DISK_FREE_USAGE("DiskFreeUsage", 246),
        WP_COUNT("WPCount", 247),
        WP_LIMIT("WPLimit", 248),
        WP_UTILIZATION("WPUtilization", 249),
        CACHE_USED("CacheUsed", 250),
        HOST_HIT("HostHit", 251),
        HOST_READ_HIT("HostReadHit", 252),
        HOST_WRITE_HIT("HostWriteHit", 253),
        HOST_MISS("HostMiss", 254),
        HOST_READ_MISS("HostReadMiss", 255),
        HOST_WRITE_MISS("HostWriteMiss", 256),
        BE_REQ("BEReq", 257),
        BE_READ_REQ("BEReadReq", 258),
        BE_WRITE_REQ("BEWriteReq", 259),
        BEM_BSTRANSFERRED("BEMBstransferred", 260),
        BEM_BS_READ("BEMBsRead", 261),
        BEM_BS_WRITTEN("BEMBsWritten", 262),
        READ_MISS_RESPONSE_TIME("ReadMissResponseTime", 263),
        WRITE_MISS_RESPONSE_TIME("WriteMissResponseTime", 264),
        READ_PERCENT("ReadPercent", 265),
        WRITE_PERCENT("WritePercent", 266),
        READ_HIT_PERCENT("ReadHitPercent", 267),
        WRITE_HIT_PERCENT("WriteHitPercent", 268),
        READ_MISS_PERCENT("ReadMissPercent", 269),
        WRITE_MISS_PERCENT("WriteMissPercent", 270),
        BE_READ_REQUEST_TIME("BEReadRequestTime", 271),
        BE_DISK_READ_RESPONSE_TIME("BEDiskReadResponseTime", 272),
        BE_READ_TASK_TIME("BEReadTaskTime", 273),
        BE_READ_RESPONSE_TIME("BEReadResponseTime", 274),
        BE_WRITE_RESPONSE_TIME("BEWriteResponseTime", 275),
        BE_AVG_RESPONSE_TIME("BEAvgResponseTime", 276),
        BE_READS_PERCENT("BEReadsPercent", 277),
        BE_WRITES_PERCENT("BEWritesPercent", 278),
        REQUEST("Request", 279),
        READ_REQUEST("ReadRequest", 280),
        WRITE_REQUEST("WriteRequest", 281),
        READ_HIT_REQUEST("ReadHitRequest", 282),
        WRITE_HIT_REQUEST("WriteHitRequest", 283),
        MISS_REQUEST("MissRequest", 284),
        READ_MISS_REQUEST("ReadMissRequest", 285),
        WRITE_MISS_REQUEST("WriteMissRequest", 286),
        READ_REQUEST_PERCENT("ReadRequestPercent", 287),
        WRITE_REQUEST_PERCENT("WriteRequestPercent", 288),
        HIT_REQUEST_PERCENT("HitRequestPercent", 289),
        READ_REQUEST_HIT_PERCENT("ReadRequestHitPercent", 290),
        IO_S("IOs", 291),
        REQUESTS("Requests", 292),
        READ_REQUESTS("ReadRequests", 293),
        WRITE_REQUESTS("WriteRequests", 294),
        FLOW("Flow", 295),
        PORT_FLOW("PortFlow", 296),
        PORT_IOS("PortIOs", 297),
        READ_FLOW("ReadFlow", 298),
        WRITTEN_FLOW("WrittenFlow", 299),
        PORT_AVG_REQ_SIZE("PortAvgReqSize", 300),
        MAX_WP_THRESHOLD("MaxWPThreshold", 301),
        RANDOM_HITS("RandomHits", 302),
        HIT_PERCENT("HitPercent", 303),
        MISSERCENT("Missercent", 304),
        RANDOM_READS_PERCENT("RandomReadsPercent", 305),
        RANDOM_WRITES_PERCENT("RandomWritesPercent", 306),
        MAX_IOP_SS_PER_SEC("MaxIOPSsPerSec", 307),
        FAILED_IOS("FailedIOs", 308),
        FAILED_IOS_PER_SEC("FailedIOsPerSec", 309),
        FAILED_IO_RATIO("FailedIORatio", 310),
        WRITE_LATENCY_DISTRIBUTION_5MS_10MS("WriteLatencyDistribution_5MS_10MS", 402),
        THROUGHPUT_BPS("ThroughputBps", 439),
        READ_LATENCY_DISTRIBUTION_5MS_10MS("ReadLatencyDistribution_5MS_10MS", 396),
        THROUGHPUT_KBS("ThroughputKbs", 512),
        READ_IO_GRANULARITY_DISTRIBUTION_0K_512B("ReadIOGranularityDistribution_0K_512B", 466),
        READ_IO_GRANULARITY_DISTRIBUTION_512B_1K("ReadIOGranularityDistribution_512B_1K", 467),
        READ_IO_GRANULARITY_DISTRIBUTION_256_K("ReadIOGranularityDistribution_256K", 468),
        WRITE_IO_GRANULARITY_DISTRIBUTION_0K_512B("WriteIOGranularityDistribution_0K_512B", 469),
        WRITE_IO_GRANULARITY_DISTRIBUTION_512B_1K("WriteIOGranularityDistribution_512B_1K", 470),
        WRITE_IO_GRANULARITY_DISTRIBUTION_256_K("WriteIOGranularityDistribution_256K", 471),
        AVG_LATENCY_FOR_WRITE_OPERATION("AvgLatencyForWriteOperation", 430),
        MAX_LATENCY_FOR_WRITE_OPERATION("MaxLatencyForWriteOperation", 431),
        AVG_LATENCY_FOR_READ_OPERATION("AvgLatencyForReadOperation", 432),
        MAX_LATENCY_FOR_READ_OPERATION("MaxLatencyForReadOperation", 433),
        AVG_READ_OPS_RESPONSE_TIME("AvgReadOPSResponseTime", 464),
        AVG_WRITE_OPS_RESPONSE_TIME("AvgWriteOPSResponseTime", 465),
        SPACE_USAGE("SpaceUsage", 462),
        SPACE_SIZE("SpaceSize", 463),
        THROUGHPUT_MVX("ThroughputMvx", 311),
        READ_THROUGHPUT_MVX("ReadThroughputMvx", 312),
        WRITE_THROUGHPUT_MVX("WriteThroughputMvx", 313),
        SERVICETIME_US("ServiceTime_us", 369),
        AVERAGE_IO_RESPONSE_TIME_US("AverageIOResponseTime_us", 370),
        MAX_IO_RESPONSE_TIME_US("MaxIOResponseTime_us", 371),
        TIMEFOR_HOSTTO_SEND_DATA_US("TimeforHosttoSendData_us", 372),
        TIMEFOR_SAVING_WRITE_DATA_US("TimeforSavingWriteData_us", 373),
        TIMEFOR_RELEASING_WRITE_REQUEST_RESOURCES_US("TimeforReleasingWriteRequestResources_us", 374),
        TIMEFOR_EXECUTINGA_READ_REQUEST_US("TimeforExecutingaReadRequest_us", 375),
        TIMEFOR_RELEASING_READ_REQUEST_RESOURCES_US("TimeforReleasingReadRequestResources_us", 376),
        TIMEFOR_ALLOCATING_MEMORYTOA_WRITE_REQUEST_US("TimeforAllocatingMemorytoaWriteRequest_us", 377),
        MAX_IO_LATENCY_CONTROLLER_A_US("MaxIOLatencyControllerA_us", 378),
        AVERAGE_IO_LATENCY_CONTROLLER_A_US("AverageIOLatencyControllerA_us", 379),
        MAX_IO_LATENCY_CONTROLLER_B_US("MaxIOLatencyControllerB_us", 380),
        AVERAGE_IO_LATENCY_CONTROLLER_B_US("AverageIOLatencyControllerB_us", 381),
        MAX_READ_IO_LATENCY_US("MaxReadIOLatency_us", 382),
        MAX_WRITE_IO_LATENCY_US("MaxWriteIOLatency_us", 383),
        AVERAGE_READ_IO_LATENCY_US("AverageReadIOLatency_us", 384),
        AVERAGE_WRITE_IO_LATENCY_US("AverageWriteIOLatency_us", 385),
        SERVICE_TIME_EXCLUDING_QUEUE_TIME_CONTROLLER_A_US("ServiceTimeExcludingQueueTimeControllerA_us", 386),
        READ_WAITING_TIME_CONTROLLER_A_US("ReadWaitingTimeControllerA_us", 387),
        WRITE_WAITING_TIME_CONTROLLER_A_US("WriteWaitingTimeControllerA_us", 388),
        SERVICE_TIME_EXCLUDING_QUEUE_TIME_CONTROLLER_B_US("ServiceTimeExcludingQueueTimeControllerB_us", 389),
        READ_WAITING_TIME_CONTROLLER_B_US("ReadWaitingTimeControllerB_us", 390),
        WRITE_WAITING_TIME_CONTROLLER_B_US("WriteWaitingTimeControllerB_us", 391),
        PROTOCOL_OPERATIONS_AVG_LATENCY_FOR_NFS("ProtocolOperationsAvgLatencyForNFS", 410),
        PROTOCOL_OPERATIONS_MAX_LATENCY_FOR_NFS("ProtocolOperationsMaxLatencyForNFS", 411),
        PROTOCOL_WRITE_OPERATIONS_AVG_LATENCY_FOR_NFS("ProtocolWriteOperationsAvgLatencyForNFS", 412),
        PROTOCOL_WRITE_OPERATIONS_MAX_LATENCY_FOR_NFS("ProtocolWriteOperationsMaxLatencyForNFS", 413),
        PROTOCOL_READ_OPERATIONS_AVG_LATENCY_FOR_NFS("ProtocolReadOperationsAvgLatencyForNFS", 414),
        PROTOCOL_READ_OPERATIONS_MAX_LATENCY_FOR_NFS("ProtocolReadOperationsMaxLatencyForNFS", 415),
        PROTOCOL_OPERATIONS_AVG_LATENCY_FOR_CIFS("ProtocolOperationsAvgLatencyForCIFS", 416),
        PROTOCOL_OPERATIONS_MAX_LATENCY_FOR_CIFS("ProtocolOperationsMaxLatencyForCIFS", 417),
        PROTOCOL_WRITE_OPERATIONS_AVG_LATENCY_FOR_CIFS("ProtocolWriteOperationsAvgLatencyForCIFS", 418),
        PROTOCOL_WRITE_OPERATIONS_MAX_LATENCY_FOR_CIFS("ProtocolWriteOperationsMaxLatencyForCIFS", 419),
        PROTOCOL_READ_OPERATIONS_AVG_LATENCY_FOR_CIFS("ProtocolReadOperationsAvgLatencyForCIFS", 420),
        PROTOCOL_READ_OPERATIONS_MAX_LATENCY_FOR_CIFS("ProtocolReadOperationsMaxLatencyForCIFS", 421),
        FILE_COUNT("FileCount", 434),
        COUNT_OF_PROTOCOL_LARGE_LATENCY_4_CIFS("CountOfProtocolReadOperationLargeLatencyContinuousOccurredForCIFS", 435),
        COUNT_OF_PROTOCOL_READ_LARGE_LATENCY_4_NFS("CountOfProtocolReadOperationLargeLatencyContinuousOccurredForNFS", 436),
        COUNT_OF_PROTOCOL_READ_LARGE_LATENCY("CountOfProtocolReadOperationLargeLatencyContinuousOccurred", 437),
        PROTOCOL_OPERATIONS_MIN_LATENCY_FOR_NFS("ProtocolOperationsMinLatencyForNFS", 438),
        FILE_BANDWIDTH("FileBandwidth", 475),
        FILE_OPS("FileOps", 476),
        AVG_LATENCY_FOR_OPERATION_MS("AvgLatencyForOperationMs", 428),
        AVG_LATENCY_FOR_OPERATION_US("AvgLatencyForOperationUs", 508),
        MAX_LATENCY_FOR_OPERATION_MS("MaxLatencyForOperationMs", 429),
        MAX_LATENCY_FOR_OPERATION_US("MaxLatencyForOperationUs", 509),
        MIN_LATENCY_FOR_OPERATION_MS("MinLatencyForOperationMs", 472),
        MIN_LATENCY_FOR_OPERATION_US("MinLatencyForOperationUs", 510),
        FILE_BANDWIDTH_KBS("FILE_BANDWIDTH_KBs", 511),
        THROUGHPUT_K_BS("THROUGHPUT_KBs", 512),
        SERVICE_TIME_US("SERVICE_TIME_US", 523),
        AVG_READ_OPS_RESPONSE_US("AVG_READ_OPS_RESPONSE_US", 524),
        AVG_WRITE_OPS_RESPONSE_US("AVG_WRITE_OPS_RESPONSE_US", 525),
        LOGICAL_BAND_WIDTH("LogicalBandWidth", 473),
        TOTAL_MOVED_DATA_SIZE("TotalMovedDataSize", 513),
        MOVED_TO_SSD_DATA_SIZE("MovedToSSDDataSize", 514),
        MOVED_TO_SAS_DATA_SIZE("MovedToSASDataSize", 515),
        MOVED_TO_NLSAS_DATA_SIZE("MovedToNLSASDataSize", 516),
        SAS_MOVED_TO_SSD_DATA_SIZE("SASMovedToSSDDataSize", 517),
        NLSAS_MOVED_TO_SSD_DATA_SIZE("NLSASMovedToSSDDataSize", 518),
        SSD_MOVED_TO_SAS_DATA_SIZE("SSDMovedToSASDataSize", 519),
        NLSAS_MOVED_TO_SAS_DATA_SIZE("NLSASMovedToSASDataSize", 520),
        SSD_MOVED_TO_NLSAS_DATA_SIZE("SSDMovedToNLSASDataSize", 521),
        SAS_MOVED_TO_NLSAS_DATA_SIZE("SASMovedToNLSASDataSize", 522),
        CACHE_WATER("CacheWater", 333),
        AVERAGE_USAGE_OF_MEMBERDISKS("AverageUsageOfMemberdisks", 808),
        TOTAL_IOS("TotalIOs", 1000),
        TOTAL_IOS_L("TotalIOs_L", 1001),
        KBYTES_TRANSFERRED("KbytesTransferred", 1002),
        KBYTES_TRANSFERRED_L("KbytesTransferred_L", 1003),
        IO_TIME_COUNTER("IOTimeCounter", 1004),
        IO_TIME_COUNTER_L("IOTimeCounter_L", 1005),
        READ_IOS("ReadIOs", 1006),
        READ_IOS_L("ReadIOs_L", 1007),
        READ_HIT_IOS("ReadHitIOs", 1008),
        READ_HIT_IOS_L("ReadHitIOs_L", 1009),
        READ_IO_TIME_COUNTER("ReadIOTimeCounter", 1010),
        READ_IO_TIME_COUNTER_L("ReadIOTimeCounter_L", 1011),
        K_BYTES_READ("KBytesRead", 1012),
        K_BYTES_READ_L("KBytesRead_L", 1013),
        WRITE_IOS("WriteIOs", 1014),
        WRITE_IOS_L("WriteIOs_L", 1015),
        WRITE_HIT_IOS("WriteHitIOs", 1016),
        WRITE_HIT_IOS_L("WriteHitIOs_L", 1017),
        WRITE_IO_TIME_COUNTER("WriteIOTimeCounter", 1018),
        WRITE_IO_TIME_COUNTER_L("WriteIOTimeCounter_L", 1019),
        K_BYTES_WRITTEN("KBytesWritten", 1020),
        K_BYTES_WRITTEN_L("KBytesWritten_L", 1021),
        IDLE_TIME_COUNTER("IdleTimeCounter", 1022),
        IDLE_TIME_COUNTER_L("IdleTimeCounter_L", 1023),
        TOTAL_IOS_FS("TotalIOs_FS", 1024),
        TOTAL_IOS_L_FS("TotalIOs_L_FS", 1025),
        TOTAL_BYTES_TRANSFERRED("TotalBytesTransferred", 1026),
        TOTAL_BYTES_TRANSFERRED_L("TotalBytesTransferred_L", 1027),
        READ_IOS_FS("ReadIOs_FS", 1028),
        READ_IOS_L_FS("ReadIOs_L_FS", 1029),
        WRITE_IOS_FS("WriteIOs_FS", 1030),
        WRITE_IOS_L_FS("WriteIOs_L_FS", 1031),
        OTHER_IOS("OtherIOs", 1032),
        OTHER_IOS_L("OtherIOs_L", 1033),
        METADATA_READ_IOS("MetadataReadIOs", 1034),
        METADATA_READ_IOS_L("MetadataReadIOs_L", 1035),
        METADATA_WRITE_IOS("MetadataWriteIOs", 1036),
        METADATA_WRITE_IOS_L("MetadataWriteIOs_L", 1037),
        TOTAL_IO_TIME_COUNTER("TotalIOTimeCounter", 1038),
        TOTAL_IO_TIME_COUNTER_L("TotalIOTimeCounter_L", 1039),
        TOTAL_IDLE_TIME_COUNTER("TotalIdleTimeCounter", 1040),
        TOTAL_IDLE_TIME_COUNTER_L("TotalIdleTimeCounter_L", 1041),
        READ_IO_TIME_COUNTER_FS("ReadIOTimeCounter_FS", 1042),
        READ_IO_TIME_COUNTER_L_FS("ReadIOTimeCounter_L_FS", 1043),
        BYTES_READ("BytesRead", 1044),
        BYTES_READ_L("BytesRead_L", 1045),
        WRITE_IO_TIME_COUNTER_FS("WriteIOTimeCounter_FS", 1046),
        WRITE_IO_TIME_COUNTER_L_FS("WriteIOTimeCounter_L_FS", 1047),
        BYTES_WRITTEN("BytesWritten", 1048),
        BYTES_WRITTEN_L("BytesWritten_L", 1049),
        METADATA_BYTES_READ("MetadataBytesRead", 1050),
        METADATA_BYTES_READ_L("MetadataBytesRead_L", 1051),
        METADATA_BYTES_WRITTEN("MetadataBytesWritten", 1052),
        METADATA_BYTES_WRITTEN_L("MetadataBytesWritten_L", 1053),
        SYNCHRONIZATION_DURATION("SynchronizationDuration", 1054),
        CACHE_PAGE_UTILIZATION("CachePageUtilization", 1055),
        CACHE_CHUNK_UTILIZATION("CacheChunkUtilization", 1056),
        CACHE_PAGE_UNIT_UTILIZATION("CachePageUnitUtilization", 1057),
        CACHE_PAGE_PRESERVATION("CachePagePreservation", 1059),
        CACHE_CHUNK_PRESERVATION("CacheChunkPreservation", 1060),
        TIME_DIFFERENCE("TimeDifference", 699),
        TOTAL_BANDWIDTH("TotalBandwidth", 767),
        BLOCK_READ_BANDWIDTH("BlockReadBandwidth", 768),
        BLOCK_WRITE_BANDWIDTH("BlockWriteBandwidth", 769),
        FILE_RAD_BANDWIDTH("FileRadBandwidth", 770),
        FILE_WRITE_BANDWIDTH("FileWriteBandwidth", 771),
        BLOCK_SERVICE_TIME("BlockServiceTime", 772),
        FILE_SERVICE_TIME("FileServiceTime", 773),
        SCSIIOPS("SCSIIOPS", 1079),
        ISCSIIOPS("ISCSIIOPS", 1073),
        NFS_OPERATION_COUNT_PER_SECOND("NFSOperationCountPerSecond", 627),
        CIFS_OPERATION_COUNT_PER_SECOND("CIFSOperationCountPerSecond", 1074),
        TOTAL_DISK_IOPS("TotalDiskIOPS", 1076),
        READ_DISK_IOPS("ReadDiskIOPS", 1077),
        WRITE_DISK_IOPS("WriteDiskIOPS", 1078),
        DISK_MAX_USAGE("DiskMaxUsage", 1075),
        REQUEST_QUEUE_USAGE("RequestQueueUsage", 784),
        TOTAL_NFS_BANDWIDTH("TotalNFSBandwidth", 703),
        TOTAL_CIFS_BANDWIDTH("TotalCIFSBandwidth", 706),
        NFS_READ_BANDWIDTH("NFSReadBandwidth", 709),
        CIFS_READ_BANDWIDTH("CIFSReadBandwidth", 712),
        NFS_WRITE_BANDWIDTH("NFSWriteBandwidth", 715),
        CIFS_WRITE_BANDWIDTH("CIFSWriteBandwidth", 718),
        TOTAL_NFSOPS("TotalNFSOPS", 721),
        TOTAL_CIFSOPS("TotalCIFSOPS", 724),
        TOTAL_NFS_READ_OPS("TotalNFSReadOPS", 727),
        TOTAL_CIFS_READ_OPS("TotalCIFSReadOPS", 730),
        TOTAL_NFS_WRITE_OPS("TotalNFSWriteOPS", 733),
        TOTAL_CIFS_WRITE_OPS("TotalCIFSWriteOPS", 736),
        OTHER_NFSOPS("OtherNFSOPS", 739),
        OTHER_CIFSOPS("OtherCIFSOPS", 742),
        AVERAGE_NFSIO_RESPONSE_TIME("AverageNFSIOResponseTime", 745),
        AVERAGE_CIFSIO_RESPONSE_TIME("AverageCIFSIOResponseTime", 748),
        AVERAGE_NF_SREAD_IO_RESPONSE_TIME("AverageNFSreadIOResponseTime", 751),
        AVERAGE_CIFS_READ_IO_RESPONSE_TIME("AverageCIFSReadIOResponseTime", 754),
        AVERAGE_NFS_WRITE_IO_RESPONSE_TIME("AverageNFSWriteIOResponseTime", 757),
        AVERAGE_CIFS_WRITE_IO_RESPONSE_TIME("AverageCIFSWriteIOResponseTime", 760),
        AVERAGE_RESPONSE_TIME_OF_OTHER_NFSIO("AverageResponseTimeOfOtherNFSIO", 763),
        AVERAGE_RESPONSE_TIME_OF_OTHER_CIFSIO("AverageResponseTimeOfOtherCIFSIO", 766),
        AVERAGE_BLOCK_READ_IO_RESPONSE_TIME("AverageBlockReadIOResponseTime", 775),
        AVERAG_BLOCK_WRITE_IO_RESPONSE_TIME("AveragBlockWriteIOResponseTime", 776),
        AVERAGE_BLOCK_IO_RESPONSE_TIME("AverageBlockIOResponseTime", 777),
        READ_LATENCY_DISTRIBUTION("ReadLatencyDistribution", 530),
        WRITE_LATENCY_DISTRIBUTION("WriteLatencyDistribution", 531),
        NUMBERFAILEDREAD("Numberfailedread", 532),
        NUMBERFAILEDWRITE("Numberfailedwrite", 533),
        UNMAP_COMMAND_BANDWIDTH("UnmapCommandBandwidth", 1154),
        UNMAP_COMMAND_IOPS("UnmapCommandIOPS", 1155),
        UNMAP_COMMAND_SIZE("UnmapCommandSize", 1156),
        UNMAP_COMMAND_RESPONSE_TIME("UnmapCommandResponseTime", 1157),
        WRITE_SAME_COMMAND_BANDWIDTH("WRITESAMECommandBandwidth", 1158),
        WRITE_SAME_COMMAND_IOPS("WRITESAMECommandIOPS", 1159),
        WRITE_SAME_COMMAND_SIZE("WRITESAMECommandSize", 1160),
        WRITE_SAME_COMMAND_RESPONSE_TIME("WRITESAMECommandResponseTime", 1161),
        FULL_COPY_READ_REQUEST_BANDWIDTH("FullCopyReadRequestBandwidth", 1162),
        FULL_COPY_READ_REQUEST_IOPS("FullCopyReadRequestIOPS", 1163),
        FULL_COPY_READ_REQUEST_SIZE("FullCopyReadRequestSize", 1164),
        FULL_COPY_READ_REQUEST_RESPONSE_TIME("FullCopyReadRequestResponseTime", 1165),
        FULL_COPY_WRITE_REQUEST_BANDWIDTH("FullCopyWriteRequestBandwidth", 1166),
        FULL_COPY_WRITE_REQUEST_IOPS("FullCopyWriteRequestIOPS", 1167),
        FULL_COPY_WRITE_REQUEST_SIZE("FullCopyWriteRequestSize", 1168),
        FULL_COPY_WRITE_REQUEST_RESPONSE_TIME("FullCopyWriteRequestResponseTime", 1169),
        ODX_READ_REQUEST_BANDWIDTH("ODXReadRequestBandwidth", 1170),
        ODX_READ_REQUEST_IOPS("ODXReadRequestIOPS", 1171),
        ODX_READ_REQUEST_SIZE("ODXReadRequestSize", 1172),
        ODX_READ_REQUEST_RESPONSE_TIME("ODXReadRequestResponseTime", 1173),
        ODX_WRITE_REQUEST_BANDWIDTH("ODXWriteRequestBandwidth", 1174),
        ODX_WRITE_REQUEST_IOPS("ODXWriteRequestIOPS", 1175),
        ODX_WRITE_REQUEST_SIZE("ODXWriteRequestSize", 1176),
        ODX_WRITE_REQUEST_RESPONSE_TIME("ODXWriteRequestResponseTime", 1177),
        ODX_WRITE_ZERO_REQUEST_BANDWIDTH("ODXWriteZeroRequestBandwidth", 1178),
        ODX_WRITE_ZERO_REQUEST_IOPS("ODXWriteZeroRequestIOPS", 1179),
        ODX_WRITE_ZERO_REQUEST_SIZE("ODXWriteZeroRequestSize", 1180),
        ODX_WRITE_ZERO_REQUEST_RESPONSE_TIME("ODXWriteZeroRequestResponseTime", 1181),
        READ_IO_TRANSMISSION_DELAY("readIOtransmissiondelay", 1139),
        WRITE_IO_TRANSMISSION_DELAY("writeIOtransmissiondelay", 1140),
        TOTAL_NFS_LOOKUP_OPS("TotalNFSlookupOPS", 1099),
        TOTAL_NFS_CREATE_OPS("TotalNFScreateOPS", 1100),
        TOTAL_NFS_REMOVE_OPS("TotalNFSremoveOPS", 1101),
        TOTAL_NFS_GETATTR_OPS("TotalNFSgetattrOPS", 1102),
        TOTAL_NFS_SETATTR_OPS("TotalNFSsetattrOPS", 1103),
        TOTAL_NFS_MKDIR_OPS("TotalNFSmkdirOPS", 1104),
        TOTAL_NFS_RMDIR_OPS("TotalNFSrmdirOPS", 1105),
        TOTAL_NFS_ACCESS_OPS("TotalNFSaccessOPS", 1106),
        TOTAL_NFS_READDIR_OPS("TotalNFSreaddirOPS", 1107),
        TOTAL_NFS_READDIR_PLUS_OPS("TotalNFSreaddirplusOPS", 1108),
        TOTAL_NFS_OPEN_OPS("TotalNFSopenOPS", 1109),
        NFS_LOOKUP_RESPONSE_TIME("NFSlookupresponsetime", 1114),
        NFS_CREATE_RESPONSE_TIME("NFScreateresponsetime", 1115),
        NFS_REMOVE_RESPONSE_TIME("NFSremoveresponsetime", 1116),
        NFS_GETATTR_RESPONSE_TIME("NFSgetattrresponsetime", 1117),
        NFS_SETATTR_RESPONSE_TIME("NFSsetattrresponsetime", 1118),
        NFS_MKDIR_RESPONSE_TIME("NFSmkdirresponsetime", 1119),
        NFS_RMDIR_RESPONSE_TIME("NFSrmdirresponsetime", 1120),
        NFS_READDIR_RESPONSE_TIME("NFSreaddirresponsetime", 1121),
        NFS_ACCESS_RESPONSE_TIME("NFSaccessresponsetime", 1122),
        NFS_READDIR_PLUS_RESPONSE_TIME("NFSreaddirplusresponsetime", 1123),
        NFS_OPEN_RESPONSE_TIME("NFSopenresponsetime", 1128),
        CUMULATIVE_AMOUNT_OF_TIME_THE_DISK_WAS_IDLEHIGH_32_BITS("CumulativeamountoftimethediskwasidleHigh32bits", 1148),
        CUMULATIVE_AMOUNT_OF_TIME_THE_DISK_WAS_IDLELOWER_32_BITS("CumulativeamountoftimethediskwasidleLower32bits", 1149),
        CUMULATIVE_AMOUNT_OF_THE_TIME_THE_DISK_RUNSHIGH_32_BITS("CumulativeamountofthetimethediskrunsHigh32bits", 1150),
        CUMULATIVE_AMOUNT_OF_THE_TIME_THE_DISK_RUNSLOWER_32_BITS("CumulativeamountofthetimethediskrunsLower32bits", 1151),
        READ_IO_GRANULARITY_DISTRIBUTION_0K_4K("ReadIOGranularityDistribution0KTo4K", 1182),
        READ_IO_GRANULARITY_DISTRIBUTION_128K_INFINITY("ReadIOGranularityDistribution128KToInfinity", 1183),
        WRITE_IO_GRANULARITY_DISTRIBUTION_0K_4K("WriteIOGranularityDistribution0KTo4K", 1184),
        WRITE_IO_GRANULARITY_DISTRIBUTION_128K_INFINITY("WriteIOGranularityDistribution128KToInfinity", 1185),
        THE_PERIOD_COUNT_OF_IO("TheperiodcountofIO", 1210),
        THE_PERIOD_COUNT_OF_WRITE_IO("TheperiodcountofwriteIO", 1209),
        THE_PERIOD_COUNT_OF_READ_IO("TheperiodcountofreadIO", 1208),
        SPECIFICATION_BANDWIDTH("SpecificationBandwidth", 1224),
        OTHER_OPS_FOR_SMB2("OtherOPSForSMB2", 741),
        WRITE_OPS_FOR_SMB2("WriteOPSForSMB2", 735),
        READ_OPS_FOR_SMB2("ReadOPSForSMB2", 729),
        OPS_FOR_SMB2("OPSForSMB2", 723),
        OTHER_IO_AVERAGE_RESPONSE_TIME_FOR_SMB2("OtherIOAverageResponseTimeForSMB2", 765),
        WRITE_IO_AVERAGE_RESPONSE_TIME_FOR_SMB2("WriteIOAverageResponseTimeForSMB2", 759),
        READ_IO_AVERAGE_RESPONSE_TIME_FOR_SMB2("ReadIOAverageResponseTimeForSMB2", 753),
        IO_AVERAGE_RESPONSE_TIME_FOR_SMB2("IOAverageResponseTimeForSMB2", 747),
        WRITE_BANDWIDTH_FOR_SMB2("WriteBandwidthForSMB2", 717),
        READ_BANDWIDTH_FOR_SMB2("ReadBandwidthForSMB2", 711),
        BANDWIDTH_FOR_SMB2("BandwidthForSMB2", 705),
        OTHER_OPS_FOR_SMB1("OtherOPSForSMB1", 740),
        WRITE_OPS_FOR_SMB1("WriteOPSForSMB1", 734),
        READ_OPS_FOR_SMB1("ReadOPSForSMB1", 728),
        OPS_FOR_SMB1("OPSForSMB1", 722),
        OTHER_IO_AVERAGE_RESPONSE_TIME_FOR_SMB1("OtherIOAverageResponseTimeForSMB1", 764),
        WRITE_IO_AVERAGE_RESPONSE_TIME_FOR_SMB1("WriteIOAverageResponseTimeForSMB1", 758),
        READ_IO_AVERAGE_RESPONSE_TIME_FOR_SMB1("ReadIOAverageResponseTimeForSMB1", 752),
        IO_AVERAGE_RESPONSE_TIME_FOR_SMB1("IOAverageResponseTimeForSMB1", 746),
        WRITE_BANDWIDTH_FOR_SMB1("WriteBandwidthForSMB1", 716),
        READ_BANDWIDTH_FOR_SMB1("ReadBandwidthForSMB1", 710),
        BANDWIDTH_FOR_SMB1("BandwidthForSMB1", 704),
        OTHER_OPS_FOR_NFS_V4("OtherOPSForNFSV4", 738),
        WRITE_OPS_FOR_NFS_V4("WriteOPSForNFSV4", 732),
        READ_OPS_FOR_NFS_V4("ReadOPSForNFSV4", 726),
        OPS_FOR_NFS_V4("OPSForNFSV4", 720),
        OTHER_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V4("OtherIOAverageResponseTimeForNFSV4", 762),
        WRITE_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V4("WriteIOAverageResponseTimeForNFSV4", 756),
        READ_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V4("ReadIOAverageResponseTimeForNFSV4", 750),
        IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V4("IOAverageResponseTimeForNFSV4", 744),
        WRITE_BANDWIDTH_FOR_NFS_V4("WriteBandwidthForNFSV4", 714),
        READ_BANDWIDTH_FOR_NFS_V4("ReadBandwidthForNFSV4", 708),
        BANDWIDTH_FOR_NFS_V4("BandwidthForNFSV4", 702),
        OTHER_OPS_FOR_NFS_V3("OtherOPSForNFSV3", 737),
        WRITE_OPS_FOR_NFS_V3("WriteOPSForNFSV3", 731),
        READ_OPS_FOR_NFS_V3("ReadOPSForNFSV3", 725),
        OPS_FOR_NFS_V3("OPSForNFSV3", 719),
        OTHER_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V3("OtherIOAverageResponseTimeForNFSV3", 761),
        WRITE_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V3("WriteIOAverageResponseTimeForNFSV3", 755),
        READ_IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V3("ReadIOAverageResponseTimeForNFSV3", 749),
        IO_AVERAGE_RESPONSE_TIME_FOR_NFS_V3("IOAverageResponseTimeForNFSV3", 743),
        WRITE_BANDWIDTH_FOR_NFS_V3("WriteBandwidthForNFSV3", 713),
        READ_BANDWIDTH_FOR_NFS_V3("ReadBandwidthForNFSV3", 707),
        BANDWIDTH_FOR_NFS_V3("BandwidthForNFSV3", 701),
        NFS_FSSTAT_RESPONSE_TIME("NFSfsstatresponsetime", 1221),
        NFS_LINK_RESPONSE_TIME("NFSlinkresponsetime", 1220),
        NFS_RENAME_RESPONSE_TIME("NFSrenameresponsetime", 1219),
        NFS_SYMLINK_RESPONSE_TIME("NFSsymlinkresponsetime", 1218),
        NFS_READLINK_RESPONSE_TIME("NFSreadlinkresponsetime", 1217),
        TOTAL_NFS_FSSTAT_OPS("TotalNFSfsstatOPS", 1216),
        TOTAL_NFS_LINK_OPS("TotalNFSlinkOPS", 1215),
        TOTAL_NFS_RENAME_OPS("TotalNFSrenameOPS", 1214),
        TOTAL_NFS_SYMLINK_OPS("TotalNFSsymlinkOPS", 1213),
        TOTAL_NFS_READLINK_OPS("TotalNFSreadlinkOPS", 1212),
        CIFS_SETINFO_RESPONSE_TIME("CIFSsetinforesponsetime", 1127),
        CIFS_QUERYDIR_RESPONSE_TIME("CIFSquerydirresponsetime", 1126),
        CIFS_QUERYINFO_RESPONSE_TIME("CIFSqueryinforesponsetime", 1125),
        CIFS_CREATE_RESPONSE_TIME("CIFScreateresponsetime", 1124),
        TOTAL_CIFS_SETINFO_OPS("TotalCIFSsetinfoOPS", 1113),
        TOTAL_CIFS_QUERYDIR_OPS("TotalCIFSquerydirOPS", 1112),
        TOTAL_CIFS_QUERYINFO_OPS("TotalCIFSqueryinfoOPS", 1111),
        TOTAL_CIFS_CREATE_OPS("TotalCIFScreateOPS", 1110),
        WRITE_IO_LATENCY_DISTRIBUTION_8S__INFINITY("WriteIOLatencyDistribution8sToInfinity", 1138),
        WRITE_IO_LATENCY_DISTRIBUTION_5S__8S("WriteIOLatencyDistribution5sTo8s", 1137),
        WRITE_IO_LATENCY_DISTRIBUTION_3S__5S("WriteIOLatencyDistribution3sTo5s", 1136),
        WRITE_IO_LATENCY_DISTRIBUTION_1S__3S("WriteIOLatencyDistribution1sTo3s", 1135),
        WRITE_IO_LATENCY_DISTRIBUTION_200MS__1S("WriteIOLatencyDistribution200msTo1s", 1134),
        READ_IO_LATENCY_DISTRIBUTION_8S__INFINITY("ReadIOLatencyDistribution8sToInfinity", 1133),
        READ_IO_LATENCY_DISTRIBUTION_5S__8S("ReadIOLatencyDistribution5sTo8s", 1132),
        READ_IO_LATENCY_DISTRIBUTION_3S__5S("ReadIOLatencyDistribution3sTo5s", 1131),
        READ_IO_LATENCY_DISTRIBUTION_1S__3S("ReadIOLatencyDistribution1sTo3s", 1130),
        READ_IO_LATENCY_DISTRIBUTION_200MS__1S("ReadIOLatencyDistribution200msTo1s", 1129),
        TOTAL_BANDWIDTHKBS("TotalBandwidthKBs", 811),
        RECEIVING_BANDWIDTH_FOR_REPLICATIONMBS("ReceivingBandwidthforReplicationMBs", 786),
        RECEIVING_BANDWIDTH_FOR_REPLICATIONKBS("ReceivingBandwidthforReplicationKBs", 813),
        TRANSMITTING_BANDWIDTH_FOR_REPLICATIONMBS("TransmittingBandwidthforReplicationMBs", 787),
        TRANSMITTING_BANDWIDTH_FOR_REPLICATIONKBS("TransmittingBandwidthforReplicationKBs", 812),
        MAX_READ_IO_SIZE("MaxReadIOSize", 802),
        MAX_WRITE_IO_SIZE("MaxWriteIOSize", 803),
        MAX_IO_SIZE("MaxIOSize", 804),
        CIFS_SESSION_COUNT("CIFSsessionCount", 1142),
        NFS_CONNECTION_COUNT("NFSconnectionCount", 1143),
        CUMULATIVE_AMOUNT_OF_TIME_THE_CPU_CORES_WERE_IDLEHIGH_32_BITS("CumulativeamountoftimetheCPUcoreswereidleHigh32bits", 1144),
        CUMULATIVE_AMOUNT_OF_TIME_THE_CPU_CORES_WERE_IDLELOWER_32_BITS("CumulativeamountoftimetheCPUcoreswereidleLower32bits", 1145),
        CUMULATIVE_AMOUNT_OF_TIME_THE_CPU_CORESHIGH_32_BITS("CumulativeamountoftimetheCPUcoresHigh32bits", 1146),
        CUMULATIVE_AMOUNT_OF_TIME_THE_CPU_CORESLOWER_32_BITS("CumulativeamountoftimetheCPUcoresLower32bits", 1147),
        AI_CACHE_HIT_RATIO("AICacheHitRatio", 1225),
        CACHE_PAGE_EVICTION_BANDWIDTH("CachePageEvictionBandwidth", 1228),
        READ_SMARTCACHE_HIT_RATIO("ReadSmartCacheHitRatio", 1234),
        READ_SMARTCACHE_HIT_RATIO1095("ReadSmartCacheHitRatio1095", 1095),
        CACHED_CAPACITYHIGH_32_BITS("CachedCapacityHigh32bits", 1096),
        CACHED_CAPACITYLOWER_32_BITS("CachedCapacityLower32bits", 1097),
        THE_PERIOD_COUNT_OF_BYTES_READ("Theperiodcountofbytesread", 1205),
        THE_PERIOD_COUNT_OF_BYTES_WRITE("Theperiodcountofbyteswrite", 1206),
        THE_PERIOD_COUNT_OF_BYTES("Theperiodcountofbytes", 1207),
        PROTECTION_CAPACITY_USAGE("ProtectionCapacityUsage", 774),
        FILE_SYSTEM_SNAPSHOT_CAPACITY_USAGE("Filesystemnapshotcapacityusage", 1080),
        BACK_END_READ_RESPONSE_TIM("BackEndReadResponseTim", 805),
        BACK_END_WRITE_RESPONSE_TIME("BackEndWriteResponseTime", 806),
        BACK_END_RESPONSE_TIME("BackEndResponseTime", 807),
        READ_USAGE("ReadUsage", 1222),
        WRITE_USAGE("WriteUsage", 1223),
        MAX_BANDWIDTH800("MaxBandwidth800", 800),
        BANDWIDTH("Bandwidth", 801),
        WRITE_REQUESTS_LESS_THAN_THE_GRAIN_SIZE_TO_THE_SNAPSHOT_LUN("WriteRequestsLessthantheGrainSizetotheSnapshotLUN", 700),
        DATA_REDUCTION_RATIO("DataReductionRatio", 1090),
        DEDUPLICATION_RATIO("DeduplicationRatio", 1091),
        COMPRESSION_RATIO("CompressionRatio", 1092),
        OVERALL_SPACE_SAVING_RATIO("OverallSpaceSavingRatio", 1093),
        THIN_LUN_SPACE_SAVING_RATE("ThinLUNSpaceSavingRate", 1094),
        PERFORMANCE_UTILIZATION("PerformanceUtilization", 1098),
        VAAI_BANDWIDTH("VAAIBandwidth", 1188),
        VAAI_IOPS("VAAIIOPS", 1189),
        VAAI_SIZE("VAAISize", 1190),
        VAAI_RESPONSE_TIME("VAAIResponseTime", 1191),
        COPY_READ_REQUEST_BANDWIDTH("CopyReadRequestBandwidth", 1192),
        COPY_READ_REQUEST_IOPS("CopyReadRequestIOPS", 1193),
        COPY_READ_REQUEST_SIZE("CopyReadRequestSize", 1194),
        COPY_READ_REQUEST_RESPONSE_TIME("CopyReadRequestResponseTime", 1195),
        COPY_WRITE_REQUEST_BANDWIDTH("CopyWriteRequestBandwidth", 1196),
        COPY_WRITE_REQUEST_IOPS("CopyWriteRequestIOPS", 1197),
        COPY_WRITE_REQUEST_SIZE("CopyWriteRequestSize", 1198),
        COPY_WRITE_REQUEST_RESPONSE_TIME("CopyWriteRequestResponseTime", 1199),
        READ_IO_LATENCY_DISTRIBUTION_0US_500US("ReadIOLatencyDistribution0usTo500us", 392),
        READ_IO_LATENCY_DISTRIBUTION_500US_1MS("ReadIOLatencyDistribution500usTo1ms", 393),
        READ_IO_LATENCY_DISTRIBUTION_1MS_2MS("ReadIOLatencyDistribution1msTo2ms", 394),
        READ_IO_LATENCY_DISTRIBUTION_2MS_5MS("ReadIOLatencyDistribution2msTo5ms", 395),
        READ_IO_LATENCY_DISTRIBUTION_5MS_10MS("ReadIOLatencyDistribution5msTo10ms", 396),
        READ_IO_LATENCY_DISTRIBUTION_10MS_INFINITY("ReadIOLatencyDistribution10msToInfinity", 397),
        WRITE_IO_LATENCY_DISTRIBUTION_0US_500US("WriteIOLatencyDistribution0usTo500us", 398),
        WRITE_IO_LATENCY_DISTRIBUTION_500US_1MS("WriteIOLatencyDistribution500usTo1ms", 399),
        WRITE_IO_LATENCY_DISTRIBUTION_1MS_2MS("WriteIOLatencyDistribution1msTo2ms", 400),
        WRITE_IO_LATENCY_DISTRIBUTION_2MS_5MS("WriteIOLatencyDistribution2msTo5ms", 401),
        WRITE_IO_LATENCY_DISTRIBUTION_5MS_10MS("WriteIOLatencyDistribution5msTo10ms", 402),
        WRITE_IO_LATENCY_DISTRIBUTION_10MS_INFINITY("WriteIOLatencyDistribution10msToInfinity", 403),
        READ_AND_WRITE_IO_LATENCY_DISTRIBUTION_0US_500US("ReadandWriteIOLatencyDistribution0usTo500us", 404),
        READ_AND_WRITE_IO_LATENCY_DISTRIBUTION_500US_1MS("ReadandWriteIOLatencyDistribution500usTo1ms", 405),
        THE_CUMULATIVE_COUNT_OF_ALL_WRITE_CACHE_HITSHIGH_32_BITS("ThecumulativecountofallwritecachehitsHigh32bits", 1226),
        THE_CUMULATIVE_COUNT_OF_ALL_WRITE_CACHE_HITSLOWER_32_BITS("ThecumulativecountofallwritecachehitsLower32bits", 1227),
        IO_SEQUENTIALITY("IOSequentiality", 1233);

        private int value;
        private String name;

        private HisDataTypeEnum(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public String getDescription() {
            return HisResourceManager.getString(this.toString());
        }

        public String getUnitDesc() {
            return this.getUnitDesc(false);
        }

        public String getUnitDesc(boolean isXVEDevice) {
            String result;
            if (isXVEDevice && (result = HisResourceManager.getString("XVE_" + this.toString() + "_unit")) != null && !"--".equals(result)) {
                return result;
            }
            return HisResourceManager.getString(this.toString() + "_unit");
        }

        public static HisDataTypeEnum valueOf(int intValue) throws IsmException {
            HisDataTypeEnum[] values;
            for (HisDataTypeEnum value : values = HisDataTypeEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("Find unknowm data type: " + intValue));
            return UNKNOWN_DATA_TYPE;
        }

        public static HisDataTypeEnum getHisDataTypeEnum(String item) throws IsmException {
            HisDataTypeEnum[] values;
            for (HisDataTypeEnum value : values = HisDataTypeEnum.values()) {
                if (!value.getName().equals(item)) continue;
                return value;
            }
            LOGGER.error((Object)("Find unknowm Object type: " + item));
            return UNKNOWN_DATA_TYPE;
        }
    }

    public static enum HisObjectTypeEnum implements IObjectTypeEnum
    {
        UNKNOWN_OBJECT_TYPE("UNKNOWN_OBJECT_TYPE", 99999),
        ARRAY("Array", 2),
        CONTROLLER("Controller", 3),
        TARGET_PORT("TargetPort", 6),
        BACK_END_PORT("BackEndPort", 7),
        DISK("Disk", 10),
        LUN("LUN", 11),
        LINK("Link", 13),
        HOST_GROUP("HostGroup", 14),
        RAID("RAID", 15),
        CPU("CPU", 16),
        HOST("Host", 21),
        POWER_SUPPLY("PowerSupply", 23),
        CPU_CORE("CPUCore", 24),
        NODE("Node", 25),
        FAN_CHASSIS("FanChassis", 26),
        SNAPSHOT("Snapshot", 27),
        HYPER_MIRROR("HyperMirror", 28),
        HYPER_COPY("HyperCopy", 29),
        THIN_POOL("ThinPool", 30),
        DEVICE("Device", 31),
        DISKGROUP("DISKGROUP", 20),
        FILE_SYSTEM("FileSystem", 40),
        HOST_ISCSI_PORT("HostIscsiPort", 41),
        SYSTEMRESOURCEPOOL("SYSTEMRESOURCEPOOL", 43),
        CLOUDCOPY("CLOUDCOPY", 44),
        SYSTEM("SYSTEM", 201),
        ENCLOSURE("ENCLOSURE", 206),
        CONTROLLER2("CONTROLLER2", 207),
        FC_PORT("FC_PORT", 212),
        ETH_PORT("ETH_PORT", 213),
        SAS_PORT("SAS_PORT", 214),
        STORAGEPOOL("STORAGEPOOL", 216),
        STORAGETIER("STORAGETIER", 217),
        LUNCOPY("LUNCOPY", 219),
        CONSISTENTGROUP("CONSISTENTGROUP", 221),
        FC_LINK("FC_LINK", 225),
        IOCLASS("IOCLASS", 230),
        MEMORY("MEMORY", 237),
        ISCSI_LINK("iSCSI_LINK", 243),
        MAPPINGVIEW("MAPPINGVIEW", 245),
        FCOE_PORT("FCOE_PORT", 252),
        LUN_GROUP("LUN_GROUP", 256),
        PORT_GROUP("PortGroup", 257),
        NETGROUP("NETGROUP", 259),
        SUBNET("SUBNET", 258),
        DNS_SERVER("DNS_SERVER", 260),
        IP_LINK("IP_LINK", 261),
        USERGROUP("USERGROUP", 262),
        REPLICATIONPAIR("REPLICATIONPAIR", 263),
        LUNBACKGROUDTASK("LUNBACKGROUDTASK", 265),
        DISKPOOL("DISKPOOL", 266),
        STORAGEENGINE("STORAGEENGINE", 267),
        CACHEPARTITION("CACHEPARTITION", 268),
        IOCLASSTEMPLATE("IOCLASSTEMPLATE", 269),
        LUN_DESTROY_DATA("LUNDestroyData", 270),
        DISK_DESTROY_DATA("DiskDestroyData", 271),
        LUN_PRIORITY_STATISTIC("LUN_PRIORITY_STATISTIC", 272),
        SMART_CACHE_PARTITION("SMART_CACHE_PARTITION", 273),
        DISK_SCAN_TASK("DISK_SCAN_TASK", 274),
        LIF("LIF", 279),
        EFC_LINK("eFC_LINK", 303),
        EISCSI_LINK("eISCSI_LINK", 304),
        CONTROLLER_NFSV_3("ControllerNFSV3", 1000),
        CONTROLLER_NFSV_4("ControllerNFSV4", 1001),
        CONTROLLER_SMBV_1("ControllerSMBV1", 1002),
        CONTROLLER_SMBV_2("ControllerSMBV2", 1003),
        SNAS_SYSTEM("SNAS_SYSTEM", 16384),
        SNAS_NODE("SNAS_NODE", 16385),
        PROTOCOL_CLUSTER("PROTOCOL_CLUSTER", 16386),
        PROTOCOL_CLUSTER_NODE("PROTOCOL_CLUSTER_NODE", 16387),
        PROTOCOL_CLUSTER_ZONE("PROTOCOL_CLUSTER_ZONE", 16388),
        SNAS_IP_POOL("SNAS_IP_POOL", 16389),
        SNAS_DNS_CONFIG("SNAS_DNS_CONFIG", 16391),
        SNAS_CLIENT("SNAS_CLIENT", 16390),
        SNAS_LOCAL_USER("SNAS_LOCAL_USER", 16392),
        SNAS_USERANDGROUP("SNAS_USERANDGROUP", 16394),
        SNAS_LOCAL_GROUP("SNAS_LOCAL_GROUP", 16393),
        SNAS_IDMAP_CONFIG("SNAS_IDMAP_CONFIG", 16395),
        SNAS_NODE_FS_SERV("SNAS_NODE_FS_SERV", 16397),
        SNAS_ROOT_USER("SNAS_ROOT_USER", 16396),
        SNAS_NODE_SHARE_SERV("SNAS_NODE_SHARE_SERV", 16398),
        SNAS_FILE("SNAS_FILE", 16400),
        SNAS_CIFS_SERVICE("SNAS_CIFS_SERVICE", 16399),
        SNAS_NFS_SHARE("SNAS_NFS_SHARE", 16401),
        SNAS_CIFS_SHARE("SNAS_CIFS_SHARE", 16402),
        SNAS_USER_QUOTA("SNAS_USER_QUOTA", 16403),
        SNAS_CIFS_SHARE_AUTH_CLIENT("SNAS_CIFS_SHARE_AUTH_CLIENT", 16404),
        SNAS_TASK("SNAS_TASK", 16406),
        DATA_RECOVER_SCHEDULE("DATA_RECOVER_SCHEDULE", 16405),
        SNAS_KEY_VALUE_STORE("SNAS_KEY_VALUE_STORE", 16407),
        SNAS_NFS_SHARE_AUTH_CLIENT("SNAS_NFS_SHARE_AUTH_CLIENT", 16409),
        SNAS_FILE_QUOTA("SNAS_FILE_QUOTA", 16408),
        SNAS_ACL_STRATEGY("SNAS_ACL_STRATEGY", 16410),
        SNAS_LOCAL_AUTH("SNAS_LOCAL_AUTH", 16411),
        SNAS_LDAP_CONFIG("SNAS_LDAP_CONFIG", 16413),
        SNAS_NIS_CONFIG("SNAS_NIS_CONFIG", 16412),
        SNAS_AD_CONFIG("SNAS_AD_CONFIG", 16414),
        SNAS_SYS_WATERLEVEL("SNAS_SYS_WATERLEVEL", 16415),
        SNAS_ALARM_VOICE("SNAS_ALARM_VOICE", 16417),
        SNAS_SYS_ENERGY_SAVING("SNAS_SYS_ENERGY_SAVING", 16416),
        SNAS_SECURITY_POLICY("SNAS_SECURITY_POLICY", 16418),
        SNAS_HEARTBEAT("SNAS_HEARTBEAT", 16419),
        SNAS_HANDSHAKE("SNAS_HANDSHAKE", 16420),
        SNAS_MGR_NODE("SNAS_MGR_NODE", 16421),
        SNAS_NODE_PERFORMANCE("SNAS_NODE_PERFORMANCE", 16422),
        SNAS_SECURITY_SMTP("SNAS_SECURITY_SMTP", 16423),
        IB_PORT("IB_PORT", 16500),
        BOND_PORT("BOND_PORT", 235),
        NOFS("NOFS", 53248),
        NFSSERVICE("NFSSERVICE", 16452),
        CIFSSERVICE("CIFSSERVICE", 16453),
        FTP_SHARE_AUTH_CLIENT("FTP_SHARE_AUTH_CLIENT", 16454),
        CONTROLLER_NFSV_41("ControllerNFSV41", 57636),
        ZONE_RAID("ZoneRAID", 57791),
        REMOTE_DEVICE("RemoteDevice", 224),
        DISK_LOG_VERIFY("disklogverify", 57637),
        BLOCK_STORAGE_PERFORMANCE_INDICATORS("BlockStoragePerformanceIndicators", 57867);

        private int sortValue = -1;
        private int value;
        private String name;

        private HisObjectTypeEnum(String name, int value) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return HisResourceManager.getString(this.getName());
        }

        public static HisObjectTypeEnum valueOf(int intValue) throws IsmException {
            HisObjectTypeEnum[] values;
            for (HisObjectTypeEnum value : values = HisObjectTypeEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("Find unknowm Object type: " + intValue));
            return UNKNOWN_OBJECT_TYPE;
        }

        public static HisObjectTypeEnum getHisObjectTypeEnum(String item) throws IsmException {
            HisObjectTypeEnum[] values;
            for (HisObjectTypeEnum value : values = HisObjectTypeEnum.values()) {
                if (!value.getName().equals(item)) continue;
                return value;
            }
            LOGGER.error((Object)("Find unknowm Object type: " + item));
            return UNKNOWN_OBJECT_TYPE;
        }

        private void setSortValue(int sortValue) {
            this.sortValue = sortValue;
        }

        public int getSortValue() {
            return this.sortValue;
        }

        static {
            int sortValue = 1;
            ARRAY.setSortValue(sortValue++);
            CONTROLLER.setSortValue(sortValue++);
            CONTROLLER2.setSortValue(sortValue++);
            LINK.setSortValue(sortValue++);
            TARGET_PORT.setSortValue(sortValue++);
            BACK_END_PORT.setSortValue(sortValue++);
            DISK.setSortValue(sortValue++);
            NODE.setSortValue(sortValue++);
            CPU.setSortValue(sortValue++);
            CPU_CORE.setSortValue(sortValue++);
            POWER_SUPPLY.setSortValue(sortValue++);
            FAN_CHASSIS.setSortValue(sortValue++);
            FC_PORT.setSortValue(sortValue++);
            ETH_PORT.setSortValue(sortValue++);
            sortValue = 256;
            RAID.setSortValue(sortValue++);
            STORAGEPOOL.setSortValue(sortValue++);
            STORAGETIER.setSortValue(sortValue++);
            THIN_POOL.setSortValue(sortValue++);
            DEVICE.setSortValue(sortValue++);
            LUN.setSortValue(sortValue++);
            SNAPSHOT.setSortValue(sortValue++);
            HYPER_COPY.setSortValue(sortValue++);
            LUNCOPY.setSortValue(sortValue++);
            HYPER_MIRROR.setSortValue(sortValue++);
            SYSTEMRESOURCEPOOL.setSortValue(sortValue++);
            sortValue = 65536;
            HOST_GROUP.setSortValue(sortValue++);
            HOST.setSortValue(sortValue++);
            IOCLASS.setSortValue(sortValue++);
            MAPPINGVIEW.setSortValue(sortValue++);
            FC_LINK.setSortValue(sortValue++);
            ISCSI_LINK.setSortValue(sortValue++);
        }
    }
}

