/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity;

import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;

public class HisType {
    private static final Logger LOGGER = Logger.getLogger(HisType.class);
    public static final String DEFAULT_STR_VALUE = "--";
    public static final int TYPE_UNKNOW = Integer.MIN_VALUE;
    private static HisType instance = new HisType();

    public static HisType getInstance() {
        return instance;
    }

    public static String getString(String key) {
        try {
            return HisResourceManager.getString(key);
        }
        catch (MissingResourceException e) {
            LOGGER.warn((Object)("can't find Type description of " + key));
            return DEFAULT_STR_VALUE;
        }
    }

    public static enum RaidType {
        RAID_0(3),
        RAID_10(1),
        RAID_5(2),
        RAID_3(7),
        RAID_1(4),
        RAID_50(6),
        RAID_6(5),
        UNKNOWN(-1);

        private static final long serialVersionUID = 8013781040702510103L;
        private int raidTypeValue;

        private RaidType(int value) {
            this.raidTypeValue = value;
        }

        public static RaidType getRaidGroupType(int type) {
            for (RaidType raidType : RaidType.values()) {
                if (raidType.raidTypeValue != type) continue;
                return raidType;
            }
            LOGGER.error((Object)("wrong Raid Type value:" + type));
            return UNKNOWN;
        }

        public int getValue() {
            return this.raidTypeValue;
        }

        public static String getDescription(RaidType type) {
            if (type.equals((Object)RAID_0)) {
                return Type.getString((String)"raid_0");
            }
            if (type.equals((Object)RAID_1)) {
                return Type.getString((String)"raid_1");
            }
            if (type.equals((Object)RAID_10)) {
                return Type.getString((String)"raid_10");
            }
            if (type.equals((Object)RAID_5)) {
                return Type.getString((String)"raid_5");
            }
            if (type.equals((Object)RAID_50)) {
                return Type.getString((String)"raid_50");
            }
            if (type.equals((Object)RAID_6)) {
                return Type.getString((String)"raid_6");
            }
            if (type.equals((Object)RAID_3)) {
                return Type.getString((String)"raid_3");
            }
            if (type.equals((Object)UNKNOWN)) {
                return Type.getString((String)HisType.DEFAULT_STR_VALUE);
            }
            throw new IllegalArgumentException("wrong Raid Type value:" + (Object)((Object)type));
        }
    }

    public static enum PrefetchPolicyType {
        NO_PREFETCH(0),
        FIXUP_PREFETCH(1),
        UNCERTAIN_PREFETCH(2),
        APTITUDE_PREFETCH(3);

        private static final long serialVersionUID = 8013102340702587303L;
        private int prefetchPolicyTypeValue;

        private PrefetchPolicyType(int value) {
            this.prefetchPolicyTypeValue = value;
        }

        public static PrefetchPolicyType getPrefetchType(int type) {
            for (PrefetchPolicyType prefetchPolicyType : PrefetchPolicyType.values()) {
                if (prefetchPolicyType.prefetchPolicyTypeValue != type) continue;
                return prefetchPolicyType;
            }
            throw new IllegalArgumentException("wrong PrefetchPolicy Type value:" + type);
        }

        public int getValue() {
            return this.prefetchPolicyTypeValue;
        }

        public static String getDescription(PrefetchPolicyType policy) {
            if (policy.equals((Object)APTITUDE_PREFETCH)) {
                return Type.getString((String)"aptitude_prefetch");
            }
            if (policy.equals((Object)FIXUP_PREFETCH)) {
                return Type.getString((String)"fixup_prefetch");
            }
            if (policy.equals((Object)NO_PREFETCH)) {
                return Type.getString((String)"no_prefetch");
            }
            if (policy.equals((Object)UNCERTAIN_PREFETCH)) {
                return Type.getString((String)"unchertain_prefetch");
            }
            throw new IllegalArgumentException("wrong PrefetchPolicyType  value:" + (Object)((Object)policy));
        }

        public String toString() {
            return PrefetchPolicyType.getDescription(this);
        }
    }

    public static enum FanRunLevel {
        LOWEST(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454101029959547L;
        private int fanRunLevelValue;

        private FanRunLevel(int value) {
            this.fanRunLevelValue = value;
        }

        public int getValue() {
            return this.fanRunLevelValue;
        }

        public static FanRunLevel getFanRunLevel(int type) {
            for (FanRunLevel fanRunLevel : FanRunLevel.values()) {
                if (fanRunLevel.getValue() != type) continue;
                return fanRunLevel;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find FanRunLevel which value = " + type));
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString((String)("FanRunLevel_" + this.name()));
            return des;
        }
    }

    public static enum PowerType {
        DCNM(0),
        ACNM(1),
        ACM(2),
        DCM(3),
        UNKNOW(-1);

        private static final long serialVersionUID = 8013781040412587303L;
        private int powerTypeValue;

        private PowerType(int value) {
            this.powerTypeValue = value;
        }

        public static PowerType getPowerType(int type) {
            for (PowerType powerType : PowerType.values()) {
                if (powerType.powerTypeValue != type) continue;
                return powerType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find PowerType which value = " + type));
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString((String)("PowerType_" + this.name()));
            return des;
        }
    }

    public static class PortType
    implements Serializable {
        public static final int PORTTYPE_EXPANDERPORT_VALUE = 2;
        public static final int PORTTYPE_MANAGEMENTPORT_VALUE = 3;
        public static final int PORTTYPE_SERIALPORT_VALUE = 4;
        public static final int PORTTYPE_IBCPORT_VALUE = 5;
        public static final int PORTTYPE_UPS_SERIAL_VALUE = 6;
        private static final long serialVersionUID = 7770470958947831750L;
    }

    public static class PortCardType
    implements Serializable {
        public static final PortCardType PORTCARD_FC_4X4G = new PortCardType("PORTCARD_FC_4X4G", 1);
        public static final PortCardType PORTCARD_FC_2X4G = new PortCardType("PORTCARD_FC_2X4G", 2);
        public static final PortCardType PORTCARD_GE_RJ45_2X = new PortCardType("PORTCARD_GE_RJ45_2X", 3);
        public static final PortCardType PORTCARD_SASI_4X = new PortCardType("PORTCARD_SASI_4X", 4);
        public static final PortCardType PORTCARD_FC_4X4G_EXPAND = new PortCardType("PORTCARD_FC_4X4G_EXPAND", 5);
        public static final PortCardType PORTCARD_ISCSI_2X10GE = new PortCardType("PORTCARD_ISCSI_2X10GE", 6);
        public static final PortCardType PORTCARD_FC_1X8G = new PortCardType("PORTCARD_FC_1X8G", 7);
        public static final PortCardType PORTCARD_FC_2X8G = new PortCardType("PORTCARD_FC_2X8G", 8);
        public static final PortCardType PORTCARD_SASII_2X = new PortCardType("PORTCARD_SASII_2X", 9);
        public static final PortCardType PORTCARD_SASII_4X = new PortCardType("PORTCARD_SASII_4X", 10);
        public static final PortCardType PORTCARD_COMBO_2FCX2GE = new PortCardType("PORTCARD_Combo_2FCx2GE", 11);
        public static final PortCardType PORTCARD_ISCSI_4X = new PortCardType("PORTCARD_iSCSI_4X", 12);
        public static final PortCardType PORTCARD_FC_4X8G = new PortCardType("PORTCARD_FC_4X8G", 13);
        public static final PortCardType PORTCARD_COMBO_2X8GFCX2GE = new PortCardType("PORTCARD_Combo_2X8GFCx2GE", 14);
        public static final PortCardType PORTCARD_MINISAS_4X = new PortCardType("PORTCARD_MINISAS_4X", 16);
        public static final PortCardType PORTCARD_ISCSI_4XGE = new PortCardType("PORTCARD_ISCSI_4XGE", 20);
        public static final PortCardType PORTCARD_FCOE_4X = new PortCardType("PORTCARD_FCoE_4X", 21);
        public static final PortCardType PORTCARD_SASA_2X6G = new PortCardType("PORTCARD_SASA_2X6G", 22);
        public static final PortCardType PORTCARD_SASB_2X6G = new PortCardType("PORTCARD_SASB_2X6G", 23);
        public static final PortCardType PORTCARD_TOE_4X = new PortCardType("PORTCARD_TOE_4X", 24);
        public static final PortCardType PORTCARD_SWITCH_8XGE = new PortCardType("PORTCARD_SWITCH_8XGE", 25);
        public static final PortCardType PORTCARD_IB_2X = new PortCardType("PORTCARD_IB_2X", 15);
        private static final long serialVersionUID = 8013781040702587303L;
        private static Collection<PortCardType> cache = new ArrayList<PortCardType>(0);
        private int portCardTypeValue;
        private String portCardTypeName;
        private String description;

        public PortCardType(String name, int value) {
            this.portCardTypeName = name;
            this.portCardTypeValue = value;
        }

        public PortCardType(String name, int value, String des) {
            this.portCardTypeName = name;
            this.portCardTypeValue = value;
            this.description = des;
        }

        public static PortCardType getPortCardType(int type) {
            for (PortCardType portCardType : cache) {
                if (portCardType.getValue() != type) continue;
                return portCardType;
            }
            throw new IllegalArgumentException("wrong PortCardType Type value:" + type);
        }

        public void addNewPortCardType(PortCardType type) {
            cache.add(type);
        }

        public int getValue() {
            return this.portCardTypeValue;
        }

        public String getName() {
            return this.portCardTypeName;
        }

        public boolean isFcTypePortcard() {
            switch (this.getValue()) {
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 14: 
                case 21: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSasTypePortcard() {
            switch (this.getValue()) {
                case 4: 
                case 9: 
                case 10: 
                case 22: 
                case 23: {
                    return true;
                }
            }
            return false;
        }

        public boolean isIscsiTypePortcard() {
            boolean flag1 = this == PORTCARD_GE_RJ45_2X || this == PORTCARD_ISCSI_4X || this == PORTCARD_COMBO_2FCX2GE;
            boolean flag2 = this == PORTCARD_COMBO_2X8GFCX2GE || this == PORTCARD_ISCSI_2X10GE || this == PORTCARD_ISCSI_4XGE;
            return flag1 || flag2;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = Type.getString((String)this.getName());
            }
            return this.description;
        }

        static {
            cache.add(PORTCARD_FC_4X4G);
            cache.add(PORTCARD_FC_2X4G);
            cache.add(PORTCARD_GE_RJ45_2X);
            cache.add(PORTCARD_SASI_4X);
            cache.add(PORTCARD_FC_4X4G_EXPAND);
            cache.add(PORTCARD_ISCSI_2X10GE);
            cache.add(PORTCARD_FC_1X8G);
            cache.add(PORTCARD_FC_2X8G);
            cache.add(PORTCARD_SASII_2X);
            cache.add(PORTCARD_SASII_4X);
            cache.add(PORTCARD_COMBO_2FCX2GE);
            cache.add(PORTCARD_COMBO_2X8GFCX2GE);
            cache.add(PORTCARD_ISCSI_4X);
            cache.add(PORTCARD_MINISAS_4X);
            cache.add(PORTCARD_FC_4X8G);
            cache.add(PORTCARD_ISCSI_4XGE);
            cache.add(PORTCARD_FCOE_4X);
            cache.add(PORTCARD_SASA_2X6G);
            cache.add(PORTCARD_SASB_2X6G);
            cache.add(PORTCARD_TOE_4X);
            cache.add(PORTCARD_IB_2X);
            cache.add(PORTCARD_SWITCH_8XGE);
        }
    }

    public static enum ChassisModel {
        BMC_4U(0),
        SAS_2U_12_CONTROLLER(1),
        SAS_2U_24_CONTROLLER(2),
        SAS_2U_25_CONTROLLER(3),
        SAS_2U_12_EXPANDER(16),
        SAS_2U_24_EXPANDER(17),
        SAS_4U_24_EXPANDER(18),
        FC_4U_24_EXPANDER(19),
        SAS_2U_25_EXPANDER(20),
        INVALID(-1);

        private static final long serialVersionUID = -3412352826959959547L;
        private int chassisModelValue;

        private ChassisModel(int value) {
            this.chassisModelValue = value;
        }

        public static ChassisModel getChassisModel(int value) {
            for (ChassisModel chassisModel : ChassisModel.values()) {
                if (chassisModel.chassisModelValue != value) continue;
                return chassisModel;
            }
            throw new IllegalArgumentException("wrong ChassisModel type argument:" + value);
        }

        public String getDescription() {
            String des = Type.getString((String)("ChassisModel_" + this.name()));
            return des;
        }

        public int getValue() {
            return this.chassisModelValue;
        }
    }

    public static enum PhysicalChassisType {
        MIX(3),
        SAS(0),
        FC(1),
        ISCSI(2),
        SAT(4),
        INVALID(-1);

        private static final long serialVersionUID = -3412352826959959547L;
        private int physicalChassisTypeValue;

        private PhysicalChassisType(int value) {
            this.physicalChassisTypeValue = value;
        }

        public static PhysicalChassisType getPhysicalChassisType(int value) {
            for (PhysicalChassisType physicalChassisType : PhysicalChassisType.values()) {
                if (physicalChassisType.physicalChassisTypeValue != value) continue;
                return physicalChassisType;
            }
            return INVALID;
        }

        public String getDescription() {
            String des = Type.getString((String)("ChassisType_" + this.name()));
            return des;
        }
    }

    public static enum OperationSystemType {
        LINUX,
        WINDOWS2003,
        SOLARIS,
        HP_UX,
        AIX,
        XEN_SERVER,
        MAC_OS,
        VMWARE_ESX,
        UN_KNOWN;

        private static final int TYPE_LINUX = 0;
        private static final int TYPE_WINDOWS2003 = 1;
        private static final int TYPE_SOLARIS = 2;
        private static final int TYPE_HP_UX = 3;
        private static final int TYPE_AIX = 4;
        private static final int TYPE_XEN_SERVER = 5;
        private static final int TYPE_MAC_OS = 6;
        private static final int TYPE_VMWARE_ESX = 7;
        private static final int UNKNOWN = -1;
        private static final long serialVersionUID = -3424454826959910320L;

        public static OperationSystemType getOperationSystem(int type) {
            OperationSystemType osType = null;
            switch (type) {
                case 1: {
                    osType = WINDOWS2003;
                    break;
                }
                case 0: {
                    osType = LINUX;
                    break;
                }
                case 2: {
                    osType = SOLARIS;
                    break;
                }
                case 3: {
                    osType = HP_UX;
                    break;
                }
                case 4: {
                    osType = AIX;
                    break;
                }
                case 5: {
                    osType = XEN_SERVER;
                    break;
                }
                case 6: {
                    osType = MAC_OS;
                    break;
                }
                case 7: {
                    osType = VMWARE_ESX;
                    break;
                }
                case -1: {
                    osType = UN_KNOWN;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong OperationSystem Type value:" + type);
                }
            }
            return osType;
        }

        public static int getValue(OperationSystemType type) {
            if (type.equals((Object)LINUX)) {
                return 0;
            }
            if (type.equals((Object)WINDOWS2003)) {
                return 1;
            }
            if (type.equals((Object)SOLARIS)) {
                return 2;
            }
            if (type.equals((Object)HP_UX)) {
                return 3;
            }
            if (type.equals((Object)AIX)) {
                return 4;
            }
            if (type.equals((Object)XEN_SERVER)) {
                return 5;
            }
            if (type.equals((Object)MAC_OS)) {
                return 6;
            }
            if (type.equals((Object)VMWARE_ESX)) {
                return 7;
            }
            if (type.equals((Object)UN_KNOWN)) {
                return -1;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + (Object)((Object)type));
        }

        public static String getDescription(OperationSystemType type) {
            if (type.equals((Object)LINUX)) {
                return Type.getString((String)"linux");
            }
            if (type.equals((Object)WINDOWS2003)) {
                return Type.getString((String)"windows2003");
            }
            if (type.equals((Object)SOLARIS)) {
                return Type.getString((String)"solaris");
            }
            if (type.equals((Object)HP_UX)) {
                return Type.getString((String)"hp_ux");
            }
            if (type.equals((Object)AIX)) {
                return Type.getString((String)"aix");
            }
            if (type.equals((Object)XEN_SERVER)) {
                return Type.getString((String)"XenServer");
            }
            if (type.equals((Object)MAC_OS)) {
                return Type.getString((String)"Mac_os");
            }
            if (type.equals((Object)VMWARE_ESX)) {
                return Type.getString((String)"Vmware_ESX");
            }
            if (type.equals((Object)UN_KNOWN)) {
                return HisType.DEFAULT_STR_VALUE;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + (Object)((Object)type));
        }

        public static OperationSystemType getOperationSystemType(String type) {
            if (type.equalsIgnoreCase("Linux")) {
                return LINUX;
            }
            if (type.equalsIgnoreCase("Windows")) {
                return WINDOWS2003;
            }
            if (type.equalsIgnoreCase("Solaris")) {
                return SOLARIS;
            }
            if (type.equalsIgnoreCase("HP-UX")) {
                return HP_UX;
            }
            if (type.equalsIgnoreCase("AIX")) {
                return AIX;
            }
            if (type.equalsIgnoreCase("XenServer")) {
                return XEN_SERVER;
            }
            if (type.equalsIgnoreCase("Mac OS X")) {
                return MAC_OS;
            }
            if (type.equalsIgnoreCase("Vmware ESX")) {
                return VMWARE_ESX;
            }
            if (type.equalsIgnoreCase("Unknown")) {
                return UN_KNOWN;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + type);
        }
    }

    public static class LogicalChassisType {
        public static final int CONTROLLERCHASSIS = 1;
        public static final int HARDDRIVECHASSIS = 0;
        public static final int PCIECHASSIS = 2;
        public static final int NASCHASSIS = 11;
        public static final int FILECHASSIS = 12;

        public static String getDescription(String value) {
            return Type.getString((String)("LogicalChassisType_" + value));
        }

        public static String getDescription(int value) {
            return Type.getString((String)("LogicalChassisType_" + value));
        }
    }

    public static enum FCModeType {
        UNKNOW(-1),
        TGT(0),
        INI(1),
        COM(2);

        private static final long serialVersionUID = -3424454826912301547L;
        private int fcModeTypeValue;

        private FCModeType(int value) {
            this.fcModeTypeValue = value;
        }

        public static FCModeType getFCModeType(int type) {
            for (FCModeType fcModeType : FCModeType.values()) {
                if (fcModeType.fcModeTypeValue != type) continue;
                return fcModeType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find fcModeType which value = " + type));
            return UNKNOW;
        }

        public int getValue() {
            return this.fcModeTypeValue;
        }

        public String getDescription() {
            String des = Type.getString((String)("FCModeType_" + this.name()));
            return des;
        }
    }

    public static enum FCPortType {
        UNKNOW("UNKNOW", -1),
        FABRIC("Fabric", 1),
        PUBLIC_LOOP("PublicLoop", 2),
        POINTTO_POINT("PointtoPoint", 3),
        AUTO("Auto", 4);

        private static final long serialVersionUID = -3424454826912301547L;
        private int fcPortTypeValue;
        private String fcPortType;

        private FCPortType(String fcPortType, int value) {
            this.fcPortTypeValue = value;
            this.fcPortType = fcPortType;
        }

        public String getFcPortType() {
            return this.fcPortType;
        }

        public static FCPortType getFCPortType(int type) {
            for (FCPortType fcPortType : FCPortType.values()) {
                if (fcPortType.fcPortTypeValue != type) continue;
                return fcPortType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find FCPortType which value = " + type));
            return UNKNOW;
        }

        public int getValue() {
            return this.fcPortTypeValue;
        }

        public String getDescription() {
            String des = Type.getString((String)("FCPortType_" + this.getFcPortType()));
            return des;
        }
    }

    public static enum ExpanderPortType {
        FC(1),
        SAS(0),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454826912301547L;
        private int expanderPortTypeValue;

        private ExpanderPortType(int value) {
            this.expanderPortTypeValue = value;
        }

        public static ExpanderPortType getExpanderPortType(int type) {
            if (ExpanderBoardType.FC.expanderBoardTypeValue == type) {
                return SAS;
            }
            if (ExpanderBoardType.SAS.expanderBoardTypeValue == type) {
                return FC;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find ExpanderPortType which value = " + type));
            return UNKNOW;
        }

        public static ExpanderPortType getExpanderPortTypeAfterNex(int type) {
            for (ExpanderPortType expanderPortType : ExpanderPortType.values()) {
                if (expanderPortType.expanderPortTypeValue != type) continue;
                return expanderPortType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find ExpanderPortType which value = " + type));
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString((String)("ExpanderPortType_" + this.name()));
            return des;
        }
    }

    public static enum PortLogicType {
        SERVICE("SERVICE", 1L),
        IBC("IBC", 2L),
        IBS("IBS", 3L),
        EXPANDER("EXPANDER", 4L),
        MANAGEMENT("Management", 5L),
        UPS_MANAGER("UPSManager", 6L),
        IPMI("IPMI", 7L),
        MAINTAIN_NET("MaintainNet", 8L),
        MANAGE_SERVICE("ManageService", 9L),
        MAINTAIN_SERVICE_NET("MaintainServiceNet", 10L),
        ETHETH_SWITCH("ETHSwitch", 11L),
        UNKNOW("UNKNOW", -1L);

        private static final long serialVersionUID = -3424454826912301547L;
        private long portLogicTypeValue;
        private String portLogicType;

        private PortLogicType(String portLogicType, long value) {
            this.portLogicTypeValue = value;
            this.portLogicType = portLogicType;
        }

        public String getPortLogicType() {
            return this.portLogicType;
        }

        public static PortLogicType getPortLogicType(long type) {
            for (PortLogicType expanderPortType : PortLogicType.values()) {
                if (expanderPortType.portLogicTypeValue != type) continue;
                return expanderPortType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find PortLogicType which value = " + type));
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString((String)("Port.Logic.Type." + this.getPortLogicType()));
            return des;
        }

        public long getValue() {
            return this.portLogicTypeValue;
        }
    }

    public static enum PortWorkModeType {
        UNKNOW(-1),
        INI(1),
        TARGET(2),
        BOTH(3);

        private int portWorkModeTypeValue = 0;

        private PortWorkModeType(int value) {
            this.portWorkModeTypeValue = value;
        }

        public static PortWorkModeType getPortWorkModeType(int value) {
            for (PortWorkModeType type : PortWorkModeType.values()) {
                if (type.portWorkModeTypeValue != value) continue;
                return type;
            }
            LOGGER.error((Object)("can not find the PortWorkModeType: value :" + value));
            return UNKNOW;
        }

        public String toString() {
            return Type.getString((String)("Type.PortWorkModeType." + this.name()));
        }

        public int getValue() {
            return this.portWorkModeTypeValue;
        }
    }

    public static enum PortPhyicalType {
        SAS(0L),
        FC(1L),
        NIC(2L),
        PCIE(3L),
        BOND(5L),
        COM(6L),
        USB(7L),
        IB(11L),
        FCOE(8L),
        UNKNOW(-1L);

        private static final long serialVersionUID = -3424454878969959547L;
        private long portPhyicalTypeValue;

        private PortPhyicalType(long value) {
            this.portPhyicalTypeValue = value;
        }

        public static PortPhyicalType getPortType(long type) {
            for (PortPhyicalType portPhyicalType : PortPhyicalType.values()) {
                if (portPhyicalType.portPhyicalTypeValue != type) continue;
                return portPhyicalType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find PortPhyicalType which value = " + type));
            return UNKNOW;
        }

        public long getValue() {
            return this.portPhyicalTypeValue;
        }

        public String getDescription() {
            String des = Type.getString((String)("Port.Phyical.Type." + this.name()));
            return des;
        }
    }

    public static enum BoardType {
        UNKNOW("UNKNOW", -1),
        CONTROLLER("Controller", 1),
        EXPANDER_MODULE("ExpanderModule", 2),
        PORT_MODULE("PortModule", 3),
        MANAGE_MODULE("ManageModule", 4);

        private long boardTypeValue;
        private String type;

        private BoardType(String type, int value) {
            this.boardTypeValue = value;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static BoardType getBoardType(long value) {
            for (BoardType type : BoardType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            LOGGER.error((Object)("BoardType.getBoardType: Can not find the BoardType: value :" + value));
            return UNKNOW;
        }

        public long getValue() {
            return this.boardTypeValue;
        }

        public String toString() {
            String packageName = "Type.BoardType.";
            return HisResourceManager.getString(packageName + this.getType());
        }
    }

    public static enum ExpanderBoardType {
        SAS(0),
        FC(1),
        ISCSI(2),
        COMBO(3),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454878969959547L;
        private int expanderBoardTypeValue;

        private ExpanderBoardType(int value) {
            this.expanderBoardTypeValue = value;
        }

        public static ExpanderBoardType getExpansionBoardType(int type) {
            for (ExpanderBoardType expanderBoardType : ExpanderBoardType.values()) {
                if (expanderBoardType.expanderBoardTypeValue != type) continue;
                return expanderBoardType;
            }
            LOGGER.warn((Object)("return UNKNOW because can't find ExpanderBoardType which value = " + type));
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString((String)("ExpanderBoardType_" + this.name()));
            return des;
        }

        public String toString() {
            String des = Type.getString((String)("ExpanderBoardPhyiscalType_" + this.name()));
            return des;
        }
    }

    public static enum DiskPhysicalType {
        DISK_FC(0),
        DISK_SAS(1),
        DISK_SATA(2),
        DISK_SSD(3),
        DISK_NLSAS(4),
        DISK_UNKNOW(-1);

        private static final long serialVersionUID = -3424454826959951237L;
        private int diskPhysicalTypeValue;

        private DiskPhysicalType(int value) {
            this.diskPhysicalTypeValue = value;
        }

        public static DiskPhysicalType getPhysicalType(int type) {
            for (DiskPhysicalType diskPhysicalType : DiskPhysicalType.values()) {
                if (diskPhysicalType.diskPhysicalTypeValue != type) continue;
                return diskPhysicalType;
            }
            LOGGER.warn((Object)("return DISK_UNKNOW because can't find DiskPhysicalType which value = " + type));
            return DISK_UNKNOW;
        }

        public String getDiskTypeDescription() {
            if (this.equals((Object)DISK_NLSAS) || this.equals((Object)DISK_SATA)) {
                return Type.getString((String)"DiskPhysicalType_DISK_SATA_OR_NLSAS");
            }
            return Type.getString((String)("DiskPhysicalType_" + this.name()));
        }

        public String getDescription() {
            String des = Type.getString((String)("DiskPhysicalType_" + this.name()));
            return des;
        }

        public int getValue() {
            return this.diskPhysicalTypeValue;
        }
    }

    public static enum DiskLogicalType {
        FREE("Free", 1),
        RAID_MEMBER("RaidMember", 2),
        SPARE("Spare", 3),
        SSDC("Ssdc", 4),
        UNKNOW("UNKNOW", Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int diskLogicalTypeValue;
        private String name;

        private DiskLogicalType(String name, int value) {
            this.diskLogicalTypeValue = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DiskLogicalType getDiskLogicalType(int type) {
            for (DiskLogicalType diskLogicalType : DiskLogicalType.values()) {
                if (diskLogicalType.diskLogicalTypeValue != type) continue;
                return diskLogicalType;
            }
            throw new IllegalArgumentException("wrong DiskLogicalType value:" + type);
        }

        public int getValue() {
            return this.diskLogicalTypeValue;
        }

        public String getDescription() {
            String des = Type.getString((String)("DiskLogicalType_" + this.getName()));
            return des;
        }
    }
}

