/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity;

import com.huawei.ism.common.entity.HisType;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SubType4
extends HisType {
    private static final Logger LOGGER = Logger.getLogger(SubType4.class);

    public static enum LunMigrationLunType {
        SRCLUN(1),
        DSTLUN(2),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private LunMigrationLunType(int value) {
            this.value = value;
        }

        public static LunMigrationLunType valueOf(int intValue) {
            LunMigrationLunType[] values;
            for (LunMigrationLunType value : values = LunMigrationLunType.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("wrong Lun Migration.LunMigrationLunType value:" + intValue));
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LunMigrationState {
        MOVING(1),
        QUEUE(2),
        COMPLETE(3),
        FAULT(4),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private LunMigrationState(int value) {
            this.value = value;
        }

        public static LunMigrationState valueOf(int intValue) {
            LunMigrationState[] values;
            for (LunMigrationState value : values = LunMigrationState.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("wrong Lun Migration LunMigrationState value:" + intValue));
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String packageName = "LUNMIGRATION.STATE.";
            return HisResourceManager.getString(packageName + this.name());
        }
    }

    public static enum SpeedLevelEnum {
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        EXTREME(4),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private SpeedLevelEnum(int value) {
            this.value = value;
        }

        public static SpeedLevelEnum valueOf(int intValue) {
            SpeedLevelEnum[] values;
            for (SpeedLevelEnum value : values = SpeedLevelEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("wrong Lun Migration.SpeedLevel value:" + intValue));
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String packageName = "CSSType.SpeedLevel.";
            return HisResourceManager.getString(packageName + this.name());
        }
    }

    public static enum CloudCopyRoleType {
        SOURCE_LUN(1),
        OTHER_LUN(2),
        UNKNOW(Integer.MIN_VALUE);

        private int cloudCopyRoleValue;

        private CloudCopyRoleType(int value) {
            this.cloudCopyRoleValue = value;
        }

        public static CloudCopyRoleType getCloudCopyRoleType(int type) {
            CloudCopyRoleType ccrt = UNKNOW;
            for (CloudCopyRoleType cloudCopyRoleType : CloudCopyRoleType.values()) {
                ccrt = CloudCopyRoleType.getCloudCopyRoleType1(type, ccrt, cloudCopyRoleType);
            }
            LOGGER.error((Object)("wrong CloudCopyRoleType value:" + type));
            return ccrt;
        }

        private static CloudCopyRoleType getCloudCopyRoleType1(int type, CloudCopyRoleType ccrt, CloudCopyRoleType cloudCopyRoleType) {
            if (cloudCopyRoleType.cloudCopyRoleValue == type) {
                ccrt = cloudCopyRoleType;
            }
            return ccrt;
        }

        public int getValue() {
            return this.cloudCopyRoleValue;
        }

        public String getDescription() {
            if (1 == this.cloudCopyRoleValue) {
                return Type.getString((String)"CLOUDCOPY_SOURCE_LUN");
            }
            if (2 == this.cloudCopyRoleValue) {
                return Type.getString((String)"CLOUDCOPY_OTHER_LUN");
            }
            return "--";
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum CloudCopySyncType {
        MANUAL(1),
        TIMED(2),
        UNKNOW(Integer.MIN_VALUE);

        private int cloudCopyValue;

        private CloudCopySyncType(int value) {
            this.cloudCopyValue = value;
        }

        public static CloudCopySyncType valueOf(int intValue) throws IsmException {
            CloudCopySyncType[] values;
            for (CloudCopySyncType value : values = CloudCopySyncType.values()) {
                if (value.cloudCopyValue != intValue) continue;
                return value;
            }
            LOGGER.error((Object)("wrong CloudCopySyncType value:" + intValue));
            return UNKNOW;
        }

        public int getValue() {
            return this.cloudCopyValue;
        }

        public String toString() {
            String packageName = "CLOUDCOPY_";
            return HisResourceManager.getString(packageName + this.name());
        }
    }

    public static enum HostGroupMappingMode {
        INITIATOR_MODE("InitiatorMode", 200),
        FC_PORT_MODE("FcPortMode", 100),
        UNKNOWN("Unknown", -1);

        private int hostGroupValue;
        private String name;

        private HostGroupMappingMode(String name, int value) {
            this.hostGroupValue = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static HostGroupMappingMode getType(int value) {
            for (HostGroupMappingMode enumValue : HostGroupMappingMode.values()) {
                if (enumValue.hostGroupValue != value) continue;
                return enumValue;
            }
            return UNKNOWN;
        }

        public int getValue() {
            return this.hostGroupValue;
        }

        public String toString() {
            return HisResourceManager.getString(this.getName().toUpperCase(Locale.ENGLISH));
        }

        public String getDescription() {
            String des = Type.getString((String)("HostGroupMappingType_" + this.getName()));
            return des;
        }
    }

    public static enum MultiPathLinkStatus {
        NORMAL(0),
        DEGRADE(1),
        UNKNOWN(-1);

        private long multiValue;

        private MultiPathLinkStatus(int value) {
            this.multiValue = value;
        }

        public static MultiPathLinkStatus getMultiPathLinkStatus(long value) {
            for (MultiPathLinkStatus linkStatus : MultiPathLinkStatus.values()) {
                if (linkStatus.multiValue != value) continue;
                return linkStatus;
            }
            return UNKNOWN;
        }

        public long getValue() {
            return this.multiValue;
        }

        public String toString() {
            String packageName = "MULTIPATH_LINK_STATUS_";
            return HisResourceManager.getString(packageName + this.name());
        }
    }

    public static enum DateInfo {
        YEAR(0),
        MONTH(1),
        DAY(2),
        UNKNOWN(-1);

        private int dateInfoValue;

        private DateInfo(int value) {
            this.dateInfoValue = value;
        }

        public static DateInfo getPortMode(int value) {
            for (DateInfo enumValue : DateInfo.values()) {
                if (enumValue.dateInfoValue != value) continue;
                return enumValue;
            }
            return UNKNOWN;
        }

        public int getValue() {
            return this.dateInfoValue;
        }

        public String toString() {
            return HisResourceManager.getString(this.name().toUpperCase(Locale.ENGLISH));
        }
    }

    public static enum MappedObjectType {
        HOST(1),
        HOST_GROUP(2),
        UN_KNOWN(-1);

        private int mappedValue;

        private MappedObjectType(int value) {
            this.mappedValue = value;
        }

        public static MappedObjectType getMappedObjectType(int value) {
            for (MappedObjectType ipType : MappedObjectType.values()) {
                if (ipType.mappedValue != value) continue;
                return ipType;
            }
            return UN_KNOWN;
        }

        public int getValue() {
            return this.mappedValue;
        }
    }

    public static enum IPType {
        IPV4("IPv4"),
        IPV6("IPv6"),
        UN_KNOWN("Unknown");

        private String ipTypeValue;

        private IPType(String value) {
            this.ipTypeValue = value;
        }

        public static IPType getIPType(String value) {
            for (IPType ipType : IPType.values()) {
                if (!ipType.ipTypeValue.equals(value)) continue;
                return ipType;
            }
            return UN_KNOWN;
        }

        public String getValue() {
            return this.ipTypeValue;
        }
    }

    public static enum PortConfigMode {
        MANUAL_SEMIDUPLEX("Manual_Semiduplex", 1),
        MANUAL_FULL_DUPLEX("Manual_FullDuplex", 2),
        SELF_ARRANGE("Self_Arrange", 3),
        UNKNOWN("Unknown", -1);

        private long portValue;
        private String name;

        private PortConfigMode(String name, int value) {
            this.portValue = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PortConfigMode getPortMode(long value) {
            for (PortConfigMode portMode : PortConfigMode.values()) {
                if (portMode.portValue != value) continue;
                return portMode;
            }
            return UNKNOWN;
        }

        public long getValue() {
            return this.portValue;
        }

        public String toString() {
            String packageName = "ISCSI_PORT_CONFIG_MODE_";
            return HisResourceManager.getString(packageName + this.getName());
        }
    }

    public static enum PortRunningMode {
        SEMIDUPLEX("Semiduplex", 1),
        FULL_DUPLEX("FullDuplex", 2),
        ROUND_ROBIN("Round_Robin", 3),
        ACTIVE_BACKUP("Active_Backup", 4),
        XOR("XOR", 5),
        BROADCAST("Broadcast", 6),
        DOT_3_AD("Dot3ad", 7),
        TLB("TLB", 8),
        ALB("ALB", 9),
        UNKNOWN("Unknown", -1);

        private long portValue;
        private String name;

        private PortRunningMode(String name, int value) {
            this.portValue = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PortRunningMode getPortMode(long value) {
            for (PortRunningMode portMode : PortRunningMode.values()) {
                if (portMode.portValue != value) continue;
                return portMode;
            }
            return UNKNOWN;
        }

        public long getValue() {
            return this.portValue;
        }

        public String toString() {
            String packageName = "ISCSI_PORT_CONFIG_MODE_Manual_";
            return HisResourceManager.getString(packageName + this.getName());
        }
    }

    public static enum ConsistentGroupType {
        HYPER_C_LONE_CG("HyperCLoneCG", 1),
        HYPER_MIRROR_CG("HyperMirrorCG", 0),
        UNKNOWN("Unknown", -1);

        private int consistentValue;
        private String name;

        private ConsistentGroupType(String name, int value) {
            this.consistentValue = value;
        }

        public String getName() {
            return this.name;
        }

        public static ConsistentGroupType getType(int value) {
            for (ConsistentGroupType enumValue : ConsistentGroupType.values()) {
                if (enumValue.consistentValue != value) continue;
                return enumValue;
            }
            return UNKNOWN;
        }

        public int getValue() {
            return this.consistentValue;
        }

        public String toString() {
            return HisResourceManager.getString(this.getName().toUpperCase(Locale.ENGLISH));
        }
    }

    public static class HyperCloneEnums {

        public static enum ResumePolicy {
            AUTO(1),
            MANUAL(2),
            UNKNOW(-1);

            private int resumePolicyValue;

            private ResumePolicy(int value) {
                this.resumePolicyValue = value;
            }

            public static ResumePolicy valueOf(int intValue) throws IsmException {
                ResumePolicy[] values;
                for (ResumePolicy value : values = ResumePolicy.values()) {
                    if (value.resumePolicyValue != intValue) continue;
                    return value;
                }
                LOGGER.error((Object)("wrong HyperCloneEnums.ResumePolicy value:" + intValue));
                return UNKNOW;
            }

            public int getValue() {
                return this.resumePolicyValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.ResumePolicy.";
                return HisResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SpeedLevel {
            LOW(1),
            MEDIUM(2),
            HIGH(3),
            EXTREME(4),
            UNKNOW(-1);

            private int speedLevelValue;

            private SpeedLevel(int value) {
                this.speedLevelValue = value;
            }

            public static SpeedLevel valueOf(int intValue) throws IsmException {
                SpeedLevel[] values;
                for (SpeedLevel value : values = SpeedLevel.values()) {
                    if (value.speedLevelValue != intValue) continue;
                    return value;
                }
                LOGGER.error((Object)("wrong HyperCloneEnums.SpeedLevel value:" + intValue));
                return UNKNOW;
            }

            public int getValue() {
                return this.speedLevelValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.SpeedLevel.";
                return HisResourceManager.getString(packageName + this.name());
            }
        }

        public static enum DataStatus {
            TARGET_INCONSISTENT(1),
            SOURCE_INCONSISTENT(2),
            SYNC_TARGET_LUN(3),
            SYNC_SOURCE_LUN(4),
            CONSISTENT(5),
            SYNCHRONIZED(6),
            FAULT(7),
            UNKNOW(-1);

            private int dataStatusValue;

            private DataStatus(int value) {
                this.dataStatusValue = value;
            }

            public static DataStatus valueOf(int intValue) throws IsmException {
                DataStatus[] values;
                for (DataStatus value : values = DataStatus.values()) {
                    if (value.dataStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error((Object)("wrong HyperCloneEnums.DataStatus value:" + intValue));
                return UNKNOW;
            }

            public int getValue() {
                return this.dataStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.DataStatus.";
                return HisResourceManager.getString(packageName + this.name());
            }
        }

        public static enum PairStatus {
            SPLIT(1),
            SYNC_TARGET_LUN(2),
            SYNC_SOURCE_LUN(3),
            NORMAL(4),
            QUEUE(5),
            INTERRUPTED(6),
            WAIT_RECOVER(7),
            FAULT(8),
            UNKNOW(-1);

            private int pairStatusValue;

            private PairStatus(int value) {
                this.pairStatusValue = value;
            }

            public static PairStatus valueOf(int intValue) throws IsmException {
                PairStatus[] values;
                for (PairStatus value : values = PairStatus.values()) {
                    if (value.pairStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error((Object)("wrong HyperCloneEnums.PairStatus value:" + intValue));
                return UNKNOW;
            }

            public int getValue() {
                return this.pairStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.PairStatus.";
                return HisResourceManager.getString(packageName + this.name());
            }
        }
    }

    public static interface BasicTypeInterface {
        public boolean isLegalType(int var1);
    }
}

