/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HisResourceManager {
    private static final Logger log = LoggerFactory.getLogger(HisResourceManager.class);
    public static final ReadWriteLock RESOURCE_LOCK = new ReentrantReadWriteLock();
    public static final ClassLoader LOADER = HisResourceManager.class.getClassLoader();
    public static final ImageIcon DEFAULT_ICON;
    private static Properties iniProperties;
    private static Locale locale;
    private static Map<String, ImageIcon> images;
    private static List<String> registerImagePaths;
    private static List<Locale> languages;
    private static Map<Locale, HashMap<String, String>> txtPool;

    private HisResourceManager() {
    }

    public static synchronized void registerPropertyFile(String textFilePath, ClassLoader classLoader) {
        if (Utils.isNullStr((String)textFilePath)) {
            throw new IllegalArgumentException("Text file path is empty and is illegal. Cannot register.");
        }
        ResourceBundle bundle = null;
        for (Locale localeValue : languages) {
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(textFilePath, localeValue);
            }
            catch (Exception e) {
                continue;
            }
            HashMap<Object, Object> txtMap = null;
            if (!txtPool.containsKey(localeValue)) {
                txtMap = new HashMap(0);
                txtPool.put(localeValue, txtMap);
            } else {
                txtMap = txtPool.get(localeValue);
            }
            for (String key : bundle.keySet()) {
                txtMap.put(key, bundle.getString(key));
            }
        }
    }

    public static synchronized void registerImages(String imageFilePath) {
        log.info("register image file, productType={}, imageFilePath={}", (Object)imageFilePath, (Object)imageFilePath);
        if (Utils.isNullStr((String)imageFilePath)) {
            throw new IllegalArgumentException("Image file path is empty and is illegal. Cannot register.");
        }
        if (registerImagePaths.contains(imageFilePath)) {
            return;
        }
        registerImagePaths.add(imageFilePath);
    }

    public static String getString(String key, String defaultStr) {
        String value = HisResourceManager.getString(key);
        if (Utils.isNullStr((String)value) || value.equals("--")) {
            return defaultStr;
        }
        return value;
    }

    public static String getString(String key, String defaultStr, Locale localeValue) {
        String value = HisResourceManager.getString(key, localeValue);
        if (Utils.isNullStr((String)value) || value.equals("--")) {
            return defaultStr;
        }
        return value;
    }

    public static String getString(String key) {
        Locale localeValue = HisResourceManager.getLocale();
        return HisResourceManager.getString(key, localeValue);
    }

    public static String getString(String key, Locale localeValue) {
        HashMap<String, String> hashMap = txtPool.get(localeValue);
        if (null == hashMap) {
            return "--";
        }
        String value = hashMap.get(key);
        if (null == value) {
            value = "--";
        }
        return value;
    }

    public static String getStringWithColon(String key) {
        String uiKey = HisResourceManager.getString(key);
        if (!"--".equalsIgnoreCase(uiKey) && !uiKey.endsWith(":")) {
            uiKey = uiKey + ":";
        }
        return uiKey;
    }

    public static String getStringWithColon(String key, Locale localeValue) {
        String uiKey = HisResourceManager.getString(key, localeValue);
        if (!"--".equalsIgnoreCase(uiKey) && !uiKey.endsWith(":")) {
            uiKey = uiKey + ":";
        }
        return uiKey;
    }

    public static String getStringByDeviceType(String key, String deviceType) {
        String value = HisResourceManager.getString(key + '.' + deviceType);
        if (Utils.isNullStr((String)value) || value.equals("--")) {
            value = HisResourceManager.getString(key);
        }
        return value;
    }

    public static String getStringWithParams(String key, Object ... params) {
        String value = HisResourceManager.getString(key);
        if (null == params || params.length == 0) {
            return value;
        }
        return MessageFormat.format(value, params);
    }

    public static String getOEMString(String key) {
        return HisResourceManager.getOEMString(key, Locale.getDefault());
    }

    public static String getOEMString(String key, Locale localeValue) {
        String vender = FrameworkCommon.getInstance().getStrProperty("VENDER", "");
        if (vender.length() <= 0) {
            vender = "Huawei";
        }
        return ResourceBundle.getBundle(vender + ".key", localeValue).getString(key);
    }

    public static ImageIcon getOEMImage(String key) {
        String vender = FrameworkCommon.getInstance().getStrProperty("VENDER", "");
        if (vender.length() <= 0) {
            vender = "Huawei";
        }
        return HisResourceManager.getImage(key, vender);
    }

    public static synchronized ImageIcon getImage(String key) {
        String imagePath;
        ImageIcon imageIcon = HisResourceManager.getImage(key, null);
        if (DEFAULT_ICON != imageIcon) {
            return imageIcon;
        }
        Iterator<String> iterator = registerImagePaths.iterator();
        while (iterator.hasNext() && DEFAULT_ICON == (imageIcon = HisResourceManager.getImage(key, imagePath = iterator.next()))) {
        }
        if (DEFAULT_ICON == imageIcon) {
            log.info("getImage(): key = [{}];value=null,will return none.png image.", (Object)key);
        }
        return imageIcon;
    }

    private static ImageIcon getImage(String key, String imagePath) {
        if (null == key) {
            return DEFAULT_ICON;
        }
        ImageIcon imageIcon = images.get(key);
        if (null != imageIcon && imageIcon.getIconHeight() != -1 && imageIcon.getIconWidth() != -1) {
            return imageIcon;
        }
        imageIcon = null;
        URL imageURL = null;
        try {
            String imgPath = null == imagePath ? key : imagePath + '/' + key;
            imageURL = LOADER.getResource(imgPath);
            if (imageURL != null) {
                imageIcon = new ImageIcon(imageURL);
            }
        }
        catch (Exception e) {
            log.error("load image file error,imageURL={}", imageURL, (Object)e);
        }
        if (null == imageIcon) {
            return DEFAULT_ICON;
        }
        images.put(key, imageIcon);
        return imageIcon;
    }

    public static synchronized Locale getLocale() {
        if (locale == null) {
            locale = Utils.getOSLocaleDefaultEn();
            return locale;
        }
        return locale;
    }

    public static synchronized void setLocale(Locale localeValue) {
        locale = localeValue;
    }

    public static int getResourceSize() {
        int size = 0;
        Iterator<Map.Entry<Locale, HashMap<String, String>>> iterator = txtPool.entrySet().iterator();
        Map.Entry<Locale, HashMap<String, String>> entry = null;
        HashMap<String, String> map = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            map = entry.getValue();
            size += map.size();
        }
        return size;
    }

    public static synchronized Properties getCfgProperties() {
        if (iniProperties == null) {
            iniProperties = new Properties();
            String path = "config/framework/configuration/hisconfiguration.properties";
            InputStream inStream = LOADER.getResourceAsStream(path);
            try {
                iniProperties.load(inStream);
            }
            catch (IOException e) {
                log.error("Get CfgProperties error.");
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error("close stream failed .", (Throwable)e);
                }
            }
        }
        return iniProperties;
    }

    public static void init() {
        String commonFile = "config.framework.resource.languages.historyperstat_common";
        String imgFile = "config/framework/resource/images";
        String errInfoFile = "config.resource.languages.historyperstat_errorInfo";
        String femaFile = "config.framework.resource.languages.historyperstat_FMEA";
        String interfaceFile = "config.framework.resource.languages.historyperstat_interface";
        String tipFile = "config.framework.resource.languages.historyperstat_prompt";
        String newImgFile = "config/framework/resource/newImgs";
        try {
            languages = CustomResourceManager.getInstance().getLanguages();
        }
        catch (Exception ex) {
            languages = new ArrayList<Locale>(0);
            log.error("Initializing text resources.", (Throwable)ex);
        }
        try {
            HisResourceManager.registerPropertyFile(commonFile, LOADER);
            HisResourceManager.registerPropertyFile(errInfoFile, LOADER);
            HisResourceManager.registerPropertyFile(femaFile, LOADER);
            HisResourceManager.registerPropertyFile(interfaceFile, LOADER);
            HisResourceManager.registerPropertyFile(tipFile, LOADER);
        }
        catch (Exception ex) {
            log.error("Register resource:{}", (Object)commonFile, (Object)ex);
        }
        try {
            HisResourceManager.registerImages(imgFile);
            HisResourceManager.registerImages(newImgFile);
        }
        catch (Exception ex) {
            log.error("Initialize image resources.", (Throwable)ex);
        }
    }

    static {
        iniProperties = null;
        locale = null;
        images = new HashMap<String, ImageIcon>(0);
        registerImagePaths = new ArrayList<String>();
        txtPool = new HashMap<Locale, HashMap<String, String>>(0);
        URL path = LOADER == null ? null : LOADER.getResource("config/resource/none.png");
        DEFAULT_ICON = path != null ? new ImageIcon(path) : new ImageIcon("config/resource/none.png");
    }
}

