/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.connection.IConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseConnection
implements IConnection {
    protected static final int DEFAULT_TIME_OUT = 30;
    private List<IConnection.StateChangeListener> stateChangeListeners = new ArrayList<IConnection.StateChangeListener>(0);

    public abstract Record pmGet(int var1, String var2) throws IsmException;

    public abstract Record invoke(long var1, List<Param> var3) throws IsmException;

    public abstract int pmCount(int var1, List<Param> var2) throws IsmException;

    public abstract List<Record> pmAssociate(int var1, int var2, String var3) throws IsmException;

    public abstract List<Record> getBatch(long var1, List<Param> var3) throws IsmException;

    public abstract List<Record> getBatch(long var1, List<Param> var3, boolean var4) throws IsmException;

    public abstract List<Record> bacthNext(long var1, List<Param> var3, TLVTag var4) throws IsmException;

    public abstract List<Record> pmGetBacthNext(int var1, List<Param> var2) throws IsmException;

    public abstract List<Record> pmGetBacthNextNew(int var1, List<Param> var2, int var3) throws IsmException;

    public abstract int getPort();

    public abstract int getProtocalType();

    public abstract String getSessionKey();

    public abstract Socket getSocket() throws IsmException;

    public abstract void releaseSocket(Socket var1) throws IsmException;

    public abstract void downloadFile(long var1, List<Param> var3, String var4);

    public void addStateChangeListener(IConnection.StateChangeListener listener) {
        if (!this.stateChangeListeners.contains(listener)) {
            this.stateChangeListeners.add(listener);
        }
    }

    public void removeStateChangeListener(IConnection.StateChangeListener listener) {
        if (this.stateChangeListeners.contains(listener)) {
            this.stateChangeListeners.remove(listener);
        }
    }

    protected void notifyStateChanged(IConnection.ConnectionState state) {
        for (IConnection.StateChangeListener listener : this.stateChangeListeners) {
            listener.stateChanged(state);
        }
    }

    public abstract void refreshClient() throws IsmException;
}

