/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ConcurrentConnector {
    private static final Logger LOGGER = Logger.getLogger(ConcurrentConnector.class);

    private static SocketChannel buildConnNoBlock(Selector s, List<String> addrs, int port) throws IOException {
        for (String addr : addrs) {
            SocketChannel c = null;
            try {
                c = SocketChannel.open();
                c.configureBlocking(false);
                if (c.connect(new InetSocketAddress(addr, port))) {
                    SocketChannel socketChannel = c;
                    return socketChannel;
                }
                c.register(s, 8, addr + ":" + port);
            }
            catch (IOException e) {
                LOGGER.warn((Object)e);
                throw e;
            }
            finally {
                if (null == c) continue;
                c.close();
            }
        }
        return null;
    }

    private static void close(SelectableChannel sc) {
        try {
            sc.close();
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
    }

    private static void closeSelector(Selector s, SocketChannel except) {
        if (null == s) {
            return;
        }
        for (SelectionKey k : s.keys()) {
            if (k.channel() == except) continue;
            ConcurrentConnector.close(k.channel());
        }
        try {
            s.close();
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
        try {
            if (null != except) {
                except.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
    }

    private static SocketChannel finishConnect(Selector s) {
        for (SelectionKey k : s.selectedKeys()) {
            SocketChannel sc = (SocketChannel)k.channel();
            k.cancel();
            try {
                if (!sc.isConnectionPending()) continue;
                sc.finishConnect();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("succeed connect to IP" + sc.socket().getRemoteSocketAddress()));
                }
                return sc;
            }
            catch (IOException e) {
                LOGGER.warn((Object)((String)k.attachment()), (Throwable)e);
                ConcurrentConnector.close(sc);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Socket connect(List<String> addrs, int port, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

