/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.common.SupportDevcieEnum;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.BaseConnection;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.RESTUtil;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.xve.monitor.eservice.PermanentConnectionMannage;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HisRESTConnection
extends BaseConnection {
    private static final Logger log = LoggerFactory.getLogger(HisRESTConnection.class);
    private static final String SCHEME_HTTPS = "https";
    private static final int REST_PORT = 8088;
    private String ip = null;
    private int port;
    private String baseUrl;
    private RestConnection conn;

    public HisRESTConnection(DeviceInfo di, boolean usePermanent) throws IsmException {
        this.ip = di.getIp();
        this.port = 8088;
        this.baseUrl = "/deviceManager/rest/" + di.getDeviceID();
        try {
            this.conn = usePermanent ? PermanentConnectionMannage.getInstance().getRestConnection(di.getDevNode()) : RestConnectionManager.getRestConnectionThrowLoginError((DevNode)di.getDevNode());
        }
        catch (ToolException e) {
            log.error("Search rest is falied ", (Throwable)e);
            try {
                throw new IsmException(!"".equals(e.getErrorId()) ? Long.valueOf(e.getErrorId()) : 1073949185L, (Object)e, e.getMessage());
            }
            catch (NumberFormatException e1) {
                throw new IsmException(1073949185L, (Object)e, e.getMessage());
            }
        }
        if (this.conn == null) {
            throw new IsmException(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
    }

    public IConnection.ConnectionState getConnectionState() {
        if (this.conn == null) {
            return IConnection.ConnectionState.Disconnected;
        }
        return IConnection.ConnectionState.Connected;
    }

    public void close() {
        this.conn.closeSession();
    }

    @Override
    public Record pmGet(int moType, String moId) throws IsmException {
        String mm = "/";
        if (moId != null && !"".equals(moId)) {
            mm = "/" + moId;
        }
        String url = this.baseUrl + MOType.getRESTPath((int)moType) + mm;
        JSONObject result = this.get(url);
        Record rec = null;
        try {
            JSONObject jsonObj = result.getJSONObject("data");
            rec = RESTUtil.jsonToRecord(moType, jsonObj);
        }
        catch (JSONException e) {
            log.error("Failed to parse json, moType: {}, json result: {}", (Object)moType, (Object)result);
        }
        return rec;
    }

    @Override
    public Record invoke(long cmdWord, List<Param> params) throws IsmException {
        String url = this.baseUrl + RESTUtil.getMOUrl(cmdWord);
        String method = RESTUtil.getMethod(cmdWord);
        if ("GET".equals(method)) {
            JSONObject result = this.get(url = url + RESTUtil.convertParamToUrl(cmdWord, params));
            List<Record> results = RESTUtil.jsonToRecordList(cmdWord, result);
            if (!VerifyUtil.isEmpty(results)) {
                return results.get(0);
            }
        } else if ("PUT".equals(method)) {
            this.put(cmdWord, url, params);
        } else if ("DELETE".equals(method)) {
            url = url + RESTUtil.convertParamToUrl(cmdWord, params);
            this.delete(url);
        } else if ("POST".equals(method)) {
            this.post(cmdWord, url, params);
        } else {
            log.error("Not support cmd :{}, please check the tlvAndRestMapping*.xml", (Object)cmdWord);
        }
        return null;
    }

    @Override
    public int pmCount(int moType, List<Param> tlvParams) throws IsmException {
        String url = this.baseUrl + MOType.getRESTPath((int)moType) + "/count";
        int count = 0;
        JSONObject result = this.get(url);
        if (VerifyUtil.isEmpty(result)) {
            return count;
        }
        try {
            count = result.getJSONObject("data").getInt("COUNT");
        }
        catch (JSONException e) {
            log.error("Failed to parse json, moType: {}", (Object)moType, (Object)e);
        }
        return count;
    }

    @Override
    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID) throws IsmException {
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl).append(MOType.getRESTPath((int)srcMOType)).append("/associate").append("?").append("TYPE").append("=").append(srcMOType).append("&").append("ASSOCIATEOBJTYPE").append("=").append(associateMOType).append("&").append("ASSOCIATEOBJID").append("=").append(associateMOID);
        JSONObject result = this.get(url.toString());
        return RESTUtil.jsonToRecordList(srcMOType, result);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> params) throws IsmException {
        return this.getBatch(cmdWord, params, true);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> params, boolean printLog) throws IsmException {
        String url = this.baseUrl + RESTUtil.getMOUrl(cmdWord);
        if (!VerifyUtil.isEmpty(params)) {
            url = url + RESTUtil.convertParamToUrl(cmdWord, params);
        }
        JSONObject result = this.get(url, printLog);
        return RESTUtil.jsonToRecordList(cmdWord, result);
    }

    @Override
    public List<Record> bacthNext(long cmdWord, List<Param> tlvParams, TLVTag endTag) throws IsmException {
        return this.getBatch(cmdWord, tlvParams);
    }

    @Override
    public List<Record> pmGetBacthNext(int moType, List<Param> params) throws IsmException {
        ArrayList<Record> resultList = new ArrayList<Record>();
        String url = this.getUrl(moType, params);
        int start = 0;
        do {
            start = this.execQuery(moType, resultList, url, start);
        } while (resultList.size() == start);
        return resultList;
    }

    @Override
    public List<Record> pmGetBacthNextNew(int moType, List<Param> params, int count) throws IsmException {
        String getUrl;
        JSONObject result;
        ArrayList<Record> resultList = new ArrayList<Record>();
        String url = this.getUrl(moType, params);
        List<Record> pageResult = null;
        for (int start = 0; resultList.size() < count && start < count && (pageResult = RESTUtil.jsonToRecordList(moType, result = this.get(getUrl = RESTUtil.getPageUrl(url, start, Math.min(start + 200, count))))) != null && !pageResult.isEmpty(); start += 200) {
            resultList.addAll(pageResult);
        }
        return resultList;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getProtocalType() {
        return 0;
    }

    @Override
    public String getSessionKey() {
        return null;
    }

    @Override
    public Socket getSocket() throws IsmException {
        return null;
    }

    @Override
    public void releaseSocket(Socket x) throws IsmException {
    }

    @Override
    public void downloadFile(long cmdWord, List<Param> params, String localPath) {
    }

    public void getSystemInfo(DeviceInfo di) {
        String url = this.baseUrl + "/system/?t=" + System.currentTimeMillis();
        JSONObject jsonObject = this.get(url);
        try {
            String productVersion = jsonObject.getJSONObject("data").getString("PRODUCTVERSION");
            String devName = jsonObject.getJSONObject("data").getString("NAME");
            String patchVersion = jsonObject.getJSONObject("data").getString("patchVersion");
            int devTypeEnum = jsonObject.getJSONObject("data").getInt("PRODUCTMODE");
            String devType = SupportDevcieEnum.getTypeNameById(devTypeEnum);
            String version = productVersion + patchVersion;
            log.info("SystemInfo->version:{},devType:{},tpyeEnum:{}", new Object[]{version, devType, devTypeEnum});
            if (di != null) {
                di.setDeviceVersion(DeviceVersion.getDeviceVersion(version, devType));
                di.setDeviceName("(" + di.getIp() + ")" + devName);
                di.setdType(devType);
                di.setdVersion(version);
            }
        }
        catch (JSONException e) {
            log.error("getSysteminfo by rest failed.rest:{}", (Object)url);
            throw new IsmException("getSystemInfo by rest failed.", (Throwable)e);
        }
    }

    private void authenticate() throws IsmException {
        try {
            this.conn.login();
        }
        catch (ToolException e) {
            log.error("Rest Login failed:", (Throwable)e);
            throw new IsmException("Rest Login failed!", (Throwable)e);
        }
    }

    private String getUrl(int moType, List<Param> params) {
        return this.baseUrl + MOType.getRESTPath((int)moType) + RESTUtil.convertParamToUrl(moType, params);
    }

    private int execQuery(int moType, List<Record> resultList, String url, int start) {
        String getUrl = RESTUtil.getPageUrl(url, start, start + 200);
        JSONObject result = this.get(getUrl);
        List<Record> pageResult = RESTUtil.jsonToRecordList(moType, result);
        resultList.addAll(pageResult);
        return start + 200;
    }

    private JSONObject get(String url) {
        JSONObject jsonObj = this.get(url, true);
        return jsonObj;
    }

    private JSONObject get(String url, boolean printLog) {
        String completeURL = this.getBaseUrl() + url;
        try {
            if (!this.conn.isLogin()) {
                this.conn.login();
            }
            ResponseInfo rest = null;
            rest = printLog ? this.conn.execGet(completeURL, "") : this.conn.execGetWithNoLog(completeURL, "");
            String restultEntity = rest.getContent();
            log.info("REST command get response length: {}", (Object)restultEntity.length());
            try {
                JSONObject jsonObj = new JSONObject(restultEntity);
                this.processJsonResult(url, jsonObj);
                return jsonObj;
            }
            catch (JSONException e) {
                log.warn("response {} is not a valid json string!", (Object)restultEntity, (Object)e);
                return null;
            }
        }
        catch (Exception e) {
            log.error("Failed to execute REST command get, url: {}", (Object)url, (Object)e);
            throw new IsmException(1073949185L, (Object)e, e.getMessage());
        }
    }

    private void put(long cmdWord, String url, List<Param> params) {
        String completeURL = this.getBaseUrl() + url;
        try {
            if (!this.conn.isLogin()) {
                this.conn.login();
            }
            String sev = RESTUtil.convertParamToJson(cmdWord, params);
            ResponseInfo rest = this.conn.execPut(completeURL, sev);
            String restultEntity = rest.getContent();
            log.info("REST command put response: {}", (Object)restultEntity);
            if (restultEntity == null) {
                log.warn("REST response is null, url: {}", (Object)url);
                throw new IsmException(201508001L);
            }
            try {
                JSONObject jsonObj = new JSONObject(restultEntity);
                this.processJsonResult(url, jsonObj);
            }
            catch (JSONException e) {
                log.warn("response {} is not a valid json string!", (Object)restultEntity, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("Failed to execute REST command put, url: {}", (Object)url, (Object)e);
            throw new IsmException(1073949185L, (Object)e, e.getMessage());
        }
    }

    private void processJsonResult(String url, JSONObject jsonObj) throws JSONException {
        int errorCode = jsonObj.getJSONObject("error").getInt("code");
        if (errorCode == -404 || errorCode == -500) {
            log.error("REST request failed, url: {}", (Object)url);
            throw new IsmException(201508001L);
        }
        if (errorCode == -401) {
            log.error("REST request not authenticate, url: {}", (Object)url);
            log.info("try authenticate again now....");
            this.authenticate();
            throw new IsmException(1077951501L);
        }
        if (!RESTUtil.isResponseSuccess(jsonObj)) {
            log.error("Response is: {}", (Object)jsonObj);
            throw new IsmException((long)errorCode);
        }
    }

    private void post(long cmdWord, String url, List<Param> params) {
        String completeURL = this.getBaseUrl() + url;
        try {
            if (!this.conn.isLogin()) {
                this.conn.login();
            }
            String sev = RESTUtil.convertParamToJson(cmdWord, params);
            ResponseInfo rest = this.conn.execPost(completeURL, sev);
            String restultEntity = rest.getContent();
            log.info("REST command put response: {}", (Object)restultEntity);
            if (restultEntity == null) {
                log.warn("REST response is null, url: {}", (Object)url);
                throw new IsmException(201508001L);
            }
            try {
                JSONObject jsonObj = new JSONObject(restultEntity);
                this.processJsonResult(url, jsonObj);
            }
            catch (JSONException e) {
                log.warn("response {} is not a valid json string!", (Object)restultEntity, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("Failed to execute REST command put, url: {}", (Object)url, (Object)e);
            throw new IsmException(1073949185L, (Object)e, e.getMessage());
        }
    }

    private JSONObject delete(String url) {
        String completeURL = this.getBaseUrl() + url;
        try {
            if (!this.conn.isLogin()) {
                this.conn.login();
            }
            ResponseInfo rest = this.conn.execDelete(completeURL, "");
            String restultEntity = rest.getContent();
            log.info("REST command get response: {}", (Object)restultEntity);
            try {
                JSONObject jsonObj = new JSONObject(restultEntity);
                this.processJsonResult(url, jsonObj);
                return jsonObj;
            }
            catch (JSONException e) {
                log.warn("response {} is not a valid json string!", (Object)restultEntity, (Object)e);
                return null;
            }
        }
        catch (Exception e) {
            log.error("Failed to execute REST command get, url: {}", (Object)url, (Object)e);
            throw new IsmException(1073949185L, (Object)e, e.getMessage());
        }
    }

    @Override
    public void refreshClient() throws IsmException {
        String url = this.baseUrl + "/refreshClient";
        this.get(url);
    }

    public String getDeviceID() {
        return null;
    }

    public void setDeviceID(String deviceID) {
    }

    public String getURL() {
        return null;
    }

    public boolean init(Properties properties) {
        return false;
    }

    public RestConnection getConn() {
        return this.conn;
    }

    private String getBaseUrl() {
        return "https://" + RestUtil.processIPByURL((String)this.ip) + ":" + 8088;
    }
}

