/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.util.ByteUtil;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.Utils;
import com.huawei.ism.util.VerifyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class HisTLVConnectionImpl
extends HisTLVConnection {
    private static final Logger LOGGER = Logger.getLogger(HisTLVConnectionImpl.class);
    public static final int MSG_HEAD_LENGTH = 28;
    private final AtomicInteger serial = new AtomicInteger();
    private String ip = null;
    private String userName = null;
    private String pwd = null;
    private int userScope = 0;
    private String sessionKey = null;
    private String userID = null;
    private String deviceID = null;
    private boolean isUserOff = false;
    private int port;
    private int protocolType;

    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getProtocalType() {
        return this.protocolType;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
        if (deviceID != null && this.ip != null) {
            ConnectionManager.getInstance().addDeviceIP(deviceID, this.ip);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.pwd;
    }

    public boolean init(Properties properties) {
        boolean checkParam;
        this.userName = properties.getProperty("USER_NAME");
        this.pwd = properties.getProperty("USER_WORD");
        try {
            this.userScope = Integer.parseInt(properties.getProperty("USERSCOPE"));
            this.ip = properties.getProperty("IP_OR_NAME");
            this.port = Integer.valueOf(properties.getProperty("PORT"));
            this.protocolType = 1;
            if (properties.getProperty("CONN_PROTOCOL") != null) {
                this.protocolType = Integer.valueOf(properties.getProperty("CONN_PROTOCOL"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"init fail", (Throwable)e);
        }
        boolean bl = checkParam = Utils.isNullStr((String)this.ip) || this.port < 0 || this.protocolType < 0;
        if (checkParam) {
            throw new IllegalArgumentException();
        }
        return true;
    }

    public void setUserInfo(String user, String ps, int scope) {
        this.userName = user;
        this.pwd = ps;
        this.userScope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User authenticate(String localIP) throws IsmException {
        Socket socket;
        if (null == localIP) {
            localIP = NetUtil.queryLocalIP((String)this.ip, (int)this.port);
        }
        if ((socket = this.getSocket()) == null) {
            LOGGER.error((Object)"socket is null.");
            return null;
        }
        try {
            User user = this.authenticateByLocalIP(socket, localIP);
            return user;
        }
        finally {
            this.releaseSocket(socket);
        }
    }

    @Override
    public User authenticate() throws IsmException {
        String localIP = NetUtil.queryLocalIP((String)this.ip, (int)this.port);
        return this.authenticate(localIP);
    }

    private DataPackage makeAuthenticateData(String localIP) {
        String loginPassword = this.pwd;
        List list = TLVUtils.paramList((Param[])new Param[]{new Param(TLV.USER.NAME.getParamIndex(), TLV.USER.NAME.getParamType(), this.userName), new Param(TLV.USER.PASSWORD.getParamIndex(), TLV.USER.PASSWORD.getParamType(), loginPassword), new Param(TLV.USER.ADDRESSINFO.getParamIndex(), TLV.USER.ADDRESSINFO.getParamType(), localIP), new Param(TLV.USER.SCOPE.getParamIndex(), TLV.USER.SCOPE.getParamType(), (IsmInteger)new UnsignedInt32(this.userScope))});
        DataPackage sendData = TLVUtils.param2DP((long)55847813121L, (String)"0", (List)list);
        return sendData;
    }

    @Override
    public User authenticateByTlvInfo(String sessionKey, int level, String id, int userState, long pwdChangeTime) {
        User returnUser = new User(this.userName);
        returnUser.setPassword(this.pwd);
        returnUser.setUserScope(User.USER_SCOPE.valueOf((int)this.userScope));
        returnUser.setSessionKey(sessionKey);
        returnUser.setLevel(User.Level.valueOf((int)level));
        returnUser.setID(id);
        this.setSessionKey(sessionKey);
        this.userID = returnUser.getID();
        returnUser.setStatus(User.Status.valueOf((int)userState));
        returnUser.setPwdChangeTime(pwdChangeTime);
        this.isUserOff = false;
        return returnUser;
    }

    protected User authenticateByLocalIP(Socket socket, String localIP) {
        DataPackage sendData = this.makeAuthenticateData(localIP);
        DataPackage returnData = this.sendAndReceive(socket, sendData, 30);
        List datas = returnData.getRecordset();
        if (null == datas || datas.isEmpty()) {
            throw new IsmException(16797698L);
        }
        Record record = (Record)datas.get(0);
        User returnUser = new User(this.userName);
        returnUser.setPassword(this.pwd);
        returnUser.setUserScope(User.USER_SCOPE.valueOf((int)this.userScope));
        returnUser.setSessionKey("" + ((IsmInteger)record.getParamValue(TLV.USER.SESSIONKEY.getParamIndex())).intValue());
        IsmInteger paramIntValue = record.getParamIntValue(TLV.USER.LEVEL.getParamIndex());
        if (paramIntValue == null) {
            LOGGER.error((Object)"paramIntValue is null.");
            return null;
        }
        returnUser.setLevel(User.Level.valueOf((int)paramIntValue.intValue()));
        returnUser.setID(record.getParamStrValue(TLV.USER.ID.getParamIndex()));
        this.setSessionKey(returnUser.getSessionKey());
        this.userID = returnUser.getID();
        int userState = record.getParamIntValue(TLV.USER.ACCOUNTSTATE.getParamIndex(), (IsmInteger)new SignedInt32(User.Status.Online.getValue())).intValue();
        returnUser.setStatus(User.Status.valueOf((int)userState));
        returnUser.setPwdChangeTime(record.getParamIntValue(TLV.USER.PWDCHANGETIME.getParamIndex(), (IsmInteger)new UnsignedInt32(0)).longValue());
        this.isUserOff = false;
        return returnUser;
    }

    @Override
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void close() {
        this.logout();
    }

    public void logout() {
        if (this.sessionKey == null) {
            return;
        }
        try {
            IConnection.ConnectionState connectionState;
            if (null != this.deviceID && IConnection.ConnectionState.Disconnected == (connectionState = this.getConnectionState())) {
                return;
            }
            Param userIDParam = new Param(TLV.USER.ID.getParamIndex(), TLV.USER.ID.getParamType(), this.userID);
            DataPackage sendData = TLVUtils.param2DP((long)55847813122L, (String)this.sessionKey, Arrays.asList(userIDParam));
            this.sendAndReceive(sendData, 30);
        }
        catch (Exception e1) {
            LOGGER.error((Object)(this.userName + " logout fail on " + this.getURL()), (Throwable)e1);
        }
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams) throws IsmException {
        this.sendCMD(cmdWord, tlvParams, 30);
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        this.invoke(cmdWord, tlvParams, timeout);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams) throws IsmException {
        return this.invoke(cmdWord, tlvParams, 30);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        List<Record> datas = this.getBatch(cmdWord, tlvParams, timeout);
        return datas.isEmpty() ? null : datas.get(0);
    }

    @Override
    public Record invoke(Socket socket, long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP((long)cmdWord, (String)this.sessionKey, tlvParams);
        DataPackage returnData = this.sendAndReceive(socket, sendData, timeout);
        List datas = returnData.getRecordset();
        return datas.isEmpty() ? null : (Record)datas.get(0);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, TLVConnection.CMD_WORK_CONTRL workContrl) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP((long)cmdWord, (String)this.sessionKey, tlvParams, (TLVConnection.CMD_WORK_CONTRL)workContrl);
        DataPackage returnData = this.sendAndReceive(sendData, 30);
        List records = returnData.getRecordset();
        return records.isEmpty() ? null : (Record)records.get(0);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, TLVConnection.CMD_WORK_CONTRL workContrl, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP((long)cmdWord, (String)this.sessionKey, tlvParams, (TLVConnection.CMD_WORK_CONTRL)workContrl);
        DataPackage returnData = this.sendAndReceive(sendData, timeout);
        List records = returnData.getRecordset();
        return records.isEmpty() ? null : (Record)records.get(0);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams) throws IsmException {
        return this.getBatch(cmdWord, tlvParams, 30);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, boolean printLog) throws IsmException {
        return this.getBatch(cmdWord, tlvParams, 30);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout) throws IsmException {
        DataPackage sendData = TLVUtils.param2DP((long)cmdWord, (String)this.sessionKey, tlvParams);
        DataPackage returnData = this.sendAndReceive(sendData, timeout);
        return returnData.getRecordset();
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param) throws IsmException {
        return this.getNext(cmdWord, param, 30);
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param, int timeOut) throws IsmException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> tmpDatas = this.getBatch(cmdWord, (List<Param>)TLVUtils.singleItemList((Param)param), timeOut);
        Record lastRecord = null;
        long errorcode = 0L;
        while (!tmpDatas.isEmpty()) {
            for (int i = 0; i < tmpDatas.size() - 1; ++i) {
                dataList.add(tmpDatas.get(i));
            }
            lastRecord = tmpDatas.get(tmpDatas.size() - 1);
            if (TLVUtils.containTag((Record)lastRecord, (int)4095)) {
                errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new IsmException(errorcode);
            }
            dataList.add(lastRecord);
            tmpDatas = this.getBatch(cmdWord, (List<Param>)TLVUtils.singleItemList((int)param.getIndex(), (ParamType)param.getType(), (Object)lastRecord.getParamValue(param.getIndex())), timeOut);
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataPackage sendAndReceive(DataPackage sendData, int timeout) throws IsmException {
        Socket socket = this.getSocket();
        if (socket == null) {
            LOGGER.error((Object)"socket is null.");
            return new DataPackage();
        }
        try {
            DataPackage dataPackage = this.sendAndReceive(socket, sendData, timeout);
            return dataPackage;
        }
        finally {
            this.releaseSocket(socket);
        }
    }

    protected DataPackage processAuthenticateException(Socket socket, IsmException exception, DataPackage sendData, int timeout) {
        if (this.isAuthenticateFail(exception) && !this.isUserOff) {
            String localIP = NetUtil.queryLocalIP((String)this.ip, (int)this.port);
            this.authenticateByLocalIP(socket, localIP);
            sendData.getHead().setSessionKey((long)Integer.valueOf(this.sessionKey).intValue());
            this.sendDataPackage(socket, sendData, timeout);
            byte[] result = this.receiveByteStream(socket);
            DataPackage receivedDataPackage = this.decodeByteStream(result);
            return receivedDataPackage;
        }
        throw exception;
    }

    private boolean isAuthenticateFail(IsmException exception) {
        long errorId = exception.getErrorId();
        if (errorId == 1077949070L) {
            this.isUserOff = true;
        }
        return errorId == 16797700L || errorId == 16806404L || errorId == 0x5000504L || errorId == 83887382L || errorId == 1077949069L;
    }

    protected void sendDataPackage(Socket socket, DataPackage sendData, int timeout) {
        try {
            socket.setSoTimeout(timeout * 1000);
            OutputStream outputStream = socket.getOutputStream();
            short msgSn = (short)(this.serial.incrementAndGet() & 0xFFFF7FFF);
            sendData.getHead().setSerial(msgSn);
            outputStream.write(sendData.toByteArray());
            outputStream.flush();
            String logMessage = MessageFormat.format("SEND TO {0}:{1}", socket.getRemoteSocketAddress(), System.lineSeparator());
            LOGGER.info((Object)logMessage);
        }
        catch (Exception e) {
            this.clean(socket);
            throw new IsmException(1073949185L, (Throwable)e);
        }
    }

    protected byte[] receiveByteStream(Socket socket) {
        byte[] result = null;
        try {
            InputStream inputStream = socket.getInputStream();
            byte[] receiveDataHeadByte = new byte[28];
            this.fillBuffer(inputStream, receiveDataHeadByte);
            byte[] tmp4Byte = new byte[4];
            System.arraycopy(receiveDataHeadByte, 8, tmp4Byte, 0, 4);
            System.arraycopy(receiveDataHeadByte, 24, tmp4Byte, 0, 4);
            int bufferLength = ByteUtil.bytes2int((byte[])tmp4Byte, (boolean)false);
            result = new byte[28 + bufferLength];
            byte[] receiveDataBuf = new byte[bufferLength];
            if (bufferLength > 0) {
                this.fillBuffer(inputStream, receiveDataBuf);
            }
            System.arraycopy(receiveDataHeadByte, 0, result, 0, 28);
            System.arraycopy(receiveDataBuf, 0, result, 28, receiveDataBuf.length);
        }
        catch (Exception e) {
            this.clean(socket);
            throw new IsmException(16797698L, (Throwable)e);
        }
        return result;
    }

    protected DataPackage decodeByteStream(byte[] byteStream) {
        DataPackage receivedData = TLVUtils.decode((byte[])byteStream);
        return receivedData;
    }

    protected void clean(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception e1) {
            LOGGER.error((Object)e1);
        }
    }

    protected void fillBuffer(InputStream is, byte[] receiveDataBuf) throws IOException, InterruptedException {
        int totalReadBytes = 0;
        int onceReadBytes = 0;
        while (totalReadBytes < receiveDataBuf.length) {
            onceReadBytes = is.read(receiveDataBuf, totalReadBytes, receiveDataBuf.length - totalReadBytes);
            if (onceReadBytes > -1) {
                totalReadBytes += onceReadBytes;
            }
            if (onceReadBytes != -1) continue;
            throw new IOException("socket closed");
        }
    }

    public IConnection.ConnectionState getConnectionState() {
        SocketPool pool = ConnectionManager.getInstance().getSocketPoolByDeviceID(this.deviceID);
        if (pool != null) {
            return pool.getConnectionState();
        }
        return IConnection.ConnectionState.Disconnected;
    }

    public String getURL() {
        return this.ip;
    }

    @Override
    public Record pmCreate(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        return this.invoke(0xD00004000L, (List<Param>)TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
    }

    @Override
    public void pmDelete(int moType, String moid, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        this.sendCMD(0xD00006000L, TLVUtils.addParam((List)Collections.EMPTY_LIST, (Param[])new Param[]{moTypeParam, moidParam}), timeout);
    }

    @Override
    public void pmModify(int moType, String moid, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        tlvParams = TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam});
        if (null != moid && !moid.isEmpty()) {
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
            tlvParams = TLVUtils.addParam((List)tlvParams, (Param[])new Param[]{moidParam});
        }
        this.sendCMD(0xD00002000L, tlvParams, timeout);
    }

    @Override
    public Record pmGet(int moType, String moid, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        return this.invoke(0xD00000000L, (List<Param>)TLVUtils.addParam((List)Collections.EMPTY_LIST, (Param[])new Param[]{moTypeParam, moidParam}), timeout);
    }

    @Override
    public List<Record> pmGetBacthNext(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        return this.bacthNext(0xD0000C000L, (List<Param>)TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
    }

    @Override
    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout) throws IsmException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> datas = this.getBatch(cmd, tlvParams, timeout);
        long errorcode = 0L;
        Record lastRecord = null;
        while (!datas.isEmpty()) {
            for (int i = 0; i < datas.size() - 1; ++i) {
                dataList.add(datas.get(i));
            }
            lastRecord = datas.get(datas.size() - 1);
            if (TLVUtils.containTag((Record)lastRecord, (int)4095)) {
                errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new IsmException(errorcode);
            }
            dataList.add(lastRecord);
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), lastRecord.getParamStrValue(TLVMOMsg.ID.getParamIndex()));
            datas = this.getBatch(cmd, (List<Param>)TLVUtils.addParam(tlvParams, (Param[])new Param[]{moidParam}), timeout);
        }
        return dataList;
    }

    @Override
    public int pmCount(int moType, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(moType));
        Record record = this.invoke(0xD0000E000L, (List<Param>)TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
        if (VerifyUtil.isEmpty(record)) {
            LOGGER.error((Object)String.format(Locale.ROOT, "Executing TLV Commands failed.cmd:{}", 0xD0000E000L));
            throw new IsmException(33L);
        }
        Object obj = record.getParamValue(TLVMOMsg.COUNT.getParamIndex());
        if (obj == null || !(obj instanceof IsmInteger)) {
            throw new IsmException(33L);
        }
        return ((IsmInteger)obj).intValue();
    }

    @Override
    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID, int timeout) throws IsmException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.bacthNext(0xD0000A000L, (List<Param>)TLVUtils.addParam((List)Collections.EMPTY_LIST, (Param[])new Param[]{srcmoTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    @Override
    public Record pmCreateAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws IsmException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param srcmoidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.invoke(0xD00005000L, (List<Param>)TLVUtils.addParam(tlvParams, (Param[])new Param[]{srcmoTypeParam, srcmoidTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    @Override
    public void pmRemoveAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws IsmException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param moidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        this.sendCMD(0xD00007000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam, moidTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    @Override
    public DataPackage sendAndReceive(Socket socket, DataPackage sendData, int timeout) throws IsmException {
        DataPackage receivedDataPackage = null;
        try {
            this.sendDataPackage(socket, sendData, timeout);
            byte[] result = this.receiveByteStream(socket);
            receivedDataPackage = this.decodeByteStream(result);
            String logMessage = MessageFormat.format("RECEIVE FROM {0}:{1}", socket.getRemoteSocketAddress(), System.lineSeparator());
            LOGGER.info((Object)logMessage);
        }
        catch (IsmException exception) {
            StringBuffer loginfo = new StringBuffer();
            loginfo.append("Error: sendAndReceive Exception.\nconnection: ").append(socket.getRemoteSocketAddress()).append("\nrequest msg: ");
            LOGGER.warn((Object)loginfo.toString(), (Throwable)exception);
            receivedDataPackage = this.processAuthenticateException(socket, exception, sendData, timeout);
        }
        return receivedDataPackage;
    }

    @Override
    public Socket getSocket() throws IsmException {
        Socket socket = null;
        SocketPool socketPool = this.getSocketPool();
        if (socketPool == null) {
            try {
                socket = NetUtil.connect((String)this.ip, (int)this.port, (int)this.protocolType, null);
                this.notifyStateChanged(IConnection.ConnectionState.Connected);
            }
            catch (Exception e) {
                this.notifyStateChanged(IConnection.ConnectionState.Disconnected);
                throw new IsmException(1073949185L, (Throwable)e);
            }
        }
        try {
            socket = socketPool.getSocket();
            if (!socket.getInetAddress().getHostAddress().equals(this.ip)) {
                this.ip = socket.getInetAddress().getHostAddress();
                IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_COMPONENT_CHANGE");
                msg.setProperty((Object)"ConnectionState", (Object)IConnection.ConnectionState.Connected);
                IsmMsgManager.getInstance().postSyncMsg(msg);
            }
            this.notifyStateChanged(IConnection.ConnectionState.Connected);
        }
        catch (InterruptedException e) {
            throw new IsmException(0x100000005L, (Throwable)e);
        }
        catch (IsmException e) {
            this.notifyStateChanged(IConnection.ConnectionState.Disconnected);
            throw e;
        }
        return socket;
    }

    @Override
    public void releaseSocket(Socket socket) throws IsmException {
        if (socket == null) {
            return;
        }
        SocketPool socketPool = this.getSocketPool();
        boolean releaseOK = false;
        if (socketPool != null) {
            releaseOK = socketPool.releaseSocket(socket);
        }
        if (!releaseOK) {
            this.clean(socket);
        }
    }

    @Override
    public Record pmGet(int moType, String moid) throws IsmException {
        return null;
    }

    @Override
    public int pmCount(int moType, List<Param> tlvParams) throws IsmException {
        return 0;
    }

    @Override
    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID) throws IsmException {
        return null;
    }

    @Override
    public List<Record> bacthNext(long cmdWord, List<Param> tlvParams, TLVTag endTag) throws IsmException {
        return null;
    }

    @Override
    public List<Record> pmGetBacthNext(int moType, List<Param> tlvParams) throws IsmException {
        return null;
    }

    @Override
    public List<Record> pmGetBacthNextNew(int moType, List<Param> tlvParams, int count) throws IsmException {
        return null;
    }

    @Override
    public void downloadFile(long cmdWord, List<Param> params, String localPath) {
    }

    @Override
    public void refreshClient() throws IsmException {
    }
}

