/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.common.bean.CMDMapping;
import com.huawei.ism.common.bean.ParamMapping;
import com.huawei.ism.common.bean.RESTMapping;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.ism.util.XmlFileReaderUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class RESTUtil {
    private static final Logger LOGGER = Logger.getLogger(RESTUtil.class);
    private static final Map<Long, CMDMapping> CMD_MAPPING = new HashMap<Long, CMDMapping>();
    private static final Map<Integer, RESTMapping> REST_MAPPING = new HashMap<Integer, RESTMapping>();

    public static String getMethod(long cmdWord) {
        CMDMapping cm = CMD_MAPPING.get(cmdWord);
        if (cm == null) {
            return "GET";
        }
        return cm.getMethod();
    }

    public static String getMOUrl(long cmdWord) {
        CMDMapping cm = CMD_MAPPING.get(cmdWord);
        if (cm == null) {
            return "";
        }
        return cm.getRestMapping().getUri();
    }

    public static Map<Integer, ParamMapping> getIdMapByType(int type) {
        HashMap<Integer, ParamMapping> mappings = new HashMap<Integer, ParamMapping>();
        RESTMapping rm = REST_MAPPING.get(0);
        if (rm != null) {
            mappings.putAll(rm.getIdToMap());
        }
        if ((rm = REST_MAPPING.get(type)) != null) {
            mappings.putAll(rm.getIdToMap());
        }
        return mappings;
    }

    public static Map<String, ParamMapping> getNameMapByType(int type) {
        HashMap<String, ParamMapping> mappings = new HashMap<String, ParamMapping>();
        RESTMapping rm = REST_MAPPING.get(0);
        if (rm != null) {
            mappings.putAll(rm.getNameToMap());
        }
        if ((rm = REST_MAPPING.get(type)) != null) {
            mappings.putAll(rm.getNameToMap());
        }
        return mappings;
    }

    public static Map<Integer, ParamMapping> getIdMapByCMD(long cmdWord) {
        RESTMapping rm = CMD_MAPPING.get(cmdWord).getRestMapping();
        if (rm == null) {
            return null;
        }
        return rm.getIdToMap();
    }

    public static Map<String, ParamMapping> getNameMapByCMD(long cmdWord) {
        RESTMapping rm = CMD_MAPPING.get(cmdWord).getRestMapping();
        if (rm == null) {
            return null;
        }
        return rm.getNameToMap();
    }

    public static String getCheckRestUrl() {
        return "/deviceManager/devicemanager/feature/login/login.html";
    }

    public static String getPageUrl(String url, int start, int end) {
        String tempUrl = "range=[" + start + "-" + end + "]";
        if (url.contains("?")) {
            return url + "&" + tempUrl;
        }
        return url + "?" + tempUrl;
    }

    public static String convertParamToUrl(int moType, List<Param> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        Map<Integer, ParamMapping> mappings = RESTUtil.getIdMapByType(moType);
        return RESTUtil.convertParams(params, mappings);
    }

    public static String convertParamToUrl(long cmdWord, List<Param> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        Map<Integer, ParamMapping> mappings = RESTUtil.getIdMapByCMD(cmdWord);
        return RESTUtil.convertParams(params, mappings);
    }

    public static String convertParamToJson(long cmdWord, List<Param> params) {
        Map<Integer, ParamMapping> mapping = RESTUtil.getIdMapByCMD(cmdWord);
        if (VerifyUtil.isEmpty(mapping)) {
            return "";
        }
        StringBuilder json = new StringBuilder();
        json.append('{');
        for (Param p : params) {
            ParamMapping pm = mapping.get(p.getIndex());
            if (pm == null) {
                LOGGER.error((Object)("Could not find param, cmdWord: " + cmdWord + " index: " + p.getIndex()));
                continue;
            }
            json.append('\"').append(pm.getName()).append("\": ");
            json.append('\"').append(p.getValue()).append('\"');
            json.append(", ");
        }
        if (json.length() > 1) {
            json.delete(json.length() - 2, json.length());
        }
        json.append('}');
        return json.toString();
    }

    public static boolean isResponseSuccess(JSONObject obj) {
        try {
            if (obj != null && obj.getJSONObject("error").getInt("code") == 0) {
                return true;
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)"JSON format error.", (Throwable)e);
        }
        return false;
    }

    public static List<Record> jsonToRecordList(int moType, JSONObject result) {
        ArrayList<Record> results = new ArrayList<Record>();
        if (VerifyUtil.isEmpty(result) || !result.has("data")) {
            return results;
        }
        try {
            Object jo = result.get("data");
            if (jo instanceof JSONObject) {
                results.add(RESTUtil.jsonToRecord(moType, (JSONObject)jo));
            } else if (jo instanceof JSONArray) {
                JSONArray ja = (JSONArray)jo;
                for (int i = 0; i < ja.length(); ++i) {
                    Object obj = ja.get(i);
                    JSONObject jsonObj = obj instanceof JSONObject ? (JSONObject)obj : null;
                    results.add(RESTUtil.jsonToRecord(moType, jsonObj));
                }
            } else {
                LOGGER.error((Object)("Failed to parse json, moType: " + moType + ", json result: " + result));
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Failed to parse json, moType: " + moType + ", json result: " + result), (Throwable)e);
        }
        return results;
    }

    public static List<Record> jsonToRecordList(long cmdWord, JSONObject result) {
        ArrayList<Record> results = new ArrayList<Record>();
        if (VerifyUtil.isEmpty(result) || !result.has("data")) {
            return results;
        }
        try {
            Object jo = result.get("data");
            if (jo instanceof JSONObject) {
                results.add(RESTUtil.jsonToRecord(cmdWord, (JSONObject)jo));
            } else if (jo instanceof JSONArray) {
                JSONArray ja = (JSONArray)jo;
                for (int i = 0; i < ja.length(); ++i) {
                    Object obj = ja.get(i);
                    JSONObject jsonObj = obj instanceof JSONObject ? (JSONObject)obj : null;
                    results.add(RESTUtil.jsonToRecord(cmdWord, jsonObj));
                }
            } else {
                LOGGER.error((Object)("Failed to parse json, cmdWord: " + cmdWord + ", json result: " + result));
            }
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Failed to parse json, cmdWord: " + cmdWord + ", json result: " + result), (Throwable)e);
        }
        return results;
    }

    public static Record jsonToRecord(int moType, JSONObject result) throws JSONException {
        if (VerifyUtil.isEmpty(result)) {
            return null;
        }
        Record rec = new Record();
        Map<String, ParamMapping> mapping = RESTUtil.getNameMapByType(moType);
        RESTUtil.parseToRecord(rec, mapping, result);
        return rec;
    }

    public static Record jsonToRecord(long cmdWord, JSONObject result) {
        if (VerifyUtil.isEmpty(result)) {
            return null;
        }
        Record rec = new Record();
        try {
            Map<String, ParamMapping> mapping = RESTUtil.getNameMapByCMD(cmdWord);
            if (mapping == null) {
                return null;
            }
            RESTUtil.parseToRecord(rec, mapping, result);
        }
        catch (JSONException e) {
            LOGGER.error((Object)("Failed to parse json, cmdWord: " + cmdWord + ", json result: " + result), (Throwable)e);
        }
        return rec;
    }

    private static void parseToRecord(Record rec, Map<String, ParamMapping> mapping, JSONObject jsonObj) throws JSONException {
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!mapping.containsKey(key.toLowerCase(Locale.getDefault()))) continue;
            ParamMapping paramMapping = mapping.get(key.toLowerCase(Locale.getDefault()));
            String value = jsonObj.get(key).toString();
            Param param = new Param(paramMapping.getId(), value);
            rec.add(param);
        }
    }

    private static void parseCMDMapping(RESTMapping rm, List<Element> cmdEles) {
        String url = rm.getUri();
        for (Element ce : cmdEles) {
            RESTMapping rmn = rm.copy();
            CMDMapping cm = new CMDMapping(RESTUtil.parseToLong(ce.attribute("value").getValue()), ce.attribute("name").getValue(), ce.attribute("method").getValue());
            if (ce.attribute("url") != null) {
                rmn.setUrl(ce.attribute("url").getValue());
            } else {
                rmn.setUrl(url);
            }
            cm.setRestMapping(rmn);
            CMD_MAPPING.put(cm.getCmd(), cm);
        }
    }

    private static RESTMapping parseRESTMapping(Element e) {
        RESTMapping rm = new RESTMapping(e.attribute("name").getValue());
        if (e.attribute("motype") != null) {
            rm.setMoType(RESTUtil.parseToInt(e.attribute("motype").getValue()));
        }
        if (e.attribute("url") != null) {
            rm.setUrl(e.attribute("url").getValue());
        }
        List paramEles = e.elements("param");
        HashMap<Integer, ParamMapping> typeToMap = new HashMap<Integer, ParamMapping>();
        HashMap<String, ParamMapping> nameToMap = new HashMap<String, ParamMapping>();
        if (!VerifyUtil.isEmpty(paramEles)) {
            for (Element pe : paramEles) {
                ParamMapping pm = new ParamMapping(RESTUtil.parseToInt(pe.attribute("id").getValue()), pe.attribute("name").getValue());
                typeToMap.put(pm.getId(), pm);
                nameToMap.put(pm.getName().toLowerCase(Locale.getDefault()), pm);
            }
        }
        rm.setIdToMap(typeToMap);
        rm.setNameToMap(nameToMap);
        return rm;
    }

    private static int parseToInt(String str) {
        int result = 0;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("ConfigMetricXml NumberFormatException: " + str + " to int."), (Throwable)e);
        }
        return result;
    }

    private static long parseToLong(String str) {
        long result = 0L;
        try {
            result = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("ConfigMetricXml NumberFormatException: " + str + " to int."), (Throwable)e);
        }
        return result;
    }

    public static void initMappings() {
        try {
            Document doc = XmlFileReaderUtil.load("config/tlvAndRestMapping_tv3.xml");
            if (doc == null) {
                LOGGER.error((Object)"cannt load res mapping file.");
                return;
            }
            Element root = doc.getRootElement();
            List mappingList = root.elements("message");
            if (VerifyUtil.isEmpty(mappingList)) {
                LOGGER.error((Object)"The tlv and rest mapping file is empty.");
                return;
            }
            for (Element e : mappingList) {
                RESTMapping rm = RESTUtil.parseRESTMapping(e);
                List cmdEles = e.elements("cmd");
                if (VerifyUtil.isEmpty(cmdEles)) {
                    REST_MAPPING.put(rm.getMoType(), rm);
                    continue;
                }
                RESTUtil.parseCMDMapping(rm, cmdEles);
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"The tlv and rest mapping file not found.", e);
        }
    }

    private static String convertParams(List<Param> params, Map<Integer, ParamMapping> mappings) {
        StringBuilder url = new StringBuilder();
        if (mappings == null || mappings.isEmpty()) {
            return url.toString();
        }
        url.append("?");
        for (Param p : params) {
            ParamMapping pm = mappings.get(p.getIndex());
            if (pm == null) continue;
            url.append(pm.getName()).append("=").append(p.getValue().toString().replaceAll("#", "%23")).append("&");
        }
        url.delete(url.length() - 1, url.length());
        return url.toString();
    }

    static {
        RESTUtil.initMappings();
    }
}

