/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisObject;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.Pair;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class HisTools {
    public static Integer convertStringToInteger(String string) {
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String convertIntegerToString(Integer integer) {
        if (integer == null) {
            return "";
        }
        return integer.toString();
    }

    public static Long convertStringToLong(String string) {
        try {
            return Long.valueOf(string.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String convertLongToString(Long longValue) {
        if (longValue == null) {
            return "";
        }
        return longValue.toString();
    }

    public static String convertScaleToString(double scale) {
        if (scale > 1.0) {
            int count = 1;
            while (scale > 1.0) {
                scale /= 10.0;
                count *= 10;
            }
            return "" + count + ':' + 1;
        }
        if (scale < 1.0) {
            int count = 1;
            while (scale < 1.0) {
                scale *= 10.0;
                count *= 10;
            }
            return "1:" + count;
        }
        return "1:1";
    }

    public static double convertStringToScale(String string) {
        String[] stringArray = string.split(":");
        double numerator = Double.parseDouble(stringArray[0]);
        double denominator = Double.parseDouble(stringArray[1]);
        return numerator / denominator;
    }

    public static void scaleTimeSeries(TimeSeries timeSeries, double oldScale, double newScale) {
        List list = timeSeries.getItems();
        TimeSeriesDataItem timeSeriesDataItem = null;
        for (int i = 0; i < list.size(); ++i) {
            timeSeriesDataItem = (TimeSeriesDataItem)list.get(i);
            double oldValue = timeSeriesDataItem.getValue().doubleValue();
            double newValue = oldValue / oldScale * newScale;
            timeSeriesDataItem.setValue((Number)newValue);
        }
    }

    public static double calculateScale(double maxValue) {
        double scale = 1.0;
        if (maxValue <= 100.0) {
            return scale;
        }
        double result = 100.0 / maxValue;
        BigDecimal bd = new BigDecimal(result);
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (bd.movePointRight(i).abs().compareTo(BigDecimal.valueOf(1L)) <= 0) continue;
            scale = BigDecimal.valueOf(scale).movePointLeft(i).doubleValue();
            break;
        }
        return scale;
    }

    public static IsmTableCell.ComboBoxCell createScaleTableCell() {
        Pair pair0001 = new Pair((Object)0.001, (Object)"1:1000");
        Pair pair001 = new Pair((Object)0.01, (Object)"1:100");
        Pair pair01 = new Pair((Object)0.1, (Object)"1:10");
        Pair pair1 = new Pair((Object)1.0, (Object)"1:1");
        Pair pair10 = new Pair((Object)10.0, (Object)"10:1");
        Pair pair100 = new Pair((Object)100.0, (Object)"100:1");
        Pair pair1000 = new Pair((Object)1000.0, (Object)"1000:1");
        Pair pairAuto = new Pair((Object)0.0, (Object)HisResourceManager.getString("perf.ui.scale.autoAdapt"));
        Object[] candidateScales = new Object[]{pairAuto, pair0001, pair001, pair01, pair1, pair10, pair100, pair1000};
        IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(candidateScales, (Object)pairAuto);
        return cell;
    }

    public static String removePath(String absolutePath) {
        if (absolutePath.lastIndexOf(47) != -1) {
            return absolutePath.substring(absolutePath.lastIndexOf(47) + 1);
        }
        return absolutePath.substring(absolutePath.lastIndexOf(92) + 1);
    }

    public static DateFormat generateDateFormat(final TimeZone timeZone) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
            private static final long serialVersionUID = 4733674717218357497L;

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                String datime = super.format(date, toAppendTo, pos).toString();
                SimpleDateFormat utcFormat = new SimpleDateFormat(" 'UTC'Z");
                utcFormat.setTimeZone(timeZone);
                String utc = utcFormat.format(date);
                StringBuilder utcBuilder = new StringBuilder(utc);
                utcBuilder.insert(utc.length() - 2, ":");
                if (timeZone.useDaylightTime()) {
                    utcBuilder.append(" DST");
                }
                return new StringBuffer(datime + utcBuilder.toString());
            }
        };
        return format;
    }

    public static long calculateDateLength(List<HisPerfStatHisObject> perfStatHisObjects) {
        long dataLength = 0L;
        List<int[]> allData = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            allData = perfStatHisObject.getData();
            for (int[] onePeriodData : allData) {
                dataLength += (long)onePeriodData.length;
            }
        }
        return dataLength;
    }

    public static String getFormatName(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        String fileName = perfStatHisFileInfo.getCompressedFileName();
        int index = (fileName = HisTools.removePath(fileName)).lastIndexOf(".");
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String generateStatItemKey(IObjectTypeEnum objectType, String name, IDataTypeEnum dataType) {
        String key = objectType.getDescription() + '_' + name + '_' + dataType.getDescription();
        return key;
    }

    public static String generateStatItemKey(HisPerfStatObjectType.HisObjectTypeEnum objectType, String name, HisPerfStatObjectType.HisDataTypeEnum dataType) {
        String key = objectType.getDescription() + '_' + name + '_' + dataType.getDescription();
        return key;
    }
}

