/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.proxy;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisObject;
import com.huawei.ism.util.ByteUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HisPerfStatHisFileProxy {
    private static final Logger LOGGER = Logger.getLogger(HisPerfStatHisFileProxy.class);
    private static final int INFO_HEAD_LENGTH = 337;
    private static final int CHECK_CODE_LENGTH = 32;
    private static final int VERSION_LENGTH = 4;
    private static final int DEVICE_SN_LENGTH = 256;
    private static final int DEVICE_NAME_LENGTH = 41;
    private static final int DATA_LENGTH_LENGTH = 4;
    private static final int MERGE_FILE_SIZE_UPPER_LIMIT = 524288000;
    private static final long DATA_TIME_SEPARATE_UPPER_LIMIT = 31536000000L;
    private static final int BUFFER_LENGTH = 0x100000;
    private List<long[]> tlvInfos = null;

    private RandomAccessFile open(String fileName) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(fileName, "rw");
        return randomAccessFile;
    }

    private void close(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"close performance history file error", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HisPerfStatHisFileInfo queryPerfStatHisFileInfo(String fileName) {
        long minStartTime = Long.MAX_VALUE;
        long maxEndTime = Long.MIN_VALUE;
        HisPerfStatHisFileInfo perfStatHisFileInfo = new HisPerfStatHisFileInfo();
        File file = new File(fileName);
        RandomAccessFile raf = null;
        try {
            perfStatHisFileInfo.setFileName(file.getCanonicalPath());
            perfStatHisFileInfo.setSize(file.length());
            raf = this.open(fileName);
            byte[] headerBuf = new byte[337];
            raf.readFully(headerBuf);
            byte[] checkCodeBuf = new byte[32];
            System.arraycopy(headerBuf, 0, checkCodeBuf, 0, checkCodeBuf.length);
            perfStatHisFileInfo.setCheckCode(new String(checkCodeBuf, "UTF-8"));
            byte[] versionBuf = new byte[4];
            System.arraycopy(headerBuf, 32, versionBuf, 0, versionBuf.length);
            perfStatHisFileInfo.setVersion(ByteUtil.bytes2int((byte[])versionBuf, (boolean)false));
            byte[] deviceSnBuf = new byte[256];
            System.arraycopy(headerBuf, 36, deviceSnBuf, 0, deviceSnBuf.length);
            perfStatHisFileInfo.setDeviceSN(new String(deviceSnBuf, "UTF-8").trim());
            byte[] deviceNameBuf = new byte[41];
            System.arraycopy(headerBuf, 292, deviceNameBuf, 0, deviceNameBuf.length);
            perfStatHisFileInfo.setDeviceName(new String(deviceNameBuf, "UTF-8").trim());
            byte[] dataLengthBuf = new byte[4];
            System.arraycopy(headerBuf, 333, dataLengthBuf, 0, dataLengthBuf.length);
            int dataLength = ByteUtil.bytes2int((byte[])dataLengthBuf, (boolean)false);
            perfStatHisFileInfo.setDataLength(dataLength);
            int skipedLength = 0;
            byte[] tlvLengthBuf = null;
            int tlvLength = 0;
            byte[] jsonBuf = null;
            String json = null;
            JSONObject jsonObj = null;
            long dataStartTime = 0L;
            long dataEndTime = 0L;
            int controllerId = 0;
            int period = 0;
            int dataBlockLength = 0;
            JSONObject objectMap = null;
            Iterator objectTypes = null;
            String objectTypeString = null;
            JSONObject objectTypeMap = null;
            JSONArray namesJSONArray = null;
            JSONArray dataTypesJSONArray = null;
            int periodCount = 0;
            do {
                if (raf.getFilePointer() >= raf.length()) {
                    perfStatHisFileInfo.setStartTime(minStartTime);
                    perfStatHisFileInfo.setEndTime(maxEndTime);
                    HisPerfStatHisFileInfo hisPerfStatHisFileInfo = perfStatHisFileInfo;
                    this.close(raf);
                    return hisPerfStatHisFileInfo;
                }
                skipedLength = raf.skipBytes(4);
                if (skipedLength != 4) {
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
                tlvLengthBuf = new byte[4];
                raf.readFully(tlvLengthBuf);
                tlvLength = ByteUtil.bytes2int((byte[])tlvLengthBuf, (boolean)false);
                jsonBuf = new byte[tlvLength - 4 - 4];
                raf.readFully(jsonBuf);
                json = new String(jsonBuf, "UTF-8").trim();
                jsonObj = new JSONObject(json);
                dataStartTime = Long.parseLong(jsonObj.get("StartTime").toString().trim()) * 1000L;
                dataEndTime = Long.parseLong(jsonObj.get("EndTime").toString().trim()) * 1000L;
                period = Integer.parseInt(jsonObj.get("Archive").toString().trim()) * 1000;
                if (0 == period) {
                    LOGGER.warn((Object)"Period is zero.");
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
                controllerId = Integer.parseInt(jsonObj.get("CtrlID").toString().trim());
                long[] tlvInfo = new long[]{dataStartTime, dataEndTime, controllerId};
                perfStatHisFileInfo.getTlvInfos().add(tlvInfo);
                perfStatHisFileInfo.setPeriod(period);
                dataBlockLength = 0;
                objectMap = jsonObj.getJSONObject("Map");
                objectTypes = objectMap.keys();
                while (objectTypes.hasNext()) {
                    objectTypeString = (String)objectTypes.next();
                    objectTypeMap = objectMap.getJSONObject(objectTypeString);
                    namesJSONArray = objectTypeMap.getJSONArray("Names");
                    dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
                    periodCount = (int)((dataEndTime - dataStartTime) / (long)period);
                    dataBlockLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength * periodCount;
                }
                minStartTime = minStartTime < dataStartTime ? minStartTime : dataStartTime;
                long l = maxEndTime = maxEndTime > dataEndTime ? maxEndTime : dataEndTime;
            } while ((skipedLength = raf.skipBytes(dataBlockLength)) == dataBlockLength);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"read data error", (Throwable)e);
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                catch (JSONException e2) {
                    LOGGER.error((Object)("performance history file json parse error :" + e2.getMessage()), (Throwable)e2);
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
            }
            catch (Throwable throwable) {
                this.close(raf);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateObjectNamesAndDataTypes(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<String>>(0);
        HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToDataTypesMapping = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>(0);
        LinkedList<HisPerfStatObjectType.HisObjectTypeEnum> allObjectTypes = new LinkedList<HisPerfStatObjectType.HisObjectTypeEnum>();
        RandomAccessFile raf = null;
        try {
            raf = this.open(perfStatHisFileInfo.getFileName());
            int skipedLength = raf.skipBytes(333);
            if (skipedLength != 333) {
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            byte[] dataLengthBuf = new byte[4];
            raf.readFully(dataLengthBuf);
            int dataLength = ByteUtil.bytes2int((byte[])dataLengthBuf, (boolean)false);
            byte[] tlvLengthBuf = null;
            int tlvLength = 0;
            byte[] jsonBuf = null;
            JSONObject jsonObj = null;
            long dataStartTime = 0L;
            long dataEndTime = 0L;
            int period = 0;
            int dataBlockLength = 0;
            HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp = null;
            HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToDataTypesMappingTmp = null;
            JSONObject objectMap = null;
            LinkedList<HisPerfStatObjectType.HisObjectTypeEnum> objectTypesTmp = null;
            Iterator objectTypes = null;
            JSONObject objectTypeMap = null;
            HisPerfStatObjectType.HisObjectTypeEnum objectType = null;
            String objectTypeString = null;
            JSONArray namesJSONArray = null;
            JSONArray idsJSONArray = null;
            JSONArray dataTypesJSONArray = null;
            ArrayList<String> names = null;
            LinkedList<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
            int periodCount = 0;
            String json = null;
            while (raf.getFilePointer() < raf.length()) {
                try {
                    skipedLength = raf.skipBytes(4);
                    if (skipedLength != 4) {
                        throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                    }
                    tlvLengthBuf = new byte[4];
                    raf.readFully(tlvLengthBuf);
                    tlvLength = ByteUtil.bytes2int((byte[])tlvLengthBuf, (boolean)false);
                    if (tlvLength < 8) {
                        LOGGER.warn((Object)"The tlv length is less than 8");
                        continue;
                    }
                    jsonBuf = new byte[tlvLength - 4 - 4];
                    raf.readFully(jsonBuf);
                    json = new String(jsonBuf, "UTF-8").trim();
                    jsonObj = new JSONObject(json);
                    dataStartTime = Long.parseLong(jsonObj.get("StartTime").toString().trim()) * 1000L;
                    dataEndTime = Long.parseLong(jsonObj.get("EndTime").toString().trim()) * 1000L;
                    period = Integer.parseInt(jsonObj.get("Archive").toString().trim()) * 1000;
                    if (0 == period) {
                        LOGGER.warn((Object)"Period is zero.");
                        throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                    }
                    dataBlockLength = 0;
                    objectTypeToNamesMappingTmp = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<String>>(0);
                    objectTypeToDataTypesMappingTmp = new HashMap<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>(0);
                    objectTypesTmp = new LinkedList<HisPerfStatObjectType.HisObjectTypeEnum>();
                    objectMap = jsonObj.getJSONObject("Map");
                    objectTypes = objectMap.keys();
                    while (objectTypes.hasNext()) {
                        objectTypeString = (String)objectTypes.next();
                        objectType = HisPerfStatObjectType.HisObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
                        if (objectType == null) continue;
                        objectTypeMap = objectMap.getJSONObject(objectTypeString);
                        namesJSONArray = objectTypeMap.getJSONArray("Names");
                        dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
                        idsJSONArray = objectTypeMap.has("IDs") ? objectTypeMap.getJSONArray("IDs") : null;
                        names = new ArrayList<String>();
                        this.addName(namesJSONArray, idsJSONArray, objectTypeString, names);
                        dataTypes = new LinkedList<HisPerfStatObjectType.HisDataTypeEnum>();
                        this.addDataTypes(dataTypes, dataTypesJSONArray);
                        objectTypeToNamesMappingTmp.put(objectType, names);
                        objectTypeToDataTypesMappingTmp.put(objectType, dataTypes);
                        this.fillObjectTypeMapping(objectTypeToNamesMappingTmp, objectType, names);
                        this.fillObjectDataMapping(objectTypeToDataTypesMappingTmp, objectType, dataTypes);
                        objectTypesTmp.add(objectType);
                        periodCount = (int)((dataEndTime - dataStartTime) / (long)period);
                        dataBlockLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength * periodCount;
                    }
                    if (dataEndTime >= perfStatHisFileInfo.getGraphicStartTime() && dataStartTime <= perfStatHisFileInfo.getGraphicEndTime()) {
                        this.mergeObjectTypeToNamesMapping(objectTypeToNamesMapping, objectTypeToNamesMappingTmp);
                        this.mergeObjectTypeToDataTypesMapping(objectTypeToDataTypesMapping, objectTypeToDataTypesMappingTmp);
                        this.mergeObjectTypes(allObjectTypes, objectTypesTmp);
                    }
                    if ((skipedLength = raf.skipBytes(dataBlockLength)) == dataBlockLength) continue;
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
                catch (IsmException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"File parse error:", (Throwable)e);
                }
            }
            perfStatHisFileInfo.setObjectTypes(allObjectTypes);
            perfStatHisFileInfo.setObjectTypeToNamesMapping(objectTypeToNamesMapping);
            perfStatHisFileInfo.setObjectTypeToDataTypeMapping(objectTypeToDataTypesMapping);
        }
        catch (IOException e) {
            LOGGER.error((Object)"read data error", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFormatException", (Throwable)e);
        }
        finally {
            this.close(raf);
        }
    }

    private void addName(JSONArray namesJSONArray, JSONArray idsJSONArray, String objectTypeString, List<String> names) throws JSONException {
        for (int i = 0; i < namesJSONArray.length(); ++i) {
            String resName = namesJSONArray.getString(i);
            if (idsJSONArray != null && resName.equals("")) {
                String objectTypeName = objectTypeString.equals("263") ? "ReplicationPair-" : "";
                resName = objectTypeName + idsJSONArray.getString(i);
            }
            names.add(resName);
        }
    }

    private void addDataTypes(List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes, JSONArray dataTypesJSONArray) {
        for (int j = 0; j < dataTypesJSONArray.length(); ++j) {
            try {
                dataTypes.add(HisPerfStatObjectType.HisDataTypeEnum.valueOf(dataTypesJSONArray.getInt(j)));
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    private void fillObjectDataMapping(Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> objectTypeToDataTypesMappingTmp, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes) {
        List<HisPerfStatObjectType.HisDataTypeEnum> dataList = objectTypeToDataTypesMappingTmp.get((Object)objectType);
        if (dataList != null) {
            dataList.addAll(dataTypes);
        } else {
            objectTypeToDataTypesMappingTmp.put(objectType, dataTypes);
        }
    }

    private void fillObjectTypeMapping(Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> objectTypeToNamesMappingTmp, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names) {
        List<String> objList = objectTypeToNamesMappingTmp.get((Object)objectType);
        if (objList != null) {
            objList.addAll(names);
        } else {
            objectTypeToNamesMappingTmp.put(objectType, names);
        }
    }

    public List<HisPerfStatHisObject> queryPerfStatHisObject(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names) {
        RandomAccessFile raf = null;
        try {
            raf = this.open(perfStatHisFileInfo.getFileName());
            int skipedLength = raf.skipBytes(333);
            if (skipedLength != 333) {
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            LinkedList<HisPerfStatHisObject> allPerfStatHisObjects = new LinkedList<HisPerfStatHisObject>();
            byte[] dataLengthBuf = new byte[4];
            raf.readFully(dataLengthBuf);
            int dataLength = ByteUtil.bytes2int((byte[])dataLengthBuf, (boolean)false);
            skipedLength = this.queryPerfStatHisObject1(perfStatHisFileInfo, objectType, names, raf, skipedLength, allPerfStatHisObjects, dataLength);
            this.alignPerfStatHisObjects(allPerfStatHisObjects);
            LinkedList<HisPerfStatHisObject> linkedList = allPerfStatHisObjects;
            return linkedList;
        }
        catch (IOException e) {
            LOGGER.error((Object)"read data error", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (JSONException e) {
            LOGGER.error((Object)("performance history file json parse error :" + e.getMessage()), (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        finally {
            this.close(raf);
        }
    }

    private int queryPerfStatHisObject1(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, RandomAccessFile raf, int skipedLength, List<HisPerfStatHisObject> allPerfStatHisObjects, int dataLength) throws IOException, JSONException {
        byte[] tlvLengthBuf = null;
        int tlvLength = 0;
        byte[] jsonBuf = null;
        String json = null;
        JSONObject jsonObj = null;
        long dataStartTime = 0L;
        long dataEndTime = 0L;
        int period = 0;
        long currentPeriodDataTime = 0L;
        int periodDataLength = 0;
        List<HisPerfStatHisObject> oneDataBlockPerfStatHisObjects = null;
        boolean offset = false;
        boolean isFirstTime = false;
        while (raf.getFilePointer() < raf.length()) {
            skipedLength = raf.skipBytes(4);
            if (skipedLength != 4) {
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            tlvLengthBuf = new byte[4];
            raf.readFully(tlvLengthBuf);
            tlvLength = ByteUtil.bytes2int((byte[])tlvLengthBuf, (boolean)false);
            jsonBuf = new byte[tlvLength - 4 - 4];
            raf.readFully(jsonBuf);
            json = new String(jsonBuf, "UTF-8").trim();
            jsonObj = new JSONObject(json);
            dataStartTime = Long.parseLong(jsonObj.get("StartTime").toString().trim()) * 1000L;
            dataEndTime = Long.parseLong(jsonObj.get("EndTime").toString().trim()) * 1000L;
            period = Integer.parseInt(jsonObj.get("Archive").toString().trim()) * 1000;
            currentPeriodDataTime = dataStartTime;
            periodDataLength = this.calculatePeriodDataLength(json, dataLength);
            oneDataBlockPerfStatHisObjects = this.getHisPerfStatHisObjects(objectType, names, dataLength, json, period);
            isFirstTime = true;
            skipedLength = this.getSkipedLength(perfStatHisFileInfo, objectType, names, raf, skipedLength, dataLength, json, dataEndTime, period, currentPeriodDataTime, periodDataLength, oneDataBlockPerfStatHisObjects, isFirstTime);
            allPerfStatHisObjects.addAll(oneDataBlockPerfStatHisObjects);
        }
        return skipedLength;
    }

    private int getSkipedLength(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, RandomAccessFile raf, int skipedLength, int dataLength, String json, long dataEndTime, int period, long currentPeriodDataTime, int periodDataLength, List<HisPerfStatHisObject> oneDataBlockPerfStatHisObjects, boolean isFirstTime) throws IOException {
        while (currentPeriodDataTime < dataEndTime) {
            if (this.checkCurrentPeriodDataTime(perfStatHisFileInfo, currentPeriodDataTime)) {
                if (isFirstTime) {
                    this.initStartTime(oneDataBlockPerfStatHisObjects, currentPeriodDataTime);
                    isFirstTime = false;
                }
                this.getDataSource(objectType, names, raf, dataLength, json, periodDataLength, oneDataBlockPerfStatHisObjects);
            } else {
                skipedLength = raf.skipBytes(periodDataLength);
                if (skipedLength != periodDataLength) {
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
            }
            currentPeriodDataTime += (long)period;
        }
        return skipedLength;
    }

    private boolean checkCurrentPeriodDataTime(HisPerfStatHisFileInfo perfStatHisFileInfo, long currentPeriodDataTime) {
        return currentPeriodDataTime >= perfStatHisFileInfo.getGraphicStartTime() && currentPeriodDataTime <= perfStatHisFileInfo.getGraphicEndTime();
    }

    private List<HisPerfStatHisObject> getHisPerfStatHisObjects(HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, int dataLength, String json, int period) {
        LinkedList<HisPerfStatHisObject> oneDataBlockPerfStatHisObjects = new LinkedList<HisPerfStatHisObject>();
        for (String name : names) {
            int offset = this.calculateOffset(json, dataLength, objectType, name);
            if (offset == -1) continue;
            HisPerfStatHisObject perfStatHisObject = new HisPerfStatHisObject();
            perfStatHisObject.setPeriod(period);
            perfStatHisObject.setObjectType(objectType);
            perfStatHisObject.setDataTypes(this.getDataTypes(json, objectType));
            perfStatHisObject.setName(name);
            oneDataBlockPerfStatHisObjects.add(perfStatHisObject);
        }
        return oneDataBlockPerfStatHisObjects;
    }

    private void initStartTime(List<HisPerfStatHisObject> perfStatHisObjects, long startTime) {
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            perfStatHisObject.setStartTime(startTime);
        }
    }

    public List<HisPerfStatHisObject> queryPerfStatHisObject(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, long maxDataLength) {
        List<HisPerfStatHisObject> perfStatHisObjects = this.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names);
        this.cutDownData(perfStatHisObjects, names, maxDataLength);
        return perfStatHisObjects;
    }

    private void alignPerfStatHisObjects(List<HisPerfStatHisObject> perfStatHisObjects) {
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            LinkedList<int[]> unionData = new LinkedList<int[]>();
            List<HisPerfStatObjectType.HisDataTypeEnum> unionDataTypes = this.getUnionDataTypes(perfStatHisObjects, perfStatHisObject.getObjectType(), perfStatHisObject.getName());
            List<int[]> srcData = perfStatHisObject.getData();
            List<HisPerfStatObjectType.HisDataTypeEnum> srcDataTypes = perfStatHisObject.getDataTypes();
            this.fillUnionData(unionData, unionDataTypes, srcData, srcDataTypes);
            perfStatHisObject.setDataTypes(unionDataTypes);
            perfStatHisObject.setData(unionData);
        }
    }

    private void fillUnionData(List<int[]> unionData, List<HisPerfStatObjectType.HisDataTypeEnum> unionDataTypes, List<int[]> srcData, List<HisPerfStatObjectType.HisDataTypeEnum> srcDataTypes) {
        for (int[] oneTimeSrcData : srcData) {
            int[] oneTimeUnionData = new int[unionDataTypes.size()];
            for (int i = 0; i < unionDataTypes.size(); ++i) {
                int pos = srcDataTypes.indexOf((Object)unionDataTypes.get(i));
                oneTimeUnionData[i] = pos != -1 ? oneTimeSrcData[pos] : 0xFFFFFF;
            }
            unionData.add(oneTimeUnionData);
        }
    }

    private List<HisPerfStatObjectType.HisDataTypeEnum> getUnionDataTypes(List<HisPerfStatHisObject> perfStatHisObjects, HisPerfStatObjectType.HisObjectTypeEnum objectType, String name) {
        ArrayList<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = new ArrayList<HisPerfStatObjectType.HisDataTypeEnum>();
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            dataTypes.removeAll(perfStatHisObject.getDataTypes());
            dataTypes.addAll(perfStatHisObject.getDataTypes());
        }
        return dataTypes;
    }

    private void cutDownData(List<HisPerfStatHisObject> perfStatHisObjects, List<String> names, long maxDataLength) {
        for (String name : names) {
            this.cutDownOneData(this.getPerfStatHisObjectByName(perfStatHisObjects, name), maxDataLength);
        }
    }

    private List<HisPerfStatHisObject> getPerfStatHisObjectByName(List<HisPerfStatHisObject> perfStatHisObjects, String name) {
        LinkedList<HisPerfStatHisObject> result = new LinkedList<HisPerfStatHisObject>();
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            if (!name.equals(perfStatHisObject.getName())) continue;
            result.add(perfStatHisObject);
        }
        return result;
    }

    private void cutDownOneData(List<HisPerfStatHisObject> perfStatHisObjects, long maxDataLength) {
        long length = this.getOneDataLength(perfStatHisObjects);
        if (length < maxDataLength) {
            return;
        }
        int i = (int)Math.ceil((double)length / (double)maxDataLength);
        List<int[]> data = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            data = perfStatHisObject.getData();
            int index = 0;
            int count = 0;
            while (index < data.size()) {
                if (count % i != 0) {
                    data.remove(index);
                    --index;
                }
                ++index;
                ++count;
            }
            perfStatHisObject.setPeriod(perfStatHisObject.getPeriod() * i);
        }
    }

    private long getOneDataLength(List<HisPerfStatHisObject> perfStatHisObjects) {
        long length = 0L;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            length += (long)perfStatHisObject.getData().size();
        }
        return length;
    }

    private void getDataSource(HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, RandomAccessFile raf, int dataLength, String json, int periodDataLength, List<HisPerfStatHisObject> oneDataBlockPerfStatHisObjects) throws IOException, JSONException {
        byte[] periodDataBuf = new byte[periodDataLength];
        raf.readFully(periodDataBuf);
        int offset = 0;
        HisPerfStatHisObject perfStatHisObject = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = null;
        int[] values = null;
        byte[] valueBuf = null;
        for (String name : names) {
            offset = this.calculateOffset(json, dataLength, objectType, name);
            if (offset == -1) continue;
            perfStatHisObject = this.findPerfStatHisObject(oneDataBlockPerfStatHisObjects, name);
            if (perfStatHisObject == null) {
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            dataTypes = perfStatHisObject.getDataTypes();
            values = new int[dataTypes.size()];
            for (int i = 0; i < dataTypes.size(); ++i) {
                valueBuf = new byte[dataLength];
                System.arraycopy(periodDataBuf, offset + i * dataLength, valueBuf, 0, valueBuf.length);
                values[i] = ByteUtil.bytes2int((byte[])valueBuf, (boolean)false);
            }
            perfStatHisObject.getData().add(values);
        }
    }

    public List<HisPerfStatHisObject> queryPerfStatHisObject(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes, long maxDataLength) {
        LinkedList<HisPerfStatHisObject> perfStatHisObjectsResult = new LinkedList<HisPerfStatHisObject>();
        List<HisPerfStatHisObject> perfStatHisObjects = this.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names, maxDataLength);
        HisPerfStatHisObject perfStatHisObjectResult = null;
        List<int[]> data = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> allDataTypes = null;
        LinkedList<int[]> dataResult = null;
        int[] valueResult = null;
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            perfStatHisObjectResult = new HisPerfStatHisObject();
            perfStatHisObjectResult.setStartTime(perfStatHisObject.getStartTime());
            perfStatHisObjectResult.setPeriod(perfStatHisObject.getPeriod());
            perfStatHisObjectResult.setObjectType(perfStatHisObject.getObjectType());
            perfStatHisObjectResult.setName(perfStatHisObject.getName());
            perfStatHisObjectResult.setDataTypes(dataTypes);
            data = perfStatHisObject.getData();
            allDataTypes = perfStatHisObject.getDataTypes();
            dataResult = new LinkedList<int[]>();
            for (int[] value : data) {
                valueResult = new int[dataTypes.size()];
                for (HisPerfStatObjectType.HisDataTypeEnum dataType : dataTypes) {
                    valueResult[dataTypes.indexOf((Object)((Object)dataType))] = value[allDataTypes.indexOf((Object)dataType)];
                }
                dataResult.add(valueResult);
            }
            perfStatHisObjectResult.setData(dataResult);
            perfStatHisObjectsResult.add(perfStatHisObjectResult);
        }
        return perfStatHisObjectsResult;
    }

    public boolean mergePerfStatHisFile(String destFileName, List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        this.validateFiles(srcPerfStatHisFileInfos);
        List<long[]> allTlvInfos = this.getSortedTlvInfos(srcPerfStatHisFileInfos);
        byte[] buffer = new byte[0x100000];
        RandomAccessFile destRaf = null;
        try {
            byte[] deviceSnBuf = new byte[256];
            byte[] deviceSnBytes = srcPerfStatHisFileInfos.get(0).getDeviceSN().getBytes("UTF-8");
            System.arraycopy(deviceSnBytes, 0, deviceSnBuf, 0, deviceSnBytes.length);
            byte[] deviceNameBuf = new byte[41];
            HisPerfStatHisFileInfo perfStatHisFileInfo = this.getLatestPerfStatHisFileInfo(srcPerfStatHisFileInfos);
            if (perfStatHisFileInfo == null) {
                LOGGER.error((Object)"Get Latest PerfStatHisFileInfo failed. ");
                boolean bl = false;
                return bl;
            }
            byte[] deviceNameBytes = perfStatHisFileInfo.getDeviceName().getBytes("UTF-8");
            System.arraycopy(deviceNameBytes, 0, deviceNameBuf, 0, deviceNameBytes.length);
            destRaf = this.open(destFileName);
            destRaf.writeBytes(srcPerfStatHisFileInfos.get(0).getCheckCode());
            destRaf.writeInt(ByteUtil.reverseInt((int)srcPerfStatHisFileInfos.get(0).getVersion()));
            destRaf.write(deviceSnBuf);
            destRaf.write(deviceNameBuf);
            destRaf.writeInt(ByteUtil.reverseInt((int)srcPerfStatHisFileInfos.get(0).getDataLength()));
            this.mergePerfStatHisFile1(srcPerfStatHisFileInfos, allTlvInfos, buffer, destRaf);
            boolean bl = true;
            this.close(destRaf);
            return bl;
        }
        catch (IOException e) {
            LOGGER.error((Object)"read data error", (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        catch (JSONException e) {
            LOGGER.error((Object)("performance history file json parse error :" + e.getMessage()), (Throwable)e);
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        finally {
            this.close(destRaf);
        }
    }

    private void mergePerfStatHisFile1(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos, List<long[]> allTlvInfos, byte[] buffer, RandomAccessFile destRaf) throws IOException, JSONException {
        int[] offsetAndLength = null;
        int offset = 0;
        int length = 0;
        for (long[] tlvInfo : allTlvInfos) {
            for (HisPerfStatHisFileInfo perfStatHisFileInfo : srcPerfStatHisFileInfos) {
                offsetAndLength = this.findData(perfStatHisFileInfo, tlvInfo[0], tlvInfo[1], tlvInfo[2]);
                offset = offsetAndLength[0];
                length = offsetAndLength[1];
                this.mergePerfStatHisFile2(buffer, destRaf, perfStatHisFileInfo, offset, length);
            }
        }
    }

    private void mergePerfStatHisFile2(byte[] buffer, RandomAccessFile destRaf, HisPerfStatHisFileInfo perfStatHisFileInfo, int offset, int length) throws IOException {
        if (offset != -1) {
            RandomAccessFile srcRaf = null;
            try {
                srcRaf = this.open(perfStatHisFileInfo.getFileName());
                int skipedLength = srcRaf.skipBytes(offset);
                if (skipedLength != offset) {
                    throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
                }
                while (length > 0) {
                    int readLength;
                    if (length >= 0x100000) {
                        readLength = srcRaf.read(buffer);
                        destRaf.write(buffer);
                        length -= readLength;
                        continue;
                    }
                    readLength = srcRaf.read(buffer, 0, length);
                    destRaf.write(buffer, 0, length);
                    length -= readLength;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"read data error", (Throwable)e);
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            finally {
                this.close(srcRaf);
            }
        }
    }

    private HisPerfStatHisFileInfo getLatestPerfStatHisFileInfo(List<HisPerfStatHisFileInfo> perfStatHisFileInfos) {
        HisPerfStatHisFileInfo perfStatHisFileInfoResult = null;
        for (HisPerfStatHisFileInfo perfStatHisFileInfo : perfStatHisFileInfos) {
            if (perfStatHisFileInfoResult == null) {
                perfStatHisFileInfoResult = perfStatHisFileInfo;
                continue;
            }
            if (perfStatHisFileInfo.getStartTime() <= perfStatHisFileInfoResult.getStartTime()) continue;
            perfStatHisFileInfoResult = perfStatHisFileInfo;
        }
        return perfStatHisFileInfoResult;
    }

    private void validateFiles(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        if (this.containSameFile(srcPerfStatHisFileInfos)) {
            throw new IsmException(HisResourceManager.getString("HIS_FILE_SAME"));
        }
        if (this.containDifferentDeviceSn(srcPerfStatHisFileInfos)) {
            throw new IsmException(HisResourceManager.getString("HIS_FILE_DEV_SN_INVALID"));
        }
        if (this.containDifferentPeriod(srcPerfStatHisFileInfos)) {
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PERIOD_INVALID"));
        }
        if (this.calculateTotalSize(srcPerfStatHisFileInfos) > 524288000L) {
            throw new IsmException(HisResourceManager.getStringWithParams("perf.error.mergeFilesTotalSizeTooLarge", String.valueOf(500)));
        }
        List<long[]> allTlvInfos = this.getSortedTlvInfos(srcPerfStatHisFileInfos);
        if (this.isDataTimeSeparateTooLong(allTlvInfos)) {
            throw new IsmException(HisResourceManager.getString("perf.error.dataSeparateTooLong"));
        }
    }

    private List<long[]> getSortedTlvInfos(List<HisPerfStatHisFileInfo> perfStatHisFileInfos) {
        this.tlvInfos = new LinkedList<long[]>();
        for (HisPerfStatHisFileInfo perfStatHisFileInfo : perfStatHisFileInfos) {
            this.tlvInfos.addAll(this.clone(perfStatHisFileInfo.getTlvInfos()));
        }
        this.sortTlvInfoByStartTime(this.tlvInfos);
        return this.tlvInfos;
    }

    private List<long[]> clone(List<long[]> tlvInfors) {
        ArrayList<long[]> tlvInfosResult = new ArrayList<long[]>(0);
        for (long[] tlvInfo : tlvInfors) {
            long[] tlvInfoResult = new long[tlvInfo.length];
            tlvInfoResult[0] = tlvInfo[0];
            tlvInfoResult[1] = tlvInfo[1];
            tlvInfoResult[2] = tlvInfo[2];
            tlvInfosResult.add(tlvInfoResult);
        }
        return tlvInfosResult;
    }

    private void sortTlvInfoByStartTime(List<long[]> dataStartAndEndTime) {
        long startTime1 = 0L;
        long startTime2 = 0L;
        for (int i = 0; i < dataStartAndEndTime.size(); ++i) {
            for (int j = 0; j < dataStartAndEndTime.size() - 1 - i; ++j) {
                startTime1 = dataStartAndEndTime.get(j)[0];
                if (startTime1 <= (startTime2 = dataStartAndEndTime.get(j + 1)[0])) continue;
                this.swap(dataStartAndEndTime.get(j), dataStartAndEndTime.get(j + 1));
            }
        }
    }

    private void swap(long[] aLong, long[] bLongs) {
        long[] tLong = new long[]{aLong[0], aLong[1], aLong[2]};
        aLong[0] = bLongs[0];
        aLong[1] = bLongs[1];
        aLong[2] = bLongs[2];
        bLongs[0] = tLong[0];
        bLongs[1] = tLong[1];
        bLongs[2] = tLong[2];
    }

    private boolean containSameFile(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        String fileName1 = null;
        String fileName2 = null;
        for (int i = 0; i < srcPerfStatHisFileInfos.size(); ++i) {
            for (int j = i + 1; j < srcPerfStatHisFileInfos.size(); ++j) {
                fileName1 = srcPerfStatHisFileInfos.get(i).getCompressedFileName();
                if (!fileName1.equals(fileName2 = srcPerfStatHisFileInfos.get(j).getCompressedFileName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containDifferentDeviceSn(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        String deviceSn2 = null;
        String deviceSn1 = null;
        for (int i = 0; i < srcPerfStatHisFileInfos.size() - 1; ++i) {
            deviceSn1 = srcPerfStatHisFileInfos.get(i).getDeviceSN();
            if (deviceSn1.equals(deviceSn2 = srcPerfStatHisFileInfos.get(i + 1).getDeviceSN())) continue;
            return true;
        }
        return false;
    }

    private boolean containDifferentPeriod(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        int period1 = 0;
        int period2 = 0;
        for (int i = 0; i < srcPerfStatHisFileInfos.size() - 1; ++i) {
            period1 = srcPerfStatHisFileInfos.get(i).getPeriod();
            if (period1 == (period2 = srcPerfStatHisFileInfos.get(i + 1).getPeriod())) continue;
            return true;
        }
        return false;
    }

    private boolean isDataTimeSeparateTooLong(List<long[]> tlvInfoes) {
        long[] tlvInfo2 = null;
        long[] tlvInfo1 = null;
        for (int i = 0; i < tlvInfoes.size() - 1; ++i) {
            tlvInfo1 = tlvInfoes.get(i);
            tlvInfo2 = tlvInfoes.get(i + 1);
            if (tlvInfo2[0] - tlvInfo1[1] <= 31536000000L) continue;
            return true;
        }
        return false;
    }

    private long calculateTotalSize(List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        long totalSize = 0L;
        for (HisPerfStatHisFileInfo perfStatHisFileInfo : srcPerfStatHisFileInfos) {
            totalSize += perfStatHisFileInfo.getCompressedSize();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findData(HisPerfStatHisFileInfo perfStatHisFileInfo, long dataStartTime, long dataEndTime, long controllerId) throws IOException, JSONException {
        int[] offsetAndLength = new int[]{-1, -1};
        List<long[]> tlvInfoes = perfStatHisFileInfo.getTlvInfos();
        RandomAccessFile raf = null;
        byte[] headerBuf = null;
        byte[] dataLengthBuf = null;
        int dataLength = 0;
        for (long[] tlvInfo : tlvInfoes) {
            if (tlvInfo[0] != dataStartTime || tlvInfo[1] != dataEndTime || tlvInfo[2] != controllerId) continue;
            offsetAndLength = new int[]{-1, -1};
            raf = null;
            try {
                raf = this.open(perfStatHisFileInfo.getFileName());
                headerBuf = new byte[337];
                raf.readFully(headerBuf);
                dataLengthBuf = new byte[4];
                System.arraycopy(headerBuf, 333, dataLengthBuf, 0, dataLengthBuf.length);
                dataLength = ByteUtil.bytes2int((byte[])dataLengthBuf, (boolean)false);
                if (null == (offsetAndLength = this.findData1(dataStartTime, dataEndTime, offsetAndLength, raf, dataLength))) continue;
                int[] nArray = offsetAndLength;
                return nArray;
            }
            finally {
                this.close(raf);
            }
        }
        if (null == offsetAndLength) {
            offsetAndLength = new int[]{-1, -1};
        }
        return offsetAndLength;
    }

    private int[] findData1(long dataStartTime, long dataEndTime, int[] offsetAndLength, RandomAccessFile raf, int dataLength) throws IOException, JSONException {
        int skipedLength = 0;
        byte[] tlvLengthBuf = null;
        int tlvLength = 0;
        byte[] jsonBuf = null;
        String json = null;
        JSONObject jsonObj = null;
        int offset = 0;
        int dataBlockLength = 0;
        long dataEndTimeTmp = 0L;
        long dataStartTimeTmp = 0L;
        while (raf.getFilePointer() < raf.length()) {
            skipedLength = raf.skipBytes(4);
            if (skipedLength != 4) {
                throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
            }
            tlvLengthBuf = new byte[4];
            raf.readFully(tlvLengthBuf);
            tlvLength = ByteUtil.bytes2int((byte[])tlvLengthBuf, (boolean)false);
            jsonBuf = new byte[tlvLength - 4 - 4];
            raf.readFully(jsonBuf);
            json = new String(jsonBuf, "UTF-8").trim();
            jsonObj = new JSONObject(json);
            dataStartTimeTmp = Long.parseLong(jsonObj.get("StartTime").toString().trim()) * 1000L;
            dataEndTimeTmp = Long.parseLong(jsonObj.get("EndTime").toString().trim()) * 1000L;
            dataBlockLength = this.calculateDataBlockLength(json, dataLength);
            if (dataStartTime == dataStartTimeTmp && dataEndTime == dataEndTimeTmp) {
                offsetAndLength[0] = offset = (int)(raf.getFilePointer() - (long)tlvLength);
                offsetAndLength[1] = tlvLength + dataBlockLength;
                return offsetAndLength;
            }
            skipedLength = raf.skipBytes(dataBlockLength);
            if (skipedLength == dataBlockLength) continue;
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        return new int[0];
    }

    private int calculateDataBlockLength(String json, int dataLength) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        long dataStartTime = Long.parseLong(jsonObj.get("StartTime").toString().trim()) * 1000L;
        long dataEndTime = Long.parseLong(jsonObj.get("EndTime").toString().trim()) * 1000L;
        int period = Integer.parseInt(jsonObj.get("Archive").toString().trim()) * 1000;
        if (0 == period) {
            LOGGER.warn((Object)"Period is zero.");
            throw new IsmException(HisResourceManager.getString("HIS_FILE_PARSE_ERROR"));
        }
        int dataBlockLength = 0;
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypes = objectMap.keys();
        String objectTypeString = null;
        JSONObject objectTypeMap = null;
        JSONArray dataTypesJSONArray = null;
        int periodCount = 0;
        JSONArray namesJSONArray = null;
        while (objectTypes.hasNext()) {
            objectTypeString = (String)objectTypes.next();
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            namesJSONArray = objectTypeMap.getJSONArray("Names");
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            periodCount = (int)((dataEndTime - dataStartTime) / (long)period);
            dataBlockLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength * periodCount;
        }
        return dataBlockLength;
    }

    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> mergeObjectTypeToDataTypesMapping(Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> destMapping, Map<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> srcMapping) {
        Iterator<Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>>> it = srcMapping.entrySet().iterator();
        Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<HisPerfStatObjectType.HisDataTypeEnum>> entry = null;
        HisPerfStatObjectType.HisObjectTypeEnum objectType = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> srcDataTypes = null;
        List<HisPerfStatObjectType.HisDataTypeEnum> destDataTypes = null;
        while (it.hasNext()) {
            entry = it.next();
            objectType = entry.getKey();
            if (destMapping.keySet().contains((Object)objectType)) {
                destDataTypes = destMapping.get((Object)objectType);
                srcDataTypes = srcMapping.get((Object)objectType);
                for (HisPerfStatObjectType.HisDataTypeEnum srcDataType : srcDataTypes) {
                    if (destDataTypes.contains((Object)srcDataType)) continue;
                    destMapping.get((Object)objectType).add(srcDataType);
                }
                continue;
            }
            destMapping.put(objectType, srcMapping.get((Object)objectType));
        }
        return destMapping;
    }

    private Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> mergeObjectTypeToNamesMapping(Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> destMapping, Map<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> srcMapping) {
        Iterator<Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<String>>> it = srcMapping.entrySet().iterator();
        List<String> srcNames = null;
        List<String> destNames = null;
        Map.Entry<HisPerfStatObjectType.HisObjectTypeEnum, List<String>> entry = null;
        while (it.hasNext()) {
            entry = it.next();
            HisPerfStatObjectType.HisObjectTypeEnum objectType = entry.getKey();
            if (destMapping.keySet().contains((Object)objectType)) {
                destNames = destMapping.get((Object)objectType);
                srcNames = srcMapping.get((Object)objectType);
                for (String srcName : srcNames) {
                    if (destNames.contains(srcName)) continue;
                    destMapping.get((Object)objectType).add(srcName);
                }
                continue;
            }
            destMapping.put(objectType, srcMapping.get((Object)objectType));
        }
        return destMapping;
    }

    private List<HisPerfStatObjectType.HisObjectTypeEnum> mergeObjectTypes(List<HisPerfStatObjectType.HisObjectTypeEnum> destObjectTypes, List<HisPerfStatObjectType.HisObjectTypeEnum> srcObjectTypes) {
        for (HisPerfStatObjectType.HisObjectTypeEnum objectType : srcObjectTypes) {
            if (destObjectTypes.contains((Object)objectType)) continue;
            destObjectTypes.add(objectType);
        }
        return destObjectTypes;
    }

    private HisPerfStatHisObject findPerfStatHisObject(List<HisPerfStatHisObject> perfStatHisObjects, String name) {
        for (HisPerfStatHisObject perfStatHisObject : perfStatHisObjects) {
            if (!perfStatHisObject.getName().equals(name)) continue;
            return perfStatHisObject;
        }
        return null;
    }

    private int calculateOffset(String json, int dataLength, HisPerfStatObjectType.HisObjectTypeEnum objectType, String name) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        int offset = 0;
        List objectTypeStrings = ByteUtil.getTypeIntgers((String)json);
        JSONObject objectTypeMap = null;
        JSONArray namesJSONArray = null;
        JSONArray idsJSONArray = null;
        JSONArray dataTypesJSONArray = null;
        HisPerfStatObjectType.HisObjectTypeEnum objectTypeTmp = null;
        String nameTmp = null;
        for (String objectTypeString : objectTypeStrings) {
            try {
                objectTypeTmp = HisPerfStatObjectType.HisObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"NumberFormatException");
                continue;
            }
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            namesJSONArray = objectTypeMap.getJSONArray("Names");
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            JSONArray jSONArray = idsJSONArray = objectTypeMap.has("IDs") ? objectTypeMap.getJSONArray("IDs") : null;
            if (objectType != objectTypeTmp) {
                offset += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength;
                continue;
            }
            for (int i = 0; i < namesJSONArray.length(); ++i) {
                nameTmp = namesJSONArray.getString(i);
                if (idsJSONArray != null && nameTmp.equals("")) {
                    String objectTypeName = objectTypeString.equals("263") ? "ReplicationPair-" : "";
                    nameTmp = objectTypeName + idsJSONArray.getString(i);
                }
                if (!name.equals(nameTmp)) {
                    offset += dataTypesJSONArray.length() * dataLength;
                    continue;
                }
                return offset;
            }
        }
        return -1;
    }

    private int calculatePeriodDataLength(String json, int dataLength) throws JSONException {
        JSONObject jsonObj = new JSONObject(json);
        int onePeriodDataLength = 0;
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypes = objectMap.keys();
        String objectTypeString = null;
        JSONObject objectTypeMap = null;
        JSONArray namesJSONArray = null;
        JSONArray dataTypesJSONArray = null;
        while (objectTypes.hasNext()) {
            objectTypeString = (String)objectTypes.next();
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            namesJSONArray = objectTypeMap.getJSONArray("Names");
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            onePeriodDataLength += namesJSONArray.length() * dataTypesJSONArray.length() * dataLength;
        }
        return onePeriodDataLength;
    }

    private List<HisPerfStatObjectType.HisDataTypeEnum> getDataTypes(String json, HisPerfStatObjectType.HisObjectTypeEnum objectType) throws JSONException {
        LinkedList<HisPerfStatObjectType.HisDataTypeEnum> dataTypes = new LinkedList<HisPerfStatObjectType.HisDataTypeEnum>();
        JSONObject jsonObj = new JSONObject(json);
        JSONObject objectMap = jsonObj.getJSONObject("Map");
        Iterator objectTypesIt = objectMap.keys();
        String objectTypeString = null;
        JSONObject objectTypeMap = null;
        JSONArray dataTypesJSONArray = null;
        HisPerfStatObjectType.HisDataTypeEnum dataType = null;
        HisPerfStatObjectType.HisObjectTypeEnum objectTypeTmp = null;
        while (objectTypesIt.hasNext()) {
            objectTypeString = (String)objectTypesIt.next();
            objectTypeMap = objectMap.getJSONObject(objectTypeString);
            try {
                objectTypeTmp = HisPerfStatObjectType.HisObjectTypeEnum.valueOf(Integer.parseInt(objectTypeString));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"NumberFormatException");
                continue;
            }
            if (objectTypeTmp != objectType) continue;
            dataTypesJSONArray = objectTypeMap.getJSONArray("DataTypes");
            for (int i = 0; i < dataTypesJSONArray.length(); ++i) {
                try {
                    dataType = HisPerfStatObjectType.HisDataTypeEnum.valueOf((int)dataTypesJSONArray.getDouble(i));
                    if (dataTypes.contains((Object)dataType) && !HisPerfStatObjectType.HisDataTypeEnum.UNKNOWN_DATA_TYPE.equals((Object)dataType)) continue;
                    dataTypes.add(dataType);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("the datatype is not support : " + dataTypesJSONArray.getInt(i)));
                }
            }
        }
        return dataTypes;
    }
}

