/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.proxy;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.ui.module.perfhis.HisTools;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisThreshold;
import com.huawei.ism.ui.module.perfhis.util.GetResultTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;

public class HisPerfStatHisThresholdProxy {
    private static final Logger LOGGER = Logger.getLogger(HisPerfStatHisThresholdProxy.class);
    private static final String THRESHOLDS_FILE_NAME = "config/framework/configuration/perfStat/perfStat.dat";
    private static final String SEPARATOR = ",";
    private static final String COMMENT_SIGN = "#";

    public static List<HisPerfStatHisThreshold> getAll() {
        LinkedList<HisPerfStatHisThreshold> perfStatHisThresholds = new LinkedList<HisPerfStatHisThreshold>();
        List<String> lines = HisPerfStatHisThresholdProxy.readFileByLines();
        String[] items = null;
        HisPerfStatHisThreshold perfStatHisThreshold = null;
        for (String line : lines) {
            if ("".equals(line) || line.startsWith(COMMENT_SIGN)) continue;
            items = line.split(SEPARATOR);
            try {
                if (items.length <= 5) continue;
                perfStatHisThreshold = new HisPerfStatHisThreshold();
                perfStatHisThreshold.setId(Integer.parseInt(items[0].trim()));
                perfStatHisThreshold.setObjectType(HisPerfStatObjectType.HisObjectTypeEnum.getHisObjectTypeEnum(items[1].trim()));
                perfStatHisThreshold.setDataType(HisPerfStatObjectType.HisDataTypeEnum.getHisDataTypeEnum(items[2].trim()));
                perfStatHisThreshold.setRecommendValue(HisTools.convertStringToInteger(items[3].trim()));
                perfStatHisThreshold.setValue(HisTools.convertStringToInteger(items[4].trim()));
                perfStatHisThreshold.setUnit(items[5].trim());
                perfStatHisThresholds.add(perfStatHisThreshold);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"NumberFormatException");
            }
        }
        return perfStatHisThresholds;
    }

    public static boolean updateAll(List<HisPerfStatHisThreshold> perfStatHisThresholds) {
        List<String> lines = HisPerfStatHisThresholdProxy.readFileByLines();
        int id = 0;
        String line = null;
        String newLine = null;
        for (HisPerfStatHisThreshold perfStatHisThreshold : perfStatHisThresholds) {
            id = perfStatHisThreshold.getId();
            for (int index = 0; index < lines.size(); ++index) {
                line = lines.get(index);
                if (!HisPerfStatHisThresholdProxy.isSpecifiedLine(line, id)) continue;
                newLine = HisPerfStatHisThresholdProxy.convertPerfStatHisThresholdToLine(perfStatHisThreshold);
                lines.remove(index);
                lines.add(index, newLine);
            }
        }
        return HisPerfStatHisThresholdProxy.saveFileByLines(lines);
    }

    public static Integer findByObjectTypeAndDataType(HisPerfStatObjectType.HisObjectTypeEnum objectType, HisPerfStatObjectType.HisDataTypeEnum dataType) {
        if (objectType == null || dataType == null) {
            return null;
        }
        List<HisPerfStatHisThreshold> perfStatHisThresholds = HisPerfStatHisThresholdProxy.getAll();
        for (HisPerfStatHisThreshold perfStatHisThreshold : perfStatHisThresholds) {
            if (perfStatHisThreshold == null || !objectType.equals((Object)perfStatHisThreshold.getObjectType()) || !dataType.equals((Object)perfStatHisThreshold.getDataType())) continue;
            return perfStatHisThreshold.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readFileByLines() {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader br = null;
        LineIterator li = null;
        try {
            String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(absoluteFile), "UTF-8"));
            li = new LineIterator(br);
            String line = null;
            while (li.hasNext()) {
                line = li.nextLine();
                if (line == null) continue;
                lines.add(line.trim());
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
        catch (Exception e) {
            LOGGER.error((Object)("IOException: " + e.toString()));
            LinkedList<String> linkedList = new LinkedList<String>();
            return linkedList;
        }
        finally {
            if (li != null) {
                try {
                    li.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("IOException: " + e.toString()));
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("IOException: " + e.toString()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean saveFileByLines(List<String> lines) {
        BufferedWriter bw = null;
        try {
            String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(absoluteFile), "UTF-8"));
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error((Object)("IOException: " + e.toString()));
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("IOException: " + e.toString()));
                }
            }
        }
    }

    private static boolean isSpecifiedLine(String line, int id) {
        if (line == null) {
            return false;
        }
        try {
            String[] items = line.split(SEPARATOR);
            return Integer.parseInt(items[0]) == id;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String convertPerfStatHisThresholdToLine(HisPerfStatHisThreshold perfStatHisThreshold) {
        if (perfStatHisThreshold == null) {
            return "";
        }
        String line = "";
        line = line + perfStatHisThreshold.getId() + SEPARATOR;
        line = line + HisPerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getObjectType().getName()) + SEPARATOR;
        line = line + HisPerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getDataType().getName()) + SEPARATOR;
        line = line + HisTools.convertIntegerToString(perfStatHisThreshold.getRecommendValue()) + SEPARATOR;
        line = line + HisTools.convertIntegerToString(perfStatHisThreshold.getValue()) + SEPARATOR;
        line = line + HisPerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getUnit());
        return line;
    }

    private static String noNullString(String string) {
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
        File file = new File(absoluteFile);
        if (!file.exists()) {
            byte[] buffer = new byte[512];
            InputStream is = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                ClassLoader cls = HisPerfStatHisThresholdProxy.class.getClassLoader();
                if (null != cls) {
                    is = cls.getResourceAsStream(THRESHOLDS_FILE_NAME);
                }
                bis = new BufferedInputStream(is);
                if (!file.getParentFile().mkdirs()) {
                    LOGGER.info((Object)"create new threshold dir fail.");
                    throw new IOException();
                }
                if (!file.createNewFile()) {
                    LOGGER.info((Object)"create new threshold file fail.");
                    throw new IOException();
                }
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                int length = 0;
                while ((length = bis.read(buffer)) > 0) {
                    ((BufferedOutputStream)bos).write(buffer, 0, length);
                    ((BufferedOutputStream)bos).flush();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("copy threshold file from jar to client error:" + e.getMessage()), (Throwable)e);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("copy threshold file from jar to client error:" + e.getMessage()), (Throwable)e);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("copy threshold file from jar to client error:" + e.getMessage()), (Throwable)e);
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("copy threshold file from jar to client error:" + e.getMessage()), (Throwable)e);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("copy threshold file from jar to client error:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }

    public static final class UpdateAllTask
    extends GetResultTask {
        private final List<HisPerfStatHisThreshold> perfStatHisThresholds;

        public UpdateAllTask(List<HisPerfStatHisThreshold> perfStatHisThresholds) {
            this.perfStatHisThresholds = perfStatHisThresholds;
        }

        public Object call() {
            try {
                this.setExecuteResult(HisPerfStatHisThresholdProxy.updateAll(this.perfStatHisThresholds));
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }
}

