/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.service;

import com.huawei.ism.common.bean.HisPerfStatObjectType;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisObject;
import com.huawei.ism.ui.module.perfhis.proxy.HisPerfStatHisFileProxy;
import com.huawei.ism.ui.module.perfhis.util.GetResultTask;
import com.huawei.util.HisUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class PerfStatHisFileService {
    private static final Logger LOGGER = Logger.getLogger(PerfStatHisFileService.class);
    private static HisPerfStatHisFileProxy hisPerfStatHisFileProxy = new HisPerfStatHisFileProxy();

    public static List<HisPerfStatHisFileInfo> queryPerfStatHisFileInfo(File[] files) {
        LinkedList<HisPerfStatHisFileInfo> perfStatHisFileInfos = new LinkedList<HisPerfStatHisFileInfo>();
        String extractedFileName = null;
        HisPerfStatHisFileInfo perfStatHisFileInfo = null;
        for (int i = 0; i < files.length; ++i) {
            String fileName = "";
            try {
                fileName = files[i].getCanonicalPath();
            }
            catch (Exception e) {
                LOGGER.error((Object)"get fileName error.", (Throwable)e);
                continue;
            }
            extractedFileName = HisUtil.decompress(fileName);
            if (extractedFileName == null) continue;
            perfStatHisFileInfo = hisPerfStatHisFileProxy.queryPerfStatHisFileInfo(extractedFileName);
            perfStatHisFileInfo.setCompressedSize(files[i].length());
            perfStatHisFileInfo.setCompressedFileName(fileName);
            perfStatHisFileInfos.add(perfStatHisFileInfo);
        }
        return perfStatHisFileInfos;
    }

    public static void populateObjectNamesAndDataTypes(HisPerfStatHisFileInfo perfStatHisFileInfo) {
        hisPerfStatHisFileProxy.populateObjectNamesAndDataTypes(perfStatHisFileInfo);
    }

    public static void mergePerfStatHisFile(String destFileName, List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
        String deCompressedFileName = destFileName;
        int pos = 0;
        if (destFileName.endsWith(".tgz")) {
            pos = destFileName.lastIndexOf(".tgz");
        } else if (destFileName.endsWith(".bz2")) {
            pos = destFileName.lastIndexOf(".bz2");
        }
        deCompressedFileName = deCompressedFileName.substring(0, pos) + ".dat";
        hisPerfStatHisFileProxy.mergePerfStatHisFile(deCompressedFileName, srcPerfStatHisFileInfos);
        HisUtil.compress(deCompressedFileName, destFileName);
        File file = new File(deCompressedFileName);
        if (file.exists() && !file.delete()) {
            LOGGER.info((Object)"delete performance temporary file fail.");
        }
    }

    public static List<HisPerfStatHisObject> queryPerfStatHisObject(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes, long maxDataLength) {
        return hisPerfStatHisFileProxy.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names, dataTypes, maxDataLength);
    }

    public static List<HisPerfStatHisObject> queryPerfStatHisObject(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, long maxDataLength) {
        return hisPerfStatHisFileProxy.queryPerfStatHisObject(perfStatHisFileInfo, objectType, names, maxDataLength);
    }

    public static final class QueryPerfStatHisObjectTask
    extends GetResultTask {
        private final HisPerfStatHisFileInfo perfStatHisFileInfo;
        private final HisPerfStatObjectType.HisObjectTypeEnum objectType;
        private final List<String> names;
        private final List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes;
        private final long maxDataLength;

        public QueryPerfStatHisObjectTask(HisPerfStatHisFileInfo perfStatHisFileInfo, HisPerfStatObjectType.HisObjectTypeEnum objectType, List<String> names, List<HisPerfStatObjectType.HisDataTypeEnum> dataTypes, long maxDataLength) {
            this.perfStatHisFileInfo = perfStatHisFileInfo;
            this.objectType = objectType;
            this.names = names;
            this.dataTypes = dataTypes;
            this.maxDataLength = maxDataLength;
        }

        public Object call() {
            try {
                this.setExecuteResult(PerfStatHisFileService.queryPerfStatHisObject(this.perfStatHisFileInfo, this.objectType, this.names, this.dataTypes, this.maxDataLength));
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }

    public static final class MergePerfStatHisFileTask
    extends GetResultTask {
        private final String destFileName;
        private final List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos;

        public MergePerfStatHisFileTask(String destFileName, List<HisPerfStatHisFileInfo> srcPerfStatHisFileInfos) {
            this.destFileName = destFileName;
            this.srcPerfStatHisFileInfos = srcPerfStatHisFileInfos;
        }

        public Object call() {
            try {
                PerfStatHisFileService.mergePerfStatHisFile(this.destFileName, this.srcPerfStatHisFileInfos);
                this.setExecuteResult(null);
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }

    public static final class QueryPerfStatHisFileInfoTask
    extends GetResultTask {
        private File[] files;

        public QueryPerfStatHisFileInfoTask(File[] files) {
            this.files = (File[])files.clone();
        }

        public Object call() {
            try {
                this.setExecuteResult(PerfStatHisFileService.queryPerfStatHisFileInfo(this.files));
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }

    public static final class PopulateObjectNamesAndDataTypesTask
    extends GetResultTask {
        private final HisPerfStatHisFileInfo perfStatHisFileInfo;

        public PopulateObjectNamesAndDataTypesTask(HisPerfStatHisFileInfo perfStatHisFileInfo) {
            this.perfStatHisFileInfo = perfStatHisFileInfo;
        }

        public Object call() {
            try {
                PerfStatHisFileService.populateObjectNamesAndDataTypes(this.perfStatHisFileInfo);
                this.setExecuteResult(this.perfStatHisFileInfo);
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }
}

