/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.util;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import utils.FilesUtil;

public class TarUtils {
    private static final Logger LOGGER = Logger.getLogger(TarUtils.class);
    private static final int BUFFER_LENGTH = 0x100000;

    /*
     * Exception decompiling
     */
    public static String extract(File file, String outputDir) throws IsmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void readAndExtract(BufferedInputStream bis, byte[] byteArray, File tempFile) {
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int number;
            long totalSize = 0L;
            long maxSize = ApplicationContext.getInstance().getMaxUnzipFileSize();
            while ((number = bis.read(byteArray)) != -1) {
                bos.write(byteArray, 0, number);
                if (maxSize == 0L || (totalSize += (long)number) <= maxSize) continue;
                LOGGER.error((Object)"Current file unzip size  is too larger than limit.");
                throw new IOException("File too larger.");
            }
        }
        catch (IOException e) {
            throw new IsmException(HisResourceManager.getString("FILE_EXTRACT_ERROR_TXT"), (Throwable)e);
        }
    }

    private static InputStream getZipInputStream(File file, FileInputStream fis) throws IOException {
        GZIPInputStream gis = file.getName().toLowerCase(Locale.getDefault()).endsWith(".tgz") ? new GZIPInputStream(fis) : new BZip2CompressorInputStream((InputStream)fis);
        return gis;
    }

    private static String checkFile(String entryName, File tempFile) {
        boolean result;
        LOGGER.warn((Object)entryName);
        String retName = FilesUtil.getCanonicalPath((File)tempFile);
        if (tempFile.exists() && !(result = tempFile.delete())) {
            throw new SecurityException();
        }
        return retName;
    }

    public static void compress(File inputFile, String targetFilePath) throws IsmException {
        File tempFile = new File(targetFilePath + "tmp.tar");
        try {
            boolean result;
            if (tempFile.exists() && !(result = tempFile.delete())) {
                throw new SecurityException();
            }
            TarUtils.packTarFile(inputFile, tempFile);
            TarUtils.compressToGzip(tempFile, new File(targetFilePath));
        }
        catch (Exception e) {
            throw new IsmException(HisResourceManager.getString("FILE_COMPRESS_ERROR_TXT"), (Throwable)e);
        }
        finally {
            boolean result = tempFile.delete();
            if (!result) {
                LOGGER.warn((Object)("delete file failed. file:" + tempFile));
            }
        }
    }

    private static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("close Stream error:" + e.getMessage()));
        }
    }

    private static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("close Stream error:" + e.getMessage()));
        }
    }

    private static void packTarFile(File inputFile, File outputFile) throws IOException {
        TarEntry tarEntry = new TarEntry(inputFile.getName());
        tarEntry.setSize(inputFile.length());
        int number = 0;
        try (FileInputStream fis = new FileInputStream(inputFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             TarOutputStream tos = new TarOutputStream((OutputStream)bos);){
            tos.putNextEntry(tarEntry);
            byte[] bArray = new byte[0x100000];
            while ((number = bis.read(bArray)) != -1) {
                tos.write(bArray, 0, number);
            }
            tos.closeEntry();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error:" + e.getMessage()));
        }
    }

    private static void compressToGzip(File srcFile, File target) throws IOException {
        try (FileInputStream fis = new FileInputStream(srcFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             FileOutputStream fos = new FileOutputStream(target);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             OutputStream gos = TarUtils.getZipOutputStream(target, bos);){
            int number = 0;
            byte[] bArray = new byte[0x100000];
            while ((number = bis.read(bArray)) != -1) {
                gos.write(bArray, 0, number);
            }
        }
    }

    private static OutputStream getZipOutputStream(File target, BufferedOutputStream bos) throws IOException {
        GZIPOutputStream gos = target.getName().toLowerCase(Locale.getDefault()).endsWith(".tgz") ? new GZIPOutputStream(bos) : new BZip2CompressorOutputStream((OutputStream)bos);
        return gos;
    }
}

