/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.StyledTextPane;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.log4j.Logger;

public final class HisConfirmDialog
extends IsmDialog {
    private static final Logger LOGGER = Logger.getLogger(HisConfirmDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int MAX_PARAM_LENGTH = 30;
    private static final int MAX_WIDTH_LENGTH = 368;
    private Font font = new Font("Dialog", 3, 14);
    private StyleContext styleContext = new StyleContext();
    private Layout layout;
    private JButton confirmButton;
    private JButton cancelButton;
    private boolean isConfirmPerformed;
    private int maxWidth = 368;

    private HisConfirmDialog(Window parent, Level level, Param param, String ... params) {
        super(parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(null, false, level, false, param, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private HisConfirmDialog(Frame parent, Level level, boolean bool, Param param, String ... params) {
        super((Window)parent);
        this.setTitle(null != level ? level.toString() : "");
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setModal(true);
        this.init(null, false, level, bool, param, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    private HisConfirmDialog(Dialog parent, Level level, Param param, String ... params) {
        super((Window)parent);
        this.setTitle(level.toString());
        this.setModal(true);
        this.init(null, false, level, false, param, params);
        this.setName("ISMV1R2_framework_uiComponent_IsmConfirmDialog");
    }

    public static HisConfirmDialog getConfirmDialog(Window parent, Level level, Param param, String ... params) {
        HisConfirmDialog dialog = new HisConfirmDialog(parent, level, param, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)parent);
        return dialog;
    }

    public static boolean showDialog(Window parent, Level level, Param param, String ... params) {
        HisConfirmDialog dialog = new HisConfirmDialog(parent, level, param, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    public static boolean showDialog(Dialog parent, Level level, Param param, String ... params) {
        HisConfirmDialog dialog = new HisConfirmDialog(parent, level, param, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    public static Param initParam(String desc, String result, String sugg) {
        return new Param(desc, result, sugg);
    }

    private void init(String confirmMes, boolean defaultSelect, Level level, boolean flag, Param param, String ... params) {
        if (null == level) {
            throw new IllegalArgumentException("Level can not be null");
        }
        this.layout = new Layout(level, confirmMes, defaultSelect);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.layout.setBackground(Color.WHITE);
        }
        this.getDialogContentPane().add(this.layout);
        String confirm = HisResourceManager.getString("COMMON.TXT.CONFIRM");
        this.confirmButton = UCD.createButton((String)confirm, (char)'O');
        String cancel = HisResourceManager.getString("COMMON.TXT.CANCEL");
        this.cancelButton = UCD.createButton((String)cancel, (char)'C');
        Box box = UCD.buildButtonBoxRight((JButton[][])new JButton[][]{{this.confirmButton, this.cancelButton}});
        this.getSouthBox().add(box);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.getRootPane().setFocusable(true);
        if (null == confirmMes) {
            this.confirmButton.setEnabled(level != Level.DANGER && level != Level.WARNING);
        }
        this.initStyles();
        ArrayList<StyledTextPane.Paragraph> paragraphs = new ArrayList<StyledTextPane.Paragraph>(0);
        String[] newParams = this.change(params);
        if (null != param.description && param.description.length() > 0) {
            paragraphs.add(this.createParagraph(param.description, false, params, newParams));
        }
        if (null != param.result && param.result.length() > 0) {
            paragraphs.add(this.createParagraph(param.result, flag, params, newParams));
        }
        if (null != param.suggestion && param.suggestion.length() > 0) {
            paragraphs.add(this.createParagraph(param.suggestion, false, params, newParams));
        }
        this.layout.textArea.setParagraph(paragraphs.toArray(new StyledTextPane.Paragraph[paragraphs.size()]));
        this.initListeners(level, confirmMes);
    }

    private void initListeners(Level level, String confirmMes) {
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HisConfirmDialog.this.isConfirmPerformed = false;
                HisConfirmDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HisConfirmDialog.this.isConfirmPerformed = false;
                HisConfirmDialog.this.dispose();
            }
        });
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HisConfirmDialog.this.isConfirmPerformed = true;
                HisConfirmDialog.this.dispose();
            }
        });
        if (null == confirmMes && (level == Level.DANGER || level == Level.WARNING)) {
            this.layout.confirmCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean isEnabled = HisConfirmDialog.this.layout.confirmCheckBox.isSelected();
                    HisConfirmDialog.this.confirmButton.setEnabled(isEnabled);
                }
            });
        }
    }

    private void initStyles() {
        Style def = this.styleContext.getStyle("default");
        Style paramStyle = this.styleContext.addStyle("param", def);
        StyleConstants.setItalic(paramStyle, true);
        StyleConstants.setAlignment(paramStyle, 1);
        StyleConstants.setSpaceAbove(paramStyle, 10.0f);
        StyleConstants.setSpaceBelow(paramStyle, 10.0f);
        StyleConstants.setFontSize(paramStyle, 14);
        StyleConstants.setBold(paramStyle, true);
        Style normalStyle = this.styleContext.addStyle("normal", def);
        StyleConstants.setFontSize(normalStyle, 12);
        StyleConstants.setSpaceAbove(normalStyle, 4.0f);
        StyleConstants.setSpaceBelow(normalStyle, 4.0f);
        StyleConstants.setFontFamily(normalStyle, "dialog");
    }

    private StyledTextPane.Paragraph createParagraph(String content, boolean flag, String[] params, String[] newParams) {
        ArrayList<StyledTextPane.Segment> segments = new ArrayList<StyledTextPane.Segment>(0);
        Style paramStyle = this.styleContext.getStyle("param");
        Style normalStyle = this.styleContext.getStyle("normal");
        if (null == params || 0 == params.length) {
            if (flag) {
                return new StyledTextPane.Paragraph(normalStyle, new StyledTextPane.Segment[]{new StyledTextPane.Segment(paramStyle, content)});
            }
            return new StyledTextPane.Paragraph(normalStyle, new StyledTextPane.Segment[]{new StyledTextPane.Segment(normalStyle, content)});
        }
        String collapsedIconPath = "/com/huawei/ism/ui/swing/plaf/icons/norm/tree_collapsed.png";
        String expandedIconPath = "/com/huawei/ism/ui/swing/plaf/icons/norm/tree_expanded.png";
        ImageIcon collapsed = new ImageIcon(((Object)((Object)this)).getClass().getResource(collapsedIconPath));
        ImageIcon expanded = new ImageIcon(((Object)((Object)this)).getClass().getResource(expandedIconPath));
        HashMap<String, StyledTextPane.Segment> paramSegments = new HashMap<String, StyledTextPane.Segment>(0);
        HashMap<String, StyledTextPane.Segment> iconSegments = new HashMap<String, StyledTextPane.Segment>(0);
        String key = null;
        Style iconStyle = null;
        JLabel label = null;
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            String newParam = newParams[i];
            key = "##" + (i <= 9 ? "0" : "") + i;
            paramSegments.put(key, new StyledTextPane.Segment(paramStyle, param));
            if (param.length() <= 30) continue;
            String shortParam = param.substring(0, 30) + "...";
            iconStyle = this.styleContext.addStyle(null, null);
            label = new JLabel(collapsed);
            label.setBorder(new EmptyBorder(0, 2, 6, 2));
            label.addMouseListener(new MyMouseAdapter(collapsed, expanded, newParam, shortParam, paramStyle, this.layout.textArea));
            StyleConstants.setComponent(iconStyle, label);
            StyledTextPane.Segment iconSegment = new StyledTextPane.Segment(iconStyle, " ");
            StyledTextPane.Segment paramSegment = new StyledTextPane.Segment(paramStyle, param.substring(0, 30) + "...");
            iconSegments.put(key, iconSegment);
            paramSegments.put(key, paramSegment);
        }
        List<String> segmentSeq = this.parseSegment(content);
        this.createParagraphDegread(segments, normalStyle, paramSegments, iconSegments, segmentSeq);
        if (flag) {
            return new StyledTextPane.Paragraph(paramStyle, segments.toArray(new StyledTextPane.Segment[segments.size()]));
        }
        return new StyledTextPane.Paragraph(normalStyle, segments.toArray(new StyledTextPane.Segment[segments.size()]));
    }

    private String[] change(String[] params) {
        if (params == null) {
            return new String[0];
        }
        String[] result = new String[params.length];
        int width = this.maxWidth - 30;
        int firstLineWidth = width - 24;
        for (int i = 0; i < params.length; ++i) {
            String s = params[i];
            StringBuffer temp = new StringBuffer();
            String[] results = this.getString(s, firstLineWidth);
            temp.append(results[0]);
            s = results[1];
            while (s != null) {
                results = this.getString(s, width);
                temp.append(System.lineSeparator()).append(results[0]);
                s = results[1];
            }
            result[i] = temp.toString();
        }
        return result;
    }

    private String[] getString(String str, int width) {
        int stringWidth = this.stringWidth(str);
        if (stringWidth <= width) {
            return new String[]{str, null};
        }
        int size = str.length();
        int cutSize = size * width / stringWidth;
        String temp = str.substring(0, cutSize);
        int currentWidth = this.stringWidth(temp);
        boolean lastOperIsAdd = false;
        while (!lastOperIsAdd || currentWidth <= width) {
            if (currentWidth <= width) {
                temp = str.substring(0, ++cutSize);
                currentWidth = this.stringWidth(temp);
                lastOperIsAdd = true;
                continue;
            }
            temp = temp.substring(0, --cutSize);
            currentWidth = this.stringWidth(temp);
            lastOperIsAdd = false;
        }
        temp = temp.substring(0, temp.length() - 1);
        str = str.substring(temp.length());
        return new String[]{temp, str};
    }

    private int stringWidth(String str) {
        return this.layout.textArea.getFontMetrics(this.font).stringWidth(str);
    }

    private void createParagraphDegread(List<StyledTextPane.Segment> segments, Style normalStyle, Map<String, StyledTextPane.Segment> paramSegments, Map<String, StyledTextPane.Segment> iconSegments, List<String> segmentSeq) {
        for (String segStr : segmentSeq) {
            if (iconSegments.containsKey(segStr)) {
                segments.add(iconSegments.get(segStr));
                segments.add(paramSegments.get(segStr));
                continue;
            }
            StyledTextPane.Segment segment = paramSegments.get(segStr);
            if (null == segment) {
                segments.add(new StyledTextPane.Segment(normalStyle, segStr));
                continue;
            }
            segments.add(segment);
        }
    }

    private List<String> parseSegment(String content) {
        ArrayList<String> segmentSeq = new ArrayList<String>(0);
        int index = -1;
        while ((index = content.indexOf("##")) >= 0) {
            if (index > 0) {
                segmentSeq.add(content.substring(0, index));
            }
            segmentSeq.add(content.substring(index, index + 4));
            content = content.substring(index + 4);
        }
        segmentSeq.add(content);
        return segmentSeq;
    }

    public boolean isConfirmPerformed() {
        return this.isConfirmPerformed;
    }

    public boolean isSelectedLinkage() {
        return this.layout.confirmCheckBox.isSelected();
    }

    private static Icon getIcon(Level level) {
        ImageIcon icon = HisResourceManager.getImage("comfirmdialog_question.png");
        switch (level) {
            case DANGER: {
                icon = HisResourceManager.getImage("comfirmdialog_danger.png");
                break;
            }
            case WARNING: {
                icon = HisResourceManager.getImage("comfirmdialog_warn.png");
                break;
            }
            case INFO: {
                icon = HisResourceManager.getImage("comfirmdialog_question.png");
                break;
            }
        }
        return icon;
    }

    public static boolean showDialog(Frame parent, Level level, Param param, boolean flag, String ... params) {
        HisConfirmDialog dialog = new HisConfirmDialog(parent, level, flag, param, params);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.toFront();
        SwingUtil.putParentCenter((Window)((Object)dialog), (Window)parent);
        dialog.setVisible(true);
        return dialog.isConfirmPerformed;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private Icon expanded;
        private Icon collapsed;
        private String param;
        private String shortParam;
        private Style paramStyle;
        private StyledTextPane styledTextPane;

        public MyMouseAdapter(Icon collapsed, Icon expanded, String param, String shortParam, Style paramStyle, StyledTextPane styledTextPane) {
            this.expanded = expanded;
            this.collapsed = collapsed;
            this.param = param;
            this.shortParam = shortParam;
            this.paramStyle = paramStyle;
            this.styledTextPane = styledTextPane;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Point mousePosition = this.styledTextPane.getMousePosition();
                if (mousePosition == null) {
                    return;
                }
                Point point = new Point(mousePosition);
                point.setLocation((int)point.getX() + 6 - mouseEvent.getX(), (int)point.getY());
                int pos = this.styledTextPane.viewToModel(point);
                Document doc = this.styledTextPane.getDocument();
                JLabel label = (JLabel)mouseEvent.getSource();
                try {
                    if (label.getIcon() == this.collapsed) {
                        label.setIcon(this.expanded);
                        doc.remove(pos, 33);
                        doc.insertString(pos, this.param, this.paramStyle);
                    } else {
                        label.setIcon(this.collapsed);
                        doc.remove(pos, this.param.length());
                        doc.insertString(pos, this.shortParam, this.paramStyle);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex);
                }
            }
        }
    }

    private static class Layout
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int layoutWidth = 368;
        private int layoutHeight = 170;
        private StyledTextPane textArea;
        private JCheckBox confirmCheckBox;

        public Layout(Level level) {
            this.setLayout(new BoxLayout(this, 0));
            this.init(level, null, false);
        }

        public Layout(Level level, String confirmMes, boolean defaultSelect) {
            this.setLayout(new BoxLayout(this, 0));
            this.init(level, confirmMes, defaultSelect);
        }

        public void test() {
            this.init(Level.DANGER, "a", true);
        }

        private void init(Level level, String confirmMes, boolean defaultSelect) {
            Box leftBox = Box.createVerticalBox();
            Icon icon = HisConfirmDialog.getIcon(level);
            leftBox.add(Box.createVerticalStrut(15));
            leftBox.add(new JLabel(icon));
            leftBox.add(Box.createVerticalGlue());
            Box rightBox = Box.createVerticalBox();
            rightBox.add(Box.createVerticalStrut(15));
            Box levelDesc = Box.createHorizontalBox();
            levelDesc.add(this.createLevelLabel(level));
            levelDesc.add(Box.createGlue());
            this.textArea = new StyledTextPane(new StyledTextPane.Paragraph[0]){
                private static final long serialVersionUID = -4736790349519271643L;

                public void scrollRectToVisible(Rectangle aRect) {
                }
            };
            this.textArea.setEditable(false);
            this.textArea.setBorder((Border)new EmptyBorder(8, 8, 0, 0));
            this.textArea.setFocusable(false);
            JScrollPane scrollPane = new JScrollPane((Component)this.textArea);
            Dimension size = new Dimension(this.layoutWidth, this.layoutHeight);
            scrollPane.setPreferredSize(size);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(31);
            rightBox.add(scrollPane);
            if (level == Level.DANGER || level == Level.WARNING || null != confirmMes) {
                rightBox.add(Box.createVerticalStrut(5));
                Box confirmBox = Box.createHorizontalBox();
                this.confirmCheckBox = new JCheckBox(null == confirmMes ? HisResourceManager.getString("COMMON.TXT.CONFIRM_DIALOG_CONFIRM") : confirmMes);
                this.confirmCheckBox.setSelected(null != confirmMes ? defaultSelect : false);
                confirmBox.add(this.confirmCheckBox);
                confirmBox.add(Box.createGlue());
                rightBox.add(confirmBox);
            }
            rightBox.add(Box.createVerticalStrut(15));
            this.add(Box.createHorizontalStrut(30));
            this.add(leftBox);
            this.add(Box.createHorizontalStrut(10));
            this.add(rightBox);
            this.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
            this.add(Box.createHorizontalGlue());
            this.add(Box.createHorizontalStrut(30));
        }

        private JLabel createLevelLabel(Level level) {
            JLabel label = new JLabel();
            if (level == Level.DANGER) {
                label.setForeground(Color.RED);
            }
            label.setFont(new FontUIResource("Dialog", 1, 24));
            label.setText(level.toString());
            return label;
        }
    }

    private static class Param {
        private String description;
        private String result;
        private String suggestion;

        private Param(String desc, String result, String sugg) {
            this.description = desc;
            this.result = result;
            this.suggestion = sugg;
        }
    }

    public static enum Level {
        DANGER("Danger"),
        WARNING("Warning"),
        INFO("Info");

        private String name;
        private String strKey;

        private Level(String name) {
            this.name = name;
            this.strKey = "COMMON.ENUM.CONFIRM_DIALOG_LEVEL." + name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return HisResourceManager.getString(this.strKey, this.getName());
        }
    }
}

