/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.BatchExecutionException;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.ui.swing.dialog.InformationDialog;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.dialog.OldConfirmDialog;
import com.huawei.ism.ui.swing.dialog.PeomptDialog;
import com.huawei.ism.ui.swing.dialog.SftpInputPassWordDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import com.huawei.util.HisUtil;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class HisDialogUtils
implements DialogsConstants {
    private static final Logger LOGGER = Logger.getLogger(HisDialogUtils.class);

    public static ErrorDialog showErrorDialog(Window parent, String message) {
        if (message.equalsIgnoreCase(HisResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            HisDialogUtils.showInfoDialog(parent, message);
            return null;
        }
        ErrorDialog errorDialog = null;
        errorDialog = parent instanceof JDialog ? new ErrorDialog((JDialog)parent, message) : (parent instanceof Frame ? new ErrorDialog((Frame)parent, message) : new ErrorDialog((JDialog)null, message));
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(JDialog parent, String message) {
        if (message.equalsIgnoreCase(HisResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            HisDialogUtils.showInfoDialog(parent, message);
            return null;
        }
        ErrorDialog errorDialog = new ErrorDialog(parent, message);
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(Window parent, String message, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            HisDialogUtils.showInfoDialog(parent, exc.getErrorMessage());
            return null;
        }
        String msg = HisDialogUtils.combineErrMsg(message, throwable);
        List<String> suggestion = HisDialogUtils.getErrorSuggestion(throwable);
        if (msg.equalsIgnoreCase(HisResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            HisDialogUtils.showInfoDialog(parent, msg);
            return null;
        }
        ErrorDialog errorDialog = null;
        errorDialog = parent instanceof JDialog ? new ErrorDialog((JDialog)parent, msg, suggestion) : (parent instanceof Frame ? new ErrorDialog((Frame)parent, msg, suggestion) : new ErrorDialog((JDialog)null, msg, suggestion));
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    public static ErrorDialog showErrorDialog(Window parent, Throwable throwable) {
        return HisDialogUtils.showErrorDialog(parent, "", throwable);
    }

    public static JDialog getErrorDialog(Window parent, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            return HisDialogUtils.getInfoDialog(parent, exc.getErrorMessage());
        }
        String msg = HisDialogUtils.combineErrMsg("", throwable);
        List<String> suggestion = HisDialogUtils.getErrorSuggestion(throwable);
        if (msg.equalsIgnoreCase(HisResourceManager.getString("COMMAND_DISPATCH_SUCCESS"))) {
            return HisDialogUtils.getInfoDialog(parent, msg);
        }
        return HisDialogUtils.getErrorDialog(parent, msg, suggestion);
    }

    private static JDialog getErrorDialog(Window parent, String msg, List<String> suggestion) {
        ErrorDialog dialog = null;
        dialog = parent instanceof JDialog ? new ErrorDialog((JDialog)parent, msg, suggestion) : (parent instanceof Frame ? new ErrorDialog((Frame)parent, msg, suggestion) : new ErrorDialog((JDialog)null, msg, suggestion));
        return dialog;
    }

    public static JDialog getInfoDialog(Window parent) {
        return HisDialogUtils.getInfoDialog(parent, HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static JDialog getInfoDialog(Window parent, String msg) {
        InformationDialog dialog = null;
        dialog = parent instanceof JDialog ? new InformationDialog((JDialog)parent, msg) : (parent instanceof Frame ? new InformationDialog((Frame)parent, msg) : new InformationDialog((JDialog)null, msg));
        return dialog;
    }

    public static ErrorDialog showErrorDialog(Frame parent, String message, Throwable throwable) {
        IsmException exc;
        if (throwable instanceof IsmException && (exc = (IsmException)throwable).getErrorId() == 50331670L) {
            HisDialogUtils.showInfoDialog(parent, exc.getErrorMessage());
            return null;
        }
        String msg = HisDialogUtils.combineErrMsg(message, throwable);
        List<String> suggestion = HisDialogUtils.getErrorSuggestion(throwable);
        ErrorDialog errorDialog = new ErrorDialog(parent, msg, suggestion);
        errorDialog.setVisible(!Utils.isJunitTest());
        return errorDialog;
    }

    private static List<String> getErrorSuggestion(Throwable throwable) {
        if (throwable instanceof IsmException) {
            IsmException exc = (IsmException)throwable;
            return exc.getSuggestions();
        }
        return null;
    }

    public static ErrorDialog showErrorDialog(Frame parent, Throwable throwable) {
        return HisDialogUtils.showErrorDialog(parent, "", throwable);
    }

    public static String combineErrMsg(String message, Throwable throwable) {
        LOGGER.error((Object)throwable);
        String msg = message;
        if (throwable instanceof IsmException) {
            IsmException ismException = (IsmException)throwable;
            String cause = ismException.getErrorMessage();
            if (null != cause && !"".equals(cause)) {
                msg = msg + cause;
            }
        } else {
            msg = throwable instanceof TimeoutException ? HisResourceManager.getString("SERVER_TIMEOUT_ERROR") : HisResourceManager.getString("SERVER_INNER_ERROR");
        }
        return msg;
    }

    public static void showSuccessDialog(JDialog parent, String message) {
        InformationDialog infoDialog = new InformationDialog(parent, message, true);
        if ("--".equals(message)) {
            try {
                throw new ToolException();
            }
            catch (Exception e) {
                LOGGER.error((Object)"showInfoDialog JDialog error.", (Throwable)e);
                return;
            }
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(JDialog parent, String message) {
        InformationDialog infoDialog = new InformationDialog(parent, message);
        if ("--".equals(message)) {
            try {
                throw new ToolException();
            }
            catch (Exception e) {
                LOGGER.error((Object)"showInfoDialog JDialog error.", (Throwable)e);
                return;
            }
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(JDialog parent, String message, Dimension areaDimension) {
        InformationDialog infoDialog = new InformationDialog(parent, message, areaDimension);
        if ("--".equals(message)) {
            return;
        }
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(Window parent, String message) {
        if ("--".equals(message)) {
            try {
                throw new ToolException();
            }
            catch (Exception e) {
                LOGGER.error((Object)"showInfoDialog Window error.", (Throwable)e);
                return;
            }
        }
        if (parent instanceof JDialog) {
            InformationDialog infoDialog = new InformationDialog((JDialog)parent, message);
            infoDialog.setVisible(!Utils.isJunitTest());
        } else if (parent instanceof Frame) {
            InformationDialog infoDialog = new InformationDialog((Frame)parent, message);
            infoDialog.setVisible(!Utils.isJunitTest());
        }
    }

    public static void showInfoDialog(Frame parent, String message) {
        if ("--".equals(message)) {
            try {
                throw new ToolException();
            }
            catch (Exception e) {
                LOGGER.error((Object)"showInfoDialog Frame error.", (Throwable)e);
                return;
            }
        }
        InformationDialog infoDialog = new InformationDialog(parent, message);
        infoDialog.setVisible(!Utils.isJunitTest());
    }

    public static void showInfoDialog(Frame parent) {
        HisDialogUtils.showInfoDialog(parent, HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static void showInfoDialog(Window parent) {
        HisDialogUtils.showInfoDialog(parent, HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static void showInfoDialog(JDialog parent) {
        HisDialogUtils.showInfoDialog(parent, HisResourceManager.getString("INFORMATION_SUCCESS_MSG"));
    }

    public static HisWarningDialog createWarningDialog(JDialog parent, String warnMsg) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, warnMsg);
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    private static void showWarningDialog(HisWarningDialog warningDialog) {
        if (Utils.isJunitTest()) {
            warningDialog.setVisible(false);
            warningDialog.setValue(0);
        } else {
            warningDialog.setVisible(true);
        }
    }

    public static synchronized HisWarningDialog createContinueDialog(Frame parent) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), HisResourceManager.getString("CONTINUE_CREATE_MSG"), "Information.png");
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized HisWarningDialog createContinueDialog(Frame parent, String warnMsg) {
        HisWarningDialog warningDialog = HisDialogUtils.createContinueWarningDialog(parent, warnMsg);
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized HisWarningDialog createContinueWarningDialog(Frame parent, String warnMsg) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png");
        warningDialog.getCannelButton().setText(HisResourceManager.getString("CREATE_LUN_FINISH"));
        warningDialog.getCannelButton().setMnemonic('F');
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getCannelButton());
        warningDialog.getConfirmButton().setText(HisResourceManager.getString("CONTINUE"));
        warningDialog.getConfirmButton().setMnemonic('C');
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getConfirmButton());
        Dimension dimension = new Dimension(100, 23);
        UCD.setJComponentSize((JComponent)warningDialog.getCannelButton(), (Dimension)dimension);
        UCD.setJComponentSize((JComponent)warningDialog.getConfirmButton(), (Dimension)dimension);
        return warningDialog;
    }

    public static HisWarningDialog showYesNoDialog(Window parent, String waringMsg) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png");
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static HisWarningDialog showcreateDialog(Window parent, String waringMsg) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, HisResourceManager.getString("WARNING_DIALOG_TITLE"), waringMsg, "comfirmdialog_warn.png");
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static PeomptDialog showCreatePromptDialog(Window parent, String waringMsg) {
        PeomptDialog warningDialog = new PeomptDialog(parent, HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), waringMsg, "Information.png");
        warningDialog.getCannelButton().setText(HisResourceManager.getString("COMMON.TXT.CANCEL"));
        warningDialog.getCannelButton().setMnemonic('F');
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getCannelButton());
        warningDialog.getConfirmButton().setText(HisResourceManager.getString("CONTINUE"));
        warningDialog.getConfirmButton().setMnemonic('C');
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getConfirmButton());
        Dimension dimension = new Dimension(100, 23);
        if ("en".equals(System.getenv("language"))) {
            dimension = new Dimension(120, 23);
        }
        UCD.setJComponentSize((JComponent)warningDialog.getCannelButton(), (Dimension)dimension);
        UCD.setJComponentSize((JComponent)warningDialog.getConfirmButton(), (Dimension)dimension);
        if (Utils.isJunitTest()) {
            warningDialog.setVisible(false);
            warningDialog.setValue(0);
        } else {
            warningDialog.setVisible(true);
        }
        return warningDialog;
    }

    public static synchronized HisWarningDialog createContinueDialog(JDialog parent, String warnMsg, boolean isOpen) {
        HisWarningDialog warningDialog = new HisWarningDialog((Window)parent, HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png");
        warningDialog.getConfirmButton().setText(HisResourceManager.getString("CONTINUE_BUTTON"));
        warningDialog.getConfirmButton().setMnemonic('C');
        warningDialog.getCannelButton().setText(HisResourceManager.getString("EXPORT_DOWNLOAD_CANCEL"));
        warningDialog.getCannelButton().setMnemonic('F');
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getCannelButton());
        Dimension dimension = new Dimension(120, 23);
        UCD.setJComponentSize((JComponent)warningDialog.getCannelButton(), (Dimension)dimension);
        UCD.setJComponentSize((JComponent)warningDialog.getConfirmButton(), (Dimension)dimension);
        UCD.formatMnemonicDisplay((AbstractButton)warningDialog.getConfirmButton());
        SwingUtil.putParentCenter((Window)warningDialog, (Window)parent);
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static synchronized HisWarningDialog createContinueDialog(JDialog parent, String warnMsg) {
        return HisDialogUtils.createContinueDialog(parent, warnMsg, true);
    }

    public static synchronized HisWarningDialog createContinueDialog(Frame parent, String warnMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, HisWarningDialog.initStrParam(HisResourceManager.getString("INFORMATION_DIALOG_TITLE"), warnMsg, "Information.png", okInfo, cancelInfo), okWidth, cancelWidth);
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    public static HisWarningDialog createWarningDialog(Frame parent, String warnMsg) {
        HisWarningDialog warningDialog = new HisWarningDialog(parent, warnMsg);
        HisDialogUtils.showWarningDialog(warningDialog);
        return warningDialog;
    }

    private static void showRequireInputConfirmationDialog(OldConfirmDialog dlg) {
        if (Utils.isJunitTest()) {
            dlg.setVisible(false);
            dlg.setValue(0);
        } else {
            dlg.setVisible(true);
        }
    }

    public static OldConfirmDialog createInputConfirmDialog(JDialog parent, String msg) {
        OldConfirmDialog inputDialog = new OldConfirmDialog(parent, msg);
        HisDialogUtils.showRequireInputConfirmationDialog(inputDialog);
        return inputDialog;
    }

    public static OldConfirmDialog createInputConfirmDialog(Frame parent, String msg) {
        OldConfirmDialog inputDialog = new OldConfirmDialog(parent, msg);
        HisDialogUtils.showRequireInputConfirmationDialog(inputDialog);
        return inputDialog;
    }

    public static void showMultiErrorDialog(Window parent, String msg, String[] headers, List<List<Object>> datas) {
        MultiErrorDialog multiErrorDialog = null;
        multiErrorDialog = parent instanceof Frame ? new MultiErrorDialog(parent, msg, headers) : (parent instanceof JDialog ? new MultiErrorDialog(parent, msg, headers) : new MultiErrorDialog((Window)Framework.getInstance().getMainFrame(), msg, headers));
        ArrayList<DefaultTableRow> tableRows = new ArrayList<DefaultTableRow>(0);
        DefaultTableRow tableRow = null;
        for (List<Object> row : datas) {
            tableRow = new DefaultTableRow(headers.length, (Object)"", (Object)String.valueOf(HisUtil.getSecureRandom()));
            tableRow.setValues(row);
            tableRows.add(tableRow);
        }
        multiErrorDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        multiErrorDialog.setVisible(true);
    }

    public static void showDeviceErrorDialog(Window dialog, Throwable e) {
        if (e instanceof BatchExecutionException) {
            DialogUtils.showDeviceMultiErrorDialog((BatchExecutionException)((BatchExecutionException)e), (Window)dialog);
        } else {
            HisDialogUtils.showErrorDialog(dialog, e);
        }
    }

    public static void showDeviceMultiErrorDialog(BatchExecutionException e, Window dialog) {
        String[] rowHeaders = new String[]{HisResourceManager.getString("TASK_SOURCE"), HisResourceManager.getString("FAILREASON")};
        ArrayList<List<Object>> rowList = new ArrayList<List<Object>>(0);
        ArrayList<String> row = null;
        String deviceName = "";
        Object obj = null;
        for (int i = 0; i < e.getFailsSize(); ++i) {
            obj = e.getFailOperateObject(i);
            if (obj instanceof String) {
                Launcher launcher = LauncherManager.getInstance().getLauncher((String)obj);
                if (launcher == null) {
                    LOGGER.error((Object)"launcher is null.");
                    return;
                }
                deviceName = launcher.getDeviceName();
            }
            row = new ArrayList<String>(0);
            row.add(deviceName);
            row.add(e.getErrorMessage(i));
            rowList.add(row);
        }
        HisDialogUtils.showMultiErrorDialog(dialog, HisResourceManager.getString("EXECUTE_FAILED"), rowHeaders, rowList);
    }

    public static void showMultiErrorDialog(String multiErrorTitle, String[] columnNames, Frame frame, JDialog dialog, BatchExecutionException be, List<List> tableData) {
        MultiErrorDialog multiErrorDialog = null;
        multiErrorDialog = null != frame ? new MultiErrorDialog((Window)frame, multiErrorTitle, columnNames) : new MultiErrorDialog((Window)dialog, multiErrorTitle, columnNames);
        ArrayList<DefaultTableRow> tableRows = new ArrayList<DefaultTableRow>(0);
        DefaultTableRow tableRow = null;
        for (List row : tableData) {
            tableRow = new DefaultTableRow(columnNames.length, (Object)"", (Object)"");
            tableRow.setValues(row);
            tableRows.add(tableRow);
        }
        multiErrorDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        multiErrorDialog.setVisible(true);
    }

    public static SftpInputPassWordDialog showInputPassWordDialog(Window parent, String userName) {
        SftpInputPassWordDialog ipd = SftpInputPassWordDialog.getInstance((Window)parent, (String)userName);
        return ipd;
    }
}

