/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.dialog.HeadlessDialog;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class HisProgressDialog
extends HeadlessDialog {
    private static final long serialVersionUID = 1L;
    private JLabel lable;

    public HisProgressDialog(Window parent) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressDialog");
        this.layoutUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(false);
    }

    private void layoutUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        if (!IsmPlafUtils.isBlueStyle()) {
            iconLabel = this.createArmorContentPane();
            iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            Border border = BorderFactory.createRaisedBevelBorder();
            panel.setBorder(border);
            iconLabel = this.createIconPanel("progress.gif");
        }
        panel.add((Component)iconLabel, "North");
        JButton jButton = new JButton("");
        jButton.setSize(0, 0);
        jButton.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)jButton, "South");
        this.add(panel);
    }

    private JLabel createIconPanel(String imgName) {
        ImageIcon process = HisResourceManager.getImage(imgName);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(process);
        process.setImageObserver(iconLabel);
        return iconLabel;
    }

    private JComponent createArmorContentPane() {
        ImagePanel leftImagePanel = new ImagePanel(HisResourceManager.getImage("loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(HisResourceManager.getImage("loading-right.png"));
        ImagePanel middleImagePanel = new ImagePanel(HisResourceManager.getImage("loading-middle.png"), ImagePanel.ExtendOrient.HORIZONAL);
        leftImagePanel.setPreferredSize(new Dimension(20, 122));
        middleImagePanel.setPreferredSize(new Dimension(220, 122));
        rightImagePanel.setPreferredSize(new Dimension(20, 122));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout((LayoutManager)new BorderLayout());
        this.lable = this.createIconPanel("task_loading.gif");
        this.lable.setFont(IsmFontFactory.getPlaint13Font());
        this.lable.setForeground(Color.WHITE);
        this.lable.setText(HisResourceManager.getString("LOADING_TEXT"));
        Box lableBox = Box.createHorizontalBox();
        lableBox.add(Box.createHorizontalGlue());
        lableBox.add(this.lable);
        lableBox.add(Box.createHorizontalGlue());
        middleImagePanel.add((Component)lableBox);
        Box box = Box.createHorizontalBox();
        box.add((Component)leftImagePanel);
        box.add((Component)middleImagePanel);
        box.add((Component)rightImagePanel);
        return box;
    }

    public void dispose() {
        super.dispose();
    }

    public JLabel getLable() {
        return this.lable;
    }
}

