/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HisWarningDialog
extends JDialog
implements DialogsConstants {
    private static final Logger log = LoggerFactory.getLogger(HisWarningDialog.class);
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static final int INSETS_EMPTY = 0;
    private static final long serialVersionUID = -7858562840591485694L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private static final int DISPLAY_PROMPT_DEFAULT_COLUMN = 26;
    private Box buttonPanel;
    private JButton cannelButton;
    private JButton confirmButton;
    private JPanel displayPanel;
    private JLabel imageLabel;
    private int dialogValue = -1;
    private IsmTextArea displayPrompt;
    private JPanel wholePanel;

    public HisWarningDialog(Window parent, String title, String newMessage, String newImageIcon) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public HisWarningDialog(Frame parent, String title, String newMessage, String newImageIcon) {
        super(parent, true);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public HisWarningDialog(Window parent, StrParam param, int okWidth, int cancelWidth) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(param, okWidth, cancelWidth);
    }

    public HisWarningDialog(Frame parent, StrParam param, int okWidth, int cancelWidth) {
        super(parent, true);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.layoutUI(param, okWidth, cancelWidth);
    }

    public HisWarningDialog(JDialog parent, String title, String newMessage) {
        this((Window)parent, title, newMessage, "comfirmdialog_warn.png");
    }

    public HisWarningDialog(Frame parent, String title, String newMessage) {
        this(parent, title, newMessage, "comfirmdialog_warn.png");
    }

    public HisWarningDialog(JDialog parent, String newMessage) {
        this(parent, HisResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage);
    }

    public HisWarningDialog(Frame parent, String newMessage) {
        this(parent, HisResourceManager.getString("WARNING_DIALOG_TITLE"), newMessage);
    }

    public static StrParam initStrParam(String title, String news, String icon, String ok, String cancel) {
        return new StrParam(title, news, icon, ok, cancel);
    }

    private void layoutUI(StrParam param, int okWidth, int cancelWidth) {
        this.toFront();
        this.init(param.title, param.newMessage, param.newImageIcon);
        this.confirmButton.setText(param.okInfo);
        this.cannelButton.setText(param.cancelInfo);
        this.confirmButton.setPreferredSize(new Dimension(okWidth, BUTTON_HTGHT));
        this.cannelButton.setPreferredSize(new Dimension(cancelWidth, BUTTON_HTGHT));
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public int getValue() {
        return this.dialogValue;
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.cannelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    protected void initComponent() {
        int margin = 8;
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        JSeparator separator = this.setjSeparator();
        this.buttonBarBackground(margin, separator);
        this.setButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        this.displayPrompt.setBorder(UCD.createEmptyBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.displayPrompt, gridBagConstraints);
        this.displayPrompt.setMargin(new Insets(0, 0, 0, 0));
    }

    private void setButtonPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert((Component[])new Component[]{this.confirmButton, this.cannelButton});
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.wholePanel.add((Component)bottomPanel, gridBagConstraints);
        this.displayPanel.setLayout(new GridBagLayout());
    }

    private void buttonBarBackground(int margin, JSeparator separator) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.wholePanel.add((Component)innerBox, gridBagConstraints);
    }

    private JSeparator setjSeparator() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new JSeparator(){
                private static final long serialVersionUID = -6149201948604054011L;

                @Override
                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(new Color(0xCECECE));
                    graphics.drawLine(0, 0, this.getWidth(), 0);
                    graphics.setColor(Color.WHITE);
                    graphics.drawLine(0, 1, this.getWidth(), 1);
                }
            };
        }
        return separator;
    }

    private void init(String title, String newMessage, String newImageIcon) {
        if (null == title) {
            title = HisResourceManager.getString("WARNING_DIALOG_TITLE");
        }
        if (null == newImageIcon) {
            newImageIcon = "comfirmdialog_warn.png";
        }
        this.cannelButton = UCD.createButton((String)HisResourceManager.getString("COMMON.TXT.CANCEL"), (char)'C');
        this.confirmButton = UCD.createButton((String)HisResourceManager.getString("COMMON.TXT.CONFIRM"), (char)'O');
        this.displayPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(26);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.wholePanel = new JPanel();
        this.initComponent();
        this.initButtonEvent();
        super.setTitle(title);
        if (null != newImageIcon) {
            ImageIcon imageIcon = HisResourceManager.getImage(newImageIcon);
            this.imageLabel.setIcon(imageIcon);
        }
        this.pack();
        this.displayPrompt.setText(newMessage);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter((Window)this, (Window)this.getOwner());
        SwingUtil.setName((Container)this);
        this.getRootPane().setDefaultButton(this.cannelButton);
    }

    private void cannelButtonAction() {
        this.dialogValue = 1;
        this.dispose();
    }

    private void confimButtonAction(ActionEvent actionEvent) {
        log.info("{}", (Object)actionEvent.getID());
        this.dialogValue = 0;
        this.dispose();
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.dialogValue = value;
        }
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent((Window)window);
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HisWarningDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cannelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HisWarningDialog.this.cannelButtonAction();
            }
        });
    }

    public JButton getCannelButton() {
        return this.cannelButton;
    }

    public void setCannelButton(JButton cannelButton) {
        this.cannelButton = cannelButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    public void setButtonSize(int okWidth, int cancelWidth, int okMneonic, int cancelMneonic) {
        this.cannelButton.setMnemonic('C');
        this.confirmButton.setMnemonic('O');
        UCD.setJComponentSize((JComponent)this.cannelButton, (Dimension)new Dimension(okWidth, BUTTON_HTGHT));
        UCD.setJComponentSize((JComponent)this.confirmButton, (Dimension)new Dimension(cancelWidth, BUTTON_HTGHT));
    }

    private static class StrParam {
        private String title;
        private String newMessage;
        private String newImageIcon;
        private String okInfo;
        private String cancelInfo;

        private StrParam(String title, String news, String icon, String ok, String cancel) {
            this.title = title;
            this.newMessage = news;
            this.newImageIcon = icon;
            this.okInfo = ok;
            this.cancelInfo = cancel;
        }
    }
}

