/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeomptDialog
extends JDialog
implements DialogsConstants {
    private static final Logger log = LoggerFactory.getLogger(PeomptDialog.class);
    private static final int GRIDX_0 = 0;
    private static final int GRIDY_0 = 0;
    private static final int GRIDY_1 = 1;
    private static final int INSETS_EMPTY = 0;
    private static final long serialVersionUID = -7858562840591485694L;
    private static final double WEIGHTX_1 = 0.1;
    private static final double WEIGHTY_1 = 0.1;
    private Box buttonPanel;
    private JButton cannelButton;
    private JButton confirmButton;
    private JPanel displayPanel;
    private JLabel imageLabel;
    private int dialogValue = -1;
    private Box displayPrompt;
    private JEditorPane datePromt;
    private JPanel wholePanel;

    public PeomptDialog(Window parent, String title, String newMessage, String newImageIcon) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_WarningDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    public int getValue() {
        return this.dialogValue;
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 200: {
                this.cannelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    protected void initComponent() {
        int margin = 8;
        this.setDefaultCloseOperation(2);
        this.wholePanel.setLayout(new GridBagLayout());
        this.add((Component)this.wholePanel, "Center");
        JSeparator separator = this.setjSeparator();
        this.setButtonBarBackground(margin, separator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        this.buttonPanel = UCD.buildHBoxCentert((Component[])new Component[]{this.confirmButton, this.cannelButton});
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        JComponent bottomStruts = (JComponent)Box.createVerticalStrut(12);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            bottomStruts.setOpaque(true);
            bottomStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        Box bottomPanel = Box.createVerticalBox();
        bottomPanel.add(this.buttonPanel);
        bottomPanel.add(bottomStruts);
        this.wholePanel.add((Component)bottomPanel, gridBagConstraints);
        this.displayPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        this.displayPrompt.setBorder(UCD.createEmptyBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        this.displayPanel.add((Component)this.displayPrompt, gridBagConstraints);
    }

    private void setButtonBarBackground(int margin, JSeparator separator) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        Box innerBox = Box.createVerticalBox();
        innerBox.add(separator);
        JComponent boxStruts = (JComponent)Box.createVerticalStrut(margin);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            boxStruts.setOpaque(true);
            boxStruts.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        innerBox.add(boxStruts);
        this.wholePanel.add((Component)innerBox, gridBagConstraints);
    }

    private JSeparator setjSeparator() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 9, 0, 12);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.wholePanel.add((Component)this.displayPanel, gridBagConstraints);
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new JSeparator(){
                private static final long serialVersionUID = -6149201948604054011L;

                @Override
                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(new Color(0xCECECE));
                    graphics.drawLine(0, 0, this.getWidth(), 0);
                    graphics.setColor(Color.WHITE);
                    graphics.drawLine(0, 1, this.getWidth(), 1);
                }
            };
        }
        return separator;
    }

    public void changebuttonPanel() {
    }

    private void init(String title, String newMessage, String newImageIcon) {
        if (null == title) {
            title = HisResourceManager.getString("WARNING_DIALOG_TITLE");
        }
        if (null == newImageIcon) {
            newImageIcon = "comfirmdialog_warn.png";
        }
        this.cannelButton = UCD.createButton((String)HisResourceManager.getString("COMMON.TXT.CANCEL"), (char)'C');
        this.confirmButton = UCD.createButton((String)HisResourceManager.getString("COMMON.TXT.CONFIRM"), (char)'O');
        this.displayPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        this.datePromt = new MyHtmlEdit("text/html", newMessage);
        this.datePromt.setOpaque(false);
        this.datePromt.setEditable(false);
        this.datePromt.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.datePromt.setFont((Font)UIManager.get("Label.font"));
        this.displayPrompt = UCD.buildVBoxTop((Component[])new Component[]{this.datePromt});
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.wholePanel = new JPanel();
        this.initComponent();
        this.initButtonEvent();
        super.setTitle(title);
        if (null != newImageIcon) {
            ImageIcon imageIcon = HisResourceManager.getImage(newImageIcon);
            this.imageLabel.setIcon(imageIcon);
        }
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putParentCenter((Window)this, (Window)this.getOwner());
        SwingUtil.setName((Container)this);
        this.getRootPane().setDefaultButton(this.cannelButton);
    }

    private void cannelButtonAction() {
        this.dialogValue = 1;
        this.dispose();
    }

    private void confimButtonAction(ActionEvent actionEvent) {
        log.info("{}", (Object)actionEvent.getID());
        this.dialogValue = 0;
        this.dispose();
    }

    public void setValue(int value) {
        if (Utils.isJunitTest()) {
            this.dialogValue = value;
        }
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent((Window)window);
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PeomptDialog.this.confimButtonAction(event);
            }
        });
        this.cannelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PeomptDialog.this.cannelButtonAction();
            }
        });
    }

    public JButton getCannelButton() {
        return this.cannelButton;
    }

    public void setCannelButton(JButton cannelButton) {
        this.cannelButton = cannelButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    public void setButtonSize(int okWidth, int cancelWidth, int okMneonic, int cancelMneonic) {
        this.cannelButton.setMnemonic('C');
        this.confirmButton.setMnemonic('O');
        UCD.setJComponentSize((JComponent)this.cannelButton, (Dimension)new Dimension(okWidth, BUTTON_HTGHT));
        UCD.setJComponentSize((JComponent)this.confirmButton, (Dimension)new Dimension(cancelWidth, BUTTON_HTGHT));
    }

    class MyHtmlEdit
    extends JEditorPane
    implements HyperlinkListener {
        private Desktop desktop;
        private static final long serialVersionUID = 1L;

        public MyHtmlEdit(String type, String text) {
            super(type, text);
            this.desktop = Desktop.getDesktop();
            this.addHyperlinkListener(this);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    this.desktop.browse(event.getURL().toURI());
                }
                catch (IOException ioException) {
                    log.error("", (Throwable)ioException);
                }
                catch (URISyntaxException exception) {
                    log.error("", (Throwable)exception);
                }
            }
        }
    }
}

