/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifyPopupMenuUI
extends BasicPopupMenuUI {
    private static final Logger log = LoggerFactory.getLogger(UnifyPopupMenuUI.class);

    public static ComponentUI createUI(JComponent c) {
        return new UnifyPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.FALSE);
    }

    @Override
    protected void uninstallDefaults() {
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.TRUE);
        super.uninstallDefaults();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Rectangle bounds = jComponent.getBounds();
        Insets insets = UIManager.getInsets("IsmPopMenuItem.inserts");
        if (insets == null) {
            log.error("insets value is null.");
            return;
        }
        int xVal = (int)bounds.getX() + insets.left;
        int yVal = (int)bounds.getY() + insets.top;
        int wVal = bounds.width - (insets.left + insets.right);
        int hVal = bounds.height - (insets.top + insets.bottom);
        Color background = UIManager.getColor("PopupMenu.background");
        int alpha = UIManager.getInt("PopupMenu.alpha");
        graphics.setColor(IsmPlafUtils.mixAlpha((Color)background, (int)alpha));
        graphics.fillRect(xVal, yVal, wVal, hVal);
    }
}

