/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.RegexDocument;
import com.huawei.ism.ui.widgets.PopupInform;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.JPasswordField;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class IsmPasswordField
extends JPasswordField {
    private static final Logger LOGGER = Logger.getLogger(IsmPasswordField.class);
    public static final int INPUT_NUMBER = 16;
    private static final int MAX_LENGTH = 256;
    private static final char ECHO_CHAR = '*';
    private static final long serialVersionUID = 5151922621139865804L;
    private static final int UCD_CONSTRANTS_HIGHT = 20;
    private int maxValidPriority = 1;
    private int minValidRestrictLen = 5;
    private int maxValidRestrictLen = 16;
    private boolean isError;
    private String errorToolTip = "";
    private String minValidRestrictTips;
    private String maxValidRestrictTips;
    private transient PopupInform passwordPopupInfo;
    private String defaultErrorTip;

    public IsmPasswordField(int fieldLength, int maxLength) {
        this(fieldLength, 0, maxLength, ".*");
    }

    public IsmPasswordField(int fieldLength, int minLength, int maxLength) {
        this(fieldLength, minLength, maxLength, ".*");
    }

    public IsmPasswordField(int fieldLength, int minLength, int maxLength, String regex) {
        super(fieldLength);
        this.minValidRestrictLen = minLength;
        this.maxValidRestrictLen = maxLength;
        this.setDefaultErrorTip();
        PasswordDocument passwordDocument = new PasswordDocument(this, regex);
        this.setDocument((Document)((Object)passwordDocument));
        this.setEchoChar('*');
        this.setMaximumSize(new Dimension(800, 20));
        this.installPopupInfo();
        SwingUtil.applyKeyBoardLockPatch((JTextComponent)this);
    }

    public IsmPasswordField(int fieldLength, int maxLength, int contentLenth, boolean isSecurity) {
        this(fieldLength, 0, maxLength, "[0-9a-zA-Z_`~!@#$%^&*()+=\\\\|\\[\\];:{}'\"/<>,.?-]*");
    }

    public IsmPasswordField() {
        this(16);
    }

    public IsmPasswordField(String regex) {
        this(16, 0, 16, regex);
    }

    public IsmPasswordField(int lenth) {
        this(lenth, 16);
    }

    private void setDefaultErrorTip() {
        this.defaultErrorTip = this.minValidRestrictLen == 0 ? HisResourceManager.getStringWithParams("COMMON.PASSWORD.OUTOFRANGE2", this.maxValidRestrictLen) : (this.minValidRestrictLen == this.maxValidRestrictLen ? HisResourceManager.getStringWithParams("COMMON.PASSWORD.OUTOFRANGE3", this.maxValidRestrictLen) : HisResourceManager.getStringWithParams("COMMON.PASSWORD.OUTOFRANGE", this.minValidRestrictLen, this.maxValidRestrictLen));
    }

    public String getDefaultErrorTip() {
        return this.defaultErrorTip;
    }

    public boolean checkLength() {
        if (this.getPassword().length > this.maxValidRestrictLen || this.getPassword().length < this.minValidRestrictLen) {
            this.setErrorToolTip(this.defaultErrorTip);
            this.requestFocus();
            return false;
        }
        return true;
    }

    private void installPopupInfo() {
        if (null == this.passwordPopupInfo) {
            this.passwordPopupInfo = new PopupInform((JTextComponent)this);
        }
        this.maxValidRestrictTips = HisResourceManager.getStringWithParams("SECURITY_PASSWORD_FIELD_INVALID_MAX_LENGTH_TIP", this.maxValidRestrictLen);
        this.minValidRestrictTips = HisResourceManager.getStringWithParams("SECURITY_PASSWORD_FIELD_INVALID_MIN_LENGTH_TIP", this.minValidRestrictLen);
        this.passwordPopupInfo.addInform(PopupInform.InformType.MIN_VALID_LENGTH, this.minValidRestrictTips, this.maxValidPriority, (Object)this.minValidRestrictLen);
        this.passwordPopupInfo.addInform(PopupInform.InformType.MAX_VALID_LENGTH, this.maxValidRestrictTips, this.maxValidPriority, (Object)this.maxValidRestrictLen);
    }

    public void setError(boolean isErrorPwd) {
        this.isError = isErrorPwd;
        if (null == this.errorToolTip) {
            return;
        }
        this.passwordPopupInfo.setErrorTooltip(this.errorToolTip, isErrorPwd);
        this.repaint();
    }

    public boolean isShowErrorToolTip() {
        return this.isError;
    }

    public void setErrorToolTip(String errorToolTip) {
        if (null == errorToolTip) {
            return;
        }
        this.errorToolTip = errorToolTip;
        this.setError(true);
        this.repaint();
    }

    public String getErrorToolTip() {
        return this.errorToolTip;
    }

    private void updateInforManager() {
        this.passwordPopupInfo.removeAllInform();
        this.passwordPopupInfo.addInform(PopupInform.InformType.MIN_VALID_LENGTH, this.minValidRestrictTips, this.maxValidPriority, (Object)this.minValidRestrictLen);
        this.passwordPopupInfo.addInform(PopupInform.InformType.MAX_VALID_LENGTH, this.maxValidRestrictTips, this.maxValidPriority, (Object)this.maxValidRestrictLen);
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    public void setMinValidRestrict(int minValidRestrict) {
        this.minValidRestrictLen = minValidRestrict;
        this.minValidRestrictTips = HisResourceManager.getStringWithParams("SECURITY_PASSWORD_FIELD_INVALID_MIN_LENGTH_TIP", this.minValidRestrictLen);
        this.setDefaultErrorTip();
        this.updateInforManager();
    }

    public int getMaxValidRestrict() {
        return this.maxValidRestrictLen;
    }

    public void setMaxValidRestrict(int maxValidRestrict) {
        this.maxValidRestrictLen = maxValidRestrict;
        this.maxValidRestrictTips = HisResourceManager.getStringWithParams("SECURITY_PASSWORD_FIELD_INVALID_MAX_LENGTH_TIP", this.maxValidRestrictLen);
        this.setDefaultErrorTip();
        this.updateInforManager();
    }

    public String getMinValidRestrictTip() {
        return this.minValidRestrictTips;
    }

    public void setMinValidRestrictTip(String minValidRestrictTip) {
        this.minValidRestrictTips = minValidRestrictTip;
        this.updateInforManager();
    }

    public String getMaxValidRestrictTip() {
        return this.maxValidRestrictTips;
    }

    public void setMaxValidRestrictTip(String maxValidRestrictTip) {
        this.maxValidRestrictTips = maxValidRestrictTip;
        this.updateInforManager();
    }

    public void setMAXValidRestrictTipSpecial(String maxValidRestrictTip) {
        this.maxValidRestrictTips = maxValidRestrictTip;
        this.passwordPopupInfo.removeAllInform();
        this.passwordPopupInfo.addInform(PopupInform.InformType.MIN_VALID_LENGTH, this.minValidRestrictTips, this.maxValidPriority, (Object)this.minValidRestrictLen);
        this.passwordPopupInfo.addInform(PopupInform.InformType.MAX_VALID_LENGTH, this.maxValidRestrictTips, this.maxValidPriority, (Object)this.maxValidRestrictLen);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip();
        tip.setComponent(this);
        return tip;
    }

    public int getMinValidRestrict() {
        return this.minValidRestrictLen;
    }

    public PopupInform getPasswordPopupInfo() {
        return this.passwordPopupInfo;
    }

    public void setPasswordPopupInfo(PopupInform passwordPopupInfo) {
        this.passwordPopupInfo = passwordPopupInfo;
    }

    public void setDefaultErrorTip(Object object) {
    }

    class PasswordDocument
    extends RegexDocument {
        private static final int SHOWERRORTIPTIME = 15000;
        private static final long serialVersionUID = 4484807512382654464L;
        private Timer insideTimer;
        private boolean isSupportBlank;
        private IsmPasswordField field;

        public PasswordDocument(IsmPasswordField field, String regex) {
            super(regex);
            this.isSupportBlank = true;
            this.field = field;
            this.insideTimer = new Timer(15000, new StillInsideTimerAction());
            this.insideTimer.setRepeats(false);
        }

        public void remove(int offs, int len) throws BadLocationException {
            String proposedInsert = this.getText(len, this.getLength() - len);
            try {
                int length = proposedInsert.getBytes("UTF8").length;
                if (IsmPasswordField.this.maxValidRestrictLen < length) {
                    super.remove(offs, len);
                    this.field.setErrorToolTip(IsmPasswordField.this.defaultErrorTip);
                    this.field.getPasswordPopupInfo().updateInformTask();
                    this.insideTimer.start();
                    return;
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String newContent, AttributeSet attr) {
            try {
                if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                    if (!this.isSupportBlank && (newContent.contains(" ") || newContent.contains("\u3000"))) {
                        return;
                    }
                    String proposedInsert = this.getText(0, offs) + newContent + this.getText(offs, this.getLength() - offs);
                    if (proposedInsert == null || proposedInsert.startsWith("-") && !IsmPlafUtils.isUnifyStyle()) {
                        return;
                    }
                    if (proposedInsert.getBytes("UTF8").length < 256) {
                        super.insertString(offs, newContent, attr);
                    }
                    if (IsmPasswordField.this.maxValidRestrictLen < proposedInsert.getBytes("UTF8").length) {
                        this.field.setErrorToolTip(IsmPasswordField.this.defaultErrorTip);
                        this.field.getPasswordPopupInfo().updateInformTask();
                        this.insideTimer.start();
                    }
                } else {
                    super.insertString(offs, newContent, attr);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }

        public void setSupportBlank(boolean value) {
            this.isSupportBlank = value;
        }

        private class StillInsideTimerAction
        implements ActionListener {
            private StillInsideTimerAction() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IsmPasswordField passwordField = PasswordDocument.this.field;
                passwordField.getPasswordPopupInfo().hideInform();
            }
        }
    }
}

