/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.util.VerifyUtil;
import com.huawei.xve.utils.DeviceInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class CopyUtil {
    private static final Logger LOGGER = Logger.getLogger(CopyUtil.class);

    public static <T extends Serializable> T clone(T obj) {
        Serializable clonedObj = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clonedObj = (Serializable)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)("clone object: " + obj.toString() + "failed."), (Throwable)e);
        }
        return (T)clonedObj;
    }

    public static DeviceInfo copyDevInfo(DeviceInfo di, String ip) {
        if (VerifyUtil.isEmpty(di)) {
            return null;
        }
        DeviceInfo copy = new DeviceInfo();
        copy.setDevNode(di.getDevNode());
        copy.setDeviceVersion(di.getDeviceVersion());
        copy.setDeviceName(di.getDeviceName());
        copy.setIp(ip);
        copy.setPubKey(di.getPubKey());
        copy.setPubKeyFile(di.getPubKeyFile());
        copy.setUseSSL(di.getUseSSL());
        copy.setScope(di.getScope());
        copy.setIsNewVersionHasManageIp(di.isNewVersionHasManageIp());
        copy.setLogin(di.isLogin());
        copy.setProperties(di.getProperties());
        copy.setDownloadTime(di.getDownloadTime());
        copy.setIoTraceParam(di.getIoTraceParam());
        return copy;
    }
}

