/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.util.NetUtil;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(StringUtils.class);
    public static final String TIME_STYLE_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSSZ = "yyyy-MM-dd HH:mm:ss z";
    public static final String TIME_STYLE_HHMMSS = "HH:mm:ss";
    public static final String TIME_STYLE_YYYY_MM_DD = "yyyy-MM-dd";
    private static final int MAX_PORT = 65535;

    private StringUtils() {
    }

    public static String convertMacToString(byte[] macArray) {
        if (null == macArray) {
            return null;
        }
        char[] src = new char[17];
        for (int i = 0; i < 5; ++i) {
            src[i * 3] = StringUtils.hexUpperChar(macArray[i]);
            src[i * 3 + 1] = StringUtils.hexLowerChar(macArray[i]);
            src[i * 3 + 2] = 58;
        }
        src[15] = StringUtils.hexUpperChar(macArray[5]);
        src[16] = StringUtils.hexLowerChar(macArray[5]);
        return new String(src);
    }

    private static char hexUpperChar(byte byt) {
        if ((byt = (byte)(byt >> 4 & 0xF)) == 0) {
            return '0';
        }
        if (byt < 10) {
            return (char)(48 + byt);
        }
        return (char)(97 + byt - 10);
    }

    private static char hexLowerChar(byte byt) {
        if ((byt = (byte)(byt & 0xF)) == 0) {
            return '0';
        }
        if (byt < 10) {
            return (char)(48 + byt);
        }
        return (char)(97 + byt - 10);
    }

    public static boolean ipTxtEmpty(String txtIp) {
        return null == txtIp || txtIp.isEmpty() || txtIp.equals(" . . . ");
    }

    public static boolean isNULLStr(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isCorrectMac(String mac) {
        String regex = "[A-Fa-f0-9]{12}";
        return mac.matches(regex);
    }

    public static String getDefaultValueIfNull(String value, String defaultValue) {
        String result = defaultValue;
        if (null != value) {
            result = value;
        }
        return result;
    }

    public static boolean hasNULLStr(String ... strs) {
        for (String s : strs) {
            if (!StringUtils.isNULLStr(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isZero(String str) {
        return !StringUtils.isNULLStr(str) && "0".equals(str);
    }

    public static boolean isHundred(String str) {
        return !StringUtils.isNULLStr(str) && "100".equals(str);
    }

    public static int object2Int(Object obj) {
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public static String findMatchStr(String source, String regex) {
        return StringUtils.findMatchStr(source, regex, 1);
    }

    public static boolean hasMatchStr(String source, String regex) {
        String result = StringUtils.findMatchStr(source, regex, 0);
        return null != result && !result.isEmpty();
    }

    public static String findMatchStr(String source, String regex, int group) {
        Pattern pattern = Pattern.compile(regex = Normalizer.normalize(regex, Normalizer.Form.NFKC));
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return "";
    }

    public static boolean isFullIpAddress(String ipAdrress) {
        return NetUtil.isValidIPV4((String)ipAdrress);
    }

    public static boolean allIsVaildIpv4(String ... ips) {
        for (String ip : ips) {
            if (StringUtils.isFullIpAddress(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean ipEqualsByBit(String ip1, String ip2) {
        if (StringUtils.allIsVaildIpv6(ip1, ip2)) {
            BigInteger ip1Bit = NetUtil.ipv6Str2Int((String)ip1);
            BigInteger ip2Bit = NetUtil.ipv6Str2Int((String)ip2);
            if (null == ip1Bit) {
                return false;
            }
            return ip1Bit.equals(ip2Bit);
        }
        if (StringUtils.allIsVaildIpv4(ip1, ip2)) {
            return NetUtil.ipv4Str2Long((String)ip1) == NetUtil.ipv4Str2Long((String)ip2);
        }
        return false;
    }

    public static boolean allIsVaildIpv6(String ... ips) {
        for (String ip : ips) {
            if (StringUtils.isIpv6Address(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIpv6Address(String addr) {
        if (StringUtils.isNULLStr(addr)) {
            return false;
        }
        return NetUtil.isValidIPV6((String)addr);
    }

    public static String fillValues(String src, Object ... args) {
        return MessageFormat.format(src, args);
    }

    public static String genDigitString(int val, int num, boolean location) {
        StringBuilder str = new StringBuilder(String.valueOf(val));
        while (str.length() < num) {
            int locat = location ? 0 : str.length();
            str.insert(locat, "0");
        }
        return str.toString();
    }

    public static char[] fillMask(char[] charr) {
        int len = charr.length;
        char[] eightBit = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int startIndex = 8 - len;
        for (int i = 0; i < len; ++i) {
            eightBit[startIndex + i] = charr[i];
        }
        return eightBit;
    }

    public static String toUpperHexString(int i) {
        String hex = Integer.toHexString(i);
        return hex.toUpperCase(Locale.ENGLISH);
    }

    public static boolean startIgnoreCase(String source, String header) {
        if (StringUtils.isNULLStr(source) || StringUtils.isNULLStr(header)) {
            return false;
        }
        return source.toLowerCase(Locale.ENGLISH).startsWith(header);
    }

    public static boolean isEmailAddress(String email) {
        if (StringUtils.isNULLStr(email)) {
            return false;
        }
        if (email.contains("..")) {
            return false;
        }
        return email.matches("^[\\w-_\\/]+[\\w-_\\/.]*+@([\\w-_\\/]+[.])+[-_\\/\\w]+$");
    }

    public static String getDateFormat(String formatString) {
        String foramt = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatString);
            foramt = sdf.format(new Date());
        }
        catch (Exception e) {
            LOGGER.error((Object)"format date error.", (Throwable)e);
        }
        return foramt;
    }

    public static String safetyGetStr(String[] arr, int index) {
        if (arr.length > index) {
            return arr[index].trim();
        }
        return "";
    }

    public static String fillStr(String src, int maxLen, String fillChar) {
        StringBuffer buffer = new StringBuffer(src);
        while (buffer.length() < maxLen) {
            buffer.append(fillChar);
        }
        return buffer.toString();
    }

    public static String formatDate(Object date, String formatStyle) {
        String foramt = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStyle);
            if (date instanceof Calendar) {
                return sdf.format(((Calendar)date).getTime());
            }
            foramt = sdf.format(date);
        }
        catch (Exception e) {
            LOGGER.error((Object)"format date error.", (Throwable)e);
        }
        return foramt;
    }

    public static long parseDate2Long(String dateStr, String dateStrStyle) {
        SimpleDateFormat format = new SimpleDateFormat(dateStrStyle);
        try {
            format.setLenient(false);
            Date date = format.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            LOGGER.error((Object)"parseDate2Long error.", (Throwable)e);
            return 0L;
        }
    }

    public static String deleteFirstLast(String str) {
        if (StringUtils.isNULLStr(str)) {
            return "";
        }
        StringBuilder sbr = new StringBuilder(str);
        sbr.deleteCharAt(0);
        sbr.deleteCharAt(sbr.length() - 1);
        return sbr.toString();
    }

    public static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String s = uuid.toString();
        return s.replaceAll("-", "");
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    public static boolean isPort(int port) {
        return port <= 65535;
    }
}

