/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.tool.base.utils.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public final class XmlFileReaderUtil {
    private static final Logger LOGGER = Logger.getLogger(XmlFileReaderUtil.class);

    private XmlFileReaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document load(String fileName) throws DocumentException, SAXException {
        Document document;
        InputStream in = null;
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader == null) {
                LOGGER.error((Object)"systemClassLoader is null.");
                Document document2 = null;
                return document2;
            }
            in = systemClassLoader.getResourceAsStream(fileName);
            document = XmlUtils.getSaxReader().read(in);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"close Stream error:", (Throwable)e);
            }
        }
        return document;
    }

    public static boolean validateDir(String source) {
        boolean res = null != source && !"".equals(source);
        res = res && source.indexOf("\"") < 0 && source.indexOf("|") < 0;
        res = res && source.indexOf("?") < 0 && source.indexOf("*") < 0;
        return res && source.indexOf("<") < 0 && source.indexOf(">") < 0;
    }
}

