/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.connection.BaseConnection;
import com.huawei.ism.connection.HisRESTConnection;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV1;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;

public abstract class AbstractSftp {
    private static final Logger LOGGER = Logger.getLogger(AbstractSftp.class);
    protected static final int TMOUT = 100000;
    protected static final int PORT = 22;
    public static final int DEFALT_PORT = 8080;
    private static Map<String, BaseConnection> connCache = new ConcurrentHashMap<String, BaseConnection>();
    private DeviceInfo di = null;
    private Map<SftpClient, ClientSession> cache;

    public AbstractSftp(DeviceInfo di) {
        this.di = di;
        this.cache = new ConcurrentHashMap<SftpClient, ClientSession>();
    }

    public SftpClient connect(String ip) throws CloneNotSupportedException {
        if (VerifyUtil.isEmpty(ip)) {
            ip = this.di.getIp();
        }
        long startTime = System.currentTimeMillis();
        DevNode node = this.di.getDevNode();
        if (!ip.equals(node.getIp())) {
            node = (DevNode)node.clone();
            node.setIp(ip);
        }
        SftpClient sftp = null;
        sftp = AbstractSftp.isSSHForward(node) ? AbstractSftp.createConnectByDev(node) : AbstractSftp.createConnect(ip, this.di.getUserName(), this.di.getPassword(), this.di.getPort());
        if (!VerifyUtil.isEmpty(sftp)) {
            this.cache.put(sftp, sftp.getSession());
        }
        LOGGER.info((Object)String.format(Locale.ROOT, "Try to connect sftp for : %s ,and connect cost : %s ms", ip, System.currentTimeMillis() - startTime));
        return sftp;
    }

    public static SftpClient connect(String ip, String userName, String pwd, int port) throws IOException {
        if (port <= 0) {
            port = 22;
        }
        Optional<DeviceInfo> deviceInfo = ConnManager.getDeviceInfoByIp(ip);
        int finalPort = port;
        SftpClient sftp = deviceInfo.filter(di -> AbstractSftp.isSSHForward(di.getDevNode())).map(di -> AbstractSftp.createConnectByDev(di.getDevNode())).orElseGet(() -> AbstractSftp.createConnect(ip, userName, pwd, finalPort));
        if (sftp != null) {
            return sftp;
        }
        throw new IOException("sftp client create failed.");
    }

    public static SftpClient createConnectByDev(DevNode node) {
        SftpTransfer sftpTransfer = new SftpTransfer(node, false);
        return sftpTransfer.getChannelSftp();
    }

    private static SftpClient createConnect(String ip, String userName, String pwd, int port) {
        SftpClient sftp = null;
        try {
            ClientSession sshSession = SshUtils.getDefaultSession((String)userName, (String)ip, (int)port, (String)pwd);
            sshSession.auth().verify(100000L, new CancelOption[0]);
            sftp = SftpClientFactory.instance().createSftpClient(sshSession);
        }
        catch (IOException e) {
            LOGGER.error((Object)"create connect error.", (Throwable)e);
        }
        return sftp;
    }

    public static ChannelShell connectWithShell(String ip, String userName, String pwd, int port) throws IOException {
        if (port <= 0) {
            port = 22;
        }
        ClientSession session = SshUtils.getDefaultSession((String)userName, (String)ip, (int)port, (String)pwd);
        session.auth().verify(100000L, new CancelOption[0]);
        ChannelShell shellChannel = session.createShellChannel();
        shellChannel.setPtyType("bash");
        shellChannel.setPtyLines(Integer.MAX_VALUE);
        shellChannel.setUsePty(true);
        return shellChannel;
    }

    public static ChannelShell connectWithShell(DeviceInfo deviceInfo) throws IOException, IsmException {
        String hostIP = deviceInfo.getIp();
        int port = deviceInfo.getPort();
        if (AbstractSftp.isSSHForward(deviceInfo.getDevNode())) {
            try {
                SshConnection connection = (SshConnection)SshConnectionManager.getSshConnection((DevNode)deviceInfo.getDevNode(), null, (boolean)true, (boolean)false);
                hostIP = connection.getHost();
                port = connection.getPort();
            }
            catch (ToolException e) {
                throw new IsmException(e.getMessage(), (Throwable)e);
            }
            catch (PwdException e) {
                throw new IsmException(e.getErrorMsg(), (Throwable)e);
            }
        }
        return AbstractSftp.connectWithShell(hostIP, deviceInfo.getUserName(), deviceInfo.getPassword(), port);
    }

    public static boolean isSftpCanConnected(String ip, int port, int timeout) {
        if (null == ip || "".equals(ip)) {
            LOGGER.error((Object)"the param is empty");
            return false;
        }
        return NetUtil.isPortCanReach((String)ip, (int)(port > 0 ? port : 22), (int)timeout);
    }

    public static Properties getDeviceProp(DeviceInfo di) {
        Properties properties = new Properties();
        properties.put("USER_NAME", di.getUserName());
        properties.put("USER_WORD", di.getPassword());
        properties.put("USERSCOPE", String.valueOf(0));
        properties.put("IP_OR_NAME", di.getIp());
        properties.put("CONN_PROTOCOL", String.valueOf(1));
        properties.put("TIME_OUT_PROPERTY", String.valueOf(30));
        properties.put("DEVICE_ID", di.getDeviceID());
        properties.put("DVENODE", di.getDevNode());
        return properties;
    }

    public void releaseConn() {
        Set<SftpClient> sftps = this.cache.keySet();
        Iterator<SftpClient> iterator = sftps.iterator();
        while (iterator.hasNext()) {
            SftpClient sftp = iterator.next();
            if (sftp == null) continue;
            try {
                sftp.close();
                ClientSession s = this.cache.get(sftp);
                if (s != null) {
                    s.close();
                    s = null;
                }
                iterator.remove();
                sftp = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)"release conn error.", (Throwable)e);
            }
        }
    }

    public static void sendOperLog(HisTLVConnection conn, String filename, EnumDefine.FILE_ID_E fileType, int ret, int optype) {
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        try {
            conn.invoke(55847747739L, (List<Param>)TLVUtils.paramList((Param[])new Param[]{TLVUtils.newParam((TLVTag)TLV1.OPERATIONLOG.FILENAME, (String)filename), TLVUtils.newParam((TLVTag)TLV1.OPERATIONLOG.FILETYPE, (int)fileType.getValue()), TLVUtils.newParam((TLVTag)TLV1.OPERATIONLOG.OPERTYPE, (int)optype), TLVUtils.newParam((TLVTag)TLV1.OPERATIONLOG.RETVALUE, (int)ret)}), 10);
        }
        catch (Exception e) {
            LOGGER.error((Object)("sendoperlog failed. filename" + filename + "result:" + ret), (Throwable)e);
        }
    }

    public static BaseConnection getConnection(DeviceInfo di) {
        BaseConnection conn = connCache.get(di.getDeviceID());
        if (conn != null) {
            return conn;
        }
        if (!AbstractSftp.isSftpCanConnected(di.getIp(), 8080, 1000)) {
            conn = new HisRESTConnection(di, false);
        } else {
            try {
                conn = ConnManager.getConnection(di.getDeviceID());
            }
            catch (Exception e) {
                LOGGER.error((Object)"TLVConnection establishment failed,retry using rest", (Throwable)e);
                conn = new HisRESTConnection(di, false);
            }
        }
        connCache.put(di.getDeviceID(), conn);
        return conn;
    }

    public static void releaseAllCacheConn() {
        Set<Map.Entry<String, BaseConnection>> es = connCache.entrySet();
        Iterator<Map.Entry<String, BaseConnection>> its = es.iterator();
        Map.Entry<String, BaseConnection> next = null;
        while (its.hasNext()) {
            next = its.next();
            AbstractSftp.releaseBaseConn(next.getValue());
        }
        connCache.clear();
    }

    public static void initSystemInfo(DeviceInfo di) {
        try (HisRESTConnection rest = null;){
            rest = new HisRESTConnection(di, false);
            rest.getSystemInfo(di);
        }
    }

    public static void releaseBaseConn(BaseConnection base) {
        if (base != null) {
            base.close();
        }
    }

    public static BaseConnection reConnection(DeviceInfo di) {
        di.setConn(null);
        connCache.remove(di.getDeviceID());
        return AbstractSftp.getConnection(di);
    }

    public static void releaseConn(DeviceInfo di) {
        if (!connCache.containsKey(di.getDeviceID())) {
            return;
        }
        AbstractSftp.releaseBaseConn(connCache.get(di.getDeviceID()));
        RestConnectionManager.releaseConn((DevNode)di.getDevNode());
        connCache.remove(di.getDeviceID());
    }

    public static void releaseConn(SftpClient ch) {
        if (ch == null) {
            return;
        }
        try {
            ClientSession s = ch.getSession();
            if (s != null) {
                s.close();
                s = null;
            }
            ch.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"release sftp conn error.", (Throwable)e);
        }
    }

    public DeviceInfo getDi() {
        return this.di;
    }

    public static Map<String, BaseConnection> getConnCache() {
        return connCache;
    }

    private static boolean isSSHForward(DevNode node) {
        return !CollectionUtil.isEmpty((Collection)node.getSshForwardList());
    }
}

