/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.huawei.ism.tool.obase.connection.support.SftpProgressMonitor;
import org.apache.log4j.Logger;

public class BatchSftpProgressMonitorImpl
implements SftpProgressMonitor {
    private static final Logger LOGGER = Logger.getLogger(BatchSftpProgressMonitorImpl.class);
    private long max;
    private String nodeName;
    private String src;
    private String dest;
    private double curr = 0.0;
    private int lastPer = 0;

    public BatchSftpProgressMonitorImpl(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean count(long currByte) {
        this.curr += (double)currByte;
        int per = (int)Math.round(this.curr * 50.0 / (double)this.max);
        if (per > this.lastPer) {
            this.lastPer = per;
        }
        return true;
    }

    public void end() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("src:" + this.src + ",curr:" + this.curr + ",max:" + this.max + "--per:" + this.lastPer));
        }
    }

    public void init(int op, String sr, String dst, long max) {
        this.max = max;
        this.src = sr;
        this.dest = dst;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(this.src + ":total->" + this.max + ",dest:" + this.dest));
        }
    }
}

